/*
 * Decompiled with CFR 0.152.
 */
package com.bisnode.opa.client.query;

import com.bisnode.opa.client.OpaClientException;
import com.bisnode.opa.client.query.OpaQueryApi;
import com.bisnode.opa.client.query.OpaQueryForDocumentRequest;
import com.bisnode.opa.client.query.OpaQueryForDocumentResponse;
import com.bisnode.opa.client.query.QueryForDocumentRequest;
import com.bisnode.opa.client.rest.OpaRestClient;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.net.http.HttpRequest;
import java.util.Objects;
import java.util.function.Supplier;

public class OpaQueryClient
implements OpaQueryApi {
    private static final String EVALUATE_POLICY_ENDPOINT = "/v1/data/";
    private static final String EMPTY_RESULT_ERROR_MESSAGE = "Result is empty, it may indicate that document under path [%s] does not exist";
    private final OpaRestClient opaRestClient;

    public OpaQueryClient(OpaRestClient opaRestClient) {
        this.opaRestClient = opaRestClient;
    }

    @Override
    public <R> R queryForDocument(QueryForDocumentRequest queryForDocumentRequest, Class<R> responseType) {
        try {
            OpaQueryForDocumentRequest opaQueryForDocumentRequest = new OpaQueryForDocumentRequest(queryForDocumentRequest.getInput());
            HttpRequest request = this.opaRestClient.getBasicRequestBuilder(EVALUATE_POLICY_ENDPOINT + queryForDocumentRequest.getPath()).header("Content-Type", "application/json").POST(this.opaRestClient.getJsonBodyPublisher(opaQueryForDocumentRequest)).build();
            JavaType opaResponseType = TypeFactory.defaultInstance().constructParametricType(OpaQueryForDocumentResponse.class, new Class[]{responseType});
            Object result = ((OpaQueryForDocumentResponse)((Supplier)this.opaRestClient.sendRequest(request, this.opaRestClient.getJsonBodyHandler(opaResponseType)).body()).get()).getResult();
            if (Objects.isNull(result)) {
                throw new OpaClientException(String.format(EMPTY_RESULT_ERROR_MESSAGE, queryForDocumentRequest.getPath()));
            }
            return (R)result;
        }
        catch (Exception e) {
            throw new OpaClientException(e);
        }
    }
}

