/*
 * Decompiled with CFR 0.152.
 */
package com.bisnode.opa.client.query;

import com.bisnode.opa.client.OpaClientException;
import com.bisnode.opa.client.query.OpaQueryApi;
import com.bisnode.opa.client.query.OpaQueryForDocumentRequest;
import com.bisnode.opa.client.query.OpaQueryForDocumentResponse;
import com.bisnode.opa.client.query.QueryForDocumentRequest;
import com.bisnode.opa.client.rest.OpaRestClient;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.http.HttpRequest;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;

public class OpaQueryClient
implements OpaQueryApi {
    private static final String EVALUATE_POLICY_ENDPOINT = "/v1/data/";
    private static final String EMPTY_RESULT_ERROR_MESSAGE = "Result is empty, it may indicate that document under path [%s] does not exist";
    private final OpaRestClient opaRestClient;

    public OpaQueryClient(OpaRestClient opaRestClient) {
        this.opaRestClient = opaRestClient;
    }

    @Override
    public <R> R queryForDocument(QueryForDocumentRequest queryForDocumentRequest, Class<R> responseType) {
        return this.internalQueryForDocument(queryForDocumentRequest, responseType);
    }

    @Override
    public <R> R queryForDocument(QueryForDocumentRequest queryForDocumentRequest, ParameterizedType responseType) {
        return this.internalQueryForDocument(queryForDocumentRequest, responseType);
    }

    private <R> R internalQueryForDocument(QueryForDocumentRequest queryForDocumentRequest, Type responseType) {
        try {
            OpaQueryForDocumentRequest opaQueryForDocumentRequest = new OpaQueryForDocumentRequest(queryForDocumentRequest.getInput());
            HttpRequest request = this.opaRestClient.getBasicRequestBuilder(EVALUATE_POLICY_ENDPOINT + queryForDocumentRequest.getPath()).header("Content-Type", "application/json").POST(this.opaRestClient.getJsonBodyPublisher(opaQueryForDocumentRequest)).build();
            JavaType opaResponseType = this.getResponseJavaType(responseType);
            Object result = ((OpaQueryForDocumentResponse)((Supplier)this.opaRestClient.sendRequest(request, this.opaRestClient.getJsonBodyHandler(opaResponseType)).body()).get()).getResult();
            if (Objects.isNull(result)) {
                throw new OpaClientException(String.format(EMPTY_RESULT_ERROR_MESSAGE, queryForDocumentRequest.getPath()));
            }
            return (R)result;
        }
        catch (OpaClientException exception) {
            throw exception;
        }
        catch (Exception e) {
            throw new OpaClientException(e);
        }
    }

    private JavaType getResponseJavaType(Type responseType) throws ClassNotFoundException {
        JavaType opaResponseType;
        if (responseType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)responseType;
            Class[] classes = (Class[])Arrays.stream(parameterizedType.getActualTypeArguments()).map(type -> {
                try {
                    return Class.forName(type.getTypeName());
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Cannot find class configured in the responseType ".concat(type.getTypeName()), e);
                }
            }).toArray(Class[]::new);
            JavaType opaType = TypeFactory.defaultInstance().constructParametricType(Class.forName(parameterizedType.getRawType().getTypeName()), classes);
            opaResponseType = TypeFactory.defaultInstance().constructParametricType(OpaQueryForDocumentResponse.class, new JavaType[]{opaType});
        } else {
            opaResponseType = TypeFactory.defaultInstance().constructParametricType(OpaQueryForDocumentResponse.class, new Class[]{Class.forName(responseType.getTypeName())});
        }
        return opaResponseType;
    }
}

