/*
 * Decompiled with CFR 0.152.
 */
package com.bisnode.opa.client;

import java.beans.ConstructorProperties;
import java.net.URI;
import java.net.http.HttpClient;
import java.util.Objects;

public final class OpaConfiguration {
    private final String url;
    private final HttpClient.Version httpVersion;

    @ConstructorProperties(value={"url"})
    public OpaConfiguration(String url) {
        this.url = url;
        this.httpVersion = "https".equals(URI.create(url).getScheme()) ? HttpClient.Version.HTTP_2 : HttpClient.Version.HTTP_1_1;
    }

    @ConstructorProperties(value={"url", "httpVersion"})
    public OpaConfiguration(String url, HttpClient.Version httpVersion) {
        this.url = url;
        this.httpVersion = httpVersion;
    }

    public String getUrl() {
        return this.url;
    }

    public HttpClient.Version getHttpVersion() {
        return this.httpVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpaConfiguration that = (OpaConfiguration)o;
        return Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.url);
    }

    public String toString() {
        return "OpaConfiguration{url='" + this.url + "'}";
    }
}

