/*
 * Decompiled with CFR 0.152.
 */
package com.bisnode.opa.client.rest;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.http.HttpResponse;
import java.util.function.Function;
import java.util.function.Supplier;

class JsonBodyHandler<T>
implements HttpResponse.BodyHandler<Supplier<T>> {
    private final JavaType responseType;
    private final ObjectMapper objectMapper;

    public JsonBodyHandler(JavaType responseType, ObjectMapper objectMapper) {
        this.responseType = responseType;
        this.objectMapper = objectMapper;
    }

    public static <W> HttpResponse.BodySubscriber<Supplier<W>> asJSON(JavaType responseType, ObjectMapper objectMapper) {
        HttpResponse.BodySubscriber<InputStream> upstream = HttpResponse.BodySubscribers.ofInputStream();
        return HttpResponse.BodySubscribers.mapping(upstream, JsonBodyHandler.createMapper(responseType, objectMapper));
    }

    private static <W> Function<InputStream, Supplier<W>> createMapper(JavaType responseType, ObjectMapper objectMapper) {
        return is -> () -> JsonBodyHandler.mapToJson(responseType, is, objectMapper);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <W> W mapToJson(JavaType responseType, InputStream is, ObjectMapper objectMapper) {
        try (InputStream inputStream = is;){
            Object object = objectMapper.readValue(inputStream, responseType);
            return (W)object;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public HttpResponse.BodySubscriber<Supplier<T>> apply(HttpResponse.ResponseInfo responseInfo) {
        return JsonBodyHandler.asJSON(this.responseType, this.objectMapper);
    }
}

