/*
 * Decompiled with CFR 0.152.
 */
package com.bisnode.opa.client.rest;

import com.bisnode.opa.client.OpaClientException;
import com.bisnode.opa.client.OpaConfiguration;
import com.bisnode.opa.client.rest.JsonBodyHandler;
import com.bisnode.opa.client.rest.JsonBodyPublisher;
import com.bisnode.opa.client.rest.OpaServerConnectionException;
import com.bisnode.opa.client.rest.url.OpaUrl;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.SocketException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

public class OpaRestClient {
    private final OpaConfiguration opaConfiguration;
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper;

    public OpaRestClient(OpaConfiguration opaConfiguration, HttpClient httpClient, ObjectMapper objectMapper) {
        this.opaConfiguration = opaConfiguration;
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
    }

    public HttpRequest.Builder getBasicRequestBuilder(String endpoint) {
        OpaUrl url = OpaUrl.of(this.opaConfiguration.getUrl(), endpoint).normalized();
        return HttpRequest.newBuilder(url.toUri());
    }

    public HttpRequest.BodyPublisher getJsonBodyPublisher(Object body) throws JsonProcessingException {
        return JsonBodyPublisher.of(body, this.objectMapper);
    }

    public <T> JsonBodyHandler<T> getJsonBodyHandler(JavaType responseType) {
        return new JsonBodyHandler(responseType, this.objectMapper);
    }

    public <T> HttpResponse<T> sendRequest(HttpRequest request, HttpResponse.BodyHandler<T> bodyHandler) throws IOException, InterruptedException {
        try {
            HttpResponse<T> response = this.httpClient.send(request, bodyHandler);
            if (response.statusCode() >= 300) {
                throw new OpaClientException("Error in communication with OPA server, status code: " + response.statusCode());
            }
            return response;
        }
        catch (SocketException exception) {
            throw new OpaServerConnectionException("Could not reach OPA server", exception);
        }
    }
}

