/*
 * Decompiled with CFR 0.152.
 */
package com.bisnode.opa.client.rest.url;

import com.bisnode.opa.client.rest.url.InvalidEndpointException;
import java.net.URI;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpaUrl {
    private static final Logger log = LoggerFactory.getLogger(OpaUrl.class);
    private final String value;

    public static OpaUrl of(String serverUrl, String endpoint) {
        return new OpaUrl(OpaUrl.urlOf(serverUrl, endpoint));
    }

    private static String urlOf(String url, String endpoint) {
        return url + "/" + Optional.ofNullable(endpoint).orElseThrow(() -> new InvalidEndpointException("Invalid endpoint: " + endpoint));
    }

    public String getValue() {
        return this.value;
    }

    public OpaUrl normalized() {
        String normalizedValue = this.normalize(this.value);
        return new OpaUrl(normalizedValue);
    }

    public URI toUri() {
        return URI.create(this.value);
    }

    private String normalize(String inputUrl) {
        String normalized = this.removeExtraSlashes().andThen(this.removeTrailingSlash()).apply(inputUrl.trim());
        if (!inputUrl.equals(normalized)) {
            log.debug("Supplied URL [{}] is malformed, has to be normalized", (Object)inputUrl);
        }
        return normalized;
    }

    private Function<String, String> removeTrailingSlash() {
        return input -> input.endsWith("/") ? input.substring(0, input.length() - 1) : input;
    }

    private Function<String, String> removeExtraSlashes() {
        return input -> input.replaceAll("([^:])//+", "$1/");
    }

    private OpaUrl(String value) {
        this.value = value;
    }
}

