/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ExceptionUtilities;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtils {
    private static final Map<Class, Collection<Field>> _reflectedFields = new ConcurrentHashMap<Class, Collection<Field>>();

    private ReflectionUtils() {
    }

    public static Annotation getClassAnnotation(Class classToCheck, Class annoClass) {
        HashSet<Class> visited = new HashSet<Class>();
        LinkedList<Class> stack = new LinkedList<Class>();
        stack.add(classToCheck);
        while (!stack.isEmpty()) {
            Class classToChk = (Class)stack.pop();
            if (classToChk == null || visited.contains(classToChk)) continue;
            visited.add(classToChk);
            Object a = classToChk.getAnnotation(annoClass);
            if (a != null) {
                return a;
            }
            stack.push(classToChk.getSuperclass());
            ReflectionUtils.addInterfaces(classToChk, stack);
        }
        return null;
    }

    private static void addInterfaces(Class classToCheck, LinkedList<Class> stack) {
        for (Class<?> interFace : classToCheck.getInterfaces()) {
            stack.push(interFace);
        }
    }

    public static Annotation getMethodAnnotation(Method method, Class annoClass) {
        HashSet<Class> visited = new HashSet<Class>();
        LinkedList<Class> stack = new LinkedList<Class>();
        stack.add(method.getDeclaringClass());
        while (!stack.isEmpty()) {
            Class classToChk = (Class)stack.pop();
            if (classToChk == null || visited.contains(classToChk)) continue;
            visited.add(classToChk);
            Method m = ReflectionUtils.getMethod(classToChk, method.getName(), method.getParameterTypes());
            if (m == null) continue;
            Object a = m.getAnnotation(annoClass);
            if (a != null) {
                return a;
            }
            stack.push(classToChk.getSuperclass());
            ReflectionUtils.addInterfaces(method.getDeclaringClass(), stack);
        }
        return null;
    }

    public static Method getMethod(Class c, String method, Class ... types) {
        try {
            return c.getMethod(method, types);
        }
        catch (Exception nse) {
            return null;
        }
    }

    public static Collection<Field> getDeepDeclaredFields(Class c) {
        if (_reflectedFields.containsKey(c)) {
            return _reflectedFields.get(c);
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class curr = c; curr != null; curr = curr.getSuperclass()) {
            ReflectionUtils.getDeclaredFields(curr, fields);
        }
        _reflectedFields.put(c, fields);
        return fields;
    }

    public static void getDeclaredFields(Class c, Collection<Field> fields) {
        try {
            Field[] local;
            for (Field field : local = c.getDeclaredFields()) {
                int modifiers;
                if (!field.isAccessible()) {
                    try {
                        field.setAccessible(true);
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
                if (Modifier.isStatic(modifiers = field.getModifiers()) || field.getName().startsWith("this$") || Modifier.isTransient(modifiers)) continue;
                fields.add(field);
            }
        }
        catch (Throwable ignored) {
            ExceptionUtilities.safelyIgnoreException(ignored);
        }
    }

    public static Map<String, Field> getDeepDeclaredFieldMap(Class c) {
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        Collection<Field> fields = ReflectionUtils.getDeepDeclaredFields(c);
        for (Field field : fields) {
            String fieldName = field.getName();
            if (fieldMap.containsKey(fieldName)) {
                fieldMap.put(field.getDeclaringClass().getName() + '.' + fieldName, field);
                continue;
            }
            fieldMap.put(fieldName, field);
        }
        return fieldMap;
    }

    public static String getClassName(Object o) {
        return o == null ? "null" : o.getClass().getName();
    }
}

