/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class CaseInsensitiveMap<K, V>
implements Map<K, V> {
    private static final Map unmodifiableMap = Collections.unmodifiableMap(new HashMap());
    private final Map<K, V> map;

    public CaseInsensitiveMap() {
        this.map = new LinkedHashMap();
    }

    public CaseInsensitiveMap(int initialCapacity) {
        this.map = new LinkedHashMap(initialCapacity);
    }

    public CaseInsensitiveMap(Map<K, V> m) {
        this.map = m instanceof TreeMap ? this.copy(m, new TreeMap()) : (m instanceof HashMap ? this.copy(m, new HashMap(m.size())) : (m instanceof ConcurrentSkipListMap ? this.copy(m, new ConcurrentSkipListMap()) : (m instanceof ConcurrentHashMap ? this.copy(m, new ConcurrentHashMap(m.size())) : (m instanceof WeakHashMap ? this.copy(m, new WeakHashMap(m.size())) : this.copy(m, new LinkedHashMap(m.size()))))));
    }

    protected Map<K, V> copy(Map<K, V> source, Map dest) {
        for (Map.Entry<K, V> entry : source.entrySet()) {
            K key = entry.getKey();
            Object altKey = key instanceof String ? new CaseInsensitiveString((String)key) : key;
            dest.put(altKey, entry.getValue());
        }
        return dest;
    }

    public CaseInsensitiveMap(int initialCapacity, float loadFactor) {
        this.map = new LinkedHashMap(initialCapacity, loadFactor);
    }

    @Override
    public V get(Object key) {
        if (key instanceof String) {
            String keyString = (String)key;
            return this.map.get(new CaseInsensitiveString(keyString));
        }
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        if (key instanceof String) {
            CaseInsensitiveString newKey = new CaseInsensitiveString((String)key);
            return this.map.put(newKey, value);
        }
        return this.map.put(key, value);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            String keyString = (String)key;
            return this.map.containsKey(new CaseInsensitiveString(keyString));
        }
        return this.map.containsKey(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (m == null) {
            return;
        }
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        if (key instanceof String) {
            String keyString = (String)key;
            return this.map.remove(new CaseInsensitiveString(keyString));
        }
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Map)) {
            return false;
        }
        Map that = (Map)other;
        if (that.size() != this.size()) {
            return false;
        }
        for (Map.Entry entry : that.entrySet()) {
            Object thatKey = entry.getKey();
            if (!this.containsKey(thatKey)) {
                return false;
            }
            Object thatValue = entry.getValue();
            V thisValue = this.get(thatKey);
            if (!(thatValue == null || thisValue == null ? thatValue != thisValue : !thisValue.equals(thatValue))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (Map.Entry<K, V> entry : this.map.entrySet()) {
            K key = entry.getKey();
            int hKey = key instanceof String ? ((String)key).toLowerCase().hashCode() : (key == null ? 0 : key.hashCode());
            V value = entry.getValue();
            int hValue = value == null ? 0 : value.hashCode();
            h += hKey ^ hValue;
        }
        return h;
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<K> keySet() {
        return new LocalSet();
    }

    public Map<K, V> getWrappedMap() {
        return this.map;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet<Map.Entry<K, V>>();
    }

    protected static final class CaseInsensitiveString
    implements Comparable {
        private final String caseInsensitiveString;
        private Integer hash = null;

        protected CaseInsensitiveString(String string) {
            this.caseInsensitiveString = string;
        }

        public String toString() {
            return this.caseInsensitiveString;
        }

        public int hashCode() {
            if (this.hash == null) {
                this.hash = this.caseInsensitiveString.toLowerCase().hashCode();
            }
            return this.hash;
        }

        public boolean equals(Object obj) {
            return obj == this || this.compareTo(obj) == 0;
        }

        public int compareTo(Object o) {
            if (o instanceof String) {
                String other = (String)o;
                return this.caseInsensitiveString.compareToIgnoreCase(other);
            }
            if (o instanceof CaseInsensitiveString) {
                CaseInsensitiveString other = (CaseInsensitiveString)o;
                return this.caseInsensitiveString.compareToIgnoreCase(other.caseInsensitiveString);
            }
            return -1;
        }
    }

    public class CaseInsensitiveEntry<KK, VV>
    extends AbstractMap.SimpleEntry<KK, VV> {
        public CaseInsensitiveEntry(Map.Entry<KK, VV> entry) {
            super(entry);
        }

        @Override
        public KK getKey() {
            if (super.getKey() instanceof CaseInsensitiveString) {
                return (KK)super.getKey().toString();
            }
            return (KK)super.getKey();
        }

        @Override
        public VV setValue(VV value) {
            return CaseInsensitiveMap.this.map.put(super.getKey(), value);
        }
    }

    private class EntrySet<E>
    extends LinkedHashSet<E> {
        final Map<K, V> localMap;
        Iterator<Map.Entry<K, V>> iter;

        public EntrySet() {
            this.localMap = CaseInsensitiveMap.this;
        }

        @Override
        public int size() {
            return CaseInsensitiveMap.this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return CaseInsensitiveMap.this.map.isEmpty();
        }

        @Override
        public void clear() {
            CaseInsensitiveMap.this.map.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)o;
            if (this.localMap.containsKey(that.getKey())) {
                Object value = this.localMap.get(that.getKey());
                if (value == null) {
                    return that.getValue() == null;
                }
                return value.equals(that.getValue());
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            boolean exists = this.contains(o);
            if (!exists) {
                return false;
            }
            Map.Entry that = (Map.Entry)o;
            this.localMap.remove(that.getKey());
            return true;
        }

        @Override
        public boolean removeAll(Collection c) {
            int size = this.size();
            for (Object o : c) {
                if (!this.contains(o)) continue;
                this.remove(o);
            }
            return this.size() != size;
        }

        @Override
        public boolean retainAll(Collection c) {
            CaseInsensitiveMap other = new CaseInsensitiveMap();
            for (Object o : c) {
                if (!(o instanceof Map.Entry)) continue;
                other.put(((Map.Entry)o).getKey(), ((Map.Entry)o).getValue());
            }
            int origSize = this.size();
            Iterator i = CaseInsensitiveMap.this.map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (!other.containsKey(key)) {
                    i.remove();
                    continue;
                }
                Object v = other.get(key);
                if (v == null) {
                    if (value == null) continue;
                    i.remove();
                    continue;
                }
                if (v.equals(value)) continue;
                i.remove();
            }
            return this.size() != origSize;
        }

        @Override
        public boolean add(E o) {
            throw new UnsupportedOperationException("Cannot add() to a 'view' of a Map.  See JavaDoc for Map.entrySet()");
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException("Cannot addAll() to a 'view' of a Map.  See JavaDoc for Map.entrySet()");
        }

        @Override
        public Iterator iterator() {
            this.iter = CaseInsensitiveMap.this.map.entrySet().iterator();
            return new Iterator(){
                Map.Entry lastReturned = null;

                @Override
                public boolean hasNext() {
                    return EntrySet.this.iter.hasNext();
                }

                public Object next() {
                    this.lastReturned = EntrySet.this.iter.next();
                    return new CaseInsensitiveEntry(this.lastReturned);
                }

                @Override
                public void remove() {
                    EntrySet.this.iter.remove();
                }
            };
        }
    }

    private class LocalSet
    extends AbstractSet<K> {
        final Map<K, V> localMap;
        Iterator iter;

        public LocalSet() {
            this.localMap = CaseInsensitiveMap.this;
        }

        @Override
        public boolean contains(Object o) {
            return this.localMap.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            boolean exists = this.localMap.containsKey(o);
            this.localMap.remove(o);
            return exists;
        }

        @Override
        public boolean removeAll(Collection c) {
            int size = this.size();
            for (Object o : c) {
                if (!this.contains(o)) continue;
                this.remove(o);
            }
            return this.size() != size;
        }

        @Override
        public boolean retainAll(Collection c) {
            CaseInsensitiveMap other = new CaseInsensitiveMap();
            for (Object o : c) {
                other.put(o, null);
            }
            int origSize = this.size();
            Iterator i = CaseInsensitiveMap.this.map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                if (other.containsKey(entry.getKey())) continue;
                i.remove();
            }
            return this.size() != origSize;
        }

        @Override
        public boolean add(K o) {
            throw new UnsupportedOperationException("Cannot add() to a 'view' of a Map.  See JavaDoc for Map.keySet()");
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException("Cannot addAll() to a 'view' of a Map.  See JavaDoc for Map.keySet()");
        }

        @Override
        public Object[] toArray() {
            Object[] items = new Object[this.size()];
            int i = 0;
            for (Object key : CaseInsensitiveMap.this.map.keySet()) {
                items[i++] = key instanceof CaseInsensitiveString ? key.toString() : key;
            }
            return items;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length < this.size()) {
                return Arrays.copyOf(this.toArray(), this.size(), a.getClass());
            }
            System.arraycopy(this.toArray(), 0, a, 0, this.size());
            if (a.length > this.size()) {
                a[this.size()] = null;
            }
            return a;
        }

        @Override
        public int size() {
            return CaseInsensitiveMap.this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return CaseInsensitiveMap.this.map.isEmpty();
        }

        @Override
        public void clear() {
            CaseInsensitiveMap.this.map.clear();
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Object key : CaseInsensitiveMap.this.map.keySet()) {
                if (key == null) continue;
                h += key.hashCode();
            }
            return h;
        }

        @Override
        public Iterator<K> iterator() {
            this.iter = CaseInsensitiveMap.this.map.keySet().iterator();
            return new Iterator<K>(){
                Object lastReturned = null;

                @Override
                public boolean hasNext() {
                    return LocalSet.this.iter.hasNext();
                }

                @Override
                public K next() {
                    this.lastReturned = LocalSet.this.iter.next();
                    if (this.lastReturned instanceof CaseInsensitiveString) {
                        this.lastReturned = this.lastReturned.toString();
                    }
                    return this.lastReturned;
                }

                @Override
                public void remove() {
                    LocalSet.this.iter.remove();
                }
            };
        }
    }
}

