/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.io.OutputStream;
import java.util.Arrays;

public class FastByteArrayOutputStream
extends OutputStream {
    protected byte[] buffer;
    protected int size;
    protected int delta;

    public FastByteArrayOutputStream() {
        this(1024, -1);
    }

    public FastByteArrayOutputStream(int capacity) {
        this(capacity, -1);
    }

    public FastByteArrayOutputStream(int capacity, int delta) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity must be at least 1 byte, passed in capacity=" + capacity);
        }
        this.buffer = new byte[capacity];
        this.delta = delta;
    }

    byte[] getBuffer() {
        return this.buffer;
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity - this.buffer.length > 0) {
            int oldCapacity = this.buffer.length;
            int newCapacity = this.delta < 1 ? oldCapacity << 1 : oldCapacity + this.delta;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            this.buffer = Arrays.copyOf(this.buffer, newCapacity);
        }
    }

    @Override
    public void write(int b) {
        this.ensureCapacity(this.size + 1);
        this.buffer[this.size] = (byte)b;
        ++this.size;
    }

    @Override
    public void write(byte[] bytes, int offset, int len) {
        if (bytes == null) {
            return;
        }
        if (offset < 0 || offset > bytes.length || len < 0 || offset + len - bytes.length > 0) {
            throw new IndexOutOfBoundsException("offset=" + offset + ", len=" + len + ", bytes.length=" + bytes.length);
        }
        this.ensureCapacity(this.size + len);
        System.arraycopy(bytes, offset, this.buffer, this.size, len);
        this.size += len;
    }

    public void clear() {
        this.size = 0;
    }

    public int size() {
        return this.size;
    }
}

