/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.FastByteArrayOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public final class IOUtilities {
    private static final int TRANSFER_BUFFER = 32768;

    private IOUtilities() {
    }

    public static InputStream getInputStream(URLConnection c) throws IOException {
        InputStream is = c.getInputStream();
        String enc = c.getContentEncoding();
        if ("gzip".equalsIgnoreCase(enc) || "x-gzip".equalsIgnoreCase(enc)) {
            is = new GZIPInputStream(is, 32768);
        } else if ("deflate".equalsIgnoreCase(enc)) {
            is = new InflaterInputStream(is, new Inflater(), 32768);
        }
        return new BufferedInputStream(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transfer(File f, URLConnection c, TransferCallback cb) throws Exception {
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(f));
            out = new BufferedOutputStream(c.getOutputStream());
            IOUtilities.transfer((InputStream)in, out, cb);
        }
        catch (Throwable throwable) {
            IOUtilities.close(in);
            IOUtilities.close(out);
            throw throwable;
        }
        IOUtilities.close(in);
        IOUtilities.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transfer(URLConnection c, File f, TransferCallback cb) throws Exception {
        InputStream in = null;
        try {
            in = IOUtilities.getInputStream(c);
            IOUtilities.transfer(in, f, cb);
        }
        finally {
            IOUtilities.close(in);
        }
    }

    public static void transfer(InputStream s, File f, TransferCallback cb) throws Exception {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));){
            IOUtilities.transfer(s, out, cb);
        }
    }

    public static void transfer(InputStream in, OutputStream out, TransferCallback cb) throws IOException {
        int count;
        byte[] bytes = new byte[32768];
        while ((count = in.read(bytes)) != -1) {
            out.write(bytes, 0, count);
            if (cb == null) continue;
            cb.bytesTransferred(bytes, count);
            if (!cb.isCancelled()) continue;
            break;
        }
    }

    public static void transfer(InputStream in, byte[] bytes) throws IOException {
        int offset;
        int numRead;
        for (offset = 0; offset < bytes.length && (numRead = in.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Retry:  Not all bytes were transferred correctly.");
        }
    }

    public static void transfer(InputStream in, OutputStream out) throws IOException {
        int count;
        byte[] bytes = new byte[32768];
        while ((count = in.read(bytes)) != -1) {
            out.write(bytes, 0, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transfer(File file, OutputStream out) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file), 32768);){
            IOUtilities.transfer((InputStream)in, out);
        }
        finally {
            IOUtilities.flush(out);
        }
    }

    public static void close(XMLStreamReader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public static void close(XMLStreamWriter writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public static void close(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void flush(Flushable f) {
        try {
            if (f != null) {
                f.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void flush(XMLStreamWriter writer) {
        try {
            if (writer != null) {
                writer.flush();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public static byte[] inputStreamToBytes(InputStream in) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtilities.transfer(in, (OutputStream)out);
            return out.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void transfer(URLConnection c, byte[] bytes) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(c.getOutputStream());){
            ((OutputStream)out).write(bytes);
        }
    }

    public static void compressBytes(ByteArrayOutputStream original, ByteArrayOutputStream compressed) throws IOException {
        GZIPOutputStream gzipStream = new GZIPOutputStream((OutputStream)compressed, 32768);
        original.writeTo(gzipStream);
        gzipStream.flush();
        gzipStream.close();
    }

    public static void compressBytes(FastByteArrayOutputStream original, FastByteArrayOutputStream compressed) throws IOException {
        GZIPOutputStream gzipStream = new GZIPOutputStream((OutputStream)compressed, 32768);
        ((DeflaterOutputStream)gzipStream).write(original.buffer, 0, original.size);
        gzipStream.flush();
        gzipStream.close();
    }

    public static byte[] compressBytes(byte[] bytes) {
        return IOUtilities.compressBytes(bytes, 0, bytes.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] compressBytes(byte[] bytes, int offset, int len) {
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();){
            try (GZIPOutputStream gzipStream = new GZIPOutputStream(byteStream);){
                gzipStream.write(bytes, offset, len);
                gzipStream.flush();
            }
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException("Error compressing bytes.", e);
        }
    }

    public static byte[] uncompressBytes(byte[] bytes) {
        return IOUtilities.uncompressBytes(bytes, 0, bytes.length);
    }

    /*
     * Exception decompiling
     */
    public static byte[] uncompressBytes(byte[] bytes, int offset, int len) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static interface TransferCallback {
        public void bytesTransferred(byte[] var1, int var2);

        public boolean isCancelled();
    }
}

