/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class CompactMap<K, V>
implements Map<K, V> {
    private static final String EMPTY_MAP = "_\ufe3f_\u03c8_\u263c";
    private Object val = "_\ufe3f_\u03c8_\u263c";

    @Override
    public int size() {
        if (this.val == EMPTY_MAP) {
            return 0;
        }
        if (this.isCompactMapEntry(this.val) || !(this.val instanceof Map)) {
            return 1;
        }
        Map map = (Map)this.val;
        return map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.val == EMPTY_MAP;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.size() == 1) {
            return this.getLogicalSingleKey().equals(key);
        }
        if (this.isEmpty()) {
            return false;
        }
        Map map = (Map)this.val;
        return map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.size() == 1) {
            return this.getLogicalSingleValue() == value;
        }
        if (this.isEmpty()) {
            return false;
        }
        Map map = (Map)this.val;
        return map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        if (this.size() == 1) {
            return this.getLogicalSingleKey().equals(key) ? (V)this.getLogicalSingleValue() : null;
        }
        if (this.isEmpty()) {
            return null;
        }
        Map map = (Map)this.val;
        return map.get(key);
    }

    @Override
    public V put(K key, V value) {
        if (this.size() == 1) {
            if (this.getLogicalSingleKey().equals(key)) {
                V save = this.getLogicalSingleValue();
                this.val = this.getSingleValueKey().equals(key) && !(value instanceof Map) ? value : new CompactMapEntry(key, value);
                return save;
            }
            Map<K, V> map = this.getNewMap();
            map.put(this.getLogicalSingleKey(), this.getLogicalSingleValue());
            map.put(key, value);
            this.val = map;
            return null;
        }
        if (this.isEmpty()) {
            this.val = this.getSingleValueKey().equals(key) && !(value instanceof Map) ? value : new CompactMapEntry(key, value);
            return null;
        }
        Map map = (Map)this.val;
        return map.put(key, value);
    }

    @Override
    public V remove(Object key) {
        if (this.size() == 1) {
            if (this.getLogicalSingleKey().equals(key)) {
                V save = this.getLogicalSingleValue();
                this.val = EMPTY_MAP;
                return save;
            }
            return null;
        }
        if (this.isEmpty()) {
            return null;
        }
        Map map = (Map)this.val;
        Object save = map.remove(key);
        if (map.size() == 1) {
            Map.Entry entry = map.entrySet().iterator().next();
            this.clear();
            this.put(entry.getKey(), entry.getValue());
        }
        return save;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.val = EMPTY_MAP;
    }

    @Override
    public int hashCode() {
        int h = 0;
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        while (i.hasNext()) {
            h += i.next().hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        int size = this.size();
        if (this.size() != other.size()) {
            return false;
        }
        if (this.isEmpty()) {
            return other.isEmpty();
        }
        if (size == 1) {
            return this.entrySet().equals(other.entrySet());
        }
        Map map = (Map)this.val;
        return map.equals(other);
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){
            Iterator<K> iter;

            @Override
            public Iterator<K> iterator() {
                if (CompactMap.this.size() == 1) {
                    HashMap<Object, Object> map = new HashMap<Object, Object>();
                    map.put(CompactMap.this.getLogicalSingleKey(), CompactMap.this.getLogicalSingleValue());
                    this.iter = map.keySet().iterator();
                    return new Iterator<K>(){

                        @Override
                        public boolean hasNext() {
                            return iter.hasNext();
                        }

                        @Override
                        public K next() {
                            return iter.next();
                        }

                        @Override
                        public void remove() {
                            CompactMap.this.clear();
                        }
                    };
                }
                if (CompactMap.this.isEmpty()) {
                    return new Iterator<K>(){

                        @Override
                        public boolean hasNext() {
                            return false;
                        }

                        @Override
                        public K next() {
                            throw new NoSuchElementException(".next() called on an empty CompactMap's keySet()");
                        }

                        @Override
                        public void remove() {
                            throw new IllegalStateException(".remove() called on an empty CompactMap's keySet()");
                        }
                    };
                }
                Map map = (Map)CompactMap.this.val;
                this.iter = map.keySet().iterator();
                return new Iterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    @Override
                    public K next() {
                        return iter.next();
                    }

                    @Override
                    public void remove() {
                        CompactMap.this.removeIteratorItem(iter, "keySet");
                    }
                };
            }

            @Override
            public int size() {
                return CompactMap.this.size();
            }

            @Override
            public boolean contains(Object o) {
                return CompactMap.this.containsKey(o);
            }

            @Override
            public void clear() {
                CompactMap.this.clear();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){
            Iterator<V> iter;

            @Override
            public Iterator<V> iterator() {
                if (CompactMap.this.size() == 1) {
                    HashMap<Object, Object> map = new HashMap<Object, Object>();
                    map.put(CompactMap.this.getLogicalSingleKey(), CompactMap.this.getLogicalSingleValue());
                    this.iter = map.values().iterator();
                    return new Iterator<V>(){

                        @Override
                        public boolean hasNext() {
                            return iter.hasNext();
                        }

                        @Override
                        public V next() {
                            return iter.next();
                        }

                        @Override
                        public void remove() {
                            CompactMap.this.clear();
                        }
                    };
                }
                if (CompactMap.this.isEmpty()) {
                    return new Iterator<V>(){

                        @Override
                        public boolean hasNext() {
                            return false;
                        }

                        @Override
                        public V next() {
                            throw new NoSuchElementException(".next() called on an empty CompactMap's values()");
                        }

                        @Override
                        public void remove() {
                            throw new IllegalStateException(".remove() called on an empty CompactMap's values()");
                        }
                    };
                }
                Map map = (Map)CompactMap.this.val;
                this.iter = map.values().iterator();
                return new Iterator<V>(){

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    @Override
                    public V next() {
                        return iter.next();
                    }

                    @Override
                    public void remove() {
                        CompactMap.this.removeIteratorItem(iter, "values");
                    }
                };
            }

            @Override
            public int size() {
                return CompactMap.this.size();
            }

            @Override
            public void clear() {
                CompactMap.this.clear();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){
            Iterator<Map.Entry<K, V>> iter;

            @Override
            public int size() {
                return CompactMap.this.size();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                if (CompactMap.this.size() == 1) {
                    HashMap<Object, Object> map = new HashMap<Object, Object>();
                    map.put(CompactMap.this.getLogicalSingleKey(), CompactMap.this.getLogicalSingleValue());
                    this.iter = map.entrySet().iterator();
                    return new Iterator<Map.Entry<K, V>>(){

                        @Override
                        public boolean hasNext() {
                            return iter.hasNext();
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            Map.Entry entry = iter.next();
                            return new CompactMapEntry(entry.getKey(), entry.getValue());
                        }

                        @Override
                        public void remove() {
                            CompactMap.this.clear();
                        }
                    };
                }
                if (CompactMap.this.isEmpty()) {
                    return new Iterator<Map.Entry<K, V>>(){

                        @Override
                        public boolean hasNext() {
                            return false;
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            throw new NoSuchElementException(".next() called on an empty CompactMap's entrySet()");
                        }

                        @Override
                        public void remove() {
                            throw new IllegalStateException(".remove() called on an empty CompactMap's entrySet()");
                        }
                    };
                }
                Map map = (Map)CompactMap.this.val;
                this.iter = map.entrySet().iterator();
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return iter.next();
                    }

                    @Override
                    public void remove() {
                        CompactMap.this.removeIteratorItem(iter, "entrySet");
                    }
                };
            }

            @Override
            public void clear() {
                CompactMap.this.clear();
            }
        };
    }

    private void removeIteratorItem(Iterator iter, String methodName) {
        if (this.size() == 1) {
            this.clear();
        } else {
            if (this.isEmpty()) {
                throw new IllegalStateException(".remove() called on an empty CompactMap's " + methodName + " iterator");
            }
            if (this.size() == 2) {
                Iterator entryIterator = ((Map)this.val).entrySet().iterator();
                Map.Entry firstEntry = entryIterator.next();
                Map.Entry secondEntry = entryIterator.next();
                this.clear();
                if (iter.hasNext()) {
                    this.put(secondEntry.getKey(), secondEntry.getValue());
                } else {
                    this.put(firstEntry.getKey(), firstEntry.getValue());
                }
            } else {
                iter.remove();
            }
        }
    }

    public Map minus(Object removeMe) {
        throw new UnsupportedOperationException("Unsupported operation [minus] or [-] between Maps.  Use removeAll() or retainAll() instead.");
    }

    public Map plus(Object right) {
        throw new UnsupportedOperationException("Unsupported operation [plus] or [+] between Maps.  Use putAll() instead.");
    }

    protected LogicalValueType getLogicalValueType() {
        if (this.size() == 1) {
            if (this.isCompactMapEntry(this.val)) {
                return LogicalValueType.ENTRY;
            }
            return LogicalValueType.OBJECT;
        }
        if (this.isEmpty()) {
            return LogicalValueType.EMPTY;
        }
        return LogicalValueType.MAP;
    }

    private K getLogicalSingleKey() {
        if (this.isCompactMapEntry(this.val)) {
            CompactMapEntry entry = (CompactMapEntry)this.val;
            return entry.getKey();
        }
        return this.getSingleValueKey();
    }

    private V getLogicalSingleValue() {
        if (this.isCompactMapEntry(this.val)) {
            CompactMapEntry entry = (CompactMapEntry)this.val;
            return entry.getValue();
        }
        return (V)this.val;
    }

    private boolean isCompactMapEntry(Object o) {
        if (o == null) {
            return false;
        }
        return CompactMapEntry.class.isAssignableFrom(o.getClass());
    }

    protected abstract K getSingleValueKey();

    protected abstract Map<K, V> getNewMap();

    private class CompactMapEntry
    extends AbstractMap.SimpleEntry<K, V> {
        private CompactMapEntry(K key, V value) {
            super(key, value);
        }

        @Override
        public V setValue(V value) {
            Object save = this.getValue();
            super.setValue(value);
            CompactMap.this.put(this.getKey(), value);
            return save;
        }
    }

    protected static enum LogicalValueType {
        EMPTY,
        OBJECT,
        ENTRY,
        MAP;

    }
}

