/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.DateUtilities;
import com.cedarsoftware.util.SafeSimpleDateFormat;
import com.cedarsoftware.util.StringUtilities;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class Converter {
    private static final Byte BYTE_ZERO = 0;
    private static final Byte BYTE_ONE = 1;
    private static final Short SHORT_ZERO = 0;
    private static final Short SHORT_ONE = 1;
    private static final Integer INTEGER_ZERO = 0;
    private static final Integer INTEGER_ONE = 1;
    private static final Long LONG_ZERO = 0L;
    private static final Long LONG_ONE = 1L;
    private static final Float FLOAT_ZERO = Float.valueOf(0.0f);
    private static final Float FLOAT_ONE = Float.valueOf(1.0f);
    private static final Double DOUBLE_ZERO = 0.0;
    private static final Double DOUBLE_ONE = 1.0;
    private static final Map<Class<?>, Work> conversion = new HashMap();
    private static final Map<Class<?>, Work> conversionToString = new HashMap();
    public static final int NULL_PROPER = 0;
    public static final int NULL_NULL = 1;
    private static int null_mode = 0;

    public static void setNullMode(int mode) {
        null_mode = mode;
    }

    private Converter() {
    }

    public static <T> T convert(Object fromInstance, Class<T> toType) {
        if (toType == null) {
            throw new IllegalArgumentException("Type cannot be null in Converter.convert(value, type)");
        }
        Work work = conversion.get(toType);
        if (work != null) {
            return (T)work.convert(fromInstance);
        }
        throw new IllegalArgumentException("Unsupported type '" + toType.getName() + "' for conversion");
    }

    public static String convertToString(Object fromInstance) {
        if (fromInstance == null) {
            return null;
        }
        Class<?> clazz = fromInstance.getClass();
        Work work = conversionToString.get(clazz);
        if (work != null) {
            return (String)work.convert(fromInstance);
        }
        if (fromInstance instanceof Calendar) {
            return SafeSimpleDateFormat.getDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(((Calendar)fromInstance).getTime());
        }
        if (fromInstance instanceof Enum) {
            return ((Enum)fromInstance).name();
        }
        return Converter.nope(fromInstance, "String");
    }

    public static BigDecimal convertToBigDecimal(Object fromInstance) {
        if (fromInstance == null) {
            if (null_mode == 0) {
                return BigDecimal.ZERO;
            }
            return null;
        }
        try {
            if (fromInstance instanceof String) {
                if (StringUtilities.isEmpty((String)fromInstance)) {
                    return BigDecimal.ZERO;
                }
                return new BigDecimal(((String)fromInstance).trim());
            }
            if (fromInstance instanceof BigDecimal) {
                return (BigDecimal)fromInstance;
            }
            if (fromInstance instanceof BigInteger) {
                return new BigDecimal((BigInteger)fromInstance);
            }
            if (fromInstance instanceof Number) {
                return new BigDecimal(((Number)fromInstance).doubleValue());
            }
            if (fromInstance instanceof Boolean) {
                return (Boolean)fromInstance != false ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            if (fromInstance instanceof AtomicBoolean) {
                return ((AtomicBoolean)fromInstance).get() ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            if (fromInstance instanceof java.util.Date) {
                return new BigDecimal(((java.util.Date)fromInstance).getTime());
            }
            if (fromInstance instanceof Calendar) {
                return new BigDecimal(((Calendar)fromInstance).getTime().getTime());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'BigDecimal'", e);
        }
        Converter.nope(fromInstance, "BigDecimal");
        return null;
    }

    public static BigInteger convertToBigInteger(Object fromInstance) {
        if (fromInstance == null) {
            if (null_mode == 0) {
                return BigInteger.ZERO;
            }
            return null;
        }
        try {
            if (fromInstance instanceof String) {
                if (StringUtilities.isEmpty((String)fromInstance)) {
                    return BigInteger.ZERO;
                }
                return new BigInteger(((String)fromInstance).trim());
            }
            if (fromInstance instanceof BigInteger) {
                return (BigInteger)fromInstance;
            }
            if (fromInstance instanceof BigDecimal) {
                return ((BigDecimal)fromInstance).toBigInteger();
            }
            if (fromInstance instanceof Number) {
                return new BigInteger(Long.toString(((Number)fromInstance).longValue()));
            }
            if (fromInstance instanceof Boolean) {
                return (Boolean)fromInstance != false ? BigInteger.ONE : BigInteger.ZERO;
            }
            if (fromInstance instanceof AtomicBoolean) {
                return ((AtomicBoolean)fromInstance).get() ? BigInteger.ONE : BigInteger.ZERO;
            }
            if (fromInstance instanceof java.util.Date) {
                return new BigInteger(Long.toString(((java.util.Date)fromInstance).getTime()));
            }
            if (fromInstance instanceof Calendar) {
                return new BigInteger(Long.toString(((Calendar)fromInstance).getTime().getTime()));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'BigInteger'", e);
        }
        Converter.nope(fromInstance, "BigInteger");
        return null;
    }

    public static Date convertToSqlDate(Object fromInstance) {
        if (fromInstance == null) {
            return null;
        }
        try {
            if (fromInstance instanceof Date) {
                return new Date(((Date)fromInstance).getTime());
            }
            if (fromInstance instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)fromInstance;
                return new Date(timestamp.getTime());
            }
            if (fromInstance instanceof java.util.Date) {
                return new Date(((java.util.Date)fromInstance).getTime());
            }
            if (fromInstance instanceof String) {
                java.util.Date date = DateUtilities.parseDate(((String)fromInstance).trim());
                if (date == null) {
                    return null;
                }
                return new Date(date.getTime());
            }
            if (fromInstance instanceof Calendar) {
                return new Date(((Calendar)fromInstance).getTime().getTime());
            }
            if (fromInstance instanceof Long) {
                return new Date((Long)fromInstance);
            }
            if (fromInstance instanceof BigInteger) {
                return new Date(((BigInteger)fromInstance).longValue());
            }
            if (fromInstance instanceof BigDecimal) {
                return new Date(((BigDecimal)fromInstance).longValue());
            }
            if (fromInstance instanceof AtomicLong) {
                return new Date(((AtomicLong)fromInstance).get());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'java.sql.Date'", e);
        }
        Converter.nope(fromInstance, "java.sql.Date");
        return null;
    }

    public static Timestamp convertToTimestamp(Object fromInstance) {
        if (fromInstance == null) {
            return null;
        }
        try {
            if (fromInstance instanceof Date) {
                return new Timestamp(((Date)fromInstance).getTime());
            }
            if (fromInstance instanceof Timestamp) {
                return new Timestamp(((Timestamp)fromInstance).getTime());
            }
            if (fromInstance instanceof java.util.Date) {
                return new Timestamp(((java.util.Date)fromInstance).getTime());
            }
            if (fromInstance instanceof String) {
                java.util.Date date = DateUtilities.parseDate(((String)fromInstance).trim());
                if (date == null) {
                    return null;
                }
                return new Timestamp(date.getTime());
            }
            if (fromInstance instanceof Calendar) {
                return new Timestamp(((Calendar)fromInstance).getTime().getTime());
            }
            if (fromInstance instanceof Long) {
                return new Timestamp((Long)fromInstance);
            }
            if (fromInstance instanceof BigInteger) {
                return new Timestamp(((BigInteger)fromInstance).longValue());
            }
            if (fromInstance instanceof BigDecimal) {
                return new Timestamp(((BigDecimal)fromInstance).longValue());
            }
            if (fromInstance instanceof AtomicLong) {
                return new Timestamp(((AtomicLong)fromInstance).get());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Timestamp'", e);
        }
        Converter.nope(fromInstance, "Timestamp");
        return null;
    }

    public static java.util.Date convertToDate(Object fromInstance) {
        if (fromInstance == null) {
            return null;
        }
        try {
            if (fromInstance instanceof String) {
                return DateUtilities.parseDate(((String)fromInstance).trim());
            }
            if (fromInstance instanceof Date) {
                return new java.util.Date(((Date)fromInstance).getTime());
            }
            if (fromInstance instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)fromInstance;
                return new java.util.Date(timestamp.getTime());
            }
            if (fromInstance instanceof java.util.Date) {
                return new java.util.Date(((java.util.Date)fromInstance).getTime());
            }
            if (fromInstance instanceof Calendar) {
                return ((Calendar)fromInstance).getTime();
            }
            if (fromInstance instanceof Long) {
                return new java.util.Date((Long)fromInstance);
            }
            if (fromInstance instanceof BigInteger) {
                return new java.util.Date(((BigInteger)fromInstance).longValue());
            }
            if (fromInstance instanceof BigDecimal) {
                return new java.util.Date(((BigDecimal)fromInstance).longValue());
            }
            if (fromInstance instanceof AtomicLong) {
                return new java.util.Date(((AtomicLong)fromInstance).get());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Date'", e);
        }
        Converter.nope(fromInstance, "Date");
        return null;
    }

    public static Calendar convertToCalendar(Object fromInstance) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(Converter.convertToDate(fromInstance));
        return calendar;
    }

    public static Byte convertToByte(Object fromInstance) {
        if (fromInstance == null) {
            if (null_mode == 0) {
                return BYTE_ZERO;
            }
            return null;
        }
        try {
            if (fromInstance instanceof String) {
                if (StringUtilities.isEmpty((String)fromInstance)) {
                    return BYTE_ZERO;
                }
                return Byte.valueOf(((String)fromInstance).trim());
            }
            if (fromInstance instanceof Byte) {
                return (Byte)fromInstance;
            }
            if (fromInstance instanceof Number) {
                return ((Number)fromInstance).byteValue();
            }
            if (fromInstance instanceof Boolean) {
                return (Boolean)fromInstance != false ? BYTE_ONE : BYTE_ZERO;
            }
            if (fromInstance instanceof AtomicBoolean) {
                return ((AtomicBoolean)fromInstance).get() ? BYTE_ONE : BYTE_ZERO;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Byte'", e);
        }
        Converter.nope(fromInstance, "Byte");
        return null;
    }

    public static Short convertToShort(Object fromInstance) {
        if (fromInstance == null) {
            if (null_mode == 0) {
                return SHORT_ZERO;
            }
            return null;
        }
        try {
            if (fromInstance instanceof String) {
                if (StringUtilities.isEmpty((String)fromInstance)) {
                    return SHORT_ZERO;
                }
                return Short.valueOf(((String)fromInstance).trim());
            }
            if (fromInstance instanceof Short) {
                return (Short)fromInstance;
            }
            if (fromInstance instanceof Number) {
                return ((Number)fromInstance).shortValue();
            }
            if (fromInstance instanceof Boolean) {
                return (Boolean)fromInstance != false ? SHORT_ONE : SHORT_ZERO;
            }
            if (fromInstance instanceof AtomicBoolean) {
                return ((AtomicBoolean)fromInstance).get() ? SHORT_ONE : SHORT_ZERO;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Short'", e);
        }
        Converter.nope(fromInstance, "Short");
        return null;
    }

    public static Integer convertToInteger(Object fromInstance) {
        if (fromInstance == null) {
            if (null_mode == 0) {
                return INTEGER_ZERO;
            }
            return null;
        }
        try {
            if (fromInstance instanceof Integer) {
                return (Integer)fromInstance;
            }
            if (fromInstance instanceof Number) {
                return ((Number)fromInstance).intValue();
            }
            if (fromInstance instanceof String) {
                if (StringUtilities.isEmpty((String)fromInstance)) {
                    return INTEGER_ZERO;
                }
                return Integer.valueOf(((String)fromInstance).trim());
            }
            if (fromInstance instanceof Boolean) {
                return (Boolean)fromInstance != false ? INTEGER_ONE : INTEGER_ZERO;
            }
            if (fromInstance instanceof AtomicBoolean) {
                return ((AtomicBoolean)fromInstance).get() ? INTEGER_ONE : INTEGER_ZERO;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to an 'Integer'", e);
        }
        Converter.nope(fromInstance, "Integer");
        return null;
    }

    public static Long convertToLong(Object fromInstance) {
        if (fromInstance == null) {
            if (null_mode == 0) {
                return LONG_ZERO;
            }
            return null;
        }
        try {
            if (fromInstance instanceof Long) {
                return (Long)fromInstance;
            }
            if (fromInstance instanceof String) {
                if ("".equals(fromInstance)) {
                    return LONG_ZERO;
                }
                return Long.valueOf(((String)fromInstance).trim());
            }
            if (fromInstance instanceof Number) {
                return ((Number)fromInstance).longValue();
            }
            if (fromInstance instanceof Boolean) {
                return (Boolean)fromInstance != false ? LONG_ONE : LONG_ZERO;
            }
            if (fromInstance instanceof java.util.Date) {
                return ((java.util.Date)fromInstance).getTime();
            }
            if (fromInstance instanceof AtomicBoolean) {
                return ((AtomicBoolean)fromInstance).get() ? LONG_ONE : LONG_ZERO;
            }
            if (fromInstance instanceof Calendar) {
                return ((Calendar)fromInstance).getTime().getTime();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Long'", e);
        }
        Converter.nope(fromInstance, "Long");
        return null;
    }

    public static Float convertToFloat(Object fromInstance) {
        if (fromInstance == null) {
            if (null_mode == 0) {
                return FLOAT_ZERO;
            }
            return null;
        }
        try {
            if (fromInstance instanceof String) {
                if (StringUtilities.isEmpty((String)fromInstance)) {
                    return FLOAT_ZERO;
                }
                return Float.valueOf(((String)fromInstance).trim());
            }
            if (fromInstance instanceof Float) {
                return (Float)fromInstance;
            }
            if (fromInstance instanceof Number) {
                return Float.valueOf(((Number)fromInstance).floatValue());
            }
            if (fromInstance instanceof Boolean) {
                return (Boolean)fromInstance != false ? FLOAT_ONE : FLOAT_ZERO;
            }
            if (fromInstance instanceof AtomicBoolean) {
                return ((AtomicBoolean)fromInstance).get() ? FLOAT_ONE : FLOAT_ZERO;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Float'", e);
        }
        Converter.nope(fromInstance, "Float");
        return null;
    }

    public static Double convertToDouble(Object fromInstance) {
        if (fromInstance == null) {
            if (null_mode == 0) {
                return DOUBLE_ZERO;
            }
            return null;
        }
        try {
            if (fromInstance instanceof String) {
                if (StringUtilities.isEmpty((String)fromInstance)) {
                    return DOUBLE_ZERO;
                }
                return Double.valueOf(((String)fromInstance).trim());
            }
            if (fromInstance instanceof Double) {
                return (Double)fromInstance;
            }
            if (fromInstance instanceof Number) {
                return ((Number)fromInstance).doubleValue();
            }
            if (fromInstance instanceof Boolean) {
                return (Boolean)fromInstance != false ? DOUBLE_ONE : DOUBLE_ZERO;
            }
            if (fromInstance instanceof AtomicBoolean) {
                return ((AtomicBoolean)fromInstance).get() ? DOUBLE_ONE : DOUBLE_ZERO;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Double'", e);
        }
        Converter.nope(fromInstance, "Double");
        return null;
    }

    public static Boolean convertToBoolean(Object fromInstance) {
        if (fromInstance == null) {
            if (null_mode == 0) {
                return false;
            }
            return null;
        }
        if (fromInstance instanceof Boolean) {
            return (Boolean)fromInstance;
        }
        if (fromInstance instanceof String) {
            if ("true".equals(fromInstance)) {
                return true;
            }
            if ("false".equals(fromInstance)) {
                return false;
            }
            return "true".equalsIgnoreCase((String)fromInstance);
        }
        if (fromInstance instanceof Number) {
            return ((Number)fromInstance).longValue() != 0L;
        }
        if (fromInstance instanceof AtomicBoolean) {
            return ((AtomicBoolean)fromInstance).get();
        }
        Converter.nope(fromInstance, "Boolean");
        return false;
    }

    public static AtomicInteger convertToAtomicInteger(Object fromInstance) {
        if (fromInstance == null) {
            return new AtomicInteger(0);
        }
        try {
            if (fromInstance instanceof AtomicInteger) {
                return new AtomicInteger(((AtomicInteger)fromInstance).get());
            }
            if (fromInstance instanceof String) {
                if (StringUtilities.isEmpty((String)fromInstance)) {
                    return new AtomicInteger(0);
                }
                return new AtomicInteger(Integer.valueOf(((String)fromInstance).trim()));
            }
            if (fromInstance instanceof Number) {
                return new AtomicInteger(((Number)fromInstance).intValue());
            }
            if (fromInstance instanceof Boolean) {
                return (Boolean)fromInstance != false ? new AtomicInteger(1) : new AtomicInteger(0);
            }
            if (fromInstance instanceof AtomicBoolean) {
                return ((AtomicBoolean)fromInstance).get() ? new AtomicInteger(1) : new AtomicInteger(0);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to an 'AtomicInteger'", e);
        }
        Converter.nope(fromInstance, "AtomicInteger");
        return null;
    }

    public static AtomicLong convertToAtomicLong(Object fromInstance) {
        if (fromInstance == null) {
            return new AtomicLong(0L);
        }
        try {
            if (fromInstance instanceof String) {
                if (StringUtilities.isEmpty((String)fromInstance)) {
                    return new AtomicLong(0L);
                }
                return new AtomicLong(Long.valueOf(((String)fromInstance).trim()));
            }
            if (fromInstance instanceof AtomicLong) {
                return new AtomicLong(((AtomicLong)fromInstance).get());
            }
            if (fromInstance instanceof Number) {
                return new AtomicLong(((Number)fromInstance).longValue());
            }
            if (fromInstance instanceof java.util.Date) {
                return new AtomicLong(((java.util.Date)fromInstance).getTime());
            }
            if (fromInstance instanceof Boolean) {
                return (Boolean)fromInstance != false ? new AtomicLong(1L) : new AtomicLong(0L);
            }
            if (fromInstance instanceof AtomicBoolean) {
                return ((AtomicBoolean)fromInstance).get() ? new AtomicLong(1L) : new AtomicLong(0L);
            }
            if (fromInstance instanceof Calendar) {
                return new AtomicLong(((Calendar)fromInstance).getTime().getTime());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to an 'AtomicLong'", e);
        }
        Converter.nope(fromInstance, "AtomicLong");
        return null;
    }

    public static AtomicBoolean convertToAtomicBoolean(Object fromInstance) {
        if (fromInstance == null) {
            return new AtomicBoolean(false);
        }
        if (fromInstance instanceof String) {
            if (StringUtilities.isEmpty((String)fromInstance)) {
                return new AtomicBoolean(false);
            }
            String value = (String)fromInstance;
            return new AtomicBoolean("true".equalsIgnoreCase(value));
        }
        if (fromInstance instanceof AtomicBoolean) {
            return new AtomicBoolean(((AtomicBoolean)fromInstance).get());
        }
        if (fromInstance instanceof Boolean) {
            return new AtomicBoolean((Boolean)fromInstance);
        }
        if (fromInstance instanceof Number) {
            return new AtomicBoolean(((Number)fromInstance).longValue() != 0L);
        }
        Converter.nope(fromInstance, "AtomicBoolean");
        return null;
    }

    private static String nope(Object fromInstance, String targetType) {
        throw new IllegalArgumentException("Unsupported value type [" + Converter.name(fromInstance) + "] attempting to convert to '" + targetType + "'");
    }

    private static String name(Object fromInstance) {
        if (fromInstance == null) {
            return "(null)";
        }
        return fromInstance.getClass().getName() + " (" + fromInstance.toString() + ")";
    }

    static {
        conversion.put(String.class, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return Converter.convertToString(fromInstance);
            }
        });
        conversion.put(Long.TYPE, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return Converter.convertToLong(fromInstance);
            }
        });
        conversion.put(Long.class, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return Converter.convertToLong(fromInstance);
            }
        });
        conversion.put(Integer.TYPE, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return Converter.convertToInteger(fromInstance);
            }
        });
        conversion.put(Integer.class, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return Converter.convertToInteger(fromInstance);
            }
        });
        conversion.put(Calendar.class, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return Converter.convertToCalendar(fromInstance);
            }
        });
        conversion.put(java.util.Date.class, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return Converter.convertToDate(fromInstance);
            }
        });
        conversion.put(BigDecimal.class, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return Converter.convertToBigDecimal(fromInstance);
            }
        });
        conversion.put(BigInteger.class, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return Converter.convertToBigInteger(fromInstance);
            }
        });
        conversion.put(Date.class, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return Converter.convertToSqlDate(fromInstance);
            }
        });
        conversion.put(Timestamp.class, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return Converter.convertToTimestamp(fromInstance);
            }
        });
        conversion.put(AtomicInteger.class, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return Converter.convertToAtomicInteger(fromInstance);
            }
        });
        conversion.put(AtomicLong.class, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return Converter.convertToAtomicLong(fromInstance);
            }
        });
        conversion.put(AtomicBoolean.class, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return Converter.convertToAtomicBoolean(fromInstance);
            }
        });
        conversion.put(Boolean.TYPE, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return Converter.convertToBoolean(fromInstance);
            }
        });
        conversion.put(Boolean.class, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return Converter.convertToBoolean(fromInstance);
            }
        });
        conversion.put(Double.TYPE, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return Converter.convertToDouble(fromInstance);
            }
        });
        conversion.put(Double.class, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return Converter.convertToDouble(fromInstance);
            }
        });
        conversion.put(Byte.TYPE, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return Converter.convertToByte(fromInstance);
            }
        });
        conversion.put(Byte.class, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return Converter.convertToByte(fromInstance);
            }
        });
        conversion.put(Float.TYPE, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return Converter.convertToFloat(fromInstance);
            }
        });
        conversion.put(Float.class, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return Converter.convertToFloat(fromInstance);
            }
        });
        conversion.put(Short.TYPE, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return Converter.convertToShort(fromInstance);
            }
        });
        conversion.put(Short.class, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return Converter.convertToShort(fromInstance);
            }
        });
        conversionToString.put(String.class, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return fromInstance;
            }
        });
        conversionToString.put(BigDecimal.class, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                BigDecimal bd = Converter.convertToBigDecimal(fromInstance);
                return bd.stripTrailingZeros().toPlainString();
            }
        });
        conversionToString.put(BigInteger.class, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                BigInteger bi = Converter.convertToBigInteger(fromInstance);
                return bi.toString();
            }
        });
        Work toString = new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return fromInstance.toString();
            }
        };
        conversionToString.put(Boolean.class, toString);
        conversionToString.put(AtomicBoolean.class, toString);
        conversionToString.put(Byte.class, toString);
        conversionToString.put(Short.class, toString);
        conversionToString.put(Integer.class, toString);
        conversionToString.put(AtomicInteger.class, toString);
        conversionToString.put(Long.class, toString);
        conversionToString.put(AtomicLong.class, toString);
        Work toNoExpString = new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return fromInstance.toString();
            }
        };
        conversionToString.put(Double.class, toNoExpString);
        conversionToString.put(Float.class, toNoExpString);
        conversionToString.put(java.util.Date.class, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return SafeSimpleDateFormat.getDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(fromInstance);
            }
        });
        conversionToString.put(Character.class, new Work(){

            @Override
            public Object convert(Object fromInstance) {
                return "" + fromInstance;
            }
        });
    }

    private static interface Work {
        public Object convert(Object var1);
    }
}

