/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseInsensitiveSet<E>
implements Set<E> {
    private final CaseInsensitiveMap<E, Object> map;

    public CaseInsensitiveSet() {
        this.map = new CaseInsensitiveMap();
    }

    public CaseInsensitiveSet(Collection<? extends E> collection) {
        this.map = new CaseInsensitiveMap(collection.size());
        for (E item : collection) {
            this.map.put(item, null);
        }
    }

    public CaseInsensitiveSet(int initialCapacity) {
        this.map = new CaseInsensitiveMap(initialCapacity);
    }

    public CaseInsensitiveSet(int initialCapacity, float loadFactor) {
        this.map = new CaseInsensitiveMap(initialCapacity, loadFactor);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.keySet().toArray(a);
    }

    @Override
    public boolean add(E e) {
        boolean exists = this.map.containsKey(e);
        this.map.put(e, null);
        return !exists;
    }

    @Override
    public boolean remove(Object o) {
        boolean exists = this.map.containsKey(o);
        this.map.remove(o);
        return exists;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean fail = false;
        for (Object o : c) {
            if (this.map.containsKey(o)) continue;
            fail = true;
            break;
        }
        return !fail;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        int origSize = this.map.size();
        for (E elem : c) {
            this.map.put(elem, null);
        }
        return this.map.size() != origSize;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        CaseInsensitiveMap other = new CaseInsensitiveMap();
        for (Object o : c) {
            other.put(o, null);
        }
        int origSize = this.map.size();
        for (E elem : this.map.keySet()) {
            if (other.containsKey(elem)) continue;
            this.map.remove(elem);
        }
        return this.map.size() != origSize;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int origSize = this.map.size();
        for (Object elem : c) {
            this.map.remove(elem);
        }
        return this.map.size() != origSize;
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

