/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public class CompactSet<E>
extends AbstractSet<E> {
    private static final String EMPTY_SET = "_\ufe3f_\u03c8_\u263c";
    private static final String NO_ENTRY = "_\ufe3f_\u03c8_\u263c";
    private Object val = "_\ufe3f_\u03c8_\u263c";

    public CompactSet() {
        if (this.compactSize() < 2) {
            throw new IllegalStateException("compactSize() must be >= 2");
        }
    }

    public CompactSet(Collection<E> other) {
        this();
        this.addAll(other);
    }

    @Override
    public int size() {
        if (this.val instanceof Object[]) {
            return ((Object[])this.val).length;
        }
        if (this.val instanceof Set) {
            return ((Set)this.val).size();
        }
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return this.val == "_\ufe3f_\u03c8_\u263c";
    }

    private boolean compareItems(Object item, Object anItem) {
        if (item instanceof String) {
            if (anItem instanceof String) {
                if (this.isCaseInsensitive()) {
                    return ((String)anItem).equalsIgnoreCase((String)item);
                }
                return anItem.equals(item);
            }
            return false;
        }
        return Objects.equals(item, anItem);
    }

    @Override
    public boolean contains(Object item) {
        if (this.val instanceof Object[]) {
            Object[] entries = (Object[])this.val;
            int len = entries.length;
            for (int i = 0; i < len; ++i) {
                if (!this.compareItems(item, entries[i])) continue;
                return true;
            }
            return false;
        }
        if (this.val instanceof Set) {
            Set set = (Set)this.val;
            return set.contains(item);
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Iterator<E> iter;
            E currentEntry;
            {
                this.iter = CompactSet.this.getCopy().iterator();
                this.currentEntry = "_\ufe3f_\u03c8_\u263c";
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public E next() {
                this.currentEntry = this.iter.next();
                return this.currentEntry;
            }

            @Override
            public void remove() {
                if (this.currentEntry == "_\ufe3f_\u03c8_\u263c") {
                    throw new IllegalStateException("remove() called on an Iterator before calling next()");
                }
                CompactSet.this.remove(this.currentEntry);
                this.currentEntry = "_\ufe3f_\u03c8_\u263c";
            }
        };
    }

    private Set<E> getCopy() {
        Set<Object> copy = this.getNewSet(this.size());
        if (this.val instanceof Object[]) {
            Object[] entries;
            for (Object entry : entries = (Object[])this.val) {
                copy.add(entry);
            }
        } else if (this.val instanceof Set) {
            copy.addAll((Set)this.val);
        }
        return copy;
    }

    @Override
    public boolean add(E item) {
        if (this.val instanceof Object[]) {
            if (this.contains(item)) {
                return false;
            }
            Object[] entries = (Object[])this.val;
            if (this.size() < this.compactSize()) {
                Object[] expand = new Object[entries.length + 1];
                System.arraycopy(entries, 0, expand, 0, entries.length);
                expand[expand.length - 1] = item;
                this.val = expand;
            } else {
                Set<Object> set = this.getNewSet(this.size() + 1);
                for (Object anItem : entries = (Object[])this.val) {
                    set.add(anItem);
                }
                set.add(item);
                this.val = set;
            }
            return true;
        }
        if (this.val instanceof Set) {
            Set set = (Set)this.val;
            return set.add(item);
        }
        this.val = new Object[]{item};
        return true;
    }

    @Override
    public boolean remove(Object item) {
        if (this.val instanceof Object[]) {
            Object[] local = (Object[])this.val;
            int len = local.length;
            for (int i = 0; i < len; ++i) {
                if (!this.compareItems(local[i], item)) continue;
                if (len == 1) {
                    this.val = "_\ufe3f_\u03c8_\u263c";
                } else {
                    Object[] newElems = new Object[len - 1];
                    System.arraycopy(local, i + 1, local, i, len - i - 1);
                    System.arraycopy(local, 0, newElems, 0, len - 1);
                    this.val = newElems;
                }
                return true;
            }
            return false;
        }
        if (this.val instanceof Set) {
            Set set = (Set)this.val;
            if (!set.contains(item)) {
                return false;
            }
            boolean removed = set.remove(item);
            if (set.size() == this.compactSize()) {
                Object[] entries = new Object[this.compactSize()];
                Iterator i = set.iterator();
                int idx = 0;
                while (i.hasNext()) {
                    entries[idx++] = i.next();
                }
                this.val = entries;
            }
            return removed;
        }
        return false;
    }

    @Override
    public void clear() {
        this.val = "_\ufe3f_\u03c8_\u263c";
    }

    protected Set<E> getNewSet() {
        return new HashSet(this.compactSize() + 1);
    }

    protected Set<E> getNewSet(int size) {
        Set<E> set = this.getNewSet();
        try {
            Constructor<?> constructor = ReflectionUtils.getConstructor(set.getClass(), Integer.TYPE);
            return (Set)constructor.newInstance(size);
        }
        catch (Exception ignored) {
            return set;
        }
    }

    protected boolean isCaseInsensitive() {
        return false;
    }

    protected int compactSize() {
        return 80;
    }
}

