/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.StringUtilities;
import com.cedarsoftware.util.SystemUtilities;
import java.security.SecureRandom;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueIdGenerator {
    public static final String JAVA_UTIL_CLUSTERID = "JAVA_UTIL_CLUSTERID";
    private static final Logger log = LoggerFactory.getLogger(UniqueIdGenerator.class);
    private static final Object lock = new Object();
    private static final Object lock19 = new Object();
    private static int count = 0;
    private static int count2 = 0;
    private static long previousTimeMilliseconds = 0L;
    private static long previousTimeMilliseconds2 = 0L;
    private static final int serverId;
    private static final Map<Long, Long> lastIds;
    private static final Map<Long, Long> lastIdsFull;

    private UniqueIdGenerator() {
    }

    private static int getServerId(String externalVarName) {
        String id = SystemUtilities.getExternalVariable(externalVarName);
        try {
            if (StringUtilities.isEmpty(id)) {
                return -1;
            }
            return Math.abs(Integer.parseInt(id)) % 100;
        }
        catch (NumberFormatException e) {
            log.warn("Unable to get unique server id or index from environment variable/system property key-value: " + externalVarName + "=" + id, (Throwable)e);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getUniqueId() {
        Object object = lock;
        synchronized (object) {
            long id = UniqueIdGenerator.getUniqueIdAttempt();
            while (lastIds.containsKey(id)) {
                id = UniqueIdGenerator.getUniqueIdAttempt();
            }
            lastIds.put(id, null);
            return id;
        }
    }

    private static long getUniqueIdAttempt() {
        long currentTimeMilliseconds;
        if (++count >= 1000) {
            count = 0;
        }
        if ((currentTimeMilliseconds = System.currentTimeMillis()) > previousTimeMilliseconds) {
            count = 0;
            previousTimeMilliseconds = currentTimeMilliseconds;
        }
        return currentTimeMilliseconds * 100000L + (long)(count * 100) + (long)serverId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getUniqueId19() {
        Object object = lock19;
        synchronized (object) {
            long id = UniqueIdGenerator.getFullUniqueId19();
            while (lastIdsFull.containsKey(id)) {
                id = UniqueIdGenerator.getFullUniqueId19();
            }
            lastIdsFull.put(id, null);
            return id;
        }
    }

    private static long getFullUniqueId19() {
        long currentTimeMilliseconds;
        if (++count2 >= 10000) {
            count2 = 0;
        }
        if ((currentTimeMilliseconds = System.currentTimeMillis()) > previousTimeMilliseconds2) {
            count2 = 0;
            previousTimeMilliseconds2 = currentTimeMilliseconds;
        }
        return currentTimeMilliseconds * 1000000L + (long)(count2 * 100) + (long)serverId;
    }

    public static Date getDate(long uniqueId) {
        return new Date(uniqueId / 100000L);
    }

    public static Date getDate19(long uniqueId) {
        return new Date(uniqueId / 1000000L);
    }

    static {
        lastIds = new LinkedHashMap<Long, Long>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Long, Long> eldest) {
                return this.size() > 1000;
            }
        };
        lastIdsFull = new LinkedHashMap<Long, Long>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Long, Long> eldest) {
                return this.size() > 10000;
            }
        };
        int id = UniqueIdGenerator.getServerId(JAVA_UTIL_CLUSTERID);
        String setVia = "environment variable: JAVA_UTIL_CLUSTERID";
        if (id == -1) {
            String envName = SystemUtilities.getExternalVariable(JAVA_UTIL_CLUSTERID);
            if (StringUtilities.hasContent(envName)) {
                String envValue = SystemUtilities.getExternalVariable(envName);
                id = UniqueIdGenerator.getServerId(envValue);
                setVia = "environment variable: " + envName;
            }
            if (id == -1) {
                id = UniqueIdGenerator.getServerId("CF_INSTANCE_INDEX");
                setVia = "environment variable: CF_INSTANCE_INDEX";
                if (id == -1) {
                    SecureRandom random = new SecureRandom();
                    id = Math.abs(random.nextInt()) % 100;
                    setVia = "new SecureRandom()";
                }
            }
        }
        log.info("java-util using server id=" + id + " for last two digits of generated unique IDs. Set using " + setVia);
        serverId = id;
    }
}

