/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseInsensitiveMap<K, V>
implements Map<K, V> {
    private Map<K, V> map;

    public CaseInsensitiveMap() {
        this.map = new LinkedHashMap();
    }

    public CaseInsensitiveMap(int initialCapacity) {
        this.map = new LinkedHashMap(initialCapacity);
    }

    public CaseInsensitiveMap(Map<? extends K, ? extends V> map) {
        this(map.size());
        this.putAll(map);
    }

    public CaseInsensitiveMap(int initialCapacity, float loadFactor) {
        this.map = new LinkedHashMap(initialCapacity, loadFactor);
    }

    @Override
    public V get(Object key) {
        if (key instanceof String) {
            String keyString = (String)key;
            return this.map.get(new CaseInsensitiveString(keyString));
        }
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        if (key instanceof String) {
            CaseInsensitiveString newKey = new CaseInsensitiveString((String)key);
            if (this.map.containsKey(newKey)) {
                this.map.remove(newKey);
            }
            return this.map.put(newKey, value);
        }
        return this.map.put(key, value);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            String keyString = (String)key;
            return this.map.containsKey(new CaseInsensitiveString(keyString));
        }
        return this.map.containsKey(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (m == null) {
            return;
        }
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        if (key instanceof String) {
            String keyString = (String)key;
            return this.map.remove(new CaseInsensitiveString(keyString));
        }
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Map)) {
            return false;
        }
        Map that = (Map)other;
        if (that.size() != this.size()) {
            return false;
        }
        for (Map.Entry entry : that.entrySet()) {
            Object thatKey = entry.getKey();
            if (!this.containsKey(thatKey)) {
                return false;
            }
            Object thatValue = entry.getValue();
            V thisValue = this.get(thatKey);
            if (!(thatValue == null || thisValue == null ? thatValue != thisValue : !thisValue.equals(thatValue))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (Map.Entry<K, V> entry : this.map.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            int hKey = key == null ? 0 : key.hashCode();
            int hValue = value == null ? 0 : value.hashCode();
            h += hKey ^ hValue;
        }
        return h;
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<K> keySet() {
        return new LocalSet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet<Map.Entry<K, V>>();
    }

    private static class CaseInsensitiveString {
        private final String caseInsensitiveString;

        private CaseInsensitiveString(String string) {
            this.caseInsensitiveString = string;
        }

        public String toString() {
            return this.caseInsensitiveString;
        }

        public int hashCode() {
            return this.caseInsensitiveString.toLowerCase().hashCode();
        }

        public boolean equals(Object obj) {
            CaseInsensitiveString other = (CaseInsensitiveString)obj;
            return this.caseInsensitiveString.equalsIgnoreCase(other.caseInsensitiveString);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet<E>
    extends LinkedHashSet<E> {
        final Map<K, V> localMap;
        final Iterator<Map.Entry> iter;

        public EntrySet() {
            this.localMap = CaseInsensitiveMap.this;
            this.iter = new LinkedHashSet(CaseInsensitiveMap.this.map.entrySet()).iterator();
        }

        @Override
        public int size() {
            return CaseInsensitiveMap.this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return CaseInsensitiveMap.this.map.isEmpty();
        }

        @Override
        public void clear() {
            CaseInsensitiveMap.this.map.clear();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Set that = (Set)o;
            if (this.size() != that.size()) {
                return false;
            }
            for (Map.Entry entry : that) {
                Object thatKey = entry.getKey();
                if (!CaseInsensitiveMap.this.containsKey(thatKey)) {
                    return false;
                }
                Object thatValue = entry.getValue();
                Object thisValue = CaseInsensitiveMap.this.get(thatKey);
                if (!(thatValue == null || thisValue == null ? thatValue != thisValue : !thisValue.equals(thatValue))) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)o;
            if (this.localMap.containsKey(that.getKey())) {
                Object value = this.localMap.get(that.getKey());
                if (value == null) {
                    return that.getValue() == null;
                }
                return value.equals(that.getValue());
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            boolean exists = this.contains(o);
            if (!exists) {
                return false;
            }
            Map.Entry that = (Map.Entry)o;
            this.localMap.remove(that.getKey());
            return true;
        }

        @Override
        public boolean removeAll(Collection c) {
            boolean modified = false;
            for (Object o : c) {
                if (!this.contains(o)) continue;
                this.remove(o);
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(Collection c) {
            CaseInsensitiveMap other = new CaseInsensitiveMap();
            for (Object o : c) {
                if (!(o instanceof Map.Entry)) continue;
                other.put(((Map.Entry)o).getKey(), ((Map.Entry)o).getValue());
            }
            int origSize = this.size();
            for (Map.Entry entry : this.localMap.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (!other.containsKey(key)) {
                    this.localMap.remove(key);
                    continue;
                }
                Object v = other.get(key);
                if (v == null) {
                    if (value == null) continue;
                    this.localMap.remove(key);
                    continue;
                }
                if (v.equals(value)) continue;
                this.localMap.remove(key);
            }
            return this.size() != origSize;
        }

        @Override
        public boolean add(E o) {
            throw new UnsupportedOperationException("Cannot add() to a 'view' of a Map.  See JavaDoc for Map.entrySet()");
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException("Cannot addAll() to a 'view' of a Map.  See JavaDoc for Map.entrySet()");
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                Map.Entry lastReturned = null;

                public boolean hasNext() {
                    return EntrySet.this.iter.hasNext();
                }

                public Object next() {
                    this.lastReturned = EntrySet.this.iter.next();
                    if (this.lastReturned.getKey() instanceof CaseInsensitiveString) {
                        this.lastReturned = new AbstractMap.SimpleImmutableEntry(this.lastReturned.getKey().toString(), this.lastReturned.getValue());
                    }
                    return this.lastReturned;
                }

                public void remove() {
                    EntrySet.this.localMap.remove(this.lastReturned.getKey());
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LocalSet
    extends AbstractSet<K> {
        final Map<K, V> localMap;
        final Iterator iter;

        public LocalSet() {
            this.localMap = CaseInsensitiveMap.this;
            this.iter = new LinkedHashSet(CaseInsensitiveMap.this.map.keySet()).iterator();
        }

        @Override
        public boolean contains(Object o) {
            return this.localMap.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            boolean exists = this.localMap.containsKey(o);
            this.localMap.remove(o);
            return exists;
        }

        @Override
        public boolean retainAll(Collection c) {
            CaseInsensitiveMap other = new CaseInsensitiveMap();
            for (Object o : c) {
                other.put(o, null);
            }
            int origSize = this.size();
            for (Map.Entry entry : this.localMap.entrySet()) {
                if (other.containsKey(entry.getKey())) continue;
                this.localMap.remove(entry.getKey());
            }
            return this.size() != origSize;
        }

        @Override
        public boolean add(K o) {
            throw new UnsupportedOperationException("Cannot add() to a 'view' of a Map.  See JavaDoc for Map.keySet()");
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException("Cannot addAll() to a 'view' of a Map.  See JavaDoc for Map.keySet()");
        }

        @Override
        public Object[] toArray() {
            Object[] items = new Object[this.size()];
            int i = 0;
            for (Map.Entry entry : CaseInsensitiveMap.this.map.entrySet()) {
                Object key = entry.getKey();
                items[i++] = key instanceof CaseInsensitiveString ? key.toString() : key;
            }
            return items;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length < this.size()) {
                return Arrays.copyOf(this.toArray(), this.size(), a.getClass());
            }
            System.arraycopy(this.toArray(), 0, a, 0, this.size());
            if (a.length > this.size()) {
                a[this.size()] = null;
            }
            return a;
        }

        @Override
        public int size() {
            return CaseInsensitiveMap.this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return CaseInsensitiveMap.this.map.isEmpty();
        }

        @Override
        public void clear() {
            CaseInsensitiveMap.this.map.clear();
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Map.Entry entry : CaseInsensitiveMap.this.map.entrySet()) {
                if (entry.getKey() == null) continue;
                h += entry.getKey().hashCode();
            }
            return h;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Set)) {
                return false;
            }
            Set that = (Set)o;
            if (that.size() != CaseInsensitiveMap.this.map.size()) {
                return false;
            }
            for (Object obj : that) {
                if (this.contains(obj)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Iterator<K> iterator() {
            return new Iterator<K>(){
                Object lastReturned = null;

                @Override
                public boolean hasNext() {
                    return LocalSet.this.iter.hasNext();
                }

                @Override
                public K next() {
                    this.lastReturned = LocalSet.this.iter.next();
                    if (this.lastReturned instanceof CaseInsensitiveString) {
                        this.lastReturned = this.lastReturned.toString();
                    }
                    return this.lastReturned;
                }

                @Override
                public void remove() {
                    LocalSet.this.localMap.remove(this.lastReturned);
                }
            };
        }
    }
}

