/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateUtilities {
    private static final String mos = "(Jan|January|Feb|February|Mar|March|Apr|April|May|Jun|June|Jul|July|Aug|August|Sep|Sept|September|Oct|October|Nov|November|Dec|December)";
    private static final Pattern datePattern1 = Pattern.compile("(\\d{4})[\\./-](\\d{1,2})[\\./-](\\d{1,2})");
    private static final Pattern datePattern2 = Pattern.compile("(\\d{1,2})[\\./-](\\d{1,2})[\\./-](\\d{4})");
    private static final Pattern datePattern3 = Pattern.compile("(Jan|January|Feb|February|Mar|March|Apr|April|May|Jun|June|Jul|July|Aug|August|Sep|Sept|September|Oct|October|Nov|November|Dec|December)[ ,]+(\\d{1,2})[ ,]+(\\d{4})", 2);
    private static final Pattern datePattern4 = Pattern.compile("(\\d{1,2})[ ,](Jan|January|Feb|February|Mar|March|Apr|April|May|Jun|June|Jul|July|Aug|August|Sep|Sept|September|Oct|October|Nov|November|Dec|December)[ ,]+(\\d{4})", 2);
    private static final Pattern datePattern5 = Pattern.compile("(\\d{4})[ ,](Jan|January|Feb|February|Mar|March|Apr|April|May|Jun|June|Jul|July|Aug|August|Sep|Sept|September|Oct|October|Nov|November|Dec|December)[ ,]+(\\d{1,2})", 2);
    private static final Pattern timePattern1 = Pattern.compile("(\\d{2})[:\\.](\\d{2})[:\\.](\\d{2})[\\.](\\d{1,3})");
    private static final Pattern timePattern2 = Pattern.compile("(\\d{2})[:\\.](\\d{2})[:\\.](\\d{2})");
    private static final Pattern timePattern3 = Pattern.compile("(\\d{2})[:\\.](\\d{2})");
    private static final Map<String, String> months = new LinkedHashMap<String, String>();

    public static Date parseDate(String dateStr) {
        String day;
        String year;
        dateStr = dateStr.trim();
        Matcher matcher = datePattern1.matcher(dateStr);
        String month = null;
        String mon = null;
        if (matcher.find()) {
            year = matcher.group(1);
            month = matcher.group(2);
            day = matcher.group(3);
        } else {
            matcher = datePattern2.matcher(dateStr);
            if (matcher.find()) {
                month = matcher.group(1);
                day = matcher.group(2);
                year = matcher.group(3);
            } else {
                matcher = datePattern3.matcher(dateStr);
                if (matcher.find()) {
                    mon = matcher.group(1);
                    day = matcher.group(2);
                    year = matcher.group(3);
                } else {
                    matcher = datePattern4.matcher(dateStr);
                    if (matcher.find()) {
                        day = matcher.group(1);
                        mon = matcher.group(2);
                        year = matcher.group(3);
                    } else {
                        matcher = datePattern5.matcher(dateStr);
                        if (!matcher.find()) {
                            DateUtilities.error("Unable to parse: " + dateStr);
                        }
                        year = matcher.group(1);
                        mon = matcher.group(2);
                        day = matcher.group(3);
                    }
                }
            }
        }
        if (mon != null) {
            month = months.get(mon.trim().toLowerCase());
        }
        if (!((matcher = timePattern1.matcher(dateStr)).find() || (matcher = timePattern2.matcher(dateStr)).find() || (matcher = timePattern3.matcher(dateStr)).find())) {
            matcher = null;
        }
        Calendar c = Calendar.getInstance();
        c.clear();
        int y = Integer.parseInt(year);
        int m = Integer.parseInt(month) - 1;
        int d = Integer.parseInt(day);
        if (m < 0 || m > 11) {
            DateUtilities.error("Month must be between 1 and 12, date: " + dateStr);
        }
        if (d < 0 || d > 31) {
            DateUtilities.error("Day cannot be > 31, date: " + dateStr);
        }
        if (matcher == null) {
            c.set(y, m, d);
        } else {
            String hour = matcher.group(1);
            String min = matcher.group(2);
            String sec = "00";
            String milli = "000";
            if (matcher.groupCount() > 2) {
                sec = matcher.group(3);
            }
            if (matcher.groupCount() > 3) {
                milli = matcher.group(4);
            }
            int h = Integer.parseInt(hour);
            int mn = Integer.parseInt(min);
            int s = Integer.parseInt(sec);
            int ms = Integer.parseInt(milli);
            if (h < 0 || h > 23) {
                DateUtilities.error("Hour must be between 0 and 23, time: " + dateStr);
            }
            if (mn < 0 || mn > 59) {
                DateUtilities.error("Minute must be between 0 and 59, time: " + dateStr);
            }
            if (s < 0 || s > 59) {
                DateUtilities.error("Second must be between 0 and 59, time: " + dateStr);
            }
            c.set(y, m, d, h, mn, s);
            c.set(14, ms);
        }
        return c.getTime();
    }

    private static void error(String msg) {
        throw new IllegalArgumentException(msg);
    }

    static {
        months.put("jan", "1");
        months.put("january", "1");
        months.put("feb", "2");
        months.put("february", "2");
        months.put("mar", "3");
        months.put("march", "3");
        months.put("apr", "4");
        months.put("april", "4");
        months.put("may", "5");
        months.put("jun", "6");
        months.put("june", "6");
        months.put("jul", "7");
        months.put("july", "7");
        months.put("aug", "8");
        months.put("august", "8");
        months.put("sep", "9");
        months.put("sept", "9");
        months.put("september", "9");
        months.put("oct", "10");
        months.put("october", "10");
        months.put("nov", "11");
        months.put("november", "11");
        months.put("dec", "12");
        months.put("december", "12");
    }
}

