/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.StringUtilities;
import com.cedarsoftware.util.convert.Converter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

final class ByteArrayConversions {
    private ByteArrayConversions() {
    }

    static String toString(Object from, Converter converter) {
        byte[] bytes = (byte[])from;
        return bytes == null ? StringUtilities.EMPTY : new String(bytes, converter.getOptions().getCharset());
    }

    static ByteBuffer toByteBuffer(Object from, Converter converter) {
        return ByteBuffer.wrap((byte[])from);
    }

    static CharBuffer toCharBuffer(Object from, Converter converter) {
        return CharBuffer.wrap(ByteArrayConversions.toString(from, converter));
    }

    static char[] toCharArray(Object from, Converter converter) {
        return ByteArrayConversions.toString(from, converter).toCharArray();
    }

    static StringBuffer toStringBuffer(Object from, Converter converter) {
        return new StringBuffer(ByteArrayConversions.toString(from, converter));
    }

    static StringBuilder toStringBuilder(Object from, Converter converter) {
        return new StringBuilder(ByteArrayConversions.toString(from, converter));
    }
}

