/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ConcurrentNavigableSetNullSafe;
import com.cedarsoftware.util.SealableSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.function.Supplier;

public class SealableNavigableSet<E>
implements NavigableSet<E> {
    private final NavigableSet<E> navSet;
    private final transient Supplier<Boolean> sealedSupplier;

    public SealableNavigableSet(Supplier<Boolean> sealedSupplier) {
        this.sealedSupplier = sealedSupplier;
        this.navSet = new ConcurrentNavigableSetNullSafe();
    }

    public SealableNavigableSet(Comparator<? super E> comparator, Supplier<Boolean> sealedSupplier) {
        this.sealedSupplier = sealedSupplier;
        this.navSet = new ConcurrentNavigableSetNullSafe<E>(comparator);
    }

    public SealableNavigableSet(Collection<? extends E> col, Supplier<Boolean> sealedSupplier) {
        this(sealedSupplier);
        this.addAll(col);
    }

    public SealableNavigableSet(SortedSet<E> set, Supplier<Boolean> sealedSupplier) {
        this.sealedSupplier = sealedSupplier;
        this.navSet = new ConcurrentNavigableSetNullSafe<E>(set);
    }

    public SealableNavigableSet(NavigableSet<E> set, Supplier<Boolean> sealedSupplier) {
        this.sealedSupplier = sealedSupplier;
        this.navSet = set;
    }

    private void throwIfSealed() {
        if (this.sealedSupplier.get().booleanValue()) {
            throw new UnsupportedOperationException("This set has been sealed and is now immutable");
        }
    }

    @Override
    public boolean equals(Object o) {
        return o == this || this.navSet.equals(o);
    }

    @Override
    public int hashCode() {
        return this.navSet.hashCode();
    }

    public String toString() {
        return this.navSet.toString();
    }

    @Override
    public int size() {
        return this.navSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.navSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.navSet.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> col) {
        return this.navSet.containsAll(col);
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.navSet.comparator();
    }

    @Override
    public E first() {
        return this.navSet.first();
    }

    @Override
    public E last() {
        return this.navSet.last();
    }

    @Override
    public Object[] toArray() {
        return this.navSet.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.navSet.toArray(a);
    }

    @Override
    public E lower(E e) {
        return this.navSet.lower(e);
    }

    @Override
    public E floor(E e) {
        return this.navSet.floor(e);
    }

    @Override
    public E ceiling(E e) {
        return this.navSet.ceiling(e);
    }

    @Override
    public E higher(E e) {
        return this.navSet.higher(e);
    }

    @Override
    public Iterator<E> iterator() {
        return this.createSealHonoringIterator(this.navSet.iterator());
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.createSealHonoringIterator(this.navSet.descendingIterator());
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return new SealableNavigableSet<E>(this.navSet.descendingSet(), this.sealedSupplier);
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return new SealableNavigableSet<E>(this.navSet.subSet(fromElement, fromInclusive, toElement, toInclusive), this.sealedSupplier);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    public NavigableSet<E> headSet(E toElement, boolean inclusive) {
        return new SealableNavigableSet<E>(this.navSet.headSet(toElement, inclusive), this.sealedSupplier);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return this.tailSet(fromElement, false);
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return new SealableNavigableSet<E>(this.navSet.tailSet(fromElement, inclusive), this.sealedSupplier);
    }

    @Override
    public boolean add(E e) {
        this.throwIfSealed();
        return this.navSet.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> col) {
        this.throwIfSealed();
        return this.navSet.addAll(col);
    }

    @Override
    public void clear() {
        this.throwIfSealed();
        this.navSet.clear();
    }

    @Override
    public boolean remove(Object o) {
        this.throwIfSealed();
        return this.navSet.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> col) {
        this.throwIfSealed();
        return this.navSet.removeAll(col);
    }

    @Override
    public boolean retainAll(Collection<?> col) {
        this.throwIfSealed();
        return this.navSet.retainAll(col);
    }

    @Override
    public E pollFirst() {
        this.throwIfSealed();
        return this.navSet.pollFirst();
    }

    @Override
    public E pollLast() {
        this.throwIfSealed();
        return this.navSet.pollLast();
    }

    private Iterator<E> createSealHonoringIterator(final Iterator<E> iterator) {
        return new Iterator<E>(){
            final /* synthetic */ SealableNavigableSet this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public E next() {
                Object item = iterator.next();
                if (item instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)item;
                    return new SealableSet.SealAwareEntry(entry, this.this$0.sealedSupplier);
                }
                return item;
            }

            @Override
            public void remove() {
                this.this$0.throwIfSealed();
                iterator.remove();
            }
        };
    }
}

