/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;

public abstract class AbstractConcurrentNullSafeMap<K, V>
implements ConcurrentMap<K, V> {
    protected final ConcurrentMap<Object, Object> internalMap;

    protected AbstractConcurrentNullSafeMap(ConcurrentMap<Object, Object> internalMap) {
        this.internalMap = internalMap;
    }

    protected Object maskNullKey(K key) {
        return key == null ? NullSentinel.NULL_KEY : key;
    }

    protected K unmaskNullKey(Object key) {
        return (K)(key == NullSentinel.NULL_KEY ? null : key);
    }

    protected Object maskNullValue(V value) {
        return value == null ? NullSentinel.NULL_VALUE : value;
    }

    protected V unmaskNullValue(Object value) {
        return (V)(value == NullSentinel.NULL_VALUE ? null : value);
    }

    @Override
    public int size() {
        return this.internalMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.internalMap.containsKey(this.maskNullKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return this.internalMap.containsValue((Object)NullSentinel.NULL_VALUE);
        }
        return this.internalMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        Object val = this.internalMap.get(this.maskNullKey(key));
        return this.unmaskNullValue(val);
    }

    @Override
    public V put(K key, V value) {
        Object prev = this.internalMap.put(this.maskNullKey(key), this.maskNullValue(value));
        return this.unmaskNullValue(prev);
    }

    @Override
    public V remove(Object key) {
        Object prev = this.internalMap.remove(this.maskNullKey(key));
        return this.unmaskNullValue(prev);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.internalMap.put(this.maskNullKey(entry.getKey()), this.maskNullValue(entry.getValue()));
        }
    }

    @Override
    public void clear() {
        this.internalMap.clear();
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        Object val = this.internalMap.get(this.maskNullKey(key));
        return val != null ? this.unmaskNullValue(val) : defaultValue;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Object prev = this.internalMap.putIfAbsent(this.maskNullKey(key), this.maskNullValue(value));
        return this.unmaskNullValue(prev);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.internalMap.remove(this.maskNullKey(key), this.maskNullValue(value));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.internalMap.replace(this.maskNullKey(key), this.maskNullValue(oldValue), this.maskNullValue(newValue));
    }

    @Override
    public V replace(K key, V value) {
        Object prev = this.internalMap.replace(this.maskNullKey(key), this.maskNullValue(value));
        return this.unmaskNullValue(prev);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Object maskedKey = this.maskNullKey(key);
        Object currentValue = this.internalMap.get(this.maskNullKey(key));
        if (currentValue != null && currentValue != NullSentinel.NULL_VALUE) {
            return this.unmaskNullValue(currentValue);
        }
        V newValue = mappingFunction.apply(this.unmaskNullKey(maskedKey));
        if (newValue != null) {
            Object result = this.internalMap.compute(maskedKey, (k, v) -> {
                if (v != null && v != NullSentinel.NULL_VALUE) {
                    return v;
                }
                return this.maskNullValue(newValue);
            });
            return this.unmaskNullValue(result);
        }
        this.internalMap.remove(maskedKey);
        return null;
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Object maskedKey = this.maskNullKey(key);
        Object result = this.internalMap.compute(maskedKey, (k, v) -> {
            V oldValue = this.unmaskNullValue(v);
            Object newValue = remappingFunction.apply((K)this.unmaskNullKey(k), (V)oldValue);
            return newValue == null ? null : this.maskNullValue(newValue);
        });
        return this.unmaskNullValue(result);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        Objects.requireNonNull(value);
        Object maskedKey = this.maskNullKey(key);
        Object result = this.internalMap.merge(maskedKey, this.maskNullValue(value), (v1, v2) -> {
            V unmaskV2;
            V unmaskV1 = this.unmaskNullValue(v1);
            Object newValue = remappingFunction.apply((V)unmaskV1, (V)(unmaskV2 = this.unmaskNullValue(v2)));
            return newValue == null ? null : this.maskNullValue(newValue);
        });
        return this.unmaskNullValue(result);
    }

    @Override
    public Collection<V> values() {
        final Collection internalValues = this.internalMap.values();
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                final Iterator it = internalValues.iterator();
                return new Iterator<V>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public V next() {
                        return AbstractConcurrentNullSafeMap.this.unmaskNullValue(it.next());
                    }

                    @Override
                    public void remove() {
                        it.remove();
                    }
                };
            }

            @Override
            public int size() {
                return internalValues.size();
            }

            @Override
            public boolean contains(Object o) {
                return AbstractConcurrentNullSafeMap.this.internalMap.containsValue(AbstractConcurrentNullSafeMap.this.maskNullValue(o));
            }

            @Override
            public void clear() {
                AbstractConcurrentNullSafeMap.this.internalMap.clear();
            }
        };
    }

    @Override
    public Set<K> keySet() {
        final Set internalKeys = this.internalMap.keySet();
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                final Iterator it = internalKeys.iterator();
                return new Iterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public K next() {
                        return AbstractConcurrentNullSafeMap.this.unmaskNullKey(it.next());
                    }

                    @Override
                    public void remove() {
                        it.remove();
                    }
                };
            }

            @Override
            public int size() {
                return internalKeys.size();
            }

            @Override
            public boolean contains(Object o) {
                return AbstractConcurrentNullSafeMap.this.internalMap.containsKey(AbstractConcurrentNullSafeMap.this.maskNullKey(o));
            }

            @Override
            public boolean remove(Object o) {
                return AbstractConcurrentNullSafeMap.this.internalMap.remove(AbstractConcurrentNullSafeMap.this.maskNullKey(o)) != null;
            }

            @Override
            public void clear() {
                AbstractConcurrentNullSafeMap.this.internalMap.clear();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        final Set internalEntries = this.internalMap.entrySet();
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator it = internalEntries.iterator();
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        final Map.Entry internalEntry = (Map.Entry)it.next();
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return AbstractConcurrentNullSafeMap.this.unmaskNullKey(internalEntry.getKey());
                            }

                            @Override
                            public V getValue() {
                                return AbstractConcurrentNullSafeMap.this.unmaskNullValue(internalEntry.getValue());
                            }

                            @Override
                            public V setValue(V value) {
                                Object oldValue = internalEntry.setValue(AbstractConcurrentNullSafeMap.this.maskNullValue(value));
                                return AbstractConcurrentNullSafeMap.this.unmaskNullValue(oldValue);
                            }

                            @Override
                            public boolean equals(Object o) {
                                if (!(o instanceof Map.Entry)) {
                                    return false;
                                }
                                Map.Entry e = (Map.Entry)o;
                                return Objects.equals(this.getKey(), e.getKey()) && Objects.equals(this.getValue(), e.getValue());
                            }

                            @Override
                            public int hashCode() {
                                return Objects.hashCode(this.getKey()) ^ Objects.hashCode(this.getValue());
                            }

                            public String toString() {
                                return this.getKey() + "=" + this.getValue();
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        it.remove();
                    }
                };
            }

            @Override
            public int size() {
                return internalEntries.size();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                Object val = AbstractConcurrentNullSafeMap.this.internalMap.get(AbstractConcurrentNullSafeMap.this.maskNullKey(e.getKey()));
                return AbstractConcurrentNullSafeMap.this.maskNullValue(e.getValue()).equals(val);
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return AbstractConcurrentNullSafeMap.this.internalMap.remove(AbstractConcurrentNullSafeMap.this.maskNullKey(e.getKey()), AbstractConcurrentNullSafeMap.this.maskNullValue(e.getValue()));
            }

            @Override
            public void clear() {
                AbstractConcurrentNullSafeMap.this.internalMap.clear();
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map other = (Map)o;
        if (this.size() != other.size()) {
            return false;
        }
        for (Map.Entry<K, V> entry : this.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            if (!other.containsKey(key)) {
                return false;
            }
            Object otherValue = other.get(key);
            if (Objects.equals(value, otherValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (Map.Entry<K, V> entry : this.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            int keyHash = key == null ? 0 : key.hashCode();
            int valueHash = value == null ? 0 : value.hashCode();
            h += keyHash ^ valueHash;
        }
        return h;
    }

    public String toString() {
        Iterator<Map.Entry<K, V>> it = this.entrySet().iterator();
        if (!it.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<K, V> e = it.next();
            K key = e.getKey();
            V value = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!it.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    protected static enum NullSentinel {
        NULL_KEY,
        NULL_VALUE;

    }
}

