/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.DateUtilities;
import com.cedarsoftware.util.StringUtilities;
import com.cedarsoftware.util.convert.CommonValues;
import com.cedarsoftware.util.convert.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class StringConversions {
    private static final BigDecimal bigDecimalMinByte = BigDecimal.valueOf(-128L);
    private static final BigDecimal bigDecimalMaxByte = BigDecimal.valueOf(127L);
    private static final BigDecimal bigDecimalMinShort = BigDecimal.valueOf(-32768L);
    private static final BigDecimal bigDecimalMaxShort = BigDecimal.valueOf(32767L);
    private static final BigDecimal bigDecimalMinInteger = BigDecimal.valueOf(Integer.MIN_VALUE);
    private static final BigDecimal bigDecimalMaxInteger = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal bigDecimalMaxLong = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal bigDecimalMinLong = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final Pattern MM_DD = Pattern.compile("^(\\d{1,2}).(\\d{1,2})$");

    private StringConversions() {
    }

    static String asString(Object from) {
        return from == null ? null : from.toString();
    }

    static Byte toByte(Object from, Converter converter) {
        String str = StringUtilities.trimToEmpty((String)from);
        if (str.isEmpty()) {
            return CommonValues.BYTE_ZERO;
        }
        try {
            return Byte.valueOf(str);
        }
        catch (NumberFormatException e) {
            Long value = StringConversions.toLong(str, bigDecimalMinByte, bigDecimalMaxByte);
            if (value == null) {
                throw new IllegalArgumentException("Value '" + str + "' not parseable as a byte value or outside " + -128 + " to " + 127, e);
            }
            return value.byteValue();
        }
    }

    static Short toShort(Object from, Converter converter) {
        String str = StringUtilities.trimToEmpty((String)from);
        if (str.isEmpty()) {
            return CommonValues.SHORT_ZERO;
        }
        try {
            return Short.valueOf(str);
        }
        catch (Exception e) {
            Long value = StringConversions.toLong(str, bigDecimalMinShort, bigDecimalMaxShort);
            if (value == null) {
                throw new IllegalArgumentException("Value '" + from + "' not parseable as a short value or outside " + Short.MIN_VALUE + " to " + Short.MAX_VALUE, e);
            }
            return value.shortValue();
        }
    }

    static Integer toInt(Object from, Converter converter) {
        String str = StringUtilities.trimToEmpty(StringConversions.asString(from));
        if (str.isEmpty()) {
            return CommonValues.INTEGER_ZERO;
        }
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            Long value = StringConversions.toLong(str, bigDecimalMinInteger, bigDecimalMaxInteger);
            if (value == null) {
                throw new IllegalArgumentException("Value '" + from + "' not parseable as an int value or outside " + Integer.MIN_VALUE + " to " + Integer.MAX_VALUE, e);
            }
            return value.intValue();
        }
    }

    static Long toLong(Object from, Converter converter) {
        String str = StringUtilities.trimToEmpty(StringConversions.asString(from));
        if (str.isEmpty()) {
            return CommonValues.LONG_ZERO;
        }
        try {
            return Long.valueOf(str);
        }
        catch (Exception e) {
            Long value = StringConversions.toLong(str, bigDecimalMinLong, bigDecimalMaxLong);
            if (value == null) {
                throw new IllegalArgumentException("Value '" + from + "' not parseable as a long value or outside " + Long.MIN_VALUE + " to " + Long.MAX_VALUE, e);
            }
            return value;
        }
    }

    private static Long toLong(String s, BigDecimal low, BigDecimal high) {
        try {
            BigDecimal big = new BigDecimal(s);
            big = big.setScale(0, RoundingMode.DOWN);
            if (big.compareTo(low) == -1 || big.compareTo(high) == 1) {
                return null;
            }
            return big.longValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    static Float toFloat(Object from, Converter converter) {
        String str = StringUtilities.trimToEmpty(StringConversions.asString(from));
        if (str.isEmpty()) {
            return CommonValues.FLOAT_ZERO;
        }
        try {
            return Float.valueOf(str);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Value '" + from + "' not parseable as a float value", e);
        }
    }

    static Double toDouble(Object from, Converter converter) {
        String str = StringUtilities.trimToEmpty(StringConversions.asString(from));
        if (str.isEmpty()) {
            return CommonValues.DOUBLE_ZERO;
        }
        try {
            return Double.valueOf(str);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Value '" + from + "' not parseable as a double value", e);
        }
    }

    static AtomicBoolean toAtomicBoolean(Object from, Converter converter) {
        return new AtomicBoolean(StringConversions.toBoolean(StringConversions.asString(from), converter));
    }

    static AtomicInteger toAtomicInteger(Object from, Converter converter) {
        return new AtomicInteger(StringConversions.toInt(from, converter));
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        return new AtomicLong(StringConversions.toLong(from, converter));
    }

    static Boolean toBoolean(Object from, Converter converter) {
        String from1 = StringConversions.asString(from);
        String str = StringUtilities.trimToEmpty(from1);
        if (str.isEmpty()) {
            return false;
        }
        if ("true".equals(str)) {
            return true;
        }
        if ("false".equals(str)) {
            return false;
        }
        return "true".equalsIgnoreCase(str) || "t".equalsIgnoreCase(str) || "1".equals(str) || "y".equalsIgnoreCase(str);
    }

    static char toCharacter(Object from, Converter converter) {
        String str = (String)from;
        if (str == null || str.isEmpty()) {
            return CommonValues.CHARACTER_ZERO.charValue();
        }
        if (str.length() == 1) {
            return str.charAt(0);
        }
        try {
            return (char)Integer.parseInt(str.trim());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse '" + from + "' as a Character.", e);
        }
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        String str = StringUtilities.trimToNull(StringConversions.asString(from));
        if (str == null) {
            return BigInteger.ZERO;
        }
        try {
            BigDecimal bigDec = new BigDecimal(str);
            return bigDec.toBigInteger();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Value '" + from + "' not parseable as a BigInteger value.", e);
        }
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        String str = StringUtilities.trimToEmpty(StringConversions.asString(from));
        if (str.isEmpty()) {
            return BigDecimal.ZERO;
        }
        try {
            return new BigDecimal(str);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Value '" + from + "' not parseable as a BigDecimal value.", e);
        }
    }

    static URL toURL(Object from, Converter converter) {
        String str = StringUtilities.trimToNull(StringConversions.asString(from));
        if (str == null) {
            return null;
        }
        try {
            URI uri = URI.create((String)from);
            return uri.toURL();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot convert String '" + str, e);
        }
    }

    static URI toURI(Object from, Converter converter) {
        String str = StringUtilities.trimToNull(StringConversions.asString(from));
        if (str == null) {
            return null;
        }
        return URI.create((String)from);
    }

    static String enumToString(Object from, Converter converter) {
        return ((Enum)from).name();
    }

    static UUID toUUID(Object from, Converter converter) {
        return UUID.fromString(((String)from).trim());
    }

    static Duration toDuration(Object from, Converter converter) {
        try {
            return Duration.parse((String)from);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse '" + from + "' as a Duration.", e);
        }
    }

    static Class<?> toClass(Object from, Converter converter) {
        String str = ((String)from).trim();
        Class<?> clazz = ClassUtilities.forName(str, converter.getOptions().getClassLoader());
        if (clazz != null) {
            return clazz;
        }
        throw new IllegalArgumentException("Cannot convert String '" + str + "' to class.  Class not found.");
    }

    static MonthDay toMonthDay(Object from, Converter converter) {
        String monthDay = (String)from;
        try {
            return MonthDay.parse(monthDay);
        }
        catch (DateTimeParseException e) {
            Matcher matcher = MM_DD.matcher(monthDay);
            if (matcher.find()) {
                String mm = matcher.group(1);
                String dd = matcher.group(2);
                return MonthDay.of(Integer.parseInt(mm), Integer.parseInt(dd));
            }
            try {
                ZonedDateTime zdt = DateUtilities.parseDate(monthDay, converter.getOptions().getZoneId(), true);
                if (zdt == null) {
                    return null;
                }
                return MonthDay.of(zdt.getMonthValue(), zdt.getDayOfMonth());
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unable to extract Month-Day from string: " + monthDay, ex);
            }
        }
    }

    static YearMonth toYearMonth(Object from, Converter converter) {
        String yearMonth = (String)from;
        try {
            return YearMonth.parse(yearMonth);
        }
        catch (DateTimeParseException e) {
            try {
                ZonedDateTime zdt = DateUtilities.parseDate(yearMonth, converter.getOptions().getZoneId(), true);
                if (zdt == null) {
                    return null;
                }
                return YearMonth.of(zdt.getYear(), zdt.getMonthValue());
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unable to extract Year-Month from string: " + yearMonth, ex);
            }
        }
    }

    static Period toPeriod(Object from, Converter converter) {
        String period = (String)from;
        try {
            return Period.parse(period);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse '" + period + "' as a Period.", e);
        }
    }

    static java.util.Date toDate(Object from, Converter converter) {
        String strDate = (String)from;
        ZonedDateTime zdt = DateUtilities.parseDate(strDate, converter.getOptions().getZoneId(), true);
        if (zdt == null) {
            return null;
        }
        return java.util.Date.from(zdt.toInstant());
    }

    static Date toSqlDate(Object from, Converter converter) {
        Instant instant = StringConversions.toInstant(from, converter);
        return instant == null ? null : new Date(instant.toEpochMilli());
    }

    static Timestamp toTimestamp(Object from, Converter converter) {
        Instant instant = StringConversions.toInstant(from, converter);
        return instant == null ? null : new Timestamp(instant.toEpochMilli());
    }

    static TimeZone toTimeZone(Object from, Converter converter) {
        String str = StringUtilities.trimToNull((String)from);
        if (str == null) {
            return null;
        }
        return TimeZone.getTimeZone(str);
    }

    static Calendar toCalendar(Object from, Converter converter) {
        String calStr = (String)from;
        if (StringUtilities.isEmpty(calStr)) {
            return null;
        }
        ZonedDateTime zdt = DateUtilities.parseDate(calStr, converter.getOptions().getZoneId(), true);
        ZonedDateTime zdtUser = zdt.withZoneSameInstant(converter.getOptions().getZoneId());
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(zdtUser.getZone()));
        cal.setTimeInMillis(zdtUser.toInstant().toEpochMilli());
        return cal;
    }

    static LocalDate toLocalDate(Object from, Converter converter) {
        return StringConversions.parseDate(from, converter).map(ZonedDateTime::toLocalDate).orElse(null);
    }

    static LocalDateTime toLocalDateTime(Object from, Converter converter) {
        return StringConversions.parseDate(from, converter).map(ZonedDateTime::toLocalDateTime).orElse(null);
    }

    static LocalTime toLocalTime(Object from, Converter converter) {
        String str = StringUtilities.trimToNull(StringConversions.asString(from));
        if (str == null) {
            return null;
        }
        try {
            return LocalTime.parse(str);
        }
        catch (Exception e) {
            return StringConversions.parseDate(str, converter).map(ZonedDateTime::toLocalTime).orElse(null);
        }
    }

    static Locale toLocale(Object from, Converter converter) {
        String str = StringUtilities.trimToNull(StringConversions.asString(from));
        if (str == null) {
            return null;
        }
        return Locale.forLanguageTag(str);
    }

    private static Optional<ZonedDateTime> parseDate(Object from, Converter converter) {
        String str = StringUtilities.trimToNull(StringConversions.asString(from));
        if (str == null) {
            return Optional.empty();
        }
        ZonedDateTime zonedDateTime = DateUtilities.parseDate(str, converter.getOptions().getZoneId(), true);
        if (zonedDateTime == null) {
            return Optional.empty();
        }
        return Optional.of(zonedDateTime);
    }

    static ZonedDateTime toZonedDateTime(Object from, Converter converter) {
        return StringConversions.parseDate(from, converter).orElse(null);
    }

    static ZoneId toZoneId(Object from, Converter converter) {
        String s = StringUtilities.trimToNull(StringConversions.asString(from));
        if (s == null) {
            return null;
        }
        try {
            return ZoneId.of(s);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown time-zone ID: '" + s + "'", e);
        }
    }

    static ZoneOffset toZoneOffset(Object from, Converter converter) {
        String s = StringUtilities.trimToNull(StringConversions.asString(from));
        if (s == null) {
            return null;
        }
        try {
            return ZoneOffset.of(s);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown time-zone offset: '" + s + "'");
        }
    }

    static OffsetDateTime toOffsetDateTime(Object from, Converter converter) {
        return StringConversions.parseDate(from, converter).map(ZonedDateTime::toOffsetDateTime).orElse(null);
    }

    static OffsetTime toOffsetTime(Object from, Converter converter) {
        String s = StringUtilities.trimToNull(StringConversions.asString(from));
        if (s == null) {
            return null;
        }
        try {
            return OffsetTime.parse(s, DateTimeFormatter.ISO_OFFSET_TIME);
        }
        catch (Exception e) {
            OffsetDateTime dateTime = StringConversions.toOffsetDateTime(from, converter);
            if (dateTime == null) {
                return null;
            }
            return dateTime.toOffsetTime();
        }
    }

    static Instant toInstant(Object from, Converter converter) {
        String s = (String)from;
        if (StringUtilities.isEmpty(s)) {
            return null;
        }
        try {
            return Instant.parse(s);
        }
        catch (Exception e) {
            return StringConversions.parseDate(s, converter).map(ChronoZonedDateTime::toInstant).orElse(null);
        }
    }

    static char[] toCharArray(Object from, Converter converter) {
        String s = StringConversions.asString(from);
        if (s == null || s.isEmpty()) {
            return ArrayUtilities.EMPTY_CHAR_ARRAY;
        }
        return s.toCharArray();
    }

    static Character[] toCharacterArray(Object from, Converter converter) {
        CharSequence s = (CharSequence)from;
        if (s == null) {
            return ArrayUtilities.EMPTY_CHARACTER_ARRAY;
        }
        int len = s.length();
        Character[] ca = new Character[len];
        for (int i = 0; i < len; ++i) {
            ca[i] = Character.valueOf(s.charAt(i));
        }
        return ca;
    }

    static CharBuffer toCharBuffer(Object from, Converter converter) {
        return CharBuffer.wrap(StringConversions.asString(from));
    }

    static byte[] toByteArray(Object from, Converter converter) {
        String s = StringConversions.asString(from);
        if (s == null || s.isEmpty()) {
            return ArrayUtilities.EMPTY_BYTE_ARRAY;
        }
        return s.getBytes(converter.getOptions().getCharset());
    }

    static ByteBuffer toByteBuffer(Object from, Converter converter) {
        return ByteBuffer.wrap(StringConversions.toByteArray(from, converter));
    }

    static String toString(Object from, Converter converter) {
        return from == null ? null : from.toString();
    }

    static StringBuffer toStringBuffer(Object from, Converter converter) {
        return from == null ? null : new StringBuffer(from.toString());
    }

    static StringBuilder toStringBuilder(Object from, Converter converter) {
        return from == null ? null : new StringBuilder(from.toString());
    }

    static Year toYear(Object from, Converter converter) {
        String s = StringUtilities.trimToNull(StringConversions.asString(from));
        if (s == null) {
            return null;
        }
        try {
            return Year.of(Integer.parseInt(s));
        }
        catch (Exception e) {
            try {
                ZonedDateTime zdt = DateUtilities.parseDate(s, converter.getOptions().getZoneId(), true);
                return Year.of(zdt.getYear());
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unable to parse 4-digit year from '" + s + "'", e);
            }
        }
    }
}

