/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LRUCache<K, V>
implements Map<K, V> {
    private final Map<K, V> cache;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public LRUCache(final int capacity) {
        this.cache = new LinkedHashMap<K, V>(capacity, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > capacity;
            }
        };
    }

    @Override
    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.cache.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.cache.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.cache.containsKey(key);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.cache.containsValue(value);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public V get(Object key) {
        this.lock.readLock().lock();
        try {
            V v = this.cache.get(key);
            return v;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        this.lock.writeLock().lock();
        try {
            V v = this.cache.put(key, value);
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public V remove(Object key) {
        this.lock.writeLock().lock();
        try {
            V v = this.cache.remove(key);
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.lock.writeLock().lock();
        try {
            this.cache.putAll(m);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.cache.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Set<K> keySet() {
        this.lock.readLock().lock();
        try {
            Set<K> set = this.cache.keySet();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Collection<V> values() {
        this.lock.readLock().lock();
        try {
            Collection<V> collection = this.cache.values();
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.lock.readLock().lock();
        try {
            Set<Map.Entry<K, V>> set = this.cache.entrySet();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        this.lock.writeLock().lock();
        try {
            V existingValue = this.cache.get(key);
            if (existingValue == null) {
                this.cache.put(key, value);
                V v = null;
                return v;
            }
            V v = existingValue;
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

