/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.CompactLinkedMap;
import com.cedarsoftware.util.convert.Converter;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;

final class EnumConversions {
    private EnumConversions() {
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        Enum enumInstance = (Enum)from;
        CompactLinkedMap<String, Object> target = new CompactLinkedMap<String, Object>();
        target.put("name", enumInstance.name());
        return target;
    }

    static <T extends Enum<T>> EnumSet<T> toEnumSet(Object from, Converter converter, Class<?> target) {
        if (!target.isEnum()) {
            throw new IllegalArgumentException("target type " + target.getName() + " must be an Enum, which instructs the EnumSet type to create.");
        }
        Class<?> enumClass = target;
        EnumSet<?> enumSet = EnumSet.noneOf(enumClass);
        if (from instanceof Collection) {
            EnumConversions.processElements((Collection)from, enumSet, enumClass);
        } else if (from.getClass().isArray()) {
            EnumConversions.processArrayElements(from, enumSet, enumClass);
        } else {
            throw new IllegalArgumentException("Source must be a Collection or Array, found: " + from.getClass().getName());
        }
        return enumSet;
    }

    private static <T extends Enum<T>> void processArrayElements(Object array, EnumSet<T> enumSet, Class<T> enumClass) {
        int length = Array.getLength(array);
        Enum[] enumConstants = null;
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(array, i);
            if (element == null) continue;
            enumConstants = EnumConversions.processElement((Object)element, enumSet, enumClass, enumConstants);
        }
    }

    private static <T extends Enum<T>> void processElements(Collection<?> collection, EnumSet<T> enumSet, Class<T> enumClass) {
        Enum[] enumConstants = null;
        for (Object element : collection) {
            if (element == null) continue;
            enumConstants = EnumConversions.processElement(element, enumSet, enumClass, enumConstants);
        }
    }

    private static <T extends Enum<T>> T[] processElement(Object element, EnumSet<T> enumSet, Class<T> enumClass, T[] enumConstants) {
        if (enumClass.isInstance(element)) {
            enumSet.add((Enum)enumClass.cast(element));
        } else if (element instanceof String) {
            enumSet.add(Enum.valueOf(enumClass, (String)element));
        } else if (element instanceof Number) {
            int ordinal;
            if (enumConstants == null) {
                enumConstants = (Enum[])enumClass.getEnumConstants();
            }
            if ((ordinal = ((Number)element).intValue()) < 0 || ordinal >= enumConstants.length) {
                throw new IllegalArgumentException(String.format("Invalid ordinal value %d for enum %s. Must be between 0 and %d", ordinal, enumClass.getName(), enumConstants.length - 1));
            }
            enumSet.add(enumConstants[ordinal]);
        } else {
            throw new IllegalArgumentException(element.getClass().getName() + " found in source collection/array is not convertible to " + enumClass.getName());
        }
        return enumConstants;
    }
}

