/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.CollectionUtilities;
import com.cedarsoftware.util.convert.CollectionHandling;
import java.lang.reflect.Array;
import java.util.Collection;

public final class CollectionConversions {
    private CollectionConversions() {
    }

    public static Object arrayToCollection(Object array, Class<?> targetType) {
        int length = Array.getLength(array);
        boolean requiresUnmodifiable = CollectionUtilities.isUnmodifiable(targetType);
        boolean requiresSynchronized = CollectionUtilities.isSynchronized(targetType);
        Collection<?> collection = CollectionHandling.createCollection(array, targetType);
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(array, i);
            if (element != null && element.getClass().isArray()) {
                element = CollectionConversions.arrayToCollection(element, targetType);
            }
            collection.add(element);
        }
        if (requiresUnmodifiable) {
            return CollectionUtilities.getUnmodifiableCollection(collection);
        }
        if (requiresSynchronized) {
            return CollectionUtilities.getSynchronizedCollection(collection);
        }
        return collection;
    }

    public static Object collectionToCollection(Collection<?> source, Class<?> targetType) {
        boolean requiresUnmodifiable = CollectionUtilities.isUnmodifiable(targetType);
        boolean requiresSynchronized = CollectionUtilities.isSynchronized(targetType);
        Collection<?> targetCollection = CollectionHandling.createCollection(source, targetType);
        for (Object element : source) {
            if (element instanceof Collection) {
                element = CollectionConversions.collectionToCollection((Collection)element, targetType);
            }
            targetCollection.add(element);
        }
        if (requiresUnmodifiable) {
            return CollectionUtilities.getUnmodifiableCollection(targetCollection);
        }
        if (requiresSynchronized) {
            return CollectionUtilities.getSynchronizedCollection(targetCollection);
        }
        return targetCollection;
    }
}

