/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.cedarsoftware.util.ConcurrentHashMapNullSafe;
import com.cedarsoftware.util.ConcurrentNavigableMapNullSafe;
import com.cedarsoftware.util.ConcurrentNavigableSetNullSafe;
import com.cedarsoftware.util.ConcurrentSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;

public class CaseInsensitiveSet<E>
implements Set<E> {
    private final Map<E, Object> map;
    private static final Object PRESENT = new Object();

    public CaseInsensitiveSet() {
        this.map = new CaseInsensitiveMap<E, Object>();
    }

    public CaseInsensitiveSet(Collection<? extends E> collection) {
        this.map = collection instanceof ConcurrentNavigableSetNullSafe ? new CaseInsensitiveMap<E, Object>(new ConcurrentNavigableMapNullSafe()) : (collection instanceof ConcurrentSkipListSet ? new CaseInsensitiveMap<E, Object>(new ConcurrentSkipListMap()) : (collection instanceof ConcurrentSet ? new CaseInsensitiveMap<E, Object>(new ConcurrentHashMapNullSafe()) : (collection instanceof SortedSet ? new CaseInsensitiveMap<E, Object>(new TreeMap()) : new CaseInsensitiveMap<E, Object>(collection.size()))));
        this.addAll(collection);
    }

    public CaseInsensitiveSet(Collection<? extends E> source, Map backingMap) {
        this.map = backingMap;
        this.addAll(source);
    }

    public CaseInsensitiveSet(int initialCapacity) {
        this.map = new CaseInsensitiveMap<E, Object>(initialCapacity);
    }

    public CaseInsensitiveSet(int initialCapacity, float loadFactor) {
        this.map = new CaseInsensitiveMap<E, Object>(initialCapacity, loadFactor);
    }

    @Override
    public int hashCode() {
        return this.map.keySet().hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Set)) {
            return false;
        }
        Set that = (Set)other;
        return that.size() == this.size() && this.containsAll(that);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.keySet().toArray(a);
    }

    @Override
    public boolean add(E e) {
        int size = this.map.size();
        this.map.put(e, PRESENT);
        return this.map.size() != size;
    }

    @Override
    public boolean remove(Object o) {
        int size = this.map.size();
        this.map.remove(o);
        return this.map.size() != size;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.map.containsKey(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        int size = this.map.size();
        for (E elem : c) {
            this.map.put(elem, PRESENT);
        }
        return this.map.size() != size;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        CaseInsensitiveMap other = new CaseInsensitiveMap();
        Iterator<?> iterator = c.iterator();
        while (iterator.hasNext()) {
            Object o;
            Object element = o = iterator.next();
            other.put(element, PRESENT);
        }
        Iterator<E> iterator2 = this.map.keySet().iterator();
        int originalSize = this.map.size();
        while (iterator2.hasNext()) {
            E elem = iterator2.next();
            if (other.containsKey(elem)) continue;
            iterator2.remove();
        }
        return this.map.size() != originalSize;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object elem : c) {
            Object element = elem;
            if (this.map.remove(element) == null) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Deprecated
    public Set<E> minus(Iterable<E> removeMe) {
        for (E me : removeMe) {
            this.remove(me);
        }
        return this;
    }

    @Deprecated
    public Set<E> minus(E removeMe) {
        this.remove(removeMe);
        return this;
    }

    @Deprecated
    public Set<E> plus(Iterable<E> right) {
        for (E item : right) {
            this.add(item);
        }
        return this;
    }

    @Deprecated
    public Set<E> plus(Object right) {
        this.add(right);
        return this;
    }

    public String toString() {
        return this.map.keySet().toString();
    }
}

