/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ConcurrentHashMapNullSafe;
import com.cedarsoftware.util.ConcurrentNavigableMapNullSafe;
import com.cedarsoftware.util.LRUCache;
import com.cedarsoftware.util.StringUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.IntStream;

public class CaseInsensitiveMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, V> map;
    private static volatile List<Map.Entry<Class<?>, Function<Integer, ? extends Map<?, ?>>>> mapRegistry;

    private static void validateMappings(List<Map.Entry<Class<?>, Function<Integer, ? extends Map<?, ?>>>> registry) {
        for (int i = 0; i < registry.size(); ++i) {
            Class<?> current = registry.get(i).getKey();
            if (current.equals(IdentityHashMap.class)) {
                throw new IllegalStateException("IdentityHashMap is not supported and cannot be added to the registry.");
            }
            for (int j = i + 1; j < registry.size(); ++j) {
                Class<?> next = registry.get(j).getKey();
                if (!current.isAssignableFrom(next)) continue;
                throw new IllegalStateException("Mapping order error: " + next.getName() + " should come before " + current.getName());
            }
        }
    }

    public static void replaceRegistry(List<Map.Entry<Class<?>, Function<Integer, ? extends Map<?, ?>>>> newRegistry) {
        Objects.requireNonNull(newRegistry, "New registry list cannot be null");
        for (Map.Entry<Class<?>, Function<Integer, Map<?, ?>>> entry : newRegistry) {
            Objects.requireNonNull(entry, "Registry entries cannot be null");
            Objects.requireNonNull(entry.getKey(), "Registry entry key (Class) cannot be null");
            Objects.requireNonNull(entry.getValue(), "Registry entry value (Function) cannot be null");
        }
        HashSet seen = new HashSet();
        for (Map.Entry<Class<?>, Function<Integer, Map<?, ?>>> entry : newRegistry) {
            if (seen.add(entry.getKey())) continue;
            throw new IllegalArgumentException("Duplicate map type in registry: " + entry.getKey());
        }
        CaseInsensitiveMap.validateMappings(newRegistry);
        mapRegistry = Collections.unmodifiableList(new ArrayList(newRegistry));
    }

    public static void replaceCache(LRUCache lruCache) {
        CaseInsensitiveString.COMMON_STRINGS = lruCache;
    }

    public static void setMaxCacheLengthString(int length) {
        if (length < 10) {
            throw new IllegalArgumentException("Max cache String length must be at least 10.");
        }
        CaseInsensitiveString.maxCacheLengthString = length;
    }

    protected Map<K, V> determineBackingMap(Map<K, V> source) {
        if (source instanceof IdentityHashMap) {
            throw new IllegalArgumentException("Cannot create a CaseInsensitiveMap from an IdentityHashMap. IdentityHashMap compares keys by reference (==) which is incompatible.");
        }
        int size = source.size();
        for (Map.Entry<Class<?>, Function<Integer, Map<?, ?>>> entry : mapRegistry) {
            if (!entry.getKey().isInstance(source)) continue;
            Function<Integer, Map<?, ?>> factory = entry.getValue();
            return this.copy(source, factory.apply(size));
        }
        return this.copy(source, new LinkedHashMap(size));
    }

    public CaseInsensitiveMap() {
        this.map = new LinkedHashMap();
    }

    public CaseInsensitiveMap(int initialCapacity) {
        this.map = new LinkedHashMap(initialCapacity);
    }

    public CaseInsensitiveMap(int initialCapacity, float loadFactor) {
        this.map = new LinkedHashMap(initialCapacity, loadFactor);
    }

    public CaseInsensitiveMap(Map<K, V> source, Map<K, V> mapInstance) {
        this.map = this.copy(source, mapInstance);
    }

    public CaseInsensitiveMap(Map<K, V> source) {
        Objects.requireNonNull(source, "Source map cannot be null");
        this.map = this.determineBackingMap(source);
    }

    protected Map<K, V> copy(Map<K, V> source, Map<K, V> dest) {
        if (source.isEmpty()) {
            return dest;
        }
        if (source instanceof CaseInsensitiveMap) {
            dest.putAll(((CaseInsensitiveMap)source).map);
        } else {
            for (Map.Entry<K, V> entry : source.entrySet()) {
                K key = entry.getKey();
                Object result = key instanceof String ? CaseInsensitiveString.of((String)key) : key;
                dest.put(result, entry.getValue());
            }
        }
        return dest;
    }

    @Override
    public V get(Object key) {
        Object result = key instanceof String ? CaseInsensitiveString.of((String)key) : key;
        return this.map.get(result);
    }

    @Override
    public boolean containsKey(Object key) {
        Object result = key instanceof String ? CaseInsensitiveString.of((String)key) : key;
        return this.map.containsKey(result);
    }

    @Override
    public V put(K key, V value) {
        Object result = key instanceof String ? CaseInsensitiveString.of((String)key) : key;
        return this.map.put(result, value);
    }

    @Override
    public V remove(Object key) {
        Object result = key instanceof String ? CaseInsensitiveString.of((String)key) : key;
        return this.map.remove(result);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Map)) {
            return false;
        }
        Map that = (Map)other;
        if (that.size() != this.size()) {
            return false;
        }
        for (Map.Entry entry : that.entrySet()) {
            Object thatKey = entry.getKey();
            if (!this.containsKey(thatKey)) {
                return false;
            }
            Object thatValue = entry.getValue();
            V thisValue = this.get(thatKey);
            if (Objects.equals(thisValue, thatValue)) continue;
            return false;
        }
        return true;
    }

    public Map<K, V> getWrappedMap() {
        return this.map;
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){
                    private final Iterator<K> iter;
                    {
                        this.iter = CaseInsensitiveMap.this.map.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public K next() {
                        Object next = this.iter.next();
                        return next instanceof CaseInsensitiveString ? next.toString() : next;
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }

            @Override
            public int hashCode() {
                int h = 0;
                for (Object key : CaseInsensitiveMap.this.map.keySet()) {
                    if (key == null) continue;
                    h += key.hashCode();
                }
                return h;
            }

            @Override
            public int size() {
                return CaseInsensitiveMap.this.map.size();
            }

            @Override
            public boolean contains(Object o) {
                return CaseInsensitiveMap.this.containsKey(o);
            }

            @Override
            public boolean remove(Object o) {
                int size = CaseInsensitiveMap.this.map.size();
                CaseInsensitiveMap.this.remove(o);
                return CaseInsensitiveMap.this.map.size() != size;
            }

            @Override
            public <T> T[] toArray(T[] a) {
                int size = this.size();
                T[] result = a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
                int i = 0;
                for (Object key : CaseInsensitiveMap.this.map.keySet()) {
                    result[i++] = key instanceof CaseInsensitiveString ? key.toString() : key;
                }
                if (result.length > size) {
                    result[size] = null;
                }
                return result;
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                CaseInsensitiveMap other = new CaseInsensitiveMap();
                for (Object o : c) {
                    other.put(o, null);
                }
                int size = CaseInsensitiveMap.this.map.size();
                CaseInsensitiveMap.this.map.keySet().removeIf(key -> !other.containsKey(key));
                return CaseInsensitiveMap.this.map.size() != size;
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return CaseInsensitiveMap.this.map.size();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry that = (Map.Entry)o;
                Object value = CaseInsensitiveMap.this.get(that.getKey());
                return value != null ? value.equals(that.getValue()) : that.getValue() == null && CaseInsensitiveMap.this.containsKey(that.getKey());
            }

            @Override
            public Object[] toArray() {
                Object[] result = new Object[this.size()];
                int i = 0;
                for (Map.Entry entry : CaseInsensitiveMap.this.map.entrySet()) {
                    result[i++] = new CaseInsensitiveEntry(entry);
                }
                return result;
            }

            @Override
            public <T> T[] toArray(T[] a) {
                int size = this.size();
                T[] result = a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
                Iterator it = CaseInsensitiveMap.this.map.entrySet().iterator();
                for (int i = 0; i < size; ++i) {
                    result[i] = new CaseInsensitiveEntry(it.next());
                }
                if (result.length > size) {
                    result[size] = null;
                }
                return result;
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                int size = CaseInsensitiveMap.this.map.size();
                Map.Entry that = (Map.Entry)o;
                CaseInsensitiveMap.this.remove(that.getKey());
                return CaseInsensitiveMap.this.map.size() != size;
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                int size = CaseInsensitiveMap.this.map.size();
                for (Object o : c) {
                    if (!(o instanceof Map.Entry)) continue;
                    try {
                        Map.Entry that = (Map.Entry)o;
                        CaseInsensitiveMap.this.remove(that.getKey());
                    }
                    catch (ClassCastException classCastException) {}
                }
                return CaseInsensitiveMap.this.map.size() != size;
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                if (c.isEmpty()) {
                    int oldSize = this.size();
                    this.clear();
                    return oldSize > 0;
                }
                CaseInsensitiveMap other = new CaseInsensitiveMap();
                for (Object o : c) {
                    if (!(o instanceof Map.Entry)) continue;
                    Map.Entry entry2 = (Map.Entry)o;
                    other.put(entry2.getKey(), entry2.getValue());
                }
                int originalSize = this.size();
                CaseInsensitiveMap.this.map.entrySet().removeIf(entry -> !other.containsKey(entry.getKey()) || !Objects.equals(other.get(entry.getKey()), entry.getValue()));
                return this.size() != originalSize;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private final Iterator<Map.Entry<K, V>> iter;
                    {
                        this.iter = CaseInsensitiveMap.this.map.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return new CaseInsensitiveEntry(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }
        };
    }

    private <R> Function<? super K, ? extends R> wrapFunctionForKey(Function<? super K, ? extends R> func) {
        return k -> {
            Object originalKey = k instanceof CaseInsensitiveString ? ((CaseInsensitiveString)k).original : k;
            return func.apply((Object)originalKey);
        };
    }

    private <R> BiFunction<? super K, ? super V, ? extends R> wrapBiFunctionForKey(BiFunction<? super K, ? super V, ? extends R> func) {
        return (k, v) -> {
            Object originalKey = k instanceof CaseInsensitiveString ? ((CaseInsensitiveString)k).original : k;
            return func.apply((Object)originalKey, (Object)v);
        };
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Object result = key instanceof String ? CaseInsensitiveString.of((String)key) : key;
        return this.map.computeIfAbsent((K)result, this.wrapFunctionForKey(mappingFunction));
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Object result = key instanceof String ? CaseInsensitiveString.of((String)key) : key;
        return this.map.computeIfPresent((K)result, (BiFunction<? super K, ? extends V, ? extends V>)this.wrapBiFunctionForKey(remappingFunction));
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Object result = key instanceof String ? CaseInsensitiveString.of((String)key) : key;
        return this.map.compute((K)result, (BiFunction<? super K, ? extends V, ? extends V>)this.wrapBiFunctionForKey(remappingFunction));
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Object result = key instanceof String ? CaseInsensitiveString.of((String)key) : key;
        return this.map.merge(result, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Object result = key instanceof String ? CaseInsensitiveString.of((String)key) : key;
        return this.map.putIfAbsent(result, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        Object result = key instanceof String ? CaseInsensitiveString.of((String)key) : key;
        return this.map.remove(result, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Object result = key instanceof String ? CaseInsensitiveString.of((String)key) : key;
        return this.map.replace(result, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        Object result = key instanceof String ? CaseInsensitiveString.of((String)key) : key;
        return this.map.replace(result, value);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.map.forEach((k, v) -> {
            Object originalKey = k instanceof CaseInsensitiveString ? ((CaseInsensitiveString)k).original : k;
            action.accept((Object)originalKey, (Object)v);
        });
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.map.replaceAll((k, v) -> {
            Object originalKey = k instanceof CaseInsensitiveString ? ((CaseInsensitiveString)k).original : k;
            return function.apply((Object)originalKey, (Object)v);
        });
    }

    static {
        ArrayList tempList = new ArrayList();
        tempList.add(new AbstractMap.SimpleEntry<Class<Hashtable>, Function<Integer, Map>>(Hashtable.class, size -> new Hashtable()));
        tempList.add(new AbstractMap.SimpleEntry<Class<TreeMap>, Function<Integer, Map>>(TreeMap.class, size -> new TreeMap()));
        tempList.add(new AbstractMap.SimpleEntry<Class<ConcurrentSkipListMap>, Function<Integer, Map>>(ConcurrentSkipListMap.class, size -> new ConcurrentSkipListMap()));
        tempList.add(new AbstractMap.SimpleEntry<Class<ConcurrentNavigableMapNullSafe>, Function<Integer, Map>>(ConcurrentNavigableMapNullSafe.class, size -> new ConcurrentNavigableMapNullSafe()));
        tempList.add(new AbstractMap.SimpleEntry<Class<ConcurrentHashMapNullSafe>, Function<Integer, Map>>(ConcurrentHashMapNullSafe.class, size -> new ConcurrentHashMapNullSafe((int)size)));
        tempList.add(new AbstractMap.SimpleEntry<Class<WeakHashMap>, Function<Integer, Map>>(WeakHashMap.class, size -> new WeakHashMap((int)size)));
        tempList.add(new AbstractMap.SimpleEntry<Class<LinkedHashMap>, Function<Integer, Map>>(LinkedHashMap.class, size -> new LinkedHashMap((int)size)));
        tempList.add(new AbstractMap.SimpleEntry<Class<HashMap>, Function<Integer, Map>>(HashMap.class, size -> new HashMap((int)size)));
        tempList.add(new AbstractMap.SimpleEntry<Class<ConcurrentNavigableMap>, Function<Integer, Map>>(ConcurrentNavigableMap.class, size -> new ConcurrentSkipListMap()));
        tempList.add(new AbstractMap.SimpleEntry<Class<ConcurrentMap>, Function<Integer, Map>>(ConcurrentMap.class, size -> new ConcurrentHashMap((int)size)));
        tempList.add(new AbstractMap.SimpleEntry<Class<NavigableMap>, Function<Integer, Map>>(NavigableMap.class, size -> new TreeMap()));
        tempList.add(new AbstractMap.SimpleEntry<Class<SortedMap>, Function<Integer, Map>>(SortedMap.class, size -> new TreeMap()));
        CaseInsensitiveMap.validateMappings(tempList);
        mapRegistry = Collections.unmodifiableList(tempList);
    }

    public static final class CaseInsensitiveString
    implements Comparable<Object>,
    CharSequence,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String original;
        private final int hash;
        private static volatile Map<String, CaseInsensitiveString> COMMON_STRINGS;
        private static volatile int maxCacheLengthString;

        public static CaseInsensitiveString of(String s) {
            if (s == null) {
                throw new IllegalArgumentException("Cannot convert null to CaseInsensitiveString");
            }
            if (s.length() > maxCacheLengthString) {
                return new CaseInsensitiveString(s);
            }
            return COMMON_STRINGS.computeIfAbsent(s, CaseInsensitiveString::new);
        }

        CaseInsensitiveString(String string) {
            this.original = string;
            this.hash = StringUtilities.hashCodeIgnoreCase(string);
        }

        @Override
        public String toString() {
            return this.original;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof CaseInsensitiveString) {
                CaseInsensitiveString cis = (CaseInsensitiveString)other;
                return this.hash == cis.hash && this.original.equalsIgnoreCase(cis.original);
            }
            if (other instanceof String) {
                return this.original.equalsIgnoreCase((String)other);
            }
            return false;
        }

        @Override
        public int compareTo(Object o) {
            if (o instanceof CaseInsensitiveString) {
                CaseInsensitiveString other = (CaseInsensitiveString)o;
                return this.original.compareToIgnoreCase(other.original);
            }
            if (o instanceof String) {
                return this.original.compareToIgnoreCase((String)o);
            }
            return -1;
        }

        @Override
        public int length() {
            return this.original.length();
        }

        @Override
        public char charAt(int index) {
            return this.original.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.original.subSequence(start, end);
        }

        @Override
        public IntStream chars() {
            return this.original.chars();
        }

        @Override
        public IntStream codePoints() {
            return this.original.codePoints();
        }

        public boolean contains(CharSequence s) {
            return this.original.toLowerCase().contains(s.toString().toLowerCase());
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
        }

        static {
            String[] commonValues;
            COMMON_STRINGS = new LRUCache<String, CaseInsensitiveString>(5000, LRUCache.StrategyType.THREADED);
            maxCacheLengthString = 100;
            for (String value : commonValues = new String[]{"true", "false", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "id", "name", "code", "type", "status", "date", "value", "amount", "yes", "no", "null", "none"}) {
                COMMON_STRINGS.put(value, new CaseInsensitiveString(value));
            }
        }
    }

    public class CaseInsensitiveEntry
    extends AbstractMap.SimpleEntry<K, V> {
        public CaseInsensitiveEntry(Map.Entry<K, V> entry) {
            super(entry);
        }

        @Override
        public K getKey() {
            Object superKey = super.getKey();
            if (superKey instanceof CaseInsensitiveString) {
                return ((CaseInsensitiveString)superKey).original;
            }
            return superKey;
        }

        public K getOriginalKey() {
            return super.getKey();
        }

        @Override
        public V setValue(V value) {
            return CaseInsensitiveMap.this.put(this.getOriginalKey(), value);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Objects.equals(this.getOriginalKey(), e.getKey()) && Objects.equals(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.getOriginalKey()) ^ Objects.hashCode(this.getValue());
        }

        @Override
        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

