/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.LoggingConfig;
import com.cedarsoftware.util.ReflectionUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Traverser {
    private static final Logger LOG = Logger.getLogger(Traverser.class.getName());
    private final Set<Object> objVisited = Collections.newSetFromMap(new IdentityHashMap());
    private final Consumer<NodeVisit> nodeVisitor;
    private final boolean collectFields;

    private Traverser(Consumer<NodeVisit> nodeVisitor, boolean collectFields) {
        this.nodeVisitor = nodeVisitor;
        this.collectFields = collectFields;
    }

    public static void traverse(Object root, Consumer<NodeVisit> visitor, Set<Class<?>> classesToSkip) {
        Traverser.traverse(root, visitor, classesToSkip, true);
    }

    public static void traverse(Object root, Consumer<NodeVisit> visitor, Set<Class<?>> classesToSkip, boolean collectFields) {
        if (visitor == null) {
            throw new IllegalArgumentException("visitor cannot be null");
        }
        Traverser traverser = new Traverser(visitor, collectFields);
        traverser.walk(root, classesToSkip);
    }

    private static void traverse(Object root, Set<Class<?>> classesToSkip, Consumer<Object> objectProcessor) {
        if (objectProcessor == null) {
            throw new IllegalArgumentException("objectProcessor cannot be null");
        }
        Traverser.traverse(root, visit -> objectProcessor.accept(visit.getNode()), classesToSkip, true);
    }

    @Deprecated
    public static void traverse(Object root, Visitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("visitor cannot be null");
        }
        Traverser.traverse(root, visit -> visitor.process(visit.getNode()), null, true);
    }

    @Deprecated
    public static void traverse(Object root, Class<?>[] skip, Visitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("visitor cannot be null");
        }
        HashSet classesToSkip = skip == null ? null : new HashSet(Arrays.asList(skip));
        Traverser.traverse(root, visit -> visitor.process(visit.getNode()), classesToSkip, true);
    }

    private void walk(Object root, Set<Class<?>> classesToSkip) {
        if (root == null) {
            return;
        }
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        stack.add(root);
        while (!stack.isEmpty()) {
            Class<?> clazz;
            Object current = stack.pollFirst();
            if (current == null || this.objVisited.contains(current) || this.shouldSkipClass(clazz = current.getClass(), classesToSkip)) continue;
            this.objVisited.add(current);
            if (this.collectFields) {
                this.nodeVisitor.accept(new NodeVisit(current, this.collectFields(current)));
            } else {
                this.nodeVisitor.accept(new NodeVisit(current, () -> this.collectFields(current)));
            }
            if (clazz.isArray()) {
                this.processArray(stack, current, classesToSkip);
                continue;
            }
            if (current instanceof Collection) {
                this.processCollection(stack, (Collection)current, classesToSkip);
                continue;
            }
            if (current instanceof Map) {
                this.processMap(stack, (Map)current, classesToSkip);
                continue;
            }
            this.processFields(stack, current, classesToSkip);
        }
    }

    private Map<Field, Object> collectFields(Object obj) {
        HashMap<Field, Object> fields = new HashMap<Field, Object>();
        List<Field> allFields = ReflectionUtils.getAllDeclaredFields(obj.getClass(), field -> ReflectionUtils.DEFAULT_FIELD_FILTER.test((Field)field) && !field.isSynthetic());
        for (Field field2 : allFields) {
            try {
                fields.put(field2, field2.get(obj));
            }
            catch (IllegalAccessException e) {
                LOG.log(Level.FINEST, "Unable to access field '" + field2.getName() + "' on " + obj.getClass().getName(), e);
                fields.put(field2, "<inaccessible>");
            }
        }
        return fields;
    }

    private boolean shouldSkipClass(Class<?> clazz, Set<Class<?>> classesToSkip) {
        if (classesToSkip == null) {
            return false;
        }
        for (Class<?> skipClass : classesToSkip) {
            if (skipClass == null || !skipClass.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    private void processArray(Deque<Object> stack, Object array, Set<Class<?>> classesToSkip) {
        int length = Array.getLength(array);
        Class<?> componentType = array.getClass().getComponentType();
        if (!componentType.isPrimitive()) {
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(array, i);
                if (element == null || this.shouldSkipClass(element.getClass(), classesToSkip)) continue;
                stack.addFirst(element);
            }
        }
    }

    private void processCollection(Deque<Object> stack, Collection<?> collection, Set<Class<?>> classesToSkip) {
        for (Object element : collection) {
            if (element == null || this.shouldSkipClass(element.getClass(), classesToSkip)) continue;
            stack.addFirst(element);
        }
    }

    private void processMap(Deque<Object> stack, Map<?, ?> map, Set<Class<?>> classesToSkip) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key != null && !this.shouldSkipClass(key.getClass(), classesToSkip)) {
                stack.addFirst(key);
            }
            if (value == null || this.shouldSkipClass(value.getClass(), classesToSkip)) continue;
            stack.addFirst(value);
        }
    }

    private void processFields(Deque<Object> stack, Object object, Set<Class<?>> classesToSkip) {
        List<Field> fields = ReflectionUtils.getAllDeclaredFields(object.getClass(), field -> ReflectionUtils.DEFAULT_FIELD_FILTER.test((Field)field) && !field.isSynthetic());
        for (Field field2 : fields) {
            if (field2.getType().isPrimitive()) continue;
            try {
                Object value = field2.get(object);
                if (value == null || this.shouldSkipClass(value.getClass(), classesToSkip)) continue;
                stack.addFirst(value);
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    static {
        LoggingConfig.init();
    }

    @Deprecated
    @FunctionalInterface
    public static interface Visitor {
        public void process(Object var1);
    }

    public static class NodeVisit {
        private final Object node;
        private final Supplier<Map<Field, Object>> fieldsSupplier;
        private Map<Field, Object> fields;

        public NodeVisit(Object node, Map<Field, Object> fields) {
            this(node, () -> fields == null ? Collections.emptyMap() : fields);
            this.fields = Collections.unmodifiableMap(new HashMap<Field, Object>(fields));
        }

        public NodeVisit(Object node, Supplier<Map<Field, Object>> supplier) {
            this.node = node;
            this.fieldsSupplier = supplier;
        }

        public Object getNode() {
            return this.node;
        }

        public Map<Field, Object> getFields() {
            if (this.fields == null) {
                Map f;
                Map<Object, Object> map = f = this.fieldsSupplier == null ? Collections.emptyMap() : this.fieldsSupplier.get();
                if (f == null) {
                    f = Collections.emptyMap();
                }
                this.fields = Collections.unmodifiableMap(new HashMap(f));
            }
            return this.fields;
        }

        public Class<?> getNodeClass() {
            return this.node.getClass();
        }
    }
}

