/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.LoggingConfig;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;

public class InetAddressUtilities {
    private static final Logger LOG = Logger.getLogger(InetAddressUtilities.class.getName());

    private InetAddressUtilities() {
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        return InetAddress.getLocalHost();
    }

    public static byte[] getIpAddress() {
        try {
            return InetAddressUtilities.getLocalHost().getAddress();
        }
        catch (Exception e) {
            LOG.warning("Failed to obtain computer's IP address");
            return new byte[]{0, 0, 0, 0};
        }
    }

    public static String getHostName() {
        try {
            return InetAddressUtilities.getLocalHost().getHostName();
        }
        catch (Exception e) {
            LOG.warning("Unable to fetch 'hostname'");
            return "localhost";
        }
    }

    static {
        LoggingConfig.init();
    }
}

