/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.LoggingConfig;
import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MultiKeyMap<V>
implements ConcurrentMap<Object, V> {
    private static final Logger LOG = Logger.getLogger(MultiKeyMap.class.getName());
    private static final AtomicBoolean STRIPE_CONFIG_LOGGED;
    private final AtomicInteger totalLockAcquisitions = new AtomicInteger(0);
    private final AtomicInteger contentionCount = new AtomicInteger(0);
    private final AtomicInteger[] stripeLockContention = new AtomicInteger[STRIPE_COUNT];
    private final AtomicInteger[] stripeLockAcquisitions = new AtomicInteger[STRIPE_COUNT];
    private final AtomicInteger globalLockAcquisitions = new AtomicInteger(0);
    private final AtomicInteger globalLockContentions = new AtomicInteger(0);
    private final AtomicBoolean resizeInProgress = new AtomicBoolean(false);
    private volatile Object[] buckets;
    private final AtomicInteger atomicSize = new AtomicInteger(0);
    private volatile int size = 0;
    private volatile int maxChainLength = 0;
    private final float loadFactor;
    private final CollectionKeyMode collectionKeyMode;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int STRIPE_COUNT;
    private static final int STRIPE_MASK;
    private final ReentrantLock[] stripeLocks = new ReentrantLock[STRIPE_COUNT];
    private static final Object NULL_SENTINEL;
    private static final Object NOT_FOUND_SENTINEL;

    public MultiKeyMap(int capacity, float loadFactor) {
        this(capacity, loadFactor, CollectionKeyMode.MULTI_KEY_ONLY);
    }

    public MultiKeyMap(int capacity, float loadFactor, CollectionKeyMode collectionKeyMode) {
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Load factor must be positive: " + loadFactor);
        }
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity must be non-negative: " + capacity);
        }
        this.buckets = new Object[capacity];
        this.loadFactor = loadFactor;
        this.collectionKeyMode = collectionKeyMode != null ? collectionKeyMode : CollectionKeyMode.MULTI_KEY_ONLY;
        for (int i = 0; i < STRIPE_COUNT; ++i) {
            this.stripeLocks[i] = new ReentrantLock();
            this.stripeLockContention[i] = new AtomicInteger(0);
            this.stripeLockAcquisitions[i] = new AtomicInteger(0);
        }
        if (STRIPE_CONFIG_LOGGED.compareAndSet(false, true) && LOG.isLoggable(Level.INFO)) {
            LOG.info(String.format("MultiKeyMap stripe configuration: %d locks for %d cores", STRIPE_COUNT, Runtime.getRuntime().availableProcessors()));
        }
    }

    public MultiKeyMap() {
        this(16);
    }

    public MultiKeyMap(CollectionKeyMode collectionKeyMode) {
        this(16, 0.75f, collectionKeyMode);
    }

    public MultiKeyMap(int capacity) {
        this(capacity, 0.75f);
    }

    private static int computeHash(Object ... keys) {
        return MultiKeyMap.computeHashFromArray(keys);
    }

    private static int computeSingleKeyHash(Object key) {
        return MultiKeyMap.computeHashFromSingle(key);
    }

    private static int computeHashFromArray(Object[] keys) {
        if (keys == null || keys.length == 0) {
            return 0;
        }
        return MultiKeyMap.computeHashInternal(keys, keys.length);
    }

    private static int computeHashFromCollection(Collection<?> keys) {
        if (keys == null || keys.isEmpty()) {
            return 0;
        }
        return MultiKeyMap.computeHashInternal(keys, keys.size());
    }

    private static int computeHashFromTypedArray(Object typedArray) {
        if (typedArray == null) {
            return 0;
        }
        int length = Array.getLength(typedArray);
        if (length == 0) {
            return 0;
        }
        return MultiKeyMap.computeHashInternal(typedArray, length);
    }

    private static int computeHashFromSingle(Object key) {
        if (key == null || key == NULL_SENTINEL) {
            return 0;
        }
        int keyHash = MultiKeyMap.getKeyHash(key);
        return MultiKeyMap.finalizeHash(keyHash);
    }

    private static int computeHashInternal(Object keys, int size) {
        if (size == 0) {
            return 0;
        }
        int hash = 1;
        if (keys instanceof Object[]) {
            Object[] array;
            for (Object o : array = (Object[])keys) {
                hash = hash * 31 + MultiKeyMap.getKeyHash(o);
            }
        } else if (keys instanceof Collection) {
            for (Object key : (Collection)keys) {
                hash = hash * 31 + MultiKeyMap.getKeyHash(key);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                hash = hash * 31 + MultiKeyMap.getKeyHash(Array.get(keys, i));
            }
        }
        return MultiKeyMap.finalizeHash(hash);
    }

    private static int getKeyHash(Object key) {
        if (key == null) {
            return 0;
        }
        if (key instanceof Class || key instanceof Executable || key instanceof Field || key instanceof ClassLoader || key instanceof Reference || key instanceof Thread) {
            return System.identityHashCode(key);
        }
        return key.hashCode();
    }

    private static int finalizeHash(int hash) {
        hash ^= hash >>> 16;
        hash *= -2048144789;
        hash ^= hash >>> 13;
        hash *= -1028477387;
        hash ^= hash >>> 16;
        return hash;
    }

    private static int computeHashForKey(Object key) {
        if (key == null) {
            return 0;
        }
        Class<?> keyClass = key.getClass();
        if (keyClass.isArray()) {
            if (key instanceof Object[]) {
                return MultiKeyMap.computeHashFromArray((Object[])key);
            }
            return MultiKeyMap.computeHashFromTypedArray(key);
        }
        if (key instanceof Collection) {
            return MultiKeyMap.computeHashFromCollection((Collection)key);
        }
        return MultiKeyMap.computeHashFromSingle(key);
    }

    private ReentrantLock getStripeLock(int hash) {
        return this.stripeLocks[hash & STRIPE_MASK];
    }

    private void lockAllStripes() {
        int contendedStripes = 0;
        for (ReentrantLock lock : this.stripeLocks) {
            boolean wasContended = lock.hasQueuedThreads();
            if (wasContended) {
                ++contendedStripes;
            }
            lock.lock();
        }
        this.globalLockAcquisitions.incrementAndGet();
        if (contendedStripes > 0) {
            this.globalLockContentions.incrementAndGet();
        }
    }

    private void unlockAllStripes() {
        for (int i = this.stripeLocks.length - 1; i >= 0; --i) {
            this.stripeLocks[i].unlock();
        }
    }

    public V get(Object ... keys) {
        if (keys == null) {
            return this.getInternalDirect(null);
        }
        return this.getInternal(keys);
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return this.getInternalDirect(null);
        }
        if (!(key instanceof Collection)) {
            Class<?> keyClass = key.getClass();
            if (keyClass.isArray()) {
                return this.getFromArray(key);
            }
            return this.getInternalDirect(key);
        }
        return this.getFromCollection((Collection)key);
    }

    private V getFromCollection(Collection<?> collection) {
        switch (this.collectionKeyMode) {
            case MULTI_KEY_ONLY: {
                return this.getFromCollectionMultiKeyOnly(collection);
            }
            case MULTI_KEY_FIRST: {
                return this.getFromCollectionMultiKeyFirst(collection);
            }
            case COLLECTION_KEY_FIRST: {
                return this.getFromCollectionKeyFirst(collection);
            }
        }
        throw new IllegalStateException("Unknown CollectionKeyMode: " + (Object)((Object)this.collectionKeyMode));
    }

    private V getFromArray(Object array) {
        if (array instanceof Object[]) {
            return this.getInternal((Object[])array);
        }
        return this.getInternalFromTypedArray(array);
    }

    private V getFromCollectionMultiKeyOnly(Collection<?> collection) {
        Object rawResult = this.getInternalFromCollectionRaw(collection);
        return (V)(rawResult == NOT_FOUND_SENTINEL ? null : rawResult);
    }

    private V getFromCollectionMultiKeyFirst(Collection<?> collection) {
        Object rawResult = this.getInternalFromCollectionRaw(collection);
        if (rawResult != NOT_FOUND_SENTINEL) {
            return (V)rawResult;
        }
        return this.getInternalDirect(collection);
    }

    private V getFromCollectionKeyFirst(Collection<?> collection) {
        V result = this.getInternalDirect(collection);
        if (result != null) {
            return result;
        }
        Object rawResult = this.getInternalFromCollectionRaw(collection);
        return (V)(rawResult == NOT_FOUND_SENTINEL ? null : rawResult);
    }

    private V getInternalFromTypedArray(Object typedArray) {
        if (typedArray == null) {
            return this.get((Object)null);
        }
        int length = Array.getLength(typedArray);
        if (length == 0) {
            return null;
        }
        int hash = MultiKeyMap.computeHashFromTypedArray(typedArray);
        return this.getFromBucket(hash, typedArray);
    }

    private V getInternal(Object[] keys) {
        int hash = MultiKeyMap.computeHash(keys);
        return this.getFromBucket(hash, keys);
    }

    private V getFromBucket(int hash, Object keysParam) {
        Object[] currentBuckets = this.buckets;
        int bucketIndex = hash & currentBuckets.length - 1;
        MultiKey[] chain = (MultiKey[])currentBuckets[bucketIndex];
        if (chain == null) {
            return null;
        }
        for (MultiKey entry : chain) {
            if (entry.hash != hash || !MultiKeyMap.keysMatch(entry.keys, keysParam)) continue;
            return entry.value;
        }
        return null;
    }

    private Object getInternalFromCollectionRaw(Collection<?> collection) {
        if (collection.isEmpty()) {
            return NOT_FOUND_SENTINEL;
        }
        Object[] currentBuckets = this.buckets;
        int hash = MultiKeyMap.computeHashFromCollection(collection);
        int bucketIndex = hash & currentBuckets.length - 1;
        MultiKey[] chain = (MultiKey[])currentBuckets[bucketIndex];
        if (chain == null) {
            return NOT_FOUND_SENTINEL;
        }
        for (MultiKey entry : chain) {
            if (entry.hash != hash || !MultiKeyMap.keysMatch(entry.keys, collection)) continue;
            return entry.value;
        }
        return NOT_FOUND_SENTINEL;
    }

    private V getInternalDirect(Object key) {
        Object[] currentBuckets = this.buckets;
        Object lookupKey = key == null ? NULL_SENTINEL : key;
        int hash = MultiKeyMap.computeSingleKeyHash(lookupKey);
        int bucketIndex = hash & currentBuckets.length - 1;
        MultiKey[] chain = (MultiKey[])currentBuckets[bucketIndex];
        if (chain == null) {
            return null;
        }
        for (MultiKey entry : chain) {
            if (entry.hash != hash || !this.isSingleKeyMatch(entry.keys, lookupKey)) continue;
            return entry.value;
        }
        return null;
    }

    private boolean isSingleKeyMatch(Object storedKeys, Object singleKey) {
        return MultiKeyMap.keysMatch(storedKeys, singleKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V removeInternalDirect(Object key) {
        Object lookupKey = key == null ? NULL_SENTINEL : key;
        int hash = MultiKeyMap.computeSingleKeyHash(lookupKey);
        ReentrantLock lock = this.getStripeLock(hash);
        int stripeIndex = hash & STRIPE_MASK;
        boolean wasContended = lock.hasQueuedThreads();
        lock.lock();
        try {
            int bucketIndex;
            MultiKey[] chain;
            this.totalLockAcquisitions.incrementAndGet();
            this.stripeLockAcquisitions[stripeIndex].incrementAndGet();
            if (wasContended) {
                this.contentionCount.incrementAndGet();
                this.stripeLockContention[stripeIndex].incrementAndGet();
            }
            if ((chain = (MultiKey[])this.buckets[bucketIndex = hash & this.buckets.length - 1]) == null) {
                V v = null;
                return v;
            }
            for (int i = 0; i < chain.length; ++i) {
                int newSize;
                MultiKey entry = chain[i];
                if (entry.hash != hash || !this.isSingleKeyMatch(entry.keys, lookupKey)) continue;
                if (chain.length == 1) {
                    this.buckets[bucketIndex] = null;
                } else {
                    MultiKey[] newChain = new MultiKey[chain.length - 1];
                    System.arraycopy(chain, 0, newChain, 0, i);
                    if (i < chain.length - 1) {
                        System.arraycopy(chain, i + 1, newChain, i, chain.length - i - 1);
                    }
                    this.buckets[bucketIndex] = newChain;
                }
                this.size = newSize = this.atomicSize.decrementAndGet();
                Object v = entry.value;
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    private boolean containsKeyInternalDirect(Object key) {
        Object[] currentBuckets = this.buckets;
        Object lookupKey = key == null ? NULL_SENTINEL : key;
        int hash = MultiKeyMap.computeSingleKeyHash(lookupKey);
        int bucketIndex = hash & currentBuckets.length - 1;
        MultiKey[] chain = (MultiKey[])currentBuckets[bucketIndex];
        if (chain == null) {
            return false;
        }
        for (MultiKey entry : chain) {
            if (entry.hash != hash || !this.isSingleKeyMatch(entry.keys, lookupKey)) continue;
            return true;
        }
        return false;
    }

    private static boolean keysMatch(Object storedKeys, Object lookupKeys) {
        boolean lookupIsArray;
        if (storedKeys == lookupKeys) {
            return true;
        }
        if (storedKeys == null || lookupKeys == null) {
            return false;
        }
        boolean storedIsArray = storedKeys instanceof Object[];
        boolean bl = lookupIsArray = lookupKeys instanceof Object[] || lookupKeys instanceof Collection || lookupKeys != null && lookupKeys.getClass().isArray();
        if (storedIsArray != lookupIsArray) {
            return false;
        }
        if (storedIsArray) {
            return MultiKeyMap.matchMultiKeys((Object[])storedKeys, lookupKeys);
        }
        return Objects.equals(storedKeys, lookupKeys);
    }

    private static boolean matchMultiKeys(Object[] stored, Object lookup) {
        if (lookup instanceof Object[]) {
            return MultiKeyMap.keysEqual(stored, (Object[])lookup);
        }
        if (lookup instanceof Collection) {
            return MultiKeyMap.keysEqualCollection(stored, (Collection)lookup);
        }
        if (lookup.getClass().isArray()) {
            return MultiKeyMap.keysEqualTypedArray(stored, lookup);
        }
        return false;
    }

    private static boolean keysEqual(Object[] keys1, Object[] keys2) {
        if (keys1 == keys2) {
            return true;
        }
        if (keys1 == null || keys2 == null) {
            return false;
        }
        if (keys1.length != keys2.length) {
            return false;
        }
        for (int i = 0; i < keys1.length; ++i) {
            if (MultiKeyMap.keyEquals(keys1[i], keys2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean keysEqualCollection(Object[] stored, Collection<?> lookup) {
        if (stored.length != lookup.size()) {
            return false;
        }
        int i = 0;
        for (Object lookupKey : lookup) {
            if (!MultiKeyMap.keyEquals(stored[i], lookupKey)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean keysEqualTypedArray(Object[] stored, Object typedArray) {
        int length = Array.getLength(typedArray);
        if (stored.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (MultiKeyMap.keyEquals(stored[i], Array.get(typedArray, i))) continue;
            return false;
        }
        return true;
    }

    private static boolean keyEquals(Object k1, Object k2) {
        if (k1 == k2) {
            return true;
        }
        if (k1 == null || k2 == null) {
            return false;
        }
        if (k1 instanceof Class && k2 instanceof Class || k1 instanceof Executable && k2 instanceof Executable || k1 instanceof Field && k2 instanceof Field || k1 instanceof ClassLoader && k2 instanceof ClassLoader || k1 instanceof Reference && k2 instanceof Reference || k1 instanceof Thread && k2 instanceof Thread) {
            return false;
        }
        return k1.equals(k2);
    }

    @Override
    public V put(V value, Object ... keys) {
        if (keys == null || keys.length == 0) {
            return this.putInternalSingle(null, value);
        }
        if (keys.length >= 2 && keys[keys.length - 1] == KeyMode.SINGLE_KEY) {
            Object[] actualKeys = new Object[keys.length - 1];
            System.arraycopy(keys, 0, actualKeys, 0, keys.length - 1);
            if (actualKeys.length == 1) {
                return this.putInternalSingle(actualKeys[0], value);
            }
            return this.putInternalSingle(actualKeys, value);
        }
        return this.putInternal(keys, value);
    }

    @Override
    public V put(Object key, V value) {
        if (key != null && key.getClass().isArray()) {
            if (key instanceof Object[]) {
                return (V)this.put((Object)value, (V)((Object[])key));
            }
            return this.putInternalFromTypedArray(key, value);
        }
        if (key instanceof Collection) {
            return this.putFromCollection((Collection)key, value);
        }
        return this.putInternalSingle(key, value);
    }

    private V putFromCollection(Collection<?> collection, V value) {
        switch (this.collectionKeyMode) {
            case MULTI_KEY_ONLY: {
                return this.putInternalFromCollection(collection, value);
            }
            case MULTI_KEY_FIRST: {
                return this.putInternalFromCollection(collection, value);
            }
            case COLLECTION_KEY_FIRST: {
                return this.putInternalSingle(collection, value);
            }
        }
        throw new IllegalStateException("Unknown CollectionKeyMode: " + (Object)((Object)this.collectionKeyMode));
    }

    private V putInternal(Object[] keys, V value) {
        MultiKey<V> newKey = new MultiKey<V>(keys, value);
        return this.putInternalCommon(newKey);
    }

    private V putInternalSingle(Object key, V value) {
        MultiKey<V> newKey = new MultiKey<V>(key, value);
        return this.putInternalCommon(newKey);
    }

    private V putInternalFromCollection(Collection<?> collection, V value) {
        if (collection.isEmpty()) {
            return this.putInternal(new Object[0], value);
        }
        Object[] keys = collection.toArray();
        MultiKey<V> newKey = new MultiKey<V>(keys, value);
        return this.putInternalCommon(newKey);
    }

    private V putInternalNoLock(MultiKey<V> newKey) {
        int hash = newKey.hash;
        int bucketIndex = hash & this.buckets.length - 1;
        MultiKey[] chain = (MultiKey[])this.buckets[bucketIndex];
        if (chain == null) {
            this.buckets[bucketIndex] = chain = this.createChain(newKey);
            this.size = this.atomicSize.incrementAndGet();
            if (1 > this.maxChainLength) {
                this.maxChainLength = 1;
            }
            return null;
        }
        for (int i = 0; i < chain.length; ++i) {
            MultiKey existing = chain[i];
            if (existing.hash != hash || !MultiKeyMap.keysMatch(existing.keys, newKey.keys)) continue;
            Object oldValue = existing.value;
            chain[i] = newKey;
            return oldValue;
        }
        this.buckets[bucketIndex] = chain = this.growChain(chain, newKey);
        this.size = this.atomicSize.incrementAndGet();
        if (chain.length > this.maxChainLength) {
            this.maxChainLength = chain.length;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V putInternalCommon(MultiKey<V> newKey) {
        int hash = newKey.hash;
        ReentrantLock lock = this.getStripeLock(hash);
        int stripeIndex = hash & STRIPE_MASK;
        boolean resizeNeeded = false;
        V oldValue = null;
        boolean wasContended = lock.hasQueuedThreads();
        lock.lock();
        try {
            this.totalLockAcquisitions.incrementAndGet();
            this.stripeLockAcquisitions[stripeIndex].incrementAndGet();
            if (wasContended) {
                this.contentionCount.incrementAndGet();
                this.stripeLockContention[stripeIndex].incrementAndGet();
            }
            oldValue = this.putInternalNoLock(newKey);
            resizeNeeded = (float)this.size > (float)this.buckets.length * this.loadFactor;
        }
        finally {
            lock.unlock();
        }
        if (resizeNeeded && this.resizeInProgress.compareAndSet(false, true)) {
            try {
                this.resize();
            }
            finally {
                this.resizeInProgress.set(false);
            }
        }
        return oldValue;
    }

    private V putInternalFromTypedArray(Object typedArray, V value) {
        int length = Array.getLength(typedArray);
        Object[] keys = new Object[length];
        for (int i = 0; i < length; ++i) {
            keys[i] = Array.get(typedArray, i);
        }
        return this.putInternal(keys, value);
    }

    private V removeInternalFromTypedArray(Object typedArray) {
        int length = Array.getLength(typedArray);
        Object[] keys = new Object[length];
        for (int i = 0; i < length; ++i) {
            keys[i] = Array.get(typedArray, i);
        }
        return this.removeInternal(keys);
    }

    private MultiKey<V>[] createChain(MultiKey<V> key) {
        return new MultiKey[]{key};
    }

    private MultiKey<V>[] growChain(MultiKey<V>[] oldChain, MultiKey<V> newKey) {
        MultiKey<V>[] newChain = Arrays.copyOf(oldChain, oldChain.length + 1);
        newChain[oldChain.length] = newKey;
        return newChain;
    }

    private int rehashEntry(MultiKey<V> entry, Object[] targetBuckets) {
        int bucketIndex = entry.hash & targetBuckets.length - 1;
        MultiKey[] chain = (MultiKey[])targetBuckets[bucketIndex];
        if (chain == null) {
            targetBuckets[bucketIndex] = this.createChain(entry);
            return 1;
        }
        targetBuckets[bucketIndex] = chain = this.growChain(chain, entry);
        return chain.length;
    }

    @Override
    public int size() {
        return this.atomicSize.get();
    }

    public int getMaxChainLength() {
        return this.maxChainLength;
    }

    public double getLoadFactor() {
        return (double)this.size / (double)this.buckets.length;
    }

    public Iterable<MultiKeyEntry<V>> entries() {
        return new EntryIterable();
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsValue(Object value) {
        for (MultiKeyEntry<V> entry : this.entries()) {
            if (!Objects.equals(entry.value, value)) continue;
            return true;
        }
        return false;
    }

    public V remove(Object ... keys) {
        if (keys == null) {
            return this.removeInternalDirect(null);
        }
        return this.removeInternal(keys);
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            return this.removeInternalDirect(null);
        }
        Class<?> keyClass = key.getClass();
        if (keyClass.isArray()) {
            return this.removeFromArray(key);
        }
        if (key instanceof Collection) {
            return this.removeFromCollection((Collection)key);
        }
        return this.removeInternalSingleKeyDirect(key);
    }

    private V removeFromCollection(Collection<?> collection) {
        switch (this.collectionKeyMode) {
            case MULTI_KEY_ONLY: {
                return this.removeFromCollectionMultiKeyOnly(collection);
            }
            case MULTI_KEY_FIRST: {
                return this.removeFromCollectionMultiKeyFirst(collection);
            }
            case COLLECTION_KEY_FIRST: {
                return this.removeFromCollectionKeyFirst(collection);
            }
        }
        throw new IllegalStateException("Unknown CollectionKeyMode: " + (Object)((Object)this.collectionKeyMode));
    }

    private V removeFromArray(Object array) {
        if (array instanceof Object[]) {
            return this.removeInternal((Object[])array);
        }
        return this.removeInternalFromTypedArray(array);
    }

    private V removeFromCollectionMultiKeyOnly(Collection<?> collection) {
        return this.removeInternalFromCollection(collection);
    }

    private V removeFromCollectionMultiKeyFirst(Collection<?> collection) {
        V result = this.removeInternalFromCollection(collection);
        if (result == null) {
            result = this.removeInternalDirect(collection);
        }
        return result;
    }

    private V removeFromCollectionKeyFirst(Collection<?> collection) {
        V result = this.removeInternalDirect(collection);
        if (result == null) {
            result = this.removeInternalFromCollection(collection);
        }
        return result;
    }

    private V removeInternalFromCollection(Collection<?> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        return this.removeInternal(collection.toArray());
    }

    private V removeInternalSingleKeyDirect(Object key) {
        return this.removeInternalDirect(key);
    }

    @Override
    public void putAll(Map<?, ? extends V> m) {
        for (Map.Entry<?, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(Object key, V value) {
        V existing = this.get(key);
        if (existing != null) {
            return existing;
        }
        int hash = this.computeKeyHash(key);
        ReentrantLock lock = this.getStripeLock(hash);
        lock.lock();
        try {
            existing = this.get(key);
            if (existing == null) {
                this.put(key, value);
                V v = null;
                return v;
            }
            V v = existing;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfAbsent(Object key, Function<? super Object, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction, "mappingFunction must not be null");
        V value = this.get(key);
        if (value != null) {
            return value;
        }
        int hash = this.computeKeyHash(key);
        ReentrantLock lock = this.getStripeLock(hash);
        lock.lock();
        try {
            V newValue;
            value = this.get(key);
            if (value == null && (newValue = mappingFunction.apply(key)) != null) {
                this.put(key, newValue);
                V v = newValue;
                return v;
            }
            V v = value;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfPresent(Object key, BiFunction<? super Object, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction, "remappingFunction must not be null");
        V oldValue = this.get(key);
        if (oldValue == null) {
            return null;
        }
        int hash = this.computeKeyHash(key);
        ReentrantLock lock = this.getStripeLock(hash);
        lock.lock();
        try {
            oldValue = this.get(key);
            if (oldValue == null) {
                V v = null;
                return v;
            }
            V newValue = remappingFunction.apply(key, oldValue);
            if (newValue != null) {
                this.put(key, newValue);
                V v = newValue;
                return v;
            }
            this.remove(key);
            V v = null;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V compute(Object key, BiFunction<? super Object, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction, "remappingFunction must not be null");
        int hash = this.computeKeyHash(key);
        ReentrantLock lock = this.getStripeLock(hash);
        lock.lock();
        try {
            boolean contains = this.containsKey(key);
            V oldValue = this.get(key);
            V newValue = remappingFunction.apply(key, oldValue);
            if (newValue == null) {
                if (contains) {
                    this.remove(key);
                }
                V v = null;
                return v;
            }
            this.put(key, newValue);
            V v = newValue;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        int hash = this.computeKeyHash(key);
        ReentrantLock lock = this.getStripeLock(hash);
        lock.lock();
        try {
            if (!this.containsKey(key)) {
                boolean bl = false;
                return bl;
            }
            V current = this.get(key);
            if (!Objects.equals(current, value)) {
                boolean bl = false;
                return bl;
            }
            this.remove(key);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(Object key, V value) {
        int hash = this.computeKeyHash(key);
        ReentrantLock lock = this.getStripeLock(hash);
        lock.lock();
        try {
            if (!this.containsKey(key)) {
                V v = null;
                return v;
            }
            V v = this.put(key, value);
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(Object key, V oldValue, V newValue) {
        int hash = this.computeKeyHash(key);
        ReentrantLock lock = this.getStripeLock(hash);
        lock.lock();
        try {
            if (!this.containsKey(key)) {
                boolean bl = false;
                return bl;
            }
            V current = this.get(key);
            if (!Objects.equals(current, oldValue)) {
                boolean bl = false;
                return bl;
            }
            this.put(key, newValue);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V merge(Object key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction, "remappingFunction must not be null");
        Objects.requireNonNull(value, "value must not be null");
        int hash = this.computeKeyHash(key);
        ReentrantLock lock = this.getStripeLock(hash);
        lock.lock();
        try {
            V newValue;
            V oldValue = this.get(key);
            V v = newValue = oldValue == null ? value : remappingFunction.apply(oldValue, value);
            if (newValue == null) {
                this.remove(key);
            } else {
                this.put(key, newValue);
            }
            V v2 = newValue;
            return v2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V removeInternal(Object[] keys) {
        int hash = MultiKeyMap.computeHash(keys);
        ReentrantLock lock = this.getStripeLock(hash);
        lock.lock();
        try {
            V v = this.removeInternalNoLock(keys);
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean containsKey(Object ... keys) {
        if (keys == null) {
            return this.containsKeyInternalDirect(null);
        }
        return this.getInternal(keys) != null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return this.containsKeyInternalDirect(null);
        }
        Class<?> keyClass = key.getClass();
        if (keyClass.isArray()) {
            return this.containsKeyFromArray(key);
        }
        if (key instanceof Collection) {
            return this.containsKeyFromCollection((Collection)key);
        }
        return this.containsKeyInternalDirect(key);
    }

    private boolean containsKeyInternal(Object[] keys) {
        int hash = MultiKeyMap.computeHash(keys);
        int bucketIndex = hash & this.buckets.length - 1;
        MultiKey[] chain = (MultiKey[])this.buckets[bucketIndex];
        if (chain == null) {
            return false;
        }
        for (MultiKey existing : chain) {
            if (existing.hash != hash || !MultiKeyMap.keysMatch(existing.keys, keys)) continue;
            return true;
        }
        return false;
    }

    private boolean containsKeyFromTypedArray(Object typedArray) {
        int length = Array.getLength(typedArray);
        Object[] keys = new Object[length];
        for (int i = 0; i < length; ++i) {
            keys[i] = Array.get(typedArray, i);
        }
        return this.containsKeyInternal(keys);
    }

    private boolean containsKeyFromArray(Object key) {
        if (key instanceof Object[]) {
            return this.containsKeyInternal((Object[])key);
        }
        return this.containsKeyFromTypedArray(key);
    }

    private boolean containsKeyFromCollection(Collection<?> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        if (this.collectionKeyMode == CollectionKeyMode.MULTI_KEY_ONLY) {
            return this.containsKeyFromCollectionAsMultiKey(collection);
        }
        if (this.collectionKeyMode == CollectionKeyMode.MULTI_KEY_FIRST) {
            return this.containsKeyFromCollectionMultiFirst(collection);
        }
        return this.containsKeyFromCollectionCollectionFirst(collection);
    }

    private boolean containsKeyFromCollectionAsMultiKey(Collection<?> collection) {
        int hash = MultiKeyMap.computeHashFromCollection(collection);
        int bucketIndex = hash & this.buckets.length - 1;
        MultiKey[] chain = (MultiKey[])this.buckets[bucketIndex];
        if (chain == null) {
            return false;
        }
        for (MultiKey entry : chain) {
            if (entry.hash != hash || !MultiKeyMap.keysMatch(entry.keys, collection)) continue;
            return true;
        }
        return false;
    }

    private boolean containsKeyFromCollectionMultiFirst(Collection<?> collection) {
        boolean found = this.containsKeyFromCollectionAsMultiKey(collection);
        if (found) {
            return true;
        }
        return this.containsKeyInternalDirect(collection);
    }

    private boolean containsKeyFromCollectionCollectionFirst(Collection<?> collection) {
        boolean found = this.containsKeyInternalDirect(collection);
        if (found) {
            return true;
        }
        return this.containsKeyFromCollectionAsMultiKey(collection);
    }

    @Override
    public void clear() {
        this.withAllStripeLocks(() -> {
            Arrays.fill(this.buckets, null);
            this.atomicSize.set(0);
            this.size = 0;
            this.maxChainLength = 0;
        });
    }

    @Override
    public Collection<V> values() {
        ArrayList values = new ArrayList();
        for (MultiKeyEntry<V> entry : this.entries()) {
            values.add(entry.value);
        }
        return values;
    }

    @Override
    public Set<Object> keySet() {
        HashSet<Object> keys = new HashSet<Object>();
        for (MultiKeyEntry<V> entry : this.entries()) {
            if (entry.keys.length == 1) {
                Object singleKey = entry.keys[0];
                Object originalKey = singleKey == NULL_SENTINEL ? null : singleKey;
                keys.add(originalKey);
                continue;
            }
            keys.add(entry.keys);
        }
        return keys;
    }

    @Override
    public Set<Map.Entry<Object, V>> entrySet() {
        HashSet<Map.Entry<Object, V>> entrySet = new HashSet<Map.Entry<Object, V>>();
        for (MultiKeyEntry<V> multiEntry : this.entries()) {
            Object singleKey;
            Object key = multiEntry.keys.length == 1 ? ((singleKey = multiEntry.keys[0]) == NULL_SENTINEL ? null : singleKey) : multiEntry.keys;
            entrySet.add(new AbstractMap.SimpleEntry((Object[])key, multiEntry.value));
        }
        return entrySet;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (MultiKeyEntry<V> entry : this.entries()) {
            Object singleKey;
            Object key = entry.keys.length == 1 ? ((singleKey = entry.keys[0]) == NULL_SENTINEL ? null : singleKey) : Integer.valueOf(Arrays.hashCode(entry.keys));
            int keyHash = key == null ? 0 : key.hashCode();
            int valueHash = entry.value == null ? 0 : entry.value.hashCode();
            hash += keyHash ^ valueHash;
        }
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        if (this.size() != other.size()) {
            return false;
        }
        try {
            for (MultiKeyEntry<V> entry : this.entries()) {
                Object singleKey;
                Object key = entry.keys.length == 1 ? ((singleKey = entry.keys[0]) == NULL_SENTINEL ? null : singleKey) : entry.keys;
                Object value = entry.value;
                if (!(value == null ? other.get(key) != null || !other.containsKey(key) : !value.equals(other.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException | NullPointerException e) {
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean first = true;
        for (MultiKeyEntry<V> entry : this.entries()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            if (entry.keys.length == 1) {
                Object singleKey = entry.keys[0];
                Object originalKey = singleKey == NULL_SENTINEL ? null : singleKey;
                this.appendSafeKey(sb, originalKey);
            } else {
                this.appendSafeMultiKey(sb, entry.keys);
            }
            sb.append('=');
            this.appendSafeValue(sb, entry.value);
        }
        return sb.append('}').toString();
    }

    private void appendSafeKey(StringBuilder sb, Object key) {
        if (key == this) {
            sb.append("(this Map)");
        } else {
            sb.append(key);
        }
    }

    private void appendSafeMultiKey(StringBuilder sb, Object[] keys) {
        sb.append('[');
        for (int i = 0; i < keys.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            if (keys[i] == this) {
                sb.append("(this Map)");
                continue;
            }
            sb.append(keys[i]);
        }
        sb.append(']');
    }

    private void appendSafeValue(StringBuilder sb, Object value) {
        if (value == this) {
            sb.append("(this Map)");
        } else {
            sb.append(value);
        }
    }

    private static int calculateOptimalStripeCount() {
        int cores = Runtime.getRuntime().availableProcessors();
        int targetStripes = Math.max(8, cores / 2);
        targetStripes = Math.min(32, targetStripes);
        return Integer.highestOneBit(targetStripes - 1) << 1;
    }

    public void printContentionStatistics() {
        int totalAcquisitions = this.totalLockAcquisitions.get();
        int totalContentions = this.contentionCount.get();
        int globalAcquisitions = this.globalLockAcquisitions.get();
        int globalContentions = this.globalLockContentions.get();
        LOG.info("=== MultiKeyMap Contention Statistics ===");
        LOG.info("Total lock acquisitions: " + totalAcquisitions);
        LOG.info("Total contentions: " + totalContentions);
        if (totalAcquisitions > 0) {
            double contentionRate = (double)totalContentions / (double)totalAcquisitions * 100.0;
            LOG.info(String.format("Overall contention rate: %.2f%%", contentionRate));
        }
        LOG.info("Global lock acquisitions: " + globalAcquisitions);
        LOG.info("Global lock contentions: " + globalContentions);
        LOG.info("Stripe-level statistics:");
        LOG.info("Stripe | Acquisitions | Contentions | Rate");
        LOG.info("-------|-------------|-------------|------");
        for (int i = 0; i < STRIPE_COUNT; ++i) {
            int acquisitions = this.stripeLockAcquisitions[i].get();
            int contentions = this.stripeLockContention[i].get();
            double rate = acquisitions > 0 ? (double)contentions / (double)acquisitions * 100.0 : 0.0;
            LOG.info(String.format("%6d | %11d | %11d | %5.2f%%", i, acquisitions, contentions, rate));
        }
        int maxContentionStripe = 0;
        int minContentionStripe = 0;
        int maxContentions = this.stripeLockContention[0].get();
        int minContentions = this.stripeLockContention[0].get();
        for (int i = 1; i < STRIPE_COUNT; ++i) {
            int contentions = this.stripeLockContention[i].get();
            if (contentions > maxContentions) {
                maxContentions = contentions;
                maxContentionStripe = i;
            }
            if (contentions >= minContentions) continue;
            minContentions = contentions;
            minContentionStripe = i;
        }
        LOG.info("Stripe distribution analysis:");
        LOG.info(String.format("Most contended stripe: %d (%d contentions)", maxContentionStripe, maxContentions));
        LOG.info(String.format("Least contended stripe: %d (%d contentions)", minContentionStripe, minContentions));
        int unusedStripes = 0;
        for (int i = 0; i < STRIPE_COUNT; ++i) {
            if (this.stripeLockAcquisitions[i].get() != 0) continue;
            ++unusedStripes;
        }
        LOG.info(String.format("Unused stripes: %d out of %d", unusedStripes, STRIPE_COUNT));
        LOG.info("================================================");
    }

    private int computeKeyHash(Object key) {
        return MultiKeyMap.computeHashForKey(key);
    }

    private void withAllStripeLocks(Runnable action) {
        this.lockAllStripes();
        try {
            action.run();
        }
        finally {
            this.unlockAllStripes();
        }
    }

    private void resize() {
        this.withAllStripeLocks(() -> {
            double currentLoadFactor = (double)this.size / (double)this.buckets.length;
            if (currentLoadFactor <= (double)this.loadFactor) {
                return;
            }
            Object[] oldBuckets = this.buckets;
            Object[] newBuckets = new Object[oldBuckets.length * 2];
            int newSize = 0;
            int newMaxChainLength = 0;
            for (Object bucket : oldBuckets) {
                MultiKey[] chain;
                if (bucket == null) continue;
                for (MultiKey entry : chain = (MultiKey[])bucket) {
                    int len = this.rehashEntry(entry, newBuckets);
                    ++newSize;
                    if (len <= newMaxChainLength) continue;
                    newMaxChainLength = len;
                }
            }
            this.buckets = newBuckets;
            this.atomicSize.set(newSize);
            this.size = newSize;
            this.maxChainLength = newMaxChainLength;
        });
    }

    private V removeInternalNoLock(Object[] keys) {
        int hash = MultiKeyMap.computeHash(keys);
        int bucketIndex = hash & this.buckets.length - 1;
        MultiKey[] chain = (MultiKey[])this.buckets[bucketIndex];
        if (chain == null) {
            return null;
        }
        for (int i = 0; i < chain.length; ++i) {
            int newSize;
            MultiKey entry = chain[i];
            if (entry.hash != hash || !MultiKeyMap.keysMatch(entry.keys, keys)) continue;
            if (chain.length == 1) {
                this.buckets[bucketIndex] = null;
            } else {
                MultiKey[] newChain = new MultiKey[chain.length - 1];
                System.arraycopy(chain, 0, newChain, 0, i);
                if (i < chain.length - 1) {
                    System.arraycopy(chain, i + 1, newChain, i, chain.length - i - 1);
                }
                this.buckets[bucketIndex] = newChain;
            }
            this.size = newSize = this.atomicSize.decrementAndGet();
            return entry.value;
        }
        return null;
    }

    static {
        LoggingConfig.init();
        STRIPE_CONFIG_LOGGED = new AtomicBoolean(false);
        STRIPE_COUNT = MultiKeyMap.calculateOptimalStripeCount();
        STRIPE_MASK = STRIPE_COUNT - 1;
        NULL_SENTINEL = new Object();
        NOT_FOUND_SENTINEL = new Object();
    }

    public static enum CollectionKeyMode {
        MULTI_KEY_ONLY,
        MULTI_KEY_FIRST,
        COLLECTION_KEY_FIRST;

    }

    private static final class MultiKey<V> {
        final Object keys;
        final int hash;
        final V value;

        MultiKey(Object singleKey, V value) {
            this.keys = singleKey == null ? NULL_SENTINEL : singleKey;
            this.hash = MultiKeyMap.computeSingleKeyHash(this.keys);
            this.value = value;
        }

        MultiKey(Object[] multiKeys, V value) {
            this.keys = multiKeys != null ? multiKeys.clone() : new Object[]{};
            this.hash = MultiKeyMap.computeHash(multiKeys);
            this.value = value;
        }
    }

    public static enum KeyMode {
        SINGLE_KEY;

    }

    private class EntryIterable
    implements Iterable<MultiKeyEntry<V>> {
        private EntryIterable() {
        }

        @Override
        public Iterator<MultiKeyEntry<V>> iterator() {
            return new EntryIterator();
        }
    }

    public static class MultiKeyEntry<V> {
        public final Object[] keys;
        public final V value;

        MultiKeyEntry(Object keys, V value) {
            this.keys = keys instanceof Object[] ? (Object[])((Object[])keys).clone() : new Object[]{keys};
            this.value = value;
        }
    }

    private class EntryIterator
    implements Iterator<MultiKeyEntry<V>> {
        private final Object[] bucketSnapshot;
        private int currentBucket = 0;
        private int currentChainIndex = 0;
        private MultiKeyEntry<V> nextEntry = null;

        EntryIterator() {
            this.bucketSnapshot = MultiKeyMap.this.buckets;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != null;
        }

        @Override
        public MultiKeyEntry<V> next() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            MultiKeyEntry result = this.nextEntry;
            this.advance();
            return result;
        }

        private void advance() {
            while (this.currentBucket < this.bucketSnapshot.length) {
                MultiKey[] chain = (MultiKey[])this.bucketSnapshot[this.currentBucket];
                if (chain != null && this.currentChainIndex < chain.length) {
                    MultiKey key = chain[this.currentChainIndex];
                    this.nextEntry = new MultiKeyEntry(key.keys, key.value);
                    ++this.currentChainIndex;
                    return;
                }
                ++this.currentBucket;
                this.currentChainIndex = 0;
            }
            this.nextEntry = null;
        }
    }
}

