/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

final class InsetsConversions {
    private InsetsConversions() {
    }

    static String toString(Object from, Converter converter) {
        Insets insets = (Insets)from;
        return "(" + insets.top + "," + insets.left + "," + insets.bottom + "," + insets.right + ")";
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        Insets insets = (Insets)from;
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        target.put("top", insets.top);
        target.put("left", insets.left);
        target.put("bottom", insets.bottom);
        target.put("right", insets.right);
        return target;
    }

    static int[] toIntArray(Object from, Converter converter) {
        Insets insets = (Insets)from;
        return new int[]{insets.top, insets.left, insets.bottom, insets.right};
    }

    static Long toLong(Object from, Converter converter) {
        Insets insets = (Insets)from;
        return (long)insets.top + (long)insets.left + (long)insets.bottom + (long)insets.right;
    }

    static Integer toInteger(Object from, Converter converter) {
        Insets insets = (Insets)from;
        return insets.top + insets.left + insets.bottom + insets.right;
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        Insets insets = (Insets)from;
        return BigInteger.valueOf((long)insets.top + (long)insets.left + (long)insets.bottom + (long)insets.right);
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        Insets insets = (Insets)from;
        return BigDecimal.valueOf((long)insets.top + (long)insets.left + (long)insets.bottom + (long)insets.right);
    }

    static Boolean toBoolean(Object from, Converter converter) {
        Insets insets = (Insets)from;
        return insets.top != 0 || insets.left != 0 || insets.bottom != 0 || insets.right != 0;
    }

    static AtomicBoolean toAtomicBoolean(Object from, Converter converter) {
        return new AtomicBoolean(InsetsConversions.toBoolean(from, converter));
    }

    static Point toPoint(Object from, Converter converter) {
        Insets insets = (Insets)from;
        return new Point(insets.top, insets.left);
    }

    static Dimension toDimension(Object from, Converter converter) {
        Insets insets = (Insets)from;
        return new Dimension(insets.left + insets.right, insets.top + insets.bottom);
    }

    static Rectangle toRectangle(Object from, Converter converter) {
        Insets insets = (Insets)from;
        int width = Math.max(0, insets.right - insets.left);
        int height = Math.max(0, insets.bottom - insets.top);
        return new Rectangle(insets.left, insets.top, width, height);
    }
}

