/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public class ClassValueMap<V>
extends AbstractMap<Class<?>, V>
implements ConcurrentMap<Class<?>, V> {
    private static final Object NO_VALUE = new Object();
    private static final Object NULL_VALUE = new Object();
    private final ConcurrentHashMap<Class<?>, Object> backingMap = new ConcurrentHashMap();
    private final AtomicReference<V> nullKeyValue = new AtomicReference();
    private volatile boolean hasNullKeyMapping = false;
    private final ClassValue<Object> cache = new ClassValue<Object>(){

        @Override
        protected Object computeValue(Class<?> key) {
            Object result = ClassValueMap.this.backingMap.get(key);
            if (result == null) {
                return NO_VALUE;
            }
            return result == NULL_VALUE ? null : result;
        }
    };

    private Object maskNull(V value) {
        return value == null ? NULL_VALUE : value;
    }

    private V unmaskNull(Object value) {
        return (V)(value == NULL_VALUE ? null : value);
    }

    public ClassValueMap() {
    }

    public ClassValueMap(Map<? extends Class<?>, ? extends V> map) {
        if (map == null) {
            throw new NullPointerException("Map cannot be null");
        }
        for (Map.Entry<Class<?>, V> entry : map.entrySet()) {
            Class<?> key = entry.getKey();
            if (key == null) {
                this.nullKeyValue.set(entry.getValue());
                this.hasNullKeyMapping = true;
                continue;
            }
            this.backingMap.put(key, this.maskNull(entry.getValue()));
        }
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return this.nullKeyValue.get();
        }
        if (key.getClass() == Class.class) {
            Object value = this.cache.get((Class)key);
            return (V)(value == NO_VALUE ? null : value);
        }
        return null;
    }

    @Override
    public V put(Class<?> key, V value) {
        if (key == null) {
            V old = this.nullKeyValue.getAndSet(value);
            this.hasNullKeyMapping = true;
            return old;
        }
        Object old = this.backingMap.put(key, this.maskNull(value));
        this.cache.remove(key);
        return this.unmaskNull(old);
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            V old = this.nullKeyValue.getAndSet(null);
            this.hasNullKeyMapping = false;
            return old;
        }
        if (key.getClass() != Class.class) {
            return null;
        }
        Class clazz = (Class)key;
        Object old = this.backingMap.remove(clazz);
        if (old != null) {
            this.cache.remove(clazz);
        }
        return this.unmaskNull(old);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return this.hasNullKeyMapping;
        }
        if (key.getClass() != Class.class) {
            return false;
        }
        return this.cache.get((Class)key) != NO_VALUE;
    }

    @Override
    public void clear() {
        for (Class key : this.backingMap.keySet()) {
            this.cache.remove(key);
        }
        this.backingMap.clear();
        this.nullKeyValue.set(null);
        this.hasNullKeyMapping = false;
    }

    @Override
    public int size() {
        return this.backingMap.size() + (this.hasNullKeyMapping ? 1 : 0);
    }

    @Override
    public Set<Map.Entry<Class<?>, V>> entrySet() {
        return new AbstractSet<Map.Entry<Class<?>, V>>(){

            @Override
            public Iterator<Map.Entry<Class<?>, V>> iterator() {
                final Iterator backingIterator = ClassValueMap.this.backingMap.entrySet().iterator();
                final boolean hasNullEntry = ClassValueMap.this.hasNullKeyMapping;
                final Object nullValue = hasNullEntry ? ClassValueMap.this.nullKeyValue.get() : null;
                return new Iterator<Map.Entry<Class<?>, V>>(){
                    private boolean nullEntryReturned;
                    {
                        this.nullEntryReturned = !hasNullEntry;
                    }

                    @Override
                    public boolean hasNext() {
                        return !this.nullEntryReturned || backingIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<Class<?>, V> next() {
                        if (!this.nullEntryReturned) {
                            this.nullEntryReturned = true;
                            return new AbstractMap.SimpleImmutableEntry<Object, Object>(null, nullValue);
                        }
                        Map.Entry entry = (Map.Entry)backingIterator.next();
                        return new AbstractMap.SimpleImmutableEntry<Class, Object>((Class)entry.getKey(), ClassValueMap.this.unmaskNull(entry.getValue()));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Removal not supported via iterator.");
                    }
                };
            }

            @Override
            public int size() {
                return ClassValueMap.this.size();
            }
        };
    }

    @Override
    public V putIfAbsent(Class<?> key, V value) {
        if (key == null) {
            if (this.hasNullKeyMapping) {
                return this.nullKeyValue.get();
            }
            if (this.nullKeyValue.compareAndSet(null, value)) {
                this.hasNullKeyMapping = true;
                return null;
            }
            return this.nullKeyValue.get();
        }
        Object prev = this.backingMap.putIfAbsent(key, this.maskNull(value));
        if (prev == null) {
            this.cache.remove(key);
        }
        return this.unmaskNull(prev);
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (key == null) {
            if (this.nullKeyValue.compareAndSet(value, null)) {
                this.hasNullKeyMapping = false;
                return true;
            }
            return false;
        }
        if (key.getClass() != Class.class) {
            return false;
        }
        boolean removed = this.backingMap.remove(key, this.maskNull(value));
        if (removed) {
            this.cache.remove((Class)key);
        }
        return removed;
    }

    @Override
    public boolean replace(Class<?> key, V oldValue, V newValue) {
        if (key == null) {
            return this.nullKeyValue.compareAndSet(oldValue, newValue);
        }
        boolean replaced = this.backingMap.replace(key, this.maskNull(oldValue), this.maskNull(newValue));
        if (replaced) {
            this.cache.remove(key);
        }
        return replaced;
    }

    @Override
    public V replace(Class<?> key, V value) {
        if (key == null) {
            if (!this.hasNullKeyMapping) {
                return null;
            }
            return this.nullKeyValue.getAndSet(value);
        }
        Object replaced = this.backingMap.replace(key, this.maskNull(value));
        if (replaced != null) {
            this.cache.remove(key);
        }
        return this.unmaskNull(replaced);
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                final Iterator backingIterator = ClassValueMap.this.backingMap.values().iterator();
                final boolean hasNullEntry = ClassValueMap.this.hasNullKeyMapping;
                final Object nullValue = hasNullEntry ? ClassValueMap.this.nullKeyValue.get() : null;
                return new Iterator<V>(){
                    private boolean nullReturned;
                    {
                        this.nullReturned = !hasNullEntry;
                    }

                    @Override
                    public boolean hasNext() {
                        return !this.nullReturned || backingIterator.hasNext();
                    }

                    @Override
                    public V next() {
                        if (!this.nullReturned) {
                            this.nullReturned = true;
                            return nullValue;
                        }
                        return ClassValueMap.this.unmaskNull(backingIterator.next());
                    }
                };
            }

            @Override
            public int size() {
                return ClassValueMap.this.size();
            }

            @Override
            public boolean contains(Object o) {
                if (ClassValueMap.this.hasNullKeyMapping && Objects.equals(ClassValueMap.this.nullKeyValue.get(), o)) {
                    return true;
                }
                return ClassValueMap.this.backingMap.containsValue(o == null ? NULL_VALUE : o);
            }
        };
    }

    public Map<Class<?>, V> unmodifiableView() {
        final ClassValueMap thisMap = this;
        return new AbstractMap<Class<?>, V>(){

            @Override
            public Set<Map.Entry<Class<?>, V>> entrySet() {
                return Collections.unmodifiableSet(thisMap.entrySet());
            }

            @Override
            public V get(Object key) {
                return thisMap.get(key);
            }

            @Override
            public boolean containsKey(Object key) {
                return thisMap.containsKey(key);
            }

            @Override
            public Set<Class<?>> keySet() {
                return Collections.unmodifiableSet(thisMap.keySet());
            }

            @Override
            public Collection<V> values() {
                return Collections.unmodifiableCollection(thisMap.values());
            }

            @Override
            public int size() {
                return thisMap.size();
            }

            @Override
            public V put(Class<?> key, V value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public V remove(Object key) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void putAll(Map<? extends Class<?>, ? extends V> m) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

