/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.cache;

import com.cedarsoftware.util.ConcurrentHashMapNullSafe;
import com.cedarsoftware.util.ConcurrentSet;
import com.cedarsoftware.util.MapUtilities;
import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

public class ThreadedLRUCacheStrategy<K, V>
implements Map<K, V>,
Closeable {
    private static final int DEFAULT_CLEANUP_INTERVAL_MS = 500;
    private static final int SAMPLE_SIZE = 15;
    private static final double SOFT_CAP_RATIO = 1.5;
    private static final double HARD_CAP_RATIO = 2.0;
    private final int capacity;
    private final int softCap;
    private final int hardCap;
    private final ConcurrentMap<K, Node<K, V>> cache;
    private final WeakReference<ThreadedLRUCacheStrategy<K, V>> selfRef;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean cleanupInProgress = new AtomicBoolean(false);
    private static final Set<WeakReference<ThreadedLRUCacheStrategy<?, ?>>> ALL_CACHES = ConcurrentHashMap.newKeySet();
    private static volatile ScheduledExecutorService scheduler;
    private static volatile ScheduledFuture<?> cleanupTask;
    private static final Object schedulerLock;

    private static ScheduledExecutorService createScheduler() {
        return Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r, "LRUCache-Cleanup-Thread");
            thread.setDaemon(true);
            return thread;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureSchedulerRunning() {
        if (scheduler == null || scheduler.isShutdown() || scheduler.isTerminated()) {
            Object object = schedulerLock;
            synchronized (object) {
                if (scheduler == null || scheduler.isShutdown() || scheduler.isTerminated()) {
                    scheduler = ThreadedLRUCacheStrategy.createScheduler();
                    cleanupTask = scheduler.scheduleAtFixedRate(ThreadedLRUCacheStrategy::cleanupAllCaches, 500L, 500L, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    public ThreadedLRUCacheStrategy(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity must be at least 1.");
        }
        this.capacity = capacity;
        this.softCap = (int)((double)capacity * 1.5);
        this.hardCap = (int)((double)capacity * 2.0);
        this.cache = new ConcurrentHashMapNullSafe<K, Node<K, V>>(capacity);
        ThreadedLRUCacheStrategy.ensureSchedulerRunning();
        WeakReference<ThreadedLRUCacheStrategy<K, V>> ref = this.selfRef = new WeakReference<ThreadedLRUCacheStrategy>(this);
        ALL_CACHES.add(ref);
    }

    @Deprecated
    public ThreadedLRUCacheStrategy(int capacity, int cleanupDelayMillis) {
        this(capacity);
    }

    private static void cleanupAllCaches() {
        try {
            Iterator<WeakReference<ThreadedLRUCacheStrategy<?, ?>>> iter = ALL_CACHES.iterator();
            while (iter.hasNext()) {
                WeakReference<ThreadedLRUCacheStrategy<?, ?>> ref = iter.next();
                ThreadedLRUCacheStrategy cache = (ThreadedLRUCacheStrategy)ref.get();
                if (cache == null) {
                    iter.remove();
                    continue;
                }
                if (cache.closed.get()) continue;
                try {
                    cache.backgroundCleanup();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void backgroundCleanup() {
        if (!this.cleanupInProgress.compareAndSet(false, true)) {
            return;
        }
        try {
            int size = this.cache.size();
            if (size <= this.capacity) {
                return;
            }
            while (this.cache.size() > this.capacity && this.evictOldestUsingSample()) {
            }
        }
        finally {
            this.cleanupInProgress.set(false);
        }
    }

    private boolean evictOldestUsingSample() {
        Node oldest = null;
        long oldestTime = Long.MAX_VALUE;
        int sampled = 0;
        for (Node node : this.cache.values()) {
            if (node.timestamp < oldestTime) {
                oldest = node;
                oldestTime = node.timestamp;
            }
            if (++sampled < 15) continue;
            break;
        }
        if (oldest != null) {
            return this.cache.remove(oldest.key, oldest);
        }
        return false;
    }

    public void shutdown() {
        this.close();
    }

    public void forceCleanup() {
        this.backgroundCleanup();
    }

    static int getRegisteredCacheCount() {
        return ALL_CACHES.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shutdownScheduler() {
        Object object = schedulerLock;
        synchronized (object) {
            if (scheduler == null || scheduler.isShutdown()) {
                return true;
            }
            if (cleanupTask != null) {
                cleanupTask.cancel(false);
                cleanupTask = null;
            }
            scheduler.shutdown();
            try {
                boolean terminated = scheduler.awaitTermination(5L, TimeUnit.SECONDS);
                if (!terminated) {
                    scheduler.shutdownNow();
                    terminated = scheduler.awaitTermination(1L, TimeUnit.SECONDS);
                }
                return terminated;
            }
            catch (InterruptedException e) {
                scheduler.shutdownNow();
                Thread.currentThread().interrupt();
                return false;
            }
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            WeakReference<ThreadedLRUCacheStrategy<K, V>> ref = this.selfRef;
            ALL_CACHES.remove(ref);
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public V get(Object key) {
        Node node = (Node)this.cache.get(key);
        if (node != null) {
            node.updateTimestamp();
            return node.value;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        Node<K, V> newNode = new Node<K, V>(key, value);
        Node<K, V> oldNode = this.cache.put(key, newNode);
        if (oldNode != null) {
            newNode.updateTimestamp();
            return oldNode.value;
        }
        int size = this.cache.size();
        if (size >= this.hardCap) {
            while (this.cache.size() >= this.hardCap && this.evictOldestUsingSample()) {
            }
        } else if (size > this.softCap) {
            double probability = (double)(size - this.softCap) / (double)(this.hardCap - this.softCap);
            if (ThreadLocalRandom.current().nextDouble() < probability) {
                this.evictOldestUsingSample();
            }
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public V remove(Object key) {
        Node node = (Node)this.cache.remove(key);
        if (node != null) {
            return node.value;
        }
        return null;
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Node node = this.cache.computeIfAbsent(key, k -> {
            Object value = mappingFunction.apply((Object)key);
            return value != null ? new Node(key, value) : null;
        });
        if (node != null) {
            node.updateTimestamp();
            int size = this.cache.size();
            if (size >= this.hardCap) {
                while (this.cache.size() >= this.hardCap && this.evictOldestUsingSample()) {
                }
            } else if (size > this.softCap) {
                double probability = (double)(size - this.softCap) / (double)(this.hardCap - this.softCap);
                if (ThreadLocalRandom.current().nextDouble() < probability) {
                    this.evictOldestUsingSample();
                }
            }
            return node.value;
        }
        return null;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Node<K, V> newNode = new Node<K, V>(key, value);
        Node<K, V> oldNode = this.cache.putIfAbsent(key, newNode);
        if (oldNode != null) {
            oldNode.updateTimestamp();
            return oldNode.value;
        }
        int size = this.cache.size();
        if (size >= this.hardCap) {
            while (this.cache.size() >= this.hardCap && this.evictOldestUsingSample()) {
            }
        } else if (size > this.softCap) {
            double probability = (double)(size - this.softCap) / (double)(this.hardCap - this.softCap);
            if (ThreadLocalRandom.current().nextDouble() < probability) {
                this.evictOldestUsingSample();
            }
        }
        return null;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Node node : this.cache.values()) {
            if (!Objects.equals(node.value, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        ConcurrentSet entrySet = new ConcurrentSet();
        for (Node node : this.cache.values()) {
            entrySet.add(new AbstractMap.SimpleEntry(node.key, node.value));
        }
        return Collections.unmodifiableSet(entrySet);
    }

    @Override
    public Set<K> keySet() {
        ConcurrentSet keySet = new ConcurrentSet();
        for (Node node : this.cache.values()) {
            keySet.add(node.key);
        }
        return Collections.unmodifiableSet(keySet);
    }

    @Override
    public Collection<V> values() {
        ArrayList values = new ArrayList();
        for (Node node : this.cache.values()) {
            values.add(node.value);
        }
        return Collections.unmodifiableCollection(values);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map other = (Map)o;
        return this.entrySet().equals(other.entrySet());
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (Node node : this.cache.values()) {
            Object key = node.key;
            Object value = node.value;
            hashCode = 31 * hashCode + (key == null ? 0 : key.hashCode());
            hashCode = 31 * hashCode + (value == null ? 0 : value.hashCode());
        }
        return hashCode;
    }

    public String toString() {
        return MapUtilities.mapToString(this);
    }

    static {
        schedulerLock = new Object();
        ThreadedLRUCacheStrategy.ensureSchedulerRunning();
    }

    private static class Node<K, V> {
        final K key;
        volatile V value;
        volatile long timestamp;

        Node(K key, V value) {
            this.key = key;
            this.value = value;
            this.timestamp = System.nanoTime();
        }

        void updateTimestamp() {
            this.timestamp = System.nanoTime();
        }
    }
}

