/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ExceptionUtilities;
import java.io.IOException;
import java.io.Writer;

public class FastWriter
extends Writer {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private Writer out;
    private char[] cb;
    private int nextChar;

    public FastWriter(Writer out) {
        this(out, 8192);
    }

    public FastWriter(Writer out, int bufferSize) {
        super((Object)out);
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.out = out;
        this.cb = new char[bufferSize];
        this.nextChar = 0;
    }

    private void flushBuffer() {
        if (this.nextChar == 0) {
            return;
        }
        try {
            this.out.write(this.cb, 0, this.nextChar);
        }
        catch (IOException e) {
            ExceptionUtilities.uncheckedThrow(e);
        }
        this.nextChar = 0;
    }

    @Override
    public void write(int c) {
        if (this.out == null) {
            ExceptionUtilities.uncheckedThrow(new IOException("FastWriter stream is closed"));
        }
        if (this.nextChar + 1 >= this.cb.length) {
            this.flushBuffer();
        }
        this.cb[this.nextChar++] = (char)c;
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (this.out == null) {
            ExceptionUtilities.uncheckedThrow(new IOException("FastWriter stream is closed"));
        }
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (len >= this.cb.length) {
            this.flushBuffer();
            try {
                this.out.write(cbuf, off, len);
            }
            catch (IOException e) {
                ExceptionUtilities.uncheckedThrow(e);
            }
            return;
        }
        if (len > this.cb.length - this.nextChar) {
            this.flushBuffer();
        }
        System.arraycopy(cbuf, off, this.cb, this.nextChar, len);
        this.nextChar += len;
    }

    @Override
    public void write(String str, int off, int len) {
        if (this.out == null) {
            ExceptionUtilities.uncheckedThrow(new IOException("FastWriter stream is closed"));
        }
        if (len == 0) {
            return;
        }
        if (this.nextChar + len <= this.cb.length) {
            str.getChars(off, off + len, this.cb, this.nextChar);
            this.nextChar += len;
            if (this.nextChar == this.cb.length) {
                this.flushBuffer();
            }
            return;
        }
        int available = this.cb.length - this.nextChar;
        if (available > 0) {
            str.getChars(off, off + available, this.cb, this.nextChar);
            off += available;
            len -= available;
            this.nextChar = this.cb.length;
            this.flushBuffer();
        }
        try {
            while (len >= this.cb.length) {
                str.getChars(off, off + this.cb.length, this.cb, 0);
                off += this.cb.length;
                len -= this.cb.length;
                this.out.write(this.cb, 0, this.cb.length);
            }
        }
        catch (IOException e) {
            ExceptionUtilities.uncheckedThrow(e);
        }
        if (len > 0) {
            str.getChars(off, off + len, this.cb, 0);
            this.nextChar = len;
        }
    }

    @Override
    public void flush() {
        this.flushBuffer();
        try {
            this.out.flush();
        }
        catch (IOException e) {
            ExceptionUtilities.uncheckedThrow(e);
        }
    }

    @Override
    public void close() {
        if (this.out == null) {
            return;
        }
        try {
            this.flushBuffer();
        }
        finally {
            try {
                this.out.close();
            }
            catch (IOException e) {
                ExceptionUtilities.uncheckedThrow(e);
            }
            this.out = null;
            this.cb = null;
        }
    }
}

