/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.ClassValueMap;
import com.cedarsoftware.util.ClassValueSet;
import com.cedarsoftware.util.CollectionUtilities;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.Converter;
import com.cedarsoftware.util.ExceptionUtilities;
import com.cedarsoftware.util.IdentitySet;
import com.cedarsoftware.util.LoggingConfig;
import com.cedarsoftware.util.ReflectionUtils;
import com.cedarsoftware.util.StringUtilities;
import com.cedarsoftware.util.Unsafe;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.PriorityQueue;
import java.util.Properties;
import java.util.Queue;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.StringJoiner;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class ClassUtilities {
    private static final Logger LOG = Logger.getLogger(ClassUtilities.class.getName());
    private static final Map<ClassLoader, LoaderCache> NAME_CACHE;
    private static final Map<String, Class<?>> GLOBAL_ALIASES;
    private static final Map<String, Class<?>> BUILTIN_ALIASES;
    private static final Map<String, Class<?>> USER_ALIASES;
    private static final Map<Class<?>, Class<?>> wrapperMap;
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER;
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE;
    private static final Map<Class<?>, Map<Class<?>, Integer>> PRIMITIVE_WIDENING_DISTANCES;
    private static final Map<Class<?>, ClassLoader> osgiClassLoaders;
    private static final ClassLoader SYSTEM_LOADER;
    private static final ThreadLocal<Integer> unsafeDepth;
    private static volatile Unsafe unsafe;
    private static final int DEFAULT_MAX_CLASS_LOAD_DEPTH = 100;
    private static final int DEFAULT_MAX_CONSTRUCTOR_ARGS = 50;
    private static final int DEFAULT_MAX_RESOURCE_NAME_LENGTH = 1000;
    private static final ThreadLocal<Integer> CLASS_LOAD_DEPTH;
    private static boolean ENHANCED_SECURITY_ENABLED;
    private static int MAX_CLASS_LOAD_DEPTH;
    private static int MAX_CONSTRUCTOR_ARGS;
    private static int MAX_RESOURCE_NAME_LENGTH;
    private static final Map<Class<?>, Supplier<Object>> DIRECT_CLASS_MAPPING;
    private static final Map<Class<?>, Supplier<Object>> ASSIGNABLE_CLASS_MAPPING;
    private static final Map<Class<?>, Optional<Supplier<Object>>> ASSIGNABLE_TYPE_CACHE;
    private static final ClassValue<Class<?>> ENUM_CLASS_CACHE;
    private static final Map<Class<?>, Constructor<?>> SUCCESSFUL_CONSTRUCTOR_CACHE;
    private static final Map<Class<?>, ClassHierarchyInfo> CLASS_HIERARCHY_CACHE;
    private static final int BUFFER_SIZE = 65536;
    private static final Pattern ARG_PATTERN;
    private static final Map<AccessibleObject, Boolean> accessibilityCache;
    private static final Class<?> INACCESSIBLE_OBJECT_EXCEPTION_CLASS;
    private static final ClassValueSet BLOCKED_CLASSES;
    private static final Set<String> BLOCKED_CLASS_NAMES_SET;
    private static final ClassValueSet INHERITS_FROM_BLOCKED;
    private static final ClassValueSet VERIFIED_SAFE_CLASSES;
    private static final ClassValue<Boolean> SECURITY_CHECK_CACHE;

    private ClassUtilities() {
    }

    private static ClassLoader resolveLoader(ClassLoader cl) {
        return cl != null ? cl : ClassUtilities.getClassLoader(ClassUtilities.class);
    }

    private static Class<?> fromCache(String name, ClassLoader cl) {
        Class cls;
        Class<?> globalAlias = GLOBAL_ALIASES.get(name);
        if (globalAlias != null) {
            return globalAlias;
        }
        ClassLoader key = ClassUtilities.resolveLoader(cl);
        LoaderCache holder = NAME_CACHE.get(key);
        if (holder == null) {
            return null;
        }
        ClassUtilities.drainQueue(holder);
        WeakReference ref = (WeakReference)holder.cache.get(name);
        Class clazz = cls = ref == null ? null : (Class)ref.get();
        if (ref != null && cls == null) {
            holder.cache.remove(name, ref);
        }
        return cls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LoaderCache getLoaderCacheHolder(ClassLoader key) {
        Map<ClassLoader, LoaderCache> map = NAME_CACHE;
        synchronized (map) {
            LoaderCache holder = NAME_CACHE.get(key);
            if (holder == null) {
                holder = new LoaderCache();
                NAME_CACHE.put(key, holder);
            }
            return holder;
        }
    }

    private static void toCache(String name, ClassLoader cl, Class<?> c) {
        ClassLoader key = ClassUtilities.resolveLoader(cl);
        LoaderCache holder = ClassUtilities.getLoaderCacheHolder(key);
        ClassUtilities.drainQueue(holder);
        holder.cache.put(name, new NamedWeakRef(name, c, holder.queue));
    }

    private static void drainQueue(LoaderCache holder) {
        Reference<Class<?>> ref;
        while ((ref = holder.queue.poll()) != null) {
            if (!(ref instanceof NamedWeakRef)) continue;
            NamedWeakRef namedRef = (NamedWeakRef)ref;
            holder.cache.remove(namedRef.name, namedRef);
        }
    }

    static void reinitializeSecuritySettings() {
        ENHANCED_SECURITY_ENABLED = "true".equalsIgnoreCase(System.getProperty("classutilities.enhanced.security.enabled"));
        if (ENHANCED_SECURITY_ENABLED) {
            MAX_CLASS_LOAD_DEPTH = ClassUtilities.getIntProperty("classutilities.max.class.load.depth", 100, 0);
            MAX_CONSTRUCTOR_ARGS = ClassUtilities.getIntProperty("classutilities.max.constructor.args", 50, 0);
            MAX_RESOURCE_NAME_LENGTH = ClassUtilities.getIntProperty("classutilities.max.resource.name.length", 1000, 100);
        } else {
            MAX_CLASS_LOAD_DEPTH = 0;
            MAX_CONSTRUCTOR_ARGS = 0;
            MAX_RESOURCE_NAME_LENGTH = 1000;
        }
    }

    private static int getIntProperty(String key, int defaultValue, int minValue) {
        String prop = System.getProperty(key);
        if (prop != null) {
            try {
                return Math.max(minValue, Integer.parseInt(prop));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Class<?> getPrimitiveFromWrapper(Class<?> toType) {
        if (toType == null) {
            throw new IllegalArgumentException("toType cannot be null");
        }
        return WRAPPER_TO_PRIMITIVE.get(toType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPermanentClassAlias(Class<?> clazz, String alias) {
        SecurityChecker.verifyClass(clazz);
        USER_ALIASES.put(alias, clazz);
        GLOBAL_ALIASES.put(alias, clazz);
        Map<ClassLoader, LoaderCache> map = NAME_CACHE;
        synchronized (map) {
            Iterator<LoaderCache> iterator = NAME_CACHE.values().iterator();
            while (iterator.hasNext()) {
                LoaderCache holder;
                LoaderCache loaderCache = holder = iterator.next();
                synchronized (loaderCache) {
                    holder.cache.remove(alias);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePermanentClassAlias(String alias) {
        USER_ALIASES.remove(alias);
        if (BUILTIN_ALIASES.containsKey(alias)) {
            GLOBAL_ALIASES.put(alias, BUILTIN_ALIASES.get(alias));
        } else {
            GLOBAL_ALIASES.remove(alias);
        }
        Map<ClassLoader, LoaderCache> map = NAME_CACHE;
        synchronized (map) {
            Iterator<LoaderCache> iterator = NAME_CACHE.values().iterator();
            while (iterator.hasNext()) {
                LoaderCache holder;
                LoaderCache loaderCache = holder = iterator.next();
                synchronized (loaderCache) {
                    holder.cache.remove(alias);
                }
            }
        }
    }

    public static int computeInheritanceDistance(Class<?> source, Class<?> destination) {
        if (source == null || destination == null) {
            return -1;
        }
        if (source.equals(destination)) {
            return 0;
        }
        boolean sp = ClassUtilities.isPrimitive(source);
        boolean dp = ClassUtilities.isPrimitive(destination);
        if (sp && dp) {
            Class<?> destPrim;
            Class<?> sourcePrim = source.isPrimitive() ? source : WRAPPER_TO_PRIMITIVE.get(source);
            Class<?> clazz = destPrim = destination.isPrimitive() ? destination : WRAPPER_TO_PRIMITIVE.get(destination);
            if (sourcePrim != null && destPrim != null) {
                return ClassUtilities.getPrimitiveWideningDistance(sourcePrim, destPrim);
            }
            return -1;
        }
        if (sp && !dp) {
            Class<?> src;
            Class<?> clazz = src = source.isPrimitive() ? PRIMITIVE_TO_WRAPPER.get(source) : source;
            if (src != null) {
                return ClassUtilities.getClassHierarchyInfo(src).getDistance(destination);
            }
            return -1;
        }
        return ClassUtilities.getClassHierarchyInfo(source).getDistance(destination);
    }

    private static int getPrimitiveWideningDistance(Class<?> sourcePrimitive, Class<?> destPrimitive) {
        Integer distance;
        if (sourcePrimitive.equals(destPrimitive)) {
            return 0;
        }
        Map<Class<?>, Integer> wideningMap = PRIMITIVE_WIDENING_DISTANCES.get(sourcePrimitive);
        if (wideningMap != null && (distance = wideningMap.get(destPrimitive)) != null) {
            return distance;
        }
        return -1;
    }

    public static boolean isPrimitive(Class<?> c) {
        return c.isPrimitive() || WRAPPER_TO_PRIMITIVE.containsKey(c);
    }

    public static Class<?> forName(String name, ClassLoader classLoader) {
        if (StringUtilities.isEmpty(name)) {
            return null;
        }
        try {
            return ClassUtilities.internalClassForName(name, classLoader);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> internalClassForName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> c = ClassUtilities.fromCache(name, classLoader);
        if (c != null) {
            return c;
        }
        if (SecurityChecker.isSecurityBlockedName(name)) {
            throw new SecurityException("For security reasons, cannot load: " + name);
        }
        if (ENHANCED_SECURITY_ENABLED) {
            int currentDepth = CLASS_LOAD_DEPTH.get();
            int nextDepth = currentDepth + 1;
            if (nextDepth > MAX_CLASS_LOAD_DEPTH && MAX_CLASS_LOAD_DEPTH > 0) {
                throw new SecurityException("Class loading depth exceeded limit: " + nextDepth + " > " + MAX_CLASS_LOAD_DEPTH);
            }
            try {
                CLASS_LOAD_DEPTH.set(nextDepth);
                c = ClassUtilities.loadClass(name, classLoader);
            }
            finally {
                CLASS_LOAD_DEPTH.set(currentDepth);
            }
        } else {
            c = ClassUtilities.loadClass(name, classLoader);
        }
        SecurityChecker.verifyClass(c);
        ClassUtilities.toCache(name, classLoader, c);
        return c;
    }

    private static Class<?> loadClass(String name, ClassLoader classLoader) throws ClassNotFoundException {
        if (name.endsWith("]")) {
            Class<Comparable<Boolean>> element;
            int dims = 0;
            String base = name;
            while (base.endsWith("[]")) {
                ++dims;
                base = base.substring(0, base.length() - 2);
            }
            switch (base) {
                case "boolean": {
                    element = Boolean.TYPE;
                    break;
                }
                case "byte": {
                    element = Byte.TYPE;
                    break;
                }
                case "short": {
                    element = Short.TYPE;
                    break;
                }
                case "int": {
                    element = Integer.TYPE;
                    break;
                }
                case "long": {
                    element = Long.TYPE;
                    break;
                }
                case "char": {
                    element = Character.TYPE;
                    break;
                }
                case "float": {
                    element = Float.TYPE;
                    break;
                }
                case "double": {
                    element = Double.TYPE;
                    break;
                }
                default: {
                    element = classLoader != null ? classLoader.loadClass(base) : Class.forName(base, false, ClassUtilities.getClassLoader(ClassUtilities.class));
                }
            }
            Class<Comparable<Boolean>> arrayClass = element;
            for (int i = 0; i < dims; ++i) {
                arrayClass = Array.newInstance(arrayClass, 0).getClass();
            }
            return arrayClass;
        }
        if (name.startsWith("[")) {
            Class<Comparable<Byte>> element;
            int dims;
            for (dims = 0; dims < name.length() && name.charAt(dims) == '['; ++dims) {
            }
            if (dims >= name.length()) {
                throw new ClassNotFoundException("Bad descriptor: " + name);
            }
            char typeChar = name.charAt(dims);
            switch (typeChar) {
                case 'B': {
                    element = Byte.TYPE;
                    break;
                }
                case 'S': {
                    element = Short.TYPE;
                    break;
                }
                case 'I': {
                    element = Integer.TYPE;
                    break;
                }
                case 'J': {
                    element = Long.TYPE;
                    break;
                }
                case 'F': {
                    element = Float.TYPE;
                    break;
                }
                case 'D': {
                    element = Double.TYPE;
                    break;
                }
                case 'Z': {
                    element = Boolean.TYPE;
                    break;
                }
                case 'C': {
                    element = Character.TYPE;
                    break;
                }
                case 'L': {
                    if (!name.endsWith(";") || name.length() <= dims + 2) {
                        throw new ClassNotFoundException("Bad descriptor: " + name);
                    }
                    String className = name.substring(dims + 1, name.length() - 1).replace('/', '.');
                    if (classLoader != null) {
                        element = classLoader.loadClass(className);
                        break;
                    }
                    ClassLoader cl = ClassUtilities.getClassLoader(ClassUtilities.class);
                    if (SecurityChecker.isSecurityBlockedName(className)) {
                        throw new SecurityException("Class loading denied for security reasons: " + className);
                    }
                    element = Class.forName(className, false, cl);
                    break;
                }
                default: {
                    throw new ClassNotFoundException("Bad descriptor: " + name);
                }
            }
            Class<Comparable<Byte>> arrayClass = element;
            for (int i = 0; i < dims; ++i) {
                arrayClass = Array.newInstance(arrayClass, 0).getClass();
            }
            return arrayClass;
        }
        if (classLoader != null) {
            return classLoader.loadClass(name);
        }
        ClassLoader cl = ClassUtilities.getClassLoader(ClassUtilities.class);
        if (SecurityChecker.isSecurityBlockedName(name)) {
            throw new SecurityException("Class loading denied for security reasons: " + name);
        }
        return Class.forName(name, false, cl);
    }

    public static boolean isClassFinal(Class<?> c) {
        return (c.getModifiers() & 0x10) != 0;
    }

    public static boolean areAllConstructorsPrivate(Class<?> c) {
        Constructor<?>[] constructors = ReflectionUtils.getAllConstructors(c);
        if (constructors.length == 0) {
            return false;
        }
        for (Constructor<?> constructor : constructors) {
            if ((constructor.getModifiers() & 2) != 0) continue;
            return false;
        }
        return true;
    }

    public static Class<?> toPrimitiveWrapperClass(Class<?> primitiveClass) {
        if (primitiveClass == null) {
            throw new IllegalArgumentException("primitiveClass cannot be null");
        }
        if (!primitiveClass.isPrimitive()) {
            return primitiveClass;
        }
        Class<?> c = PRIMITIVE_TO_WRAPPER.get(primitiveClass);
        if (c == null) {
            throw new IllegalArgumentException("Passed in class: " + primitiveClass + " is not a primitive class");
        }
        return c;
    }

    public static Class<?> toPrimitiveClass(Class<?> wrapperClass) {
        if (wrapperClass == null) {
            throw new IllegalArgumentException("Passed in class cannot be null");
        }
        Class<?> primitive = WRAPPER_TO_PRIMITIVE.get(wrapperClass);
        return primitive != null ? primitive : wrapperClass;
    }

    public static boolean doesOneWrapTheOther(Class<?> x, Class<?> y) {
        if (x == null || y == null) {
            return false;
        }
        return wrapperMap.get(x) == y || wrapperMap.get(y) == x;
    }

    public static ClassLoader getClassLoader() {
        return ClassUtilities.getClassLoader(ClassUtilities.class);
    }

    public static ClassLoader getClassLoader(Class<?> anchorClass) {
        if (anchorClass == null) {
            throw new IllegalArgumentException("Anchor class cannot be null");
        }
        ClassUtilities.checkSecurityAccess();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            return cl;
        }
        cl = anchorClass.getClassLoader();
        if (cl != null) {
            return cl;
        }
        cl = ClassUtilities.getOSGiClassLoader(anchorClass);
        if (cl != null) {
            return cl;
        }
        return SYSTEM_LOADER;
    }

    private static void checkSecurityAccess() {
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new RuntimePermission("getClassLoader"));
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private static ClassLoader getOSGiClassLoader(Class<?> classFromBundle) {
        ClassLoader cl = osgiClassLoaders.get(classFromBundle);
        if (cl != null) {
            return cl;
        }
        ClassLoader computed = ClassUtilities.getOSGiClassLoader0(classFromBundle);
        if (computed != null) {
            osgiClassLoaders.put(classFromBundle, computed);
        }
        return computed;
    }

    private static ClassLoader getOSGiClassLoader0(Class<?> classFromBundle) {
        try {
            Class<?> frameworkUtilClass;
            Method getBundleMethod;
            Object bundle;
            ClassLoader baseLoader = ClassUtilities.class.getClassLoader();
            if (baseLoader == null) {
                baseLoader = ClassLoader.getSystemClassLoader();
            }
            if ((bundle = (getBundleMethod = (frameworkUtilClass = Class.forName("org.osgi.framework.FrameworkUtil", false, baseLoader)).getMethod("getBundle", Class.class)).invoke(null, classFromBundle)) != null) {
                Method getClassLoaderMethod;
                Object classLoader;
                Class<?> bundleWiringClass = Class.forName("org.osgi.framework.wiring.BundleWiring", false, baseLoader);
                Method adaptMethod = bundle.getClass().getMethod("adapt", Class.class);
                Object bundleWiring = adaptMethod.invoke(bundle, bundleWiringClass);
                if (bundleWiring != null && (classLoader = (getClassLoaderMethod = bundleWiringClass.getMethod("getClassLoader", new Class[0])).invoke(bundleWiring, new Object[0])) instanceof ClassLoader) {
                    return (ClassLoader)classLoader;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static <T> T findClosest(Class<?> clazz, Map<Class<?>, T> candidateClasses, T defaultValue) {
        Convention.throwIfNull(clazz, "Source class cannot be null");
        Convention.throwIfNull(candidateClasses, "Candidate classes Map cannot be null");
        T exactMatch = candidateClasses.get(clazz);
        if (exactMatch != null) {
            return exactMatch;
        }
        Map<Class<?>, Integer> distanceMap = ClassUtilities.getClassHierarchyInfo(clazz).getDistanceMap();
        T closest = defaultValue;
        int minDistance = Integer.MAX_VALUE;
        Class<?> closestClass = null;
        for (Map.Entry<Class<?>, T> entry : candidateClasses.entrySet()) {
            Class<?> candidateClass = entry.getKey();
            Integer distance = distanceMap.get(candidateClass);
            if (distance == null || distance >= minDistance && (distance != minDistance || !ClassUtilities.shouldPreferNewCandidate(candidateClass, closestClass))) continue;
            minDistance = distance;
            closest = entry.getValue();
            closestClass = candidateClass;
        }
        return closest;
    }

    private static boolean shouldPreferNewCandidate(Class<?> newClass, Class<?> currentClass) {
        if (currentClass == null) {
            return true;
        }
        if (newClass.isInterface() != currentClass.isInterface()) {
            return !newClass.isInterface();
        }
        return currentClass.isAssignableFrom(newClass);
    }

    public static String loadResourceAsString(String resourceName) {
        byte[] resourceBytes = ClassUtilities.loadResourceAsBytes(resourceName);
        return new String(resourceBytes, StandardCharsets.UTF_8);
    }

    public static byte[] loadResourceAsBytes(String resourceName) {
        byte[] byArray;
        block14: {
            Objects.requireNonNull(resourceName, "resourceName cannot be null");
            resourceName = ClassUtilities.validateAndNormalizeResourcePath(resourceName);
            InputStream inputStream = null;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                inputStream = cl.getResourceAsStream(resourceName);
            }
            if (inputStream == null) {
                cl = ClassUtilities.getClassLoader(ClassUtilities.class);
                inputStream = cl.getResourceAsStream(resourceName);
            }
            if (inputStream == null && resourceName.startsWith("/")) {
                String noSlash = resourceName.substring(1);
                cl = Thread.currentThread().getContextClassLoader();
                if (cl != null) {
                    inputStream = cl.getResourceAsStream(noSlash);
                }
                if (inputStream == null) {
                    inputStream = ClassUtilities.getClassLoader(ClassUtilities.class).getResourceAsStream(noSlash);
                }
            }
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource not found: " + resourceName);
            }
            InputStream in = inputStream;
            try {
                byArray = ClassUtilities.readInputStreamFully(in);
                if (in == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Error reading resource: " + resourceName, e);
                }
            }
            in.close();
        }
        return byArray;
    }

    private static byte[] readInputStreamFully(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(65536);
        byte[] data = new byte[65536];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }

    private static Object getArgForType(com.cedarsoftware.util.convert.Converter converter, Class<?> argType) {
        if (argType.isPrimitive()) {
            return converter.convert(null, argType);
        }
        Supplier<Object> directClassMapping = DIRECT_CLASS_MAPPING.get(argType);
        if (directClassMapping != null) {
            return directClassMapping.get();
        }
        Optional<Supplier<Object>> cached = ASSIGNABLE_TYPE_CACHE.get(argType);
        if (cached != null) {
            return cached.map(Supplier::get).orElse(null);
        }
        for (Map.Entry<Class<?>, Supplier<Object>> entry : ASSIGNABLE_CLASS_MAPPING.entrySet()) {
            if (!entry.getKey().isAssignableFrom(argType)) continue;
            ASSIGNABLE_TYPE_CACHE.put(argType, Optional.of(entry.getValue()));
            return entry.getValue().get();
        }
        ASSIGNABLE_TYPE_CACHE.put(argType, Optional.empty());
        if (argType.isArray()) {
            return Array.newInstance(argType.getComponentType(), 0);
        }
        return null;
    }

    private static Object[] matchArgumentsToParameters(com.cedarsoftware.util.convert.Converter converter, Object[] valueArray, Parameter[] parameters, boolean allowNulls) {
        if (parameters == null || parameters.length == 0) {
            return ArrayUtilities.EMPTY_OBJECT_ARRAY;
        }
        boolean isVarargs = parameters[parameters.length - 1].isVarArgs();
        if (isVarargs) {
            return ClassUtilities.matchArgumentsWithVarargs(converter, valueArray, parameters, allowNulls);
        }
        Object[] result = new Object[parameters.length];
        boolean[] parameterMatched = new boolean[parameters.length];
        boolean[] valueUsed = new boolean[valueArray.length];
        ClassUtilities.findExactMatches(valueArray, valueUsed, parameters, parameterMatched, result);
        ClassUtilities.findInheritanceMatches(valueArray, valueUsed, parameters, parameterMatched, result);
        ClassUtilities.findPrimitiveWrapperMatches(valueArray, valueUsed, parameters, parameterMatched, result);
        ClassUtilities.findConvertibleMatches(converter, valueArray, valueUsed, parameters, parameterMatched, result);
        ClassUtilities.fillRemainingParameters(converter, parameters, parameterMatched, result, allowNulls);
        return result;
    }

    private static Object[] matchArgumentsWithVarargs(com.cedarsoftware.util.convert.Converter converter, Object[] valueArray, Parameter[] parameters, boolean allowNulls) {
        Object lastArg;
        int fixedParamCount = parameters.length - 1;
        Object[] result = new Object[parameters.length];
        Class<?> varargsType = parameters[fixedParamCount].getType();
        Class<?> componentType = varargsType.getComponentType();
        if (valueArray.length == parameters.length && valueArray.length > 0 && (lastArg = valueArray[valueArray.length - 1]) != null && varargsType.isInstance(lastArg)) {
            if (fixedParamCount > 0) {
                Parameter[] fixedParams = Arrays.copyOf(parameters, fixedParamCount);
                Object[] fixedValues = Arrays.copyOf(valueArray, fixedParamCount);
                boolean[] valueUsed = new boolean[fixedValues.length];
                boolean[] parameterMatched = new boolean[fixedParamCount];
                ClassUtilities.findExactMatches(fixedValues, valueUsed, fixedParams, parameterMatched, result);
                ClassUtilities.findInheritanceMatches(fixedValues, valueUsed, fixedParams, parameterMatched, result);
                ClassUtilities.findPrimitiveWrapperMatches(fixedValues, valueUsed, fixedParams, parameterMatched, result);
                ClassUtilities.findConvertibleMatches(converter, fixedValues, valueUsed, fixedParams, parameterMatched, result);
                ClassUtilities.fillRemainingParameters(converter, fixedParams, parameterMatched, result, allowNulls);
            }
            result[fixedParamCount] = lastArg;
            return result;
        }
        if (fixedParamCount > 0) {
            Parameter[] fixedParams = Arrays.copyOf(parameters, fixedParamCount);
            boolean[] valueUsed = new boolean[valueArray.length];
            boolean[] parameterMatched = new boolean[fixedParamCount];
            ClassUtilities.findExactMatches(valueArray, valueUsed, fixedParams, parameterMatched, result);
            ClassUtilities.findInheritanceMatches(valueArray, valueUsed, fixedParams, parameterMatched, result);
            ClassUtilities.findPrimitiveWrapperMatches(valueArray, valueUsed, fixedParams, parameterMatched, result);
            ClassUtilities.findConvertibleMatches(converter, valueArray, valueUsed, fixedParams, parameterMatched, result);
            ClassUtilities.fillRemainingParameters(converter, fixedParams, parameterMatched, result, allowNulls);
            ArrayList<Object> varargsValues = new ArrayList<Object>();
            for (int i = 0; i < valueArray.length; ++i) {
                if (valueUsed[i]) continue;
                varargsValues.add(valueArray[i]);
            }
            if (varargsValues.size() == 1 && varargsType.isInstance(varargsValues.get(0))) {
                result[fixedParamCount] = varargsValues.get(0);
            } else {
                Object varargsArray = Array.newInstance(componentType, varargsValues.size());
                for (int i = 0; i < varargsValues.size(); ++i) {
                    Object value = varargsValues.get(i);
                    if (value != null && !componentType.isInstance(value)) {
                        try {
                            value = converter.convert(value, componentType);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (value != null && !componentType.isInstance(value)) {
                        if (componentType.isPrimitive()) {
                            try {
                                value = converter.convert(value, componentType);
                            }
                            catch (Exception e) {
                                value = ClassUtilities.getArgForType(converter, componentType);
                            }
                        } else {
                            try {
                                value = converter.convert(value, componentType);
                            }
                            catch (Exception e) {
                                value = null;
                            }
                        }
                    }
                    try {
                        ArrayUtilities.setElement(varargsArray, i, value);
                        continue;
                    }
                    catch (IllegalArgumentException ex) {
                        ArrayUtilities.setElement(varargsArray, i, ClassUtilities.getArgForType(converter, componentType));
                    }
                }
                result[fixedParamCount] = varargsArray;
            }
        } else if (valueArray.length == 1 && varargsType.isInstance(valueArray[0])) {
            result[0] = valueArray[0];
        } else {
            Object varargsArray = Array.newInstance(componentType, valueArray.length);
            for (int i = 0; i < valueArray.length; ++i) {
                Object value = valueArray[i];
                if (value != null && !componentType.isInstance(value)) {
                    try {
                        value = converter.convert(value, componentType);
                    }
                    catch (Exception varargsValues) {
                        // empty catch block
                    }
                }
                if (value != null && !componentType.isInstance(value)) {
                    if (componentType.isPrimitive()) {
                        try {
                            value = converter.convert(value, componentType);
                        }
                        catch (Exception e) {
                            value = ClassUtilities.getArgForType(converter, componentType);
                        }
                    } else {
                        try {
                            value = converter.convert(value, componentType);
                        }
                        catch (Exception e) {
                            value = null;
                        }
                    }
                }
                try {
                    ArrayUtilities.setElement(varargsArray, i, value);
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    ArrayUtilities.setElement(varargsArray, i, ClassUtilities.getArgForType(converter, componentType));
                }
            }
            result[0] = varargsArray;
        }
        return result;
    }

    private static void findExactMatches(Object[] values, boolean[] valueUsed, Parameter[] parameters, boolean[] parameterMatched, Object[] result) {
        int valLen = values.length;
        int paramLen = parameters.length;
        block0: for (int i = 0; i < paramLen; ++i) {
            if (parameterMatched[i]) continue;
            Class<?> paramType = parameters[i].getType();
            for (int j = 0; j < valLen; ++j) {
                Object value;
                if (valueUsed[j] || (value = values[j]) == null || value.getClass() != paramType) continue;
                result[i] = value;
                parameterMatched[i] = true;
                valueUsed[j] = true;
                continue block0;
            }
        }
    }

    private static void findInheritanceMatches(Object[] values, boolean[] valueUsed, Parameter[] parameters, boolean[] parameterMatched, Object[] result) {
        HashMap<Class, ClassHierarchyInfo> valueClassCache = new HashMap<Class, ClassHierarchyInfo>();
        for (int j = 0; j < values.length; ++j) {
            if (valueUsed[j] || values[j] == null) continue;
            Class<?> valueClass = values[j].getClass();
            valueClassCache.computeIfAbsent(valueClass, ClassUtilities::getClassHierarchyInfo);
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (parameterMatched[i]) continue;
            Class<?> paramType = parameters[i].getType();
            int bestDistance = Integer.MAX_VALUE;
            int bestValueIndex = -1;
            for (int j = 0; j < values.length; ++j) {
                Class<?> valueClass;
                ClassHierarchyInfo hierarchyInfo;
                int distance;
                Object value;
                if (valueUsed[j] || (value = values[j]) == null || (distance = (hierarchyInfo = (ClassHierarchyInfo)valueClassCache.get(valueClass = value.getClass())).getDistance(paramType)) < 0 || distance >= bestDistance) continue;
                bestDistance = distance;
                bestValueIndex = j;
            }
            if (bestValueIndex < 0) continue;
            result[i] = values[bestValueIndex];
            parameterMatched[i] = true;
            valueUsed[bestValueIndex] = true;
        }
    }

    private static void findPrimitiveWrapperMatches(Object[] values, boolean[] valueUsed, Parameter[] parameters, boolean[] parameterMatched, Object[] result) {
        block0: for (int i = 0; i < parameters.length; ++i) {
            if (parameterMatched[i]) continue;
            Class<?> paramType = parameters[i].getType();
            for (int j = 0; j < values.length; ++j) {
                Class<?> valueClass;
                Object value;
                if (valueUsed[j] || (value = values[j]) == null || !ClassUtilities.doesOneWrapTheOther(paramType, valueClass = value.getClass())) continue;
                result[i] = value;
                parameterMatched[i] = true;
                valueUsed[j] = true;
                continue block0;
            }
        }
    }

    private static void findConvertibleMatches(com.cedarsoftware.util.convert.Converter converter, Object[] values, boolean[] valueUsed, Parameter[] parameters, boolean[] parameterMatched, Object[] result) {
        block2: for (int i = 0; i < parameters.length; ++i) {
            if (parameterMatched[i]) continue;
            Class<?> paramType = parameters[i].getType();
            for (int j = 0; j < values.length; ++j) {
                Class<?> valueClass;
                Object value;
                if (valueUsed[j] || (value = values[j]) == null || !converter.isSimpleTypeConversionSupported(paramType, valueClass = value.getClass())) continue;
                try {
                    Object converted = converter.convert(value, paramType);
                    result[i] = converted;
                    parameterMatched[i] = true;
                    valueUsed[j] = true;
                    continue block2;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void fillRemainingParameters(com.cedarsoftware.util.convert.Converter converter, Parameter[] parameters, boolean[] parameterMatched, Object[] result, boolean allowNulls) {
        for (int i = 0; i < parameters.length; ++i) {
            if (parameterMatched[i]) continue;
            Parameter parameter = parameters[i];
            Class<?> paramType = parameter.getType();
            if (allowNulls && !paramType.isPrimitive()) {
                result[i] = null;
                continue;
            }
            Object defaultValue = ClassUtilities.getArgForType(converter, paramType);
            if (defaultValue == null && paramType.isPrimitive()) {
                defaultValue = converter.convert(null, paramType);
            }
            result[i] = defaultValue;
        }
    }

    public static Class<?> getClassIfEnum(Class<?> c) {
        if (c == null) {
            return null;
        }
        return ENUM_CLASS_CACHE.get(c);
    }

    private static Class<?> computeEnum(Class<?> c) {
        if (c.isEnum() && c != Enum.class) {
            return c;
        }
        Class<?> current = c;
        while ((current = current.getSuperclass()) != null) {
            if (!current.isEnum() || current == Enum.class) continue;
            return current;
        }
        for (current = c.getEnclosingClass(); current != null; current = current.getEnclosingClass()) {
            if (!current.isEnum() || current == Enum.class) continue;
            return current;
        }
        return null;
    }

    public static Object newInstance(Class<?> c, Object arguments) {
        return ClassUtilities.newInstance(Converter.getInstance(), c, arguments);
    }

    public static Object newInstance(com.cedarsoftware.util.convert.Converter converter, Class<?> c, Object arguments) {
        Collection<Object> normalizedArgs;
        block26: {
            Convention.throwIfNull(c, "Class cannot be null");
            Convention.throwIfNull(converter, "Converter cannot be null");
            Map namedParameters = null;
            boolean hasNamedParameters = false;
            if (arguments == null) {
                normalizedArgs = Collections.emptyList();
            } else if (arguments instanceof Collection) {
                normalizedArgs = (Collection)arguments;
            } else if (arguments instanceof Map) {
                Map map = (Map)arguments;
                boolean generatedKeys = ClassUtilities.hasGeneratedKeys(map);
                if (!generatedKeys) {
                    hasNamedParameters = true;
                    namedParameters = map;
                }
                if (generatedKeys) {
                    ArrayList entries = new ArrayList(map.entrySet());
                    entries.sort((e1, e2) -> {
                        try {
                            int num1 = Integer.parseInt(((String)e1.getKey()).substring(3));
                            int num2 = Integer.parseInt(((String)e2.getKey()).substring(3));
                            return Integer.compare(num1, num2);
                        }
                        catch (NumberFormatException | StringIndexOutOfBoundsException e) {
                            return ((String)e1.getKey()).compareTo((String)e2.getKey());
                        }
                    });
                    ArrayList orderedValues = new ArrayList(entries.size());
                    for (Map.Entry entry : entries) {
                        orderedValues.add(entry.getValue());
                    }
                    normalizedArgs = orderedValues;
                } else if (map instanceof LinkedHashMap || map instanceof SortedMap) {
                    normalizedArgs = map.values();
                } else {
                    ArrayList sortedKeys = new ArrayList(map.keySet());
                    Collections.sort(sortedKeys);
                    ArrayList orderedValues = new ArrayList(sortedKeys.size());
                    for (String string : sortedKeys) {
                        orderedValues.add(map.get(string));
                    }
                    normalizedArgs = orderedValues;
                }
            } else {
                normalizedArgs = arguments.getClass().isArray() ? converter.convert(arguments, Collection.class) : Collections.singletonList(arguments);
            }
            if (hasNamedParameters && namedParameters != null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Attempting parameter name matching for class: {0}", c.getName());
                }
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "Provided parameter names: {0}", namedParameters.keySet());
                }
                try {
                    Object result = ClassUtilities.newInstanceWithNamedParameters(converter, c, namedParameters);
                    if (result != null) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "Successfully created instance of {0} using parameter names", c.getName());
                        }
                        return result;
                    }
                }
                catch (Exception e) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "Parameter name matching failed for {0}: {1}", new Object[]{c.getName(), e.getMessage()});
                    }
                    if (!LOG.isLoggable(Level.FINER)) break block26;
                    LOG.log(Level.FINER, "Falling back to positional argument matching");
                }
            }
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Using positional argument matching for {0}", c.getName());
        }
        IdentitySet visited = new IdentitySet();
        try {
            return ClassUtilities.newInstance(converter, c, normalizedArgs, visited);
        }
        catch (Exception e) {
            if (arguments instanceof Map && normalizedArgs != null && !normalizedArgs.isEmpty()) {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "Positional matching with map values failed for {0}, trying no-arg constructor", c.getName());
                }
                return ClassUtilities.newInstance(converter, c, null, visited);
            }
            throw e;
        }
    }

    private static Object newInstanceWithNamedParameters(com.cedarsoftware.util.convert.Converter converter, Class<?> c, Map<String, Object> namedParams) {
        Parameter[] parameters;
        Constructor<?>[] sortedConstructors = ReflectionUtils.getAllConstructors(c);
        boolean isFinal = Modifier.isFinal(c.getModifiers());
        boolean isException = Throwable.class.isAssignableFrom(c);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Class {0} is {1}{2}", new Object[]{c.getName(), isFinal ? "final" : "non-final", isException ? " (Exception type)" : ""});
            LOG.log(Level.FINER, "Trying {0} constructors for {1}", new Object[]{sortedConstructors.length, c.getName()});
        }
        IdentityHashMap constructorParametersCache = new IdentityHashMap();
        boolean anyConstructorHasRealNames = false;
        for (Constructor<?> constructor : sortedConstructors) {
            parameters = constructor.getParameters();
            constructorParametersCache.put(constructor, parameters);
            if (parameters.length <= 0) continue;
            boolean allParamsHaveRealNames = true;
            for (Parameter param : parameters) {
                if (!ClassUtilities.isSyntheticArgName(param.getName())) continue;
                allParamsHaveRealNames = false;
                break;
            }
            if (!allParamsHaveRealNames) continue;
            anyConstructorHasRealNames = true;
            break;
        }
        if (!anyConstructorHasRealNames) {
            boolean hasParameterizedConstructor = false;
            Constructor<?>[] constructorArray = sortedConstructors;
            int n = constructorArray.length;
            for (int constructor = 0; constructor < n; ++constructor) {
                Constructor<?> cons = constructorArray[constructor];
                if (cons.getParameterCount() <= 0) continue;
                hasParameterizedConstructor = true;
                break;
            }
            if (hasParameterizedConstructor) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "No constructors for {0} have real parameter names - cannot use parameter matching", c.getName());
                }
                return null;
            }
        }
        for (Constructor<?> constructor : sortedConstructors) {
            try {
                ClassUtilities.trySetAccessible(constructor);
            }
            catch (SecurityException se) {
                if (!LOG.isLoggable(Level.FINER)) continue;
                LOG.log(Level.FINER, "Cannot access constructor {0} due to security restrictions: {1}", new Object[]{constructor, se.getMessage()});
                continue;
            }
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "Trying constructor: {0}", constructor);
            }
            if ((parameters = (Parameter[])constructorParametersCache.get(constructor)) == null) {
                parameters = constructor.getParameters();
                constructorParametersCache.put(constructor, parameters);
            }
            String[] paramNames = new String[parameters.length];
            boolean hasRealNames = true;
            for (int i = 0; i < parameters.length; ++i) {
                paramNames[i] = parameters[i].getName();
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINEST, "  Parameter {0}: name=''{1}'', type={2}", new Object[]{i, paramNames[i], parameters[i].getType().getSimpleName()});
                }
                if (!ClassUtilities.isSyntheticArgName(paramNames[i])) continue;
                hasRealNames = false;
            }
            if (!hasRealNames && parameters.length > 0) {
                if (!LOG.isLoggable(Level.FINER)) continue;
                LOG.log(Level.FINER, "  Skipping constructor - parameter names not available");
                continue;
            }
            Object[] args = new Object[parameters.length];
            boolean allMatched = true;
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i].isVarArgs()) {
                    Object array;
                    Class<?> arrayType = parameters[i].getType();
                    Class<?> componentType = arrayType.getComponentType();
                    Object v = namedParams.get(paramNames[i]);
                    if (v != null && arrayType.isInstance(v)) {
                        array = v;
                    } else {
                        List<Object> src = v instanceof Collection ? (List<Object>)v : Collections.singletonList(v);
                        array = Array.newInstance(componentType, src.size());
                        int k = 0;
                        for (Object e : src) {
                            try {
                                ArrayUtilities.setElement(array, k++, converter.convert(e, componentType));
                            }
                            catch (Exception e2) {
                                ArrayUtilities.setElement(array, k++, ClassUtilities.getArgForType(converter, componentType));
                            }
                        }
                    }
                    args[i] = array;
                    if (!LOG.isLoggable(Level.FINEST)) continue;
                    LOG.log(Level.FINEST, "  Matched varargs parameter ''{0}'' with array of length: {1}", new Object[]{paramNames[i], ArrayUtilities.getLength(array)});
                    continue;
                }
                if (namedParams.containsKey(paramNames[i])) {
                    Object value = namedParams.get(paramNames[i]);
                    try {
                        args[i] = value == null ? (parameters[i].getType().isPrimitive() ? converter.convert(value, parameters[i].getType()) : null) : (parameters[i].getType().isInstance(value) ? value : converter.convert(value, parameters[i].getType()));
                        if (!LOG.isLoggable(Level.FINEST)) continue;
                        LOG.log(Level.FINEST, "  Matched parameter ''{0}'' with value: {1}", new Object[]{paramNames[i], value});
                        continue;
                    }
                    catch (Exception conversionException) {
                        allMatched = false;
                        break;
                    }
                }
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "  Missing parameter: {0}", paramNames[i]);
                }
                allMatched = false;
                break;
            }
            if (!allMatched) continue;
            try {
                Object instance = constructor.newInstance(args);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "  Successfully created instance of {0}", c.getName());
                }
                return instance;
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINER)) continue;
                LOG.log(Level.FINER, "  Failed to invoke constructor: {0}", e.getMessage());
            }
        }
        return null;
    }

    private static boolean isSyntheticArgName(String name) {
        if (name == null || name.length() < 4 || !name.startsWith("arg")) {
            return false;
        }
        for (int i = 3; i < name.length(); ++i) {
            if (Character.isDigit(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean hasGeneratedKeys(Map<String, Object> map) {
        if (map.isEmpty()) {
            return false;
        }
        for (String key : map.keySet()) {
            if (ClassUtilities.isSyntheticArgName(key)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static Object newInstance(com.cedarsoftware.util.convert.Converter converter, Class<?> c, Collection<?> argumentValues) {
        return ClassUtilities.newInstance(converter, c, argumentValues);
    }

    private static Object newInstance(com.cedarsoftware.util.convert.Converter converter, Class<?> c, Collection<?> argumentValues, Set<Class<?>> visitedClasses) {
        Object[] suppliedArgs;
        block35: {
            ArrayList normalizedArgs;
            Convention.throwIfNull(c, "Class cannot be null");
            SecurityChecker.verifyClass(c);
            if (argumentValues != null) {
                ClassUtilities.validateEnhancedSecurity("Constructor argument", argumentValues.size(), ClassUtilities.getMaxConstructorArgs());
            }
            if (visitedClasses.contains(c)) {
                throw new IllegalStateException("Circular reference detected for " + c.getName());
            }
            if (c.isInterface()) {
                throw new IllegalArgumentException("Cannot instantiate interface: " + c.getName());
            }
            if (Modifier.isAbstract(c.getModifiers())) {
                throw new IllegalArgumentException("Cannot instantiate abstract class: " + c.getName());
            }
            ArrayList<Object> arrayList = normalizedArgs = argumentValues == null ? new ArrayList() : new ArrayList(argumentValues);
            if (normalizedArgs.isEmpty()) {
                try {
                    Constructor<?> noArg = c.getDeclaredConstructor(new Class[0]);
                    ClassUtilities.trySetAccessible(noArg);
                    Object instance = noArg.newInstance(new Object[0]);
                    SUCCESSFUL_CONSTRUCTOR_CACHE.put(c, noArg);
                    return instance;
                }
                catch (NoSuchMethodException noArg) {
                }
                catch (SecurityException noArg) {
                }
                catch (Exception noArg) {
                    // empty catch block
                }
            }
            suppliedArgs = normalizedArgs.isEmpty() ? ArrayUtilities.EMPTY_OBJECT_ARRAY : normalizedArgs.toArray();
            Constructor<?> cachedConstructor = SUCCESSFUL_CONSTRUCTOR_CACHE.get(c);
            if (cachedConstructor != null) {
                try {
                    Parameter[] parameters = cachedConstructor.getParameters();
                    try {
                        Object[] argsNonNull = ClassUtilities.matchArgumentsToParameters(converter, suppliedArgs, parameters, false);
                        return cachedConstructor.newInstance(argsNonNull);
                    }
                    catch (Exception e) {
                        Object[] argsNull = ClassUtilities.matchArgumentsToParameters(converter, suppliedArgs, parameters, true);
                        return cachedConstructor.newInstance(argsNull);
                    }
                }
                catch (Exception parameters) {
                    // empty catch block
                }
            }
            if (c.getEnclosingClass() != null && !Modifier.isStatic(c.getModifiers())) {
                Constructor<?>[] constructors;
                Object enclosingInstance;
                visitedClasses.add(c);
                Class<?> enclosingClass2 = c.getEnclosingClass();
                if (visitedClasses.contains(enclosingClass2)) break block35;
                try {
                    Constructor<?> defaultCtor = enclosingClass2.getDeclaredConstructor(new Class[0]);
                    ClassUtilities.trySetAccessible(defaultCtor);
                    enclosingInstance = defaultCtor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    enclosingInstance = ClassUtilities.newInstance(converter, enclosingClass2, Collections.emptyList(), visitedClasses);
                }
                Constructor<?>[] constructorArray = constructors = ReflectionUtils.getAllConstructors(c);
                int n = constructorArray.length;
                for (int i = 0; i < n; ++i) {
                    Constructor<?> constructor = constructorArray[i];
                    Parameter[] params = constructor.getParameters();
                    if (params.length <= 0 || !params[0].getType().equals(enclosingClass2)) continue;
                    try {
                        ClassUtilities.trySetAccessible(constructor);
                        if (params.length == 1) {
                            Object instance = constructor.newInstance(enclosingInstance);
                            SUCCESSFUL_CONSTRUCTOR_CACHE.put(c, constructor);
                            return instance;
                        }
                        Parameter[] restParams = Arrays.copyOfRange(params, 1, params.length);
                        Object[] restArgs = ClassUtilities.matchArgumentsToParameters(converter, suppliedArgs, restParams, false);
                        Object[] allArgs = new Object[params.length];
                        allArgs[0] = enclosingInstance;
                        System.arraycopy(restArgs, 0, allArgs, 1, restArgs.length);
                        Object instance = constructor.newInstance(allArgs);
                        SUCCESSFUL_CONSTRUCTOR_CACHE.put(c, constructor);
                        return instance;
                    }
                    catch (Exception restParams) {
                        try {
                            continue;
                        }
                        catch (Exception enclosingClass2) {
                            // empty catch block
                            break;
                        }
                    }
                }
            }
        }
        Constructor<?>[] constructors = ReflectionUtils.getAllConstructors(c);
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Constructor<?> constructor : constructors) {
            try {
                ClassUtilities.trySetAccessible(constructor);
            }
            catch (SecurityException se) {
                if (!LOG.isLoggable(Level.FINER)) continue;
                LOG.log(Level.FINER, "Cannot access constructor {0} due to security restrictions: {1}", new Object[]{constructor, se.getMessage()});
                continue;
            }
            Parameter[] parameters = constructor.getParameters();
            try {
                Object[] argsNonNull = ClassUtilities.matchArgumentsToParameters(converter, suppliedArgs, parameters, false);
                Object instance = constructor.newInstance(argsNonNull);
                SUCCESSFUL_CONSTRUCTOR_CACHE.put(c, constructor);
                return instance;
            }
            catch (Exception e1) {
                exceptions.add(e1);
                try {
                    Object[] argsNull = ClassUtilities.matchArgumentsToParameters(converter, suppliedArgs, parameters, true);
                    Object instance = constructor.newInstance(argsNull);
                    SUCCESSFUL_CONSTRUCTOR_CACHE.put(c, constructor);
                    return instance;
                }
                catch (Exception e2) {
                    exceptions.add(e2);
                }
            }
        }
        Object instance = ClassUtilities.tryUnsafeInstantiation(c);
        if (instance != null) {
            return instance;
        }
        String msg = "Unable to instantiate: " + c.getName();
        if (!exceptions.isEmpty()) {
            Exception lastException = (Exception)exceptions.get(exceptions.size() - 1);
            msg = msg + " - Most recent error: " + lastException.getMessage();
            if (exceptions.size() > 1) {
                StringBuilder errorDetails = new StringBuilder("\nAll constructor errors:\n");
                for (int i = 0; i < exceptions.size(); ++i) {
                    Exception e = (Exception)exceptions.get(i);
                    errorDetails.append("  ").append(i + 1).append(") ").append(e.getClass().getSimpleName()).append(": ").append(e.getMessage()).append("\n");
                }
                msg = msg + errorDetails.toString();
            }
        }
        throw new IllegalArgumentException(msg);
    }

    static void trySetAccessible(AccessibleObject object) {
        Boolean prev = accessibilityCache.get(object);
        if (Boolean.FALSE.equals(prev)) {
            return;
        }
        if (Boolean.TRUE.equals(prev)) {
            return;
        }
        try {
            object.setAccessible(true);
            accessibilityCache.put(object, Boolean.TRUE);
        }
        catch (SecurityException e) {
            accessibilityCache.put(object, Boolean.FALSE);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Unable to set accessible: " + object + " - " + e.getMessage());
            }
            throw e;
        }
        catch (Throwable t) {
            accessibilityCache.put(object, Boolean.FALSE);
            ExceptionUtilities.safelyIgnoreException(t);
        }
    }

    private static Object tryUnsafeInstantiation(Class<?> c) {
        if (unsafeDepth.get() > 0) {
            try {
                SecurityChecker.verifyClass(c);
                return unsafe.allocateInstance(c);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUseUnsafe(boolean state) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && state) {
            sm.checkPermission(new RuntimePermission("com.cedarsoftware.util.enableUnsafe"));
        }
        if (state) {
            unsafeDepth.set(unsafeDepth.get() + 1);
            if (unsafe == null) {
                Class<ClassUtilities> clazz = ClassUtilities.class;
                synchronized (ClassUtilities.class) {
                    block11: {
                        if (unsafe == null) {
                            try {
                                unsafe = new Unsafe();
                            }
                            catch (Exception e) {
                                unsafeDepth.set(unsafeDepth.get() - 1);
                                if (!LOG.isLoggable(Level.FINE)) break block11;
                                LOG.log(Level.FINE, "Failed to initialize unsafe instantiation: " + e.getMessage());
                            }
                        }
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                }
            }
        } else {
            int depth = unsafeDepth.get();
            if (depth > 0) {
                unsafeDepth.set(depth - 1);
            }
        }
    }

    public static void logAccessIssue(AccessibleObject accessible, Exception e, String operation) {
        String modifiers;
        String declaringClass;
        String elementName;
        String elementType;
        if (!LOG.isLoggable(Level.FINEST)) {
            return;
        }
        if (accessible instanceof Field) {
            Field field = (Field)accessible;
            elementType = "field";
            elementName = field.getName();
            declaringClass = field.getDeclaringClass().getName();
            modifiers = Modifier.toString(field.getModifiers());
        } else if (accessible instanceof Method) {
            Method method = (Method)accessible;
            elementType = "method";
            elementName = method.getName() + "()";
            declaringClass = method.getDeclaringClass().getName();
            modifiers = Modifier.toString(method.getModifiers());
        } else if (accessible instanceof Constructor) {
            Constructor constructor = (Constructor)accessible;
            elementType = "constructor";
            elementName = constructor.getDeclaringClass().getSimpleName() + "()";
            declaringClass = constructor.getDeclaringClass().getName();
            modifiers = Modifier.toString(constructor.getModifiers());
        } else {
            elementType = "member";
            elementName = accessible.toString();
            declaringClass = "unknown";
            modifiers = "";
        }
        String reason = null;
        if (e instanceof IllegalAccessException) {
            String msg = e.getMessage();
            if (msg != null) {
                if (msg.contains("module")) {
                    reason = "Java module system restriction";
                } else if (msg.contains("private")) {
                    reason = "private access";
                } else if (msg.contains("protected")) {
                    reason = "protected access";
                } else if (msg.contains("package")) {
                    reason = "package-private access";
                }
            }
        } else if (INACCESSIBLE_OBJECT_EXCEPTION_CLASS != null && INACCESSIBLE_OBJECT_EXCEPTION_CLASS.isInstance(e)) {
            reason = "Java module system restriction (InaccessibleObjectException)";
        } else if (e instanceof SecurityException) {
            reason = "Security manager restriction";
        }
        if (reason == null) {
            reason = e.getClass().getSimpleName();
        }
        if (LOG.isLoggable(Level.FINEST)) {
            if (operation != null && !operation.isEmpty()) {
                LOG.log(Level.FINEST, "Cannot {0} {1} {2} ''{3}'' on {4} ({5})", new Object[]{operation, modifiers, elementType, elementName, declaringClass, reason});
            } else {
                LOG.log(Level.FINEST, "Cannot access {0} {1} ''{2}'' on {3} ({4})", new Object[]{modifiers, elementType, elementName, declaringClass, reason});
            }
        }
    }

    private static String validateAndNormalizeResourcePath(String resourceName) {
        if (StringUtilities.isEmpty(resourceName)) {
            throw new SecurityException("Resource name cannot be null or empty");
        }
        if (resourceName.indexOf(0) >= 0) {
            throw new SecurityException("Invalid resource path contains null byte: " + resourceName);
        }
        String lowerPath = resourceName.toLowerCase();
        if (lowerPath.contains("%2e%2e") || lowerPath.contains("%252e") || lowerPath.contains("%2e.") || lowerPath.contains(".%2e")) {
            throw new SecurityException("Invalid resource path contains encoded traversal sequence: " + resourceName);
        }
        String normalizedPath = resourceName.replace('\\', '/');
        int pathLength = normalizedPath.length();
        if (pathLength >= 3 && Character.isLetter(normalizedPath.charAt(0)) && normalizedPath.charAt(1) == ':' && normalizedPath.charAt(2) == '/') {
            throw new SecurityException("Absolute/UNC paths not allowed: " + resourceName);
        }
        if (pathLength >= 2 && normalizedPath.charAt(0) == '/' && normalizedPath.charAt(1) == '/') {
            throw new SecurityException("Absolute/UNC paths not allowed: " + resourceName);
        }
        for (String segment : normalizedPath.split("/")) {
            if (!segment.equals("..")) continue;
            throw new SecurityException("Invalid resource path contains directory traversal: " + resourceName);
        }
        int maxLength = ClassUtilities.getMaxResourceNameLength();
        if (normalizedPath.length() > maxLength) {
            throw new SecurityException("Resource name too long (max " + maxLength + "): " + normalizedPath.length());
        }
        return normalizedPath;
    }

    public static void logFieldAccessIssue(Field field, Exception e) {
        ClassUtilities.logAccessIssue(field, e, "read");
    }

    public static void logMethodAccessIssue(Method method, Exception e) {
        ClassUtilities.logAccessIssue(method, e, "invoke");
    }

    public static void logConstructorAccessIssue(Constructor<?> constructor, Exception e) {
        ClassUtilities.logAccessIssue(constructor, e, "invoke");
    }

    public static Set<Class<?>> findLowestCommonSupertypesExcluding(Class<?> classA, Class<?> classB, Set<Class<?>> excluded) {
        Set<Object> set = excluded = excluded == null ? Collections.emptySet() : excluded;
        if (classA == null || classB == null) {
            return Collections.emptySet();
        }
        if (classA.equals(classB)) {
            return excluded.contains(classA) ? Collections.emptySet() : Collections.singleton(classA);
        }
        Set<Class<?>> allA = ClassUtilities.getClassHierarchyInfo(classA).getAllSupertypes();
        Set<Class<?>> allB = ClassUtilities.getClassHierarchyInfo(classB).getAllSupertypes();
        Set<Class<?>> smaller = allA.size() <= allB.size() ? allA : allB;
        Set<Class<?>> larger = allA.size() <= allB.size() ? allB : allA;
        LinkedHashSet common = new LinkedHashSet();
        for (Class<?> type : smaller) {
            if (!larger.contains(type) || excluded.contains(type)) continue;
            common.add(type);
        }
        if (common.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList candidates = new ArrayList(common);
        ClassHierarchyInfo infoA = ClassUtilities.getClassHierarchyInfo(classA);
        ClassHierarchyInfo infoB = ClassUtilities.getClassHierarchyInfo(classB);
        candidates.sort((x, y) -> {
            int dx = infoA.getDistance((Class<?>)x) + infoB.getDistance((Class<?>)x);
            int dy = infoA.getDistance((Class<?>)y) + infoB.getDistance((Class<?>)y);
            return Integer.compare(dx, dy);
        });
        LinkedHashSet lowest = new LinkedHashSet();
        IdentitySet unionOfAncestors = new IdentitySet();
        for (Class type : candidates) {
            if (unionOfAncestors.contains(type)) continue;
            lowest.add(type);
            unionOfAncestors.addAll(ClassUtilities.getClassHierarchyInfo(type).getAllSupertypes());
        }
        return lowest;
    }

    public static Set<Class<?>> findLowestCommonSupertypes(Class<?> classA, Class<?> classB) {
        return ClassUtilities.findLowestCommonSupertypesExcluding(classA, classB, CollectionUtilities.setOf(Object.class, Serializable.class, Externalizable.class, Cloneable.class));
    }

    public static Class<?> findLowestCommonSupertype(Class<?> classA, Class<?> classB) {
        Set<Class<?>> all = ClassUtilities.findLowestCommonSupertypes(classA, classB);
        return all.isEmpty() ? null : all.iterator().next();
    }

    public static ClassHierarchyInfo getClassHierarchyInfo(Class<?> clazz) {
        return CLASS_HIERARCHY_CACHE.computeIfAbsent(clazz, key -> {
            LinkedHashSet<Class> allSupertypes = new LinkedHashSet<Class>();
            HashMap distanceMap = new HashMap();
            ArrayDeque queue = new ArrayDeque();
            queue.add((Class<?>)key);
            distanceMap.put((Class<?>)key, 0);
            while (!queue.isEmpty()) {
                Class current = (Class)queue.poll();
                int currentDistance = (Integer)distanceMap.get(current);
                if (current == null || !allSupertypes.add(current)) continue;
                Class superclass = current.getSuperclass();
                if (superclass != null && !distanceMap.containsKey(superclass)) {
                    distanceMap.put(superclass, currentDistance + 1);
                    queue.add(superclass);
                }
                for (Class<?> iface : current.getInterfaces()) {
                    if (distanceMap.containsKey(iface)) continue;
                    distanceMap.put(iface, currentDistance + 1);
                    queue.add(iface);
                }
            }
            return new ClassHierarchyInfo(Collections.unmodifiableSet(allSupertypes), Collections.unmodifiableMap(distanceMap));
        });
    }

    public static boolean haveCommonAncestor(Class<?> a, Class<?> b) {
        return !ClassUtilities.findLowestCommonSupertypes(a, b).isEmpty();
    }

    public static void clearCaches() {
        NAME_CACHE.clear();
        GLOBAL_ALIASES.clear();
        GLOBAL_ALIASES.putAll(BUILTIN_ALIASES);
        GLOBAL_ALIASES.putAll(USER_ALIASES);
        SUCCESSFUL_CONSTRUCTOR_CACHE.clear();
        CLASS_HIERARCHY_CACHE.clear();
        accessibilityCache.clear();
        osgiClassLoaders.clear();
    }

    private static boolean isEnhancedSecurityEnabled() {
        return ENHANCED_SECURITY_ENABLED;
    }

    private static int getMaxClassLoadDepth() {
        return MAX_CLASS_LOAD_DEPTH;
    }

    private static int getMaxConstructorArgs() {
        return MAX_CONSTRUCTOR_ARGS;
    }

    private static int getMaxResourceNameLength() {
        return MAX_RESOURCE_NAME_LENGTH;
    }

    private static void validateEnhancedSecurity(String operation, int currentCount, int maxAllowed) {
        if (!ENHANCED_SECURITY_ENABLED || maxAllowed <= 0) {
            return;
        }
        if (currentCount > maxAllowed) {
            throw new SecurityException(operation + " count exceeded limit: " + currentCount + " > " + maxAllowed);
        }
    }

    static {
        LoggingConfig.init();
        NAME_CACHE = Collections.synchronizedMap(new WeakHashMap());
        GLOBAL_ALIASES = new ConcurrentHashMap();
        BUILTIN_ALIASES = new ConcurrentHashMap();
        USER_ALIASES = new ConcurrentHashMap();
        PRIMITIVE_TO_WRAPPER = new ClassValueMap();
        WRAPPER_TO_PRIMITIVE = new ClassValueMap();
        osgiClassLoaders = new ClassValueMap<ClassLoader>();
        SYSTEM_LOADER = ClassLoader.getSystemClassLoader();
        unsafeDepth = ThreadLocal.withInitial(() -> 0);
        CLASS_LOAD_DEPTH = ThreadLocal.withInitial(() -> 0);
        ClassUtilities.reinitializeSecuritySettings();
        DIRECT_CLASS_MAPPING = new ClassValueMap<Supplier<Object>>();
        ASSIGNABLE_CLASS_MAPPING = new LinkedHashMap();
        ASSIGNABLE_TYPE_CACHE = new ClassValueMap<Optional<Supplier<Object>>>();
        ENUM_CLASS_CACHE = new ClassValue<Class<?>>(){

            @Override
            protected Class<?> computeValue(Class<?> type) {
                return ClassUtilities.computeEnum(type);
            }
        };
        SUCCESSFUL_CONSTRUCTOR_CACHE = new ClassValueMap();
        CLASS_HIERARCHY_CACHE = new ClassValueMap<ClassHierarchyInfo>();
        DIRECT_CLASS_MAPPING.put(Date.class, Date::new);
        DIRECT_CLASS_MAPPING.put(StringBuilder.class, StringBuilder::new);
        DIRECT_CLASS_MAPPING.put(StringBuffer.class, StringBuffer::new);
        DIRECT_CLASS_MAPPING.put(Locale.class, Locale::getDefault);
        DIRECT_CLASS_MAPPING.put(TimeZone.class, () -> (TimeZone)TimeZone.getDefault().clone());
        DIRECT_CLASS_MAPPING.put(Timestamp.class, () -> new Timestamp(0L));
        DIRECT_CLASS_MAPPING.put(java.sql.Date.class, () -> new java.sql.Date(0L));
        DIRECT_CLASS_MAPPING.put(LocalDate.class, () -> LocalDate.of(1970, 1, 1));
        DIRECT_CLASS_MAPPING.put(LocalDateTime.class, () -> LocalDateTime.of(1970, 1, 1, 0, 0, 0));
        DIRECT_CLASS_MAPPING.put(OffsetDateTime.class, () -> OffsetDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC));
        DIRECT_CLASS_MAPPING.put(ZonedDateTime.class, () -> ZonedDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC));
        DIRECT_CLASS_MAPPING.put(ZoneId.class, ZoneId::systemDefault);
        DIRECT_CLASS_MAPPING.put(AtomicBoolean.class, AtomicBoolean::new);
        DIRECT_CLASS_MAPPING.put(AtomicInteger.class, AtomicInteger::new);
        DIRECT_CLASS_MAPPING.put(AtomicLong.class, AtomicLong::new);
        DIRECT_CLASS_MAPPING.put(Object.class, Object::new);
        DIRECT_CLASS_MAPPING.put(String.class, () -> "");
        DIRECT_CLASS_MAPPING.put(BigInteger.class, () -> BigInteger.ZERO);
        DIRECT_CLASS_MAPPING.put(BigDecimal.class, () -> BigDecimal.ZERO);
        DIRECT_CLASS_MAPPING.put(Calendar.class, () -> {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(0L);
            return cal;
        });
        DIRECT_CLASS_MAPPING.put(Instant.class, () -> Instant.EPOCH);
        DIRECT_CLASS_MAPPING.put(Duration.class, () -> Duration.ZERO);
        DIRECT_CLASS_MAPPING.put(Period.class, () -> Period.ofDays(0));
        DIRECT_CLASS_MAPPING.put(Year.class, () -> Year.of(1970));
        DIRECT_CLASS_MAPPING.put(YearMonth.class, () -> YearMonth.of(1970, 1));
        DIRECT_CLASS_MAPPING.put(MonthDay.class, () -> MonthDay.of(1, 1));
        DIRECT_CLASS_MAPPING.put(ZoneOffset.class, () -> ZoneOffset.UTC);
        DIRECT_CLASS_MAPPING.put(OffsetTime.class, () -> OffsetTime.of(0, 0, 0, 0, ZoneOffset.UTC));
        DIRECT_CLASS_MAPPING.put(LocalTime.class, () -> LocalTime.MIDNIGHT);
        DIRECT_CLASS_MAPPING.put(ByteBuffer.class, () -> ByteBuffer.allocate(0));
        DIRECT_CLASS_MAPPING.put(CharBuffer.class, () -> CharBuffer.allocate(0));
        DIRECT_CLASS_MAPPING.put(HashSet.class, HashSet::new);
        DIRECT_CLASS_MAPPING.put(TreeSet.class, TreeSet::new);
        DIRECT_CLASS_MAPPING.put(HashMap.class, HashMap::new);
        DIRECT_CLASS_MAPPING.put(TreeMap.class, TreeMap::new);
        DIRECT_CLASS_MAPPING.put(Hashtable.class, Hashtable::new);
        DIRECT_CLASS_MAPPING.put(ArrayList.class, ArrayList::new);
        DIRECT_CLASS_MAPPING.put(LinkedList.class, LinkedList::new);
        DIRECT_CLASS_MAPPING.put(Vector.class, Vector::new);
        DIRECT_CLASS_MAPPING.put(Stack.class, Stack::new);
        DIRECT_CLASS_MAPPING.put(Properties.class, Properties::new);
        DIRECT_CLASS_MAPPING.put(ConcurrentHashMap.class, ConcurrentHashMap::new);
        DIRECT_CLASS_MAPPING.put(LinkedHashMap.class, LinkedHashMap::new);
        DIRECT_CLASS_MAPPING.put(LinkedHashSet.class, LinkedHashSet::new);
        DIRECT_CLASS_MAPPING.put(ArrayDeque.class, ArrayDeque::new);
        DIRECT_CLASS_MAPPING.put(PriorityQueue.class, PriorityQueue::new);
        DIRECT_CLASS_MAPPING.put(CopyOnWriteArrayList.class, CopyOnWriteArrayList::new);
        DIRECT_CLASS_MAPPING.put(CopyOnWriteArraySet.class, CopyOnWriteArraySet::new);
        DIRECT_CLASS_MAPPING.put(LinkedBlockingQueue.class, LinkedBlockingQueue::new);
        DIRECT_CLASS_MAPPING.put(LinkedBlockingDeque.class, LinkedBlockingDeque::new);
        DIRECT_CLASS_MAPPING.put(ConcurrentSkipListMap.class, ConcurrentSkipListMap::new);
        DIRECT_CLASS_MAPPING.put(ConcurrentSkipListSet.class, ConcurrentSkipListSet::new);
        DIRECT_CLASS_MAPPING.put(WeakHashMap.class, WeakHashMap::new);
        DIRECT_CLASS_MAPPING.put(IdentityHashMap.class, IdentityHashMap::new);
        DIRECT_CLASS_MAPPING.put(UUID.class, () -> new UUID(0L, 0L));
        DIRECT_CLASS_MAPPING.put(Currency.class, () -> {
            try {
                return Currency.getInstance(Locale.getDefault());
            }
            catch (Exception e) {
                return Currency.getInstance(Locale.US);
            }
        });
        DIRECT_CLASS_MAPPING.put(Pattern.class, () -> Pattern.compile(""));
        DIRECT_CLASS_MAPPING.put(BitSet.class, BitSet::new);
        DIRECT_CLASS_MAPPING.put(StringJoiner.class, () -> new StringJoiner(","));
        DIRECT_CLASS_MAPPING.put(Optional.class, Optional::empty);
        DIRECT_CLASS_MAPPING.put(OptionalInt.class, OptionalInt::empty);
        DIRECT_CLASS_MAPPING.put(OptionalLong.class, OptionalLong::empty);
        DIRECT_CLASS_MAPPING.put(OptionalDouble.class, OptionalDouble::empty);
        DIRECT_CLASS_MAPPING.put(Stream.class, Stream::empty);
        DIRECT_CLASS_MAPPING.put(IntStream.class, IntStream::empty);
        DIRECT_CLASS_MAPPING.put(LongStream.class, LongStream::empty);
        DIRECT_CLASS_MAPPING.put(DoubleStream.class, DoubleStream::empty);
        DIRECT_CLASS_MAPPING.put(boolean[].class, () -> new boolean[0]);
        DIRECT_CLASS_MAPPING.put(byte[].class, () -> new byte[0]);
        DIRECT_CLASS_MAPPING.put(short[].class, () -> new short[0]);
        DIRECT_CLASS_MAPPING.put(int[].class, () -> new int[0]);
        DIRECT_CLASS_MAPPING.put(long[].class, () -> new long[0]);
        DIRECT_CLASS_MAPPING.put(float[].class, () -> new float[0]);
        DIRECT_CLASS_MAPPING.put(double[].class, () -> new double[0]);
        DIRECT_CLASS_MAPPING.put(char[].class, () -> new char[0]);
        DIRECT_CLASS_MAPPING.put(Object[].class, () -> new Object[0]);
        DIRECT_CLASS_MAPPING.put(Boolean[].class, () -> new Boolean[0]);
        DIRECT_CLASS_MAPPING.put(Byte[].class, () -> new Byte[0]);
        DIRECT_CLASS_MAPPING.put(Short[].class, () -> new Short[0]);
        DIRECT_CLASS_MAPPING.put(Integer[].class, () -> new Integer[0]);
        DIRECT_CLASS_MAPPING.put(Long[].class, () -> new Long[0]);
        DIRECT_CLASS_MAPPING.put(Float[].class, () -> new Float[0]);
        DIRECT_CLASS_MAPPING.put(Double[].class, () -> new Double[0]);
        DIRECT_CLASS_MAPPING.put(Character[].class, () -> new Character[0]);
        ASSIGNABLE_CLASS_MAPPING.put(BlockingDeque.class, LinkedBlockingDeque::new);
        ASSIGNABLE_CLASS_MAPPING.put(Deque.class, ArrayDeque::new);
        ASSIGNABLE_CLASS_MAPPING.put(BlockingQueue.class, LinkedBlockingQueue::new);
        ASSIGNABLE_CLASS_MAPPING.put(Queue.class, LinkedList::new);
        ASSIGNABLE_CLASS_MAPPING.put(NavigableSet.class, TreeSet::new);
        ASSIGNABLE_CLASS_MAPPING.put(SortedSet.class, TreeSet::new);
        ASSIGNABLE_CLASS_MAPPING.put(Set.class, LinkedHashSet::new);
        ASSIGNABLE_CLASS_MAPPING.put(ConcurrentMap.class, ConcurrentHashMap::new);
        ASSIGNABLE_CLASS_MAPPING.put(NavigableMap.class, TreeMap::new);
        ASSIGNABLE_CLASS_MAPPING.put(SortedMap.class, TreeMap::new);
        ASSIGNABLE_CLASS_MAPPING.put(Map.class, LinkedHashMap::new);
        ASSIGNABLE_CLASS_MAPPING.put(List.class, ArrayList::new);
        ASSIGNABLE_CLASS_MAPPING.put(Collection.class, ArrayList::new);
        ASSIGNABLE_CLASS_MAPPING.put(ListIterator.class, () -> new ArrayList().listIterator());
        ASSIGNABLE_CLASS_MAPPING.put(Iterator.class, Collections::emptyIterator);
        ASSIGNABLE_CLASS_MAPPING.put(Enumeration.class, Collections::emptyEnumeration);
        ASSIGNABLE_CLASS_MAPPING.put(RandomAccess.class, ArrayList::new);
        ASSIGNABLE_CLASS_MAPPING.put(CharSequence.class, StringBuilder::new);
        ASSIGNABLE_CLASS_MAPPING.put(Cloneable.class, ArrayList::new);
        ASSIGNABLE_CLASS_MAPPING.put(AutoCloseable.class, () -> new ByteArrayInputStream(new byte[0]));
        ASSIGNABLE_CLASS_MAPPING.put(Iterable.class, ArrayList::new);
        BUILTIN_ALIASES.put("boolean", Boolean.TYPE);
        BUILTIN_ALIASES.put("char", Character.TYPE);
        BUILTIN_ALIASES.put("byte", Byte.TYPE);
        BUILTIN_ALIASES.put("short", Short.TYPE);
        BUILTIN_ALIASES.put("int", Integer.TYPE);
        BUILTIN_ALIASES.put("long", Long.TYPE);
        BUILTIN_ALIASES.put("float", Float.TYPE);
        BUILTIN_ALIASES.put("double", Double.TYPE);
        BUILTIN_ALIASES.put("void", Void.TYPE);
        BUILTIN_ALIASES.put("string", String.class);
        BUILTIN_ALIASES.put("date", Date.class);
        BUILTIN_ALIASES.put("class", Class.class);
        GLOBAL_ALIASES.putAll(BUILTIN_ALIASES);
        PRIMITIVE_TO_WRAPPER.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TO_WRAPPER.put(Long.TYPE, Long.class);
        PRIMITIVE_TO_WRAPPER.put(Double.TYPE, Double.class);
        PRIMITIVE_TO_WRAPPER.put(Float.TYPE, Float.class);
        PRIMITIVE_TO_WRAPPER.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TO_WRAPPER.put(Character.TYPE, Character.class);
        PRIMITIVE_TO_WRAPPER.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TO_WRAPPER.put(Short.TYPE, Short.class);
        PRIMITIVE_TO_WRAPPER.put(Void.TYPE, Void.class);
        WRAPPER_TO_PRIMITIVE.put(Boolean.class, Boolean.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Byte.class, Byte.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Character.class, Character.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Short.class, Short.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Integer.class, Integer.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Long.class, Long.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Float.class, Float.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Double.class, Double.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Void.class, Void.TYPE);
        HashMap tempPrimitiveWidening = new HashMap();
        HashMap<Class<Number>, Integer> byteWidening = new HashMap<Class<Number>, Integer>();
        byteWidening.put(Short.TYPE, 1);
        byteWidening.put(Integer.TYPE, 2);
        byteWidening.put(Long.TYPE, 3);
        byteWidening.put(Float.TYPE, 4);
        byteWidening.put(Double.TYPE, 5);
        tempPrimitiveWidening.put(Byte.TYPE, Collections.unmodifiableMap(byteWidening));
        HashMap<Class<Number>, Integer> shortWidening = new HashMap<Class<Number>, Integer>();
        shortWidening.put(Integer.TYPE, 1);
        shortWidening.put(Long.TYPE, 2);
        shortWidening.put(Float.TYPE, 3);
        shortWidening.put(Double.TYPE, 4);
        tempPrimitiveWidening.put(Short.TYPE, Collections.unmodifiableMap(shortWidening));
        HashMap<Class<Number>, Integer> charWidening = new HashMap<Class<Number>, Integer>();
        charWidening.put(Integer.TYPE, 1);
        charWidening.put(Long.TYPE, 2);
        charWidening.put(Float.TYPE, 3);
        charWidening.put(Double.TYPE, 4);
        tempPrimitiveWidening.put(Character.TYPE, Collections.unmodifiableMap(charWidening));
        HashMap<Class<Number>, Integer> intWidening = new HashMap<Class<Number>, Integer>();
        intWidening.put(Long.TYPE, 1);
        intWidening.put(Float.TYPE, 2);
        intWidening.put(Double.TYPE, 3);
        tempPrimitiveWidening.put(Integer.TYPE, Collections.unmodifiableMap(intWidening));
        HashMap<Class<Number>, Integer> longWidening = new HashMap<Class<Number>, Integer>();
        longWidening.put(Float.TYPE, 1);
        longWidening.put(Double.TYPE, 2);
        tempPrimitiveWidening.put(Long.TYPE, Collections.unmodifiableMap(longWidening));
        HashMap<Class<Double>, Integer> floatWidening = new HashMap<Class<Double>, Integer>();
        floatWidening.put(Double.TYPE, 1);
        tempPrimitiveWidening.put(Float.TYPE, Collections.unmodifiableMap(floatWidening));
        PRIMITIVE_WIDENING_DISTANCES = Collections.unmodifiableMap(tempPrimitiveWidening);
        ClassValueMap map = new ClassValueMap();
        map.putAll(PRIMITIVE_TO_WRAPPER);
        map.putAll(WRAPPER_TO_PRIMITIVE);
        wrapperMap = Collections.unmodifiableMap(map);
        ARG_PATTERN = Pattern.compile("arg\\d+");
        accessibilityCache = Collections.synchronizedMap(new WeakHashMap());
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.lang.reflect.InaccessibleObjectException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        INACCESSIBLE_OBJECT_EXCEPTION_CLASS = clazz;
        BLOCKED_CLASSES = new ClassValueSet();
        BLOCKED_CLASS_NAMES_SET = new HashSet<String>(SecurityChecker.SECURITY_BLOCKED_CLASS_NAMES);
        INHERITS_FROM_BLOCKED = new ClassValueSet();
        VERIFIED_SAFE_CLASSES = new ClassValueSet();
        BLOCKED_CLASSES.addAll(SecurityChecker.SECURITY_BLOCKED_CLASSES.toSet());
        SECURITY_CHECK_CACHE = new ClassValue<Boolean>(){

            @Override
            protected Boolean computeValue(Class<?> type) {
                if (BLOCKED_CLASSES.contains(type)) {
                    return Boolean.TRUE;
                }
                if (BLOCKED_CLASS_NAMES_SET.contains(type.getName())) {
                    return Boolean.TRUE;
                }
                if (INHERITS_FROM_BLOCKED.contains(type)) {
                    return Boolean.TRUE;
                }
                if (VERIFIED_SAFE_CLASSES.contains(type)) {
                    return Boolean.FALSE;
                }
                for (Class<?> superType : ClassUtilities.getClassHierarchyInfo(type).getAllSupertypes()) {
                    if (!BLOCKED_CLASSES.contains(superType)) continue;
                    INHERITS_FROM_BLOCKED.add(type);
                    return Boolean.TRUE;
                }
                VERIFIED_SAFE_CLASSES.add(type);
                return Boolean.FALSE;
            }
        };
    }

    private static final class LoaderCache {
        final ConcurrentMap<String, WeakReference<Class<?>>> cache = new ConcurrentHashMap(2048);
        final ReferenceQueue<Class<?>> queue = new ReferenceQueue();

        private LoaderCache() {
        }
    }

    private static final class NamedWeakRef
    extends WeakReference<Class<?>> {
        final String name;

        NamedWeakRef(String name, Class<?> referent, ReferenceQueue<Class<?>> q) {
            super(referent, q);
            this.name = name;
        }
    }

    public static class SecurityChecker {
        static final ClassValueSet SECURITY_BLOCKED_CLASSES = ClassValueSet.of(ClassLoader.class, ProcessBuilder.class, Process.class, Constructor.class, Method.class, Field.class, Runtime.class, System.class);
        static final Set<String> SECURITY_BLOCKED_CLASS_NAMES = new HashSet<String>(CollectionUtilities.listOf("java.lang.ProcessImpl", "java.lang.Runtime", "java.lang.ProcessBuilder", "java.lang.System", "javax.script.ScriptEngineManager", "javax.script.ScriptEngine", "java.lang.invoke.MethodHandles$Lookup"));

        public static boolean isSecurityBlocked(Class<?> clazz) {
            return (Boolean)SECURITY_CHECK_CACHE.get(clazz);
        }

        public static boolean isSecurityBlockedName(String className) {
            if (BLOCKED_CLASS_NAMES_SET.contains(className)) {
                return true;
            }
            return className.startsWith("javax.script.") || className.startsWith("jdk.nashorn.");
        }

        public static void verifyClass(Class<?> clazz) {
            if (SecurityChecker.isSecurityBlocked(clazz)) {
                throw new SecurityException("For security reasons, access to this class is not allowed: " + clazz.getName());
            }
        }
    }

    public static class ClassHierarchyInfo {
        private final Set<Class<?>> allSupertypes;
        private final Map<Class<?>, Integer> distanceMap;
        private final int depth;

        ClassHierarchyInfo(Set<Class<?>> supertypes, Map<Class<?>, Integer> distances) {
            this.allSupertypes = Collections.unmodifiableSet(supertypes);
            this.distanceMap = Collections.unmodifiableMap(distances);
            int max = 0;
            for (int d : distances.values()) {
                if (d <= max) continue;
                max = d;
            }
            this.depth = max;
        }

        public Map<Class<?>, Integer> getDistanceMap() {
            return this.distanceMap;
        }

        Set<Class<?>> getAllSupertypes() {
            return this.allSupertypes;
        }

        int getDistance(Class<?> type) {
            return this.distanceMap.getOrDefault(type, -1);
        }

        public int getDepth() {
            return this.depth;
        }
    }
}

