/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ByteUtilities;
import com.cedarsoftware.util.CaseInsensitiveMap;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.ClassValueMap;
import com.cedarsoftware.util.CollectionUtilities;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.EncryptionUtilities;
import com.cedarsoftware.util.MapUtilities;
import com.cedarsoftware.util.ReflectionUtils;
import com.cedarsoftware.util.StringUtilities;
import com.cedarsoftware.util.TrackingMap;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class CompactMap<K, V>
implements Map<K, V> {
    private static final String EMPTY_MAP = "_\ufe3f_\u03c8_\u263c";
    public static final String COMPACT_SIZE = "compactSize";
    public static final String CASE_SENSITIVE = "caseSensitive";
    public static final String MAP_TYPE = "mapType";
    public static final String SINGLE_KEY = "singleKey";
    public static final String SOURCE_MAP = "source";
    public static final String ORDERING = "ordering";
    public static final String UNORDERED = "unordered";
    public static final String SORTED = "sorted";
    public static final String INSERTION = "insertion";
    public static final String REVERSE = "reverse";
    public static final int DEFAULT_COMPACT_SIZE = 50;
    public static final boolean DEFAULT_CASE_SENSITIVE = true;
    public static final Class<? extends Map> DEFAULT_MAP_TYPE = HashMap.class;
    public static final String DEFAULT_SINGLE_KEY = "id";
    private static final Set<String> ALLOWED_MAP_PACKAGES = CollectionUtilities.setOf("java.util", "java.util.concurrent", "com.cedarsoftware.util", "com.cedarsoftware.io");
    private static final String INNER_MAP_TYPE = "innerMapType";
    private static final TemplateClassLoader templateClassLoader = new TemplateClassLoader(ClassUtilities.getClassLoader(CompactMap.class));
    private static final Map<String, ReentrantLock> CLASS_LOCKS = new ConcurrentHashMap<String, ReentrantLock>();
    private static final ClassValueMap<Boolean> LEGACY_CONSTRUCTED_CACHE = new ClassValueMap();
    protected Object val = "_\ufe3f_\u03c8_\u263c";

    private boolean getCachedLegacyConstructed() {
        Class<?> clazz = this.getClass();
        Boolean legacy = LEGACY_CONSTRUCTED_CACHE.get(clazz);
        if (legacy == null) {
            legacy = !clazz.getName().startsWith("com.cedarsoftware.util.CompactMap$");
            LEGACY_CONSTRUCTED_CACHE.put(clazz, legacy);
        }
        return legacy;
    }

    private static boolean isAllowedMapType(Class<?> mapType) {
        String name = mapType.getName();
        for (String prefix : ALLOWED_MAP_PACKAGES) {
            if (!name.startsWith(prefix + ".") && !name.equals(prefix)) continue;
            return true;
        }
        return false;
    }

    public CompactMap() {
        SortedMap sortedMap;
        Comparator comparator;
        Map<K, V> map;
        if (this.compactSize() < 2) {
            throw new IllegalArgumentException("compactSize() must be >= 2");
        }
        if (this.getClass() != CompactMap.class && this.getCachedLegacyConstructed() && (map = this.getNewMap()) instanceof SortedMap && (comparator = (sortedMap = (SortedMap)map).comparator()) == String.CASE_INSENSITIVE_ORDER && !this.isCaseInsensitive()) {
            throw new IllegalStateException("Inconsistent configuration: Map uses case-insensitive comparison but isCaseInsensitive() returns false");
        }
    }

    public CompactMap(Map<K, V> other) {
        this();
        this.putAll(other);
    }

    public boolean isDefaultCompactMap() {
        if (this.compactSize() != 50) {
            return false;
        }
        if (this.isCaseInsensitive()) {
            return false;
        }
        if (!UNORDERED.equals(this.getOrdering())) {
            return false;
        }
        if (!DEFAULT_SINGLE_KEY.equals(this.getSingleValueKey())) {
            return false;
        }
        return HashMap.class.equals(this.getNewMap().getClass());
    }

    @Override
    public int size() {
        if (this.val instanceof Object[]) {
            return ((Object[])this.val).length >> 1;
        }
        if (this.val instanceof Map) {
            return ((Map)this.val).size();
        }
        if (this.val == EMPTY_MAP) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return this.val == EMPTY_MAP;
    }

    private boolean areKeysEqual(Object key, Object aKey) {
        if (key instanceof String && aKey instanceof String) {
            return this.isCaseInsensitive() ? ((String)key).equalsIgnoreCase((String)aKey) : key.equals(aKey);
        }
        return Objects.equals(key, aKey);
    }

    private boolean isLegacyConstructed() {
        return !this.getClass().getName().startsWith("com.cedarsoftware.util.CompactMap$");
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.val instanceof Object[]) {
            Object[] entries = (Object[])this.val;
            String ordering = this.getOrdering();
            if (SORTED.equals(ordering) || REVERSE.equals(ordering)) {
                CompactMapComparator comp = new CompactMapComparator(this.isCaseInsensitive(), REVERSE.equals(ordering));
                return this.pairBinarySearch(entries, key, comp) >= 0;
            }
            int len = entries.length;
            for (int i = 0; i < len; i += 2) {
                if (!this.areKeysEqual(key, entries[i])) continue;
                return true;
            }
            return false;
        }
        if (this.val instanceof Map) {
            Map map = (Map)this.val;
            return map.containsKey(key);
        }
        if (this.val == EMPTY_MAP) {
            return false;
        }
        return this.areKeysEqual(key, this.getLogicalSingleKey());
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.val instanceof Object[]) {
            Object[] entries = (Object[])this.val;
            int len = entries.length;
            for (int i = 0; i < len; i += 2) {
                Object aValue = entries[i + 1];
                if (!Objects.equals(value, aValue)) continue;
                return true;
            }
            return false;
        }
        if (this.val instanceof Map) {
            Map map = (Map)this.val;
            return map.containsValue(value);
        }
        if (this.val == EMPTY_MAP) {
            return false;
        }
        return Objects.equals(this.getLogicalSingleValue(), value);
    }

    @Override
    public V get(Object key) {
        if (this.val instanceof Object[]) {
            Object[] entries = (Object[])this.val;
            String ordering = this.getOrdering();
            if (SORTED.equals(ordering) || REVERSE.equals(ordering)) {
                CompactMapComparator comp = new CompactMapComparator(this.isCaseInsensitive(), REVERSE.equals(ordering));
                int pairIdx = this.pairBinarySearch(entries, key, comp);
                return (V)(pairIdx >= 0 ? entries[pairIdx * 2 + 1] : null);
            }
            int len = entries.length;
            for (int i = 0; i < len; i += 2) {
                if (!this.areKeysEqual(key, entries[i])) continue;
                return (V)entries[i + 1];
            }
            return null;
        }
        if (this.val instanceof Map) {
            return ((Map)this.val).get(key);
        }
        if (this.val == EMPTY_MAP) {
            return null;
        }
        if (this.areKeysEqual(key, this.getLogicalSingleKey())) {
            return this.getLogicalSingleValue();
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        if (this.val instanceof Object[]) {
            return this.putInCompactArray((Object[])this.val, key, value);
        }
        if (this.val instanceof Map) {
            return ((Map)this.val).put(key, value);
        }
        if (this.val == EMPTY_MAP) {
            this.val = this.areKeysEqual(key, this.getSingleValueKey()) && !(value instanceof Map) && !(value instanceof Object[]) ? value : new CompactMapEntry(key, value);
            return null;
        }
        return this.handleSingleEntryPut(key, value);
    }

    @Override
    public V remove(Object key) {
        if (this.val instanceof Object[]) {
            return this.removeFromCompactArray(key);
        }
        if (this.val instanceof Map) {
            Map map = (Map)this.val;
            return this.removeFromMap(map, key);
        }
        if (this.val == EMPTY_MAP) {
            return null;
        }
        return this.handleSingleEntryRemove(key);
    }

    private int pairBinarySearch(Object[] arr, Object key, Comparator<Object> comp) {
        int low = 0;
        int high = arr.length / 2 - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Object midKey = arr[mid * 2];
            int cmp = comp.compare(key, midKey);
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private V putInCompactArray(Object[] entries, K key, V value) {
        int len = entries.length;
        String ordering = this.getOrdering();
        boolean binary = SORTED.equals(ordering) || REVERSE.equals(ordering);
        CompactMapComparator comp = null;
        int pairIndex = -1;
        if (binary) {
            comp = new CompactMapComparator(this.isCaseInsensitive(), REVERSE.equals(ordering));
            pairIndex = this.pairBinarySearch(entries, key, comp);
            if (pairIndex >= 0) {
                int vIdx = pairIndex * 2 + 1;
                Object oldValue = entries[vIdx];
                entries[vIdx] = value;
                return (V)oldValue;
            }
            pairIndex = -(pairIndex + 1);
        } else {
            for (int i = 0; i < len; i += 2) {
                if (!this.areKeysEqual(key, entries[i])) continue;
                int vIdx = i + 1;
                Object oldValue = entries[vIdx];
                entries[vIdx] = value;
                return (V)oldValue;
            }
        }
        if (this.size() < this.compactSize()) {
            Object[] expand = new Object[len + 2];
            if (binary) {
                int insert = pairIndex * 2;
                System.arraycopy(entries, 0, expand, 0, insert);
                expand[insert] = key;
                expand[insert + 1] = value;
                System.arraycopy(entries, insert, expand, insert + 2, len - insert);
            } else {
                System.arraycopy(entries, 0, expand, 0, len);
                expand[len] = key;
                expand[len + 1] = value;
            }
            this.val = expand;
        } else {
            this.switchToMap(entries, key, value);
        }
        return null;
    }

    private V removeFromCompactArray(Object key) {
        Object[] entries = (Object[])this.val;
        int pairCount = this.size();
        if (pairCount == 2) {
            return this.handleTransitionToSingleEntry(entries, key);
        }
        int len = entries.length;
        String ordering = this.getOrdering();
        boolean binary = SORTED.equals(ordering) || REVERSE.equals(ordering);
        int idx = -1;
        if (binary) {
            CompactMapComparator comp = new CompactMapComparator(this.isCaseInsensitive(), REVERSE.equals(ordering));
            int pairIdx = this.pairBinarySearch(entries, key, comp);
            if (pairIdx < 0) {
                return null;
            }
            idx = pairIdx * 2;
        } else {
            for (int i = 0; i < len; i += 2) {
                if (!this.areKeysEqual(key, entries[i])) continue;
                idx = i;
                break;
            }
            if (idx < 0) {
                return null;
            }
        }
        Object oldValue = entries[idx + 1];
        Object[] shrink = new Object[len - 2];
        if (idx > 0) {
            System.arraycopy(entries, 0, shrink, 0, idx);
        }
        if (idx + 2 < len) {
            System.arraycopy(entries, idx + 2, shrink, idx, len - idx - 2);
        }
        this.val = shrink;
        return (V)oldValue;
    }

    private void sortCompactArray(Object[] array) {
        int pairCount = array.length / 2;
        if (pairCount <= 1) {
            return;
        }
        if (this.getCachedLegacyConstructed()) {
            Map<K, V> mapInstance = this.getNewMap();
            if (mapInstance instanceof SortedMap) {
                Comparator legacyComp;
                String ordering = this.getOrdering();
                boolean reverse = REVERSE.equals(ordering);
                if (!reverse && (legacyComp = ((SortedMap)mapInstance).comparator()) != null) {
                    String name = legacyComp.getClass().getName().toLowerCase();
                    reverse = name.contains(REVERSE);
                }
                CompactMapComparator comparator = new CompactMapComparator(this.isCaseInsensitive(), reverse);
                this.quickSort(array, 0, pairCount - 1, comparator);
            }
            return;
        }
        String ordering = this.getOrdering();
        if (ordering.equals(UNORDERED) || ordering.equals(INSERTION)) {
            return;
        }
        CompactMapComparator comparator = new CompactMapComparator(this.isCaseInsensitive(), REVERSE.equals(ordering));
        this.quickSort(array, 0, pairCount - 1, comparator);
    }

    private void quickSort(Object[] array, int lowPair, int highPair, Comparator<Object> comparator) {
        if (lowPair < highPair) {
            int pivotPair = this.partition(array, lowPair, highPair, comparator);
            this.quickSort(array, lowPair, pivotPair - 1, comparator);
            this.quickSort(array, pivotPair + 1, highPair, comparator);
        }
    }

    private int partition(Object[] array, int lowPair, int highPair, Comparator<Object> comparator) {
        int low = lowPair * 2;
        int high = highPair * 2;
        int mid = low + (high - low) / 4 * 2;
        Object pivot = this.selectPivot(array, low, mid, high, comparator);
        int i = low - 2;
        for (int j = low; j < high; j += 2) {
            if (comparator.compare(array[j], pivot) > 0) continue;
            this.swapPairs(array, i += 2, j);
        }
        this.swapPairs(array, i += 2, high);
        return i / 2;
    }

    private Object selectPivot(Object[] array, int low, int mid, int high, Comparator<Object> comparator) {
        Object first = array[low];
        Object middle = array[mid];
        Object last = array[high];
        if (comparator.compare(first, middle) <= 0) {
            if (comparator.compare(middle, last) <= 0) {
                this.swapPairs(array, mid, high);
                return middle;
            }
            if (comparator.compare(first, last) <= 0) {
                return last;
            }
            this.swapPairs(array, low, high);
            return first;
        }
        if (comparator.compare(first, last) <= 0) {
            this.swapPairs(array, low, high);
            return first;
        }
        if (comparator.compare(middle, last) <= 0) {
            this.swapPairs(array, mid, high);
            return middle;
        }
        return last;
    }

    private void swapPairs(Object[] array, int i, int j) {
        Object tempKey = array[i];
        Object tempValue = array[i + 1];
        array[i] = array[j];
        array[i + 1] = array[j + 1];
        array[j] = tempKey;
        array[j + 1] = tempValue;
    }

    private void switchToMap(Object[] entries, K key, V value) {
        Map<Object, Object> map = this.getNewMap();
        int len = entries.length;
        for (int i = 0; i < len; i += 2) {
            map.put(entries[i], entries[i + 1]);
        }
        map.put(key, value);
        this.val = map;
    }

    private V handleTransitionToSingleEntry(Object[] entries, Object key) {
        if (this.areKeysEqual(key, entries[0])) {
            Object prevValue = entries[1];
            this.clear();
            this.put(entries[2], entries[3]);
            return (V)prevValue;
        }
        if (this.areKeysEqual(key, entries[2])) {
            Object prevValue = entries[3];
            this.clear();
            this.put(entries[0], entries[1]);
            return (V)prevValue;
        }
        return null;
    }

    private V handleSingleEntryPut(K key, V value) {
        if (this.areKeysEqual(key, this.getLogicalSingleKey())) {
            V save = this.getLogicalSingleValue();
            this.val = this.areKeysEqual(key, this.getSingleValueKey()) && !(value instanceof Map) && !(value instanceof Object[]) ? value : new CompactMapEntry(key, value);
            return save;
        }
        Object[] entries = new Object[]{this.getLogicalSingleKey(), this.getLogicalSingleValue()};
        this.val = entries;
        this.putInCompactArray(entries, key, value);
        return null;
    }

    private V handleSingleEntryRemove(Object key) {
        if (this.areKeysEqual(key, this.getLogicalSingleKey())) {
            V save = this.getLogicalSingleValue();
            this.clear();
            return save;
        }
        return null;
    }

    private V removeFromMap(Map<K, V> map, Object key) {
        if (!map.containsKey(key)) {
            return null;
        }
        V save = map.remove(key);
        if (map.size() == this.compactSize()) {
            Object[] entries = new Object[this.compactSize() * 2];
            int idx = 0;
            for (Map.Entry<K, V> entry : map.entrySet()) {
                entries[idx] = entry.getKey();
                entries[idx + 1] = entry.getValue();
                idx += 2;
            }
            this.val = entries;
        }
        return save;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int targetSize = this.size() + map.size();
        if (targetSize > this.compactSize()) {
            Map backingMap;
            if (this.val instanceof Map) {
                backingMap = (Map)this.val;
            } else {
                backingMap = this.getNewMap();
                if (this.val instanceof Object[]) {
                    Object[] entries = (Object[])this.val;
                    for (int i = 0; i < entries.length; i += 2) {
                        backingMap.put(entries[i], entries[i + 1]);
                    }
                } else if (this.val != EMPTY_MAP) {
                    backingMap.put(this.getLogicalSingleKey(), this.getLogicalSingleValue());
                }
                this.val = backingMap;
            }
            backingMap.putAll(map);
            return;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.val = EMPTY_MAP;
    }

    @Override
    public int hashCode() {
        if (this.val instanceof Object[]) {
            int h = 0;
            Object[] entries = (Object[])this.val;
            int len = entries.length;
            for (int i = 0; i < len; i += 2) {
                Object aKey = entries[i];
                Object aValue = entries[i + 1];
                h += this.computeKeyHashCode(aKey) ^ this.computeValueHashCode(aValue);
            }
            return h;
        }
        if (this.val instanceof Map) {
            return this.val.hashCode();
        }
        if (this.val == EMPTY_MAP) {
            return 0;
        }
        return this.computeKeyHashCode(this.getLogicalSingleKey()) ^ this.computeValueHashCode(this.getLogicalSingleValue());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.val instanceof Object[]) {
            for (Map.Entry entry : other.entrySet()) {
                Object thatKey = entry.getKey();
                if (!this.containsKey(thatKey)) {
                    return false;
                }
                Object thatValue = entry.getValue();
                V thisValue = this.get(thatKey);
                if (!(thatValue == null || thisValue == null ? thatValue != thisValue : !thisValue.equals(thatValue))) continue;
                return false;
            }
        } else {
            if (this.val instanceof Map) {
                Map map = (Map)this.val;
                return map.equals(other);
            }
            if (this.val == EMPTY_MAP) {
                return other.isEmpty();
            }
        }
        return this.entrySet().equals(other.entrySet());
    }

    public String toString() {
        return MapUtilities.mapToString(this);
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new CompactKeyIterator();
            }

            @Override
            public int size() {
                return CompactMap.this.size();
            }

            @Override
            public void clear() {
                CompactMap.this.clear();
            }

            @Override
            public boolean contains(Object o) {
                return CompactMap.this.containsKey(o);
            }

            @Override
            public boolean remove(Object o) {
                int size = this.size();
                CompactMap.this.remove(o);
                return this.size() != size;
            }

            @Override
            public boolean removeAll(Collection c) {
                int size = this.size();
                for (Object o : c) {
                    CompactMap.this.remove(o);
                }
                return this.size() != size;
            }

            @Override
            public boolean retainAll(Collection c) {
                Map other = CompactMap.this.getNewMap();
                for (Object o : c) {
                    other.put(o, null);
                }
                int size = this.size();
                CompactMap.this.keySet().removeIf(key -> !other.containsKey(key));
                return this.size() != size;
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new CompactValueIterator();
            }

            @Override
            public int size() {
                return CompactMap.this.size();
            }

            @Override
            public void clear() {
                CompactMap.this.clear();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new CompactEntryIterator();
            }

            @Override
            public int size() {
                return CompactMap.this.size();
            }

            @Override
            public void clear() {
                CompactMap.this.clear();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)o;
                    Object entryKey = entry.getKey();
                    Object value = CompactMap.this.get(entryKey);
                    if (value != null) {
                        return Objects.equals(value, entry.getValue());
                    }
                    if (CompactMap.this.containsKey(entryKey)) {
                        value = CompactMap.this.get(entryKey);
                        return Objects.equals(value, entry.getValue());
                    }
                }
                return false;
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                int size = this.size();
                Map.Entry that = (Map.Entry)o;
                CompactMap.this.remove(that.getKey());
                return this.size() != size;
            }

            @Override
            public boolean removeAll(Collection c) {
                int size = this.size();
                for (Object o : c) {
                    this.remove(o);
                }
                return this.size() != size;
            }

            @Override
            public boolean retainAll(Collection c) {
                CompactMap other = new CompactMap<K, V>(){

                    @Override
                    protected boolean isCaseInsensitive() {
                        return CompactMap.this.isCaseInsensitive();
                    }

                    @Override
                    protected int compactSize() {
                        return CompactMap.this.compactSize();
                    }

                    @Override
                    protected Map<K, V> getNewMap() {
                        return CompactMap.this.getNewMap();
                    }
                };
                for (Object o : c) {
                    if (!(o instanceof Map.Entry)) continue;
                    other.put(((Map.Entry)o).getKey(), ((Map.Entry)o).getValue());
                }
                int origSize = this.size();
                Iterator i = CompactMap.this.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (!other.containsKey(key)) {
                        i.remove();
                        continue;
                    }
                    Object v = other.get(key);
                    if (Objects.equals(v, value)) continue;
                    i.remove();
                }
                return this.size() != origSize;
            }
        };
    }

    @Deprecated
    public Map<K, V> minus(Object removeMe) {
        throw new UnsupportedOperationException("Unsupported operation [minus] or [-] between Maps.  Use removeAll() or retainAll() instead.");
    }

    @Deprecated
    public Map<K, V> plus(Object right) {
        throw new UnsupportedOperationException("Unsupported operation [plus] or [+] between Maps.  Use putAll() instead.");
    }

    public LogicalValueType getLogicalValueType() {
        if (this.val instanceof Object[]) {
            return LogicalValueType.ARRAY;
        }
        if (this.val instanceof Map) {
            return LogicalValueType.MAP;
        }
        if (this.val == EMPTY_MAP) {
            return LogicalValueType.EMPTY;
        }
        if (CompactMapEntry.class.isInstance(this.val)) {
            return LogicalValueType.ENTRY;
        }
        return LogicalValueType.OBJECT;
    }

    protected int computeKeyHashCode(Object key) {
        if (key instanceof String) {
            if (this.isCaseInsensitive()) {
                return StringUtilities.hashCodeIgnoreCase((String)key);
            }
            return key.hashCode();
        }
        if (key == null) {
            return 0;
        }
        return key == this ? 37 : key.hashCode();
    }

    protected int computeValueHashCode(Object value) {
        if (value == this) {
            return 17;
        }
        return value == null ? 0 : value.hashCode();
    }

    private K getLogicalSingleKey() {
        if (CompactMapEntry.class.isInstance(this.val)) {
            CompactMapEntry entry = (CompactMapEntry)this.val;
            return entry.getKey();
        }
        return this.getSingleValueKey();
    }

    private V getLogicalSingleValue() {
        if (CompactMapEntry.class.isInstance(this.val)) {
            CompactMapEntry entry = (CompactMapEntry)this.val;
            return entry.getValue();
        }
        return (V)this.val;
    }

    protected K getSingleValueKey() {
        return (K)DEFAULT_SINGLE_KEY;
    }

    protected Map<K, V> getNewMap() {
        return new HashMap();
    }

    protected boolean isCaseInsensitive() {
        return false;
    }

    protected int compactSize() {
        return 50;
    }

    protected String getOrdering() {
        return UNORDERED;
    }

    public Map<String, Object> getConfig() {
        LinkedHashMap<String, Object> config = new LinkedHashMap<String, Object>();
        int compSize = this.isLegacyConstructed() ? 50 : this.compactSize();
        config.put(COMPACT_SIZE, compSize);
        config.put(CASE_SENSITIVE, !this.isCaseInsensitive());
        config.put(ORDERING, this.getOrdering());
        config.put(SINGLE_KEY, this.getSingleValueKey());
        Map<K, V> map = this.getNewMap();
        if (map instanceof CaseInsensitiveMap) {
            map = ((CaseInsensitiveMap)map).getWrappedMap();
        }
        config.put(MAP_TYPE, map.getClass());
        return Collections.unmodifiableMap(config);
    }

    public CompactMap<K, V> withConfig(Map<String, Object> config) {
        String orderingToUse;
        Convention.throwIfNull(config, "config cannot be null");
        Builder<String, V> builder = CompactMap.builder();
        Integer configCompactSize = (Integer)config.get(COMPACT_SIZE);
        int compactSizeToUse = configCompactSize != null ? configCompactSize.intValue() : this.compactSize();
        builder.compactSize(compactSizeToUse);
        Boolean configCaseSensitive = (Boolean)config.get(CASE_SENSITIVE);
        boolean caseSensitiveToUse = configCaseSensitive != null ? configCaseSensitive : !this.isCaseInsensitive();
        builder.caseSensitive(caseSensitiveToUse);
        String configOrdering = (String)config.get(ORDERING);
        switch (orderingToUse = configOrdering != null ? configOrdering : this.getOrdering()) {
            case "sorted": {
                builder.sortedOrder();
                break;
            }
            case "reverse": {
                builder.reverseOrder();
                break;
            }
            case "insertion": {
                builder.insertionOrder();
                break;
            }
            default: {
                builder.noOrder();
            }
        }
        String thisSingleKeyValue = (String)this.getSingleValueKey();
        String configSingleKeyValue = (String)config.get(SINGLE_KEY);
        String priorityKey = configSingleKeyValue != null ? configSingleKeyValue : (thisSingleKeyValue != null ? thisSingleKeyValue : DEFAULT_SINGLE_KEY);
        builder.singleValueKey(priorityKey);
        Class<?> configMapType = (Class<?>)config.get(MAP_TYPE);
        Map<K, V> thisMap = this.getNewMap();
        Class<?> thisMapType = thisMap.getClass();
        if (thisMapType == CaseInsensitiveMap.class && thisMap instanceof CaseInsensitiveMap) {
            thisMapType = ((CaseInsensitiveMap)thisMap).getWrappedMap().getClass();
        }
        Class<?> mapTypeToUse = configMapType != null ? configMapType : thisMapType;
        builder.mapType(mapTypeToUse);
        CompactMap<K, V> newMap = builder.build();
        newMap.putAll(this);
        return newMap;
    }

    static <K, V> CompactMap<K, V> newMap(Map<String, Object> options) {
        if (!ReflectionUtils.isJavaCompilerAvailable()) {
            throw new IllegalStateException("CompactMap dynamic subclassing requires the Java Compiler (JDK). You are running on a JRE or in an environment where javax.tools.JavaCompiler is not available. Use CompactMap as-is, one of the pre-built subclasses, or provide your own subclass instead.");
        }
        CompactMap.validateAndFinalizeOptions(options);
        try {
            Class templateClass = TemplateGenerator.getOrCreateTemplateClass(options);
            CompactMap map = (CompactMap)templateClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Map source = (Map)options.get(SOURCE_MAP);
            if (source != null) {
                map.putAll(source);
            }
            return map;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to create CompactMap instance", e);
        }
    }

    static void validateAndFinalizeOptions(Map<String, Object> options) {
        String ordering = (String)options.getOrDefault(ORDERING, UNORDERED);
        int compactSize = (Integer)options.getOrDefault(COMPACT_SIZE, 50);
        if (compactSize < 2) {
            throw new IllegalArgumentException("compactSize must be >= 2");
        }
        Class<Map> mapType = CompactMap.determineMapType(options, ordering);
        if (!CompactMap.isAllowedMapType(mapType)) {
            throw new IllegalArgumentException("Map type " + mapType.getName() + " is not from an allowed package");
        }
        boolean caseSensitive = (Boolean)options.getOrDefault(CASE_SENSITIVE, true);
        options.put(MAP_TYPE, mapType);
        Map sourceMap = (Map)options.get(SOURCE_MAP);
        if (sourceMap != null) {
            String sourceOrdering = MapUtilities.detectMapOrdering(sourceMap);
            if (!(UNORDERED.equals(ordering) || UNORDERED.equals(sourceOrdering) || ordering.equals(sourceOrdering))) {
                throw new IllegalArgumentException("Requested ordering '" + ordering + "' conflicts with source map's ordering '" + sourceOrdering + "'. Map structure: " + MapUtilities.getMapStructureString(sourceMap));
            }
        }
        if (!(caseSensitive || SORTED.equals(ordering) || REVERSE.equals(ordering) || mapType == CaseInsensitiveMap.class)) {
            options.put(INNER_MAP_TYPE, mapType);
            options.put(MAP_TYPE, CaseInsensitiveMap.class);
        }
        options.putIfAbsent(COMPACT_SIZE, 50);
        options.putIfAbsent(CASE_SENSITIVE, true);
    }

    private static Class<? extends Map> determineMapType(Map<String, Object> options, String ordering) {
        boolean isValidForOrdering;
        Class rawMapType = (Class<LinkedHashMap>)options.get(MAP_TYPE);
        if (rawMapType != null) {
            if (IdentityHashMap.class.isAssignableFrom(rawMapType)) {
                throw new IllegalArgumentException("IdentityHashMap is not supported as it compares keys by reference identity");
            }
            if (WeakHashMap.class.isAssignableFrom(rawMapType)) {
                throw new IllegalArgumentException("WeakHashMap is not supported as it can unpredictably remove entries");
            }
        }
        if (rawMapType == null) {
            rawMapType = ordering.equals(INSERTION) ? LinkedHashMap.class : (ordering.equals(SORTED) || ordering.equals(REVERSE) ? TreeMap.class : DEFAULT_MAP_TYPE);
        } else if (options.get(ORDERING) == null) {
            ordering = LinkedHashMap.class.isAssignableFrom(rawMapType) || EnumMap.class.isAssignableFrom(rawMapType) ? INSERTION : (SortedMap.class.isAssignableFrom(rawMapType) ? (rawMapType.getName().toLowerCase().contains(REVERSE) || rawMapType.getName().toLowerCase().contains("descending") ? REVERSE : SORTED) : UNORDERED);
            options.put(ORDERING, ordering);
        }
        if (rawMapType != CompactMap.class && rawMapType != CaseInsensitiveMap.class && rawMapType != TrackingMap.class && !(isValidForOrdering = ordering.equals(INSERTION) ? LinkedHashMap.class.isAssignableFrom(rawMapType) || EnumMap.class.isAssignableFrom(rawMapType) : (ordering.equals(SORTED) || ordering.equals(REVERSE) ? SortedMap.class.isAssignableFrom(rawMapType) : true))) {
            throw new IllegalArgumentException("Map type " + rawMapType.getSimpleName() + " is not compatible with ordering '" + ordering + "'");
        }
        options.put(MAP_TYPE, rawMapType);
        if (rawMapType != null && !Map.class.isAssignableFrom(rawMapType)) {
            throw new IllegalArgumentException("mapType must be a Map class");
        }
        return rawMapType;
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    private static final class TemplateClassLoader
    extends ClassLoader {
        private final Map<String, WeakReference<Class<?>>> definedClasses = new ConcurrentHashMap();
        private final Map<String, ReentrantLock> classLoadLocks = new ConcurrentHashMap<String, ReentrantLock>();

        private TemplateClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.getParent().loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    c = this.findClass(name);
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Class<?> defineTemplateClass(String name, byte[] bytes) {
            ReentrantLock lock = this.classLoadLocks.computeIfAbsent(name, k -> new ReentrantLock());
            lock.lock();
            try {
                WeakReference<Class<?>> cachedRef = this.definedClasses.get(name);
                if (cachedRef != null) {
                    Class cached = (Class)cachedRef.get();
                    if (cached != null) {
                        Class clazz = cached;
                        return clazz;
                    }
                    this.definedClasses.remove(name);
                }
                Class<?> definedClass = this.defineClass(name, bytes, 0, bytes.length);
                this.definedClasses.put(name, new WeakReference(definedClass));
                Class<?> clazz = definedClass;
                return clazz;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (name.startsWith("com.cedarsoftware.util.CompactMap$")) {
                WeakReference<Class<?>> cachedRef = this.definedClasses.get(name);
                if (cachedRef != null) {
                    Class cached = (Class)cachedRef.get();
                    if (cached != null) {
                        return cached;
                    }
                    this.definedClasses.remove(name);
                }
                throw new ClassNotFoundException("Not found: " + name);
            }
            return super.findClass(name);
        }
    }

    public static class CompactMapComparator
    implements Comparator<Object> {
        private final boolean caseInsensitive;
        private final boolean reverse;

        public CompactMapComparator(boolean caseInsensitive, boolean reverse) {
            this.caseInsensitive = caseInsensitive;
            this.reverse = reverse;
        }

        @Override
        public int compare(Object key1, Object key2) {
            if (key1 == null) {
                return key2 == null ? 0 : 1;
            }
            if (key2 == null) {
                return -1;
            }
            Class<?> key1Class = key1.getClass();
            Class<?> key2Class = key2.getClass();
            int result = key1Class == String.class ? (key2Class == String.class ? (this.caseInsensitive ? String.CASE_INSENSITIVE_ORDER.compare((String)key1, (String)key2) : ((String)key1).compareTo((String)key2)) : key1Class.getName().compareTo(key2Class.getName())) : (key1Class == key2Class && key1 instanceof Comparable ? ((Comparable)key1).compareTo(key2) : key1Class.getName().compareTo(key2Class.getName()));
            return this.reverse ? -result : result;
        }

        public String toString() {
            return "CompactMapComparator{caseInsensitive=" + this.caseInsensitive + ", reverse=" + this.reverse + "}";
        }
    }

    public class CompactMapEntry
    extends AbstractMap.SimpleEntry<K, V> {
        public CompactMapEntry(K key, V value) {
            super(key, value);
        }

        @Override
        public V setValue(V value) {
            Object save = this.getValue();
            super.setValue(value);
            CompactMap.this.put(this.getKey(), value);
            return save;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            Map.Entry e = (Map.Entry)o;
            return CompactMap.this.areKeysEqual(this.getKey(), e.getKey()) && Objects.equals(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            return CompactMap.this.computeKeyHashCode(this.getKey()) ^ CompactMap.this.computeValueHashCode(this.getValue());
        }
    }

    public static enum LogicalValueType {
        EMPTY,
        OBJECT,
        ENTRY,
        MAP,
        ARRAY;

    }

    public static final class Builder<K, V> {
        private final Map<String, Object> options = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder<K, V> caseSensitive(boolean caseSensitive) {
            this.options.put(CompactMap.CASE_SENSITIVE, caseSensitive);
            return this;
        }

        public Builder<K, V> mapType(Class<? extends Map> mapType) {
            if (!Map.class.isAssignableFrom(mapType)) {
                throw new IllegalArgumentException("mapType must be a Map class");
            }
            if (!CompactMap.isAllowedMapType(mapType)) {
                throw new IllegalArgumentException("Map type " + mapType.getName() + " is not from an allowed package");
            }
            this.options.put(CompactMap.MAP_TYPE, mapType);
            return this;
        }

        public Builder<K, V> singleValueKey(K key) {
            if (key == null) {
                throw new IllegalArgumentException("Single value key cannot be null");
            }
            String keyStr = String.valueOf(key);
            if (keyStr.length() > 50) {
                throw new IllegalArgumentException("Single value key is too long (max 50 characters): " + keyStr.length());
            }
            this.options.put(CompactMap.SINGLE_KEY, key);
            return this;
        }

        public Builder<K, V> compactSize(int size) {
            if (size < 2) {
                throw new IllegalArgumentException("Compact size must be >= 2, got: " + size);
            }
            this.options.put(CompactMap.COMPACT_SIZE, size);
            return this;
        }

        public Builder<K, V> sortedOrder() {
            this.options.put(CompactMap.ORDERING, CompactMap.SORTED);
            return this;
        }

        public Builder<K, V> reverseOrder() {
            this.options.put(CompactMap.ORDERING, CompactMap.REVERSE);
            return this;
        }

        public Builder<K, V> insertionOrder() {
            this.options.put(CompactMap.ORDERING, CompactMap.INSERTION);
            return this;
        }

        public Builder<K, V> noOrder() {
            this.options.put(CompactMap.ORDERING, CompactMap.UNORDERED);
            return this;
        }

        public Builder<K, V> sourceMap(Map<K, V> source) {
            if (source == null) {
                throw new IllegalArgumentException("Source map cannot be null");
            }
            this.options.put(CompactMap.SOURCE_MAP, source);
            return this;
        }

        public CompactMap<K, V> build() {
            if (!ReflectionUtils.isJavaCompilerAvailable()) {
                throw new IllegalStateException("CompactMap builder pattern requires the Java Compiler (JDK). You are running on a JRE or in an environment where javax.tools.JavaCompiler is not available. Use CompactMap as-is, one of the pre-built subclasses, or provide your own subclass instead.");
            }
            return CompactMap.newMap(this.options);
        }
    }

    private static final class TemplateGenerator {
        private static final String TEMPLATE_CLASS_PREFIX = "com.cedarsoftware.util.CompactMap$";
        private static final String CLASS_NAME_PLACEHOLDER = "0000000000000000";
        private static final byte[] PLACEHOLDER_BYTES = "0000000000000000".getBytes(StandardCharsets.UTF_8);
        private static final String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
        private static final byte[] templateBytecode = ByteUtilities.decode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

        private TemplateGenerator() {
        }

        private static Class<?> getOrCreateTemplateClass(Map<String, Object> options) {
            String className = TemplateGenerator.generateClassName(options);
            try {
                return ClassUtilities.getClassLoader(CompactMap.class).loadClass(className);
            }
            catch (ClassNotFoundException e) {
                return TemplateGenerator.generateTemplateClass(options);
            }
        }

        private static String generateClassName(Map<String, Object> options) {
            StringBuilder configBuilder = new StringBuilder();
            Object mapTypeObj = options.get(CompactMap.MAP_TYPE);
            String mapTypeName = mapTypeObj instanceof Class ? ((Class)mapTypeObj).getName() : String.valueOf(mapTypeObj);
            configBuilder.append("mt:").append(mapTypeName).append(";");
            boolean caseSensitive = (Boolean)options.getOrDefault(CompactMap.CASE_SENSITIVE, true);
            configBuilder.append("cs:").append(caseSensitive).append(";");
            int compactSize = (Integer)options.getOrDefault(CompactMap.COMPACT_SIZE, 50);
            configBuilder.append("sz:").append(compactSize).append(";");
            String singleKey = (String)options.getOrDefault(CompactMap.SINGLE_KEY, CompactMap.DEFAULT_SINGLE_KEY);
            configBuilder.append("sk:").append(singleKey).append(";");
            String ordering = (String)options.getOrDefault(CompactMap.ORDERING, CompactMap.UNORDERED);
            configBuilder.append("or:").append(ordering);
            String fullHash = EncryptionUtilities.calculateSHA1Hash(configBuilder.toString().getBytes(StandardCharsets.UTF_8));
            String hash16 = fullHash.substring(0, 16).toLowerCase();
            return TEMPLATE_CLASS_PREFIX + hash16;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Class<?> generateTemplateClass(Map<String, Object> options) {
            String className = TemplateGenerator.generateClassName(options);
            String classNameSuffix = className.substring(TEMPLATE_CLASS_PREFIX.length());
            ReentrantLock lock = CLASS_LOCKS.computeIfAbsent(className, k -> new ReentrantLock());
            lock.lock();
            try {
                Class<?> clazz = ClassUtilities.getClassLoader(CompactMap.class).loadClass(className);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                byte[] patchedBytecode = TemplateGenerator.patchBytecode(classNameSuffix);
                Class<?> templateClass = TemplateGenerator.defineClass(className, patchedBytecode);
                TemplateGenerator.injectStaticFields(templateClass, options);
                Class<?> clazz = templateClass;
                return clazz;
            }
            finally {
                lock.unlock();
            }
        }

        private static byte[] patchBytecode(String classNameSuffix) {
            if (classNameSuffix.length() != 16) {
                throw new IllegalArgumentException("Class name suffix must be exactly 16 characters: " + classNameSuffix);
            }
            byte[] patched = (byte[])templateBytecode.clone();
            byte[] replacement = classNameSuffix.getBytes(StandardCharsets.UTF_8);
            int idx = 0;
            while ((idx = ByteUtilities.indexOf(patched, PLACEHOLDER_BYTES, idx)) != -1) {
                System.arraycopy(replacement, 0, patched, idx, replacement.length);
                idx += replacement.length;
            }
            return patched;
        }

        private static void injectStaticFields(Class<?> clazz, Map<String, Object> options) {
            List<Field> staticFields = ReflectionUtils.getDeclaredFields(clazz, field -> Modifier.isStatic(field.getModifiers()));
            HashMap<String, Field> fieldMap = new HashMap<String, Field>();
            for (Field field2 : staticFields) {
                fieldMap.put(field2.getName(), field2);
            }
            try {
                ((Field)fieldMap.get("_caseSensitive")).setBoolean(null, (Boolean)options.getOrDefault(CompactMap.CASE_SENSITIVE, true));
                ((Field)fieldMap.get("_compactSize")).setInt(null, (Integer)options.getOrDefault(CompactMap.COMPACT_SIZE, 50));
                ((Field)fieldMap.get("_singleKey")).set(null, options.getOrDefault(CompactMap.SINGLE_KEY, CompactMap.DEFAULT_SINGLE_KEY));
                ((Field)fieldMap.get("_ordering")).set(null, options.getOrDefault(CompactMap.ORDERING, CompactMap.UNORDERED));
                Class<? extends Map> mapTypeObj = options.getOrDefault(CompactMap.MAP_TYPE, DEFAULT_MAP_TYPE);
                String mapClassName = mapTypeObj instanceof Class ? mapTypeObj.getName() : String.valueOf(mapTypeObj);
                ((Field)fieldMap.get("_mapClassName")).set(null, mapClassName);
                Object innerMapTypeObj = options.get(CompactMap.INNER_MAP_TYPE);
                String innerMapClassName = innerMapTypeObj instanceof Class ? ((Class)innerMapTypeObj).getName() : (innerMapTypeObj != null ? String.valueOf(innerMapTypeObj) : null);
                ((Field)fieldMap.get("_innerMapClassName")).set(null, innerMapClassName);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Failed to inject static fields into generated class", e);
            }
        }

        private static Class<?> defineClass(String className, byte[] classBytes) {
            return templateClassLoader.defineTemplateClass(className, classBytes);
        }
    }

    final class CompactEntryIterator
    extends CompactIterator
    implements Iterator<Map.Entry<K, V>> {
        CompactEntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            this.advance();
            if (this.mapIterator != null) {
                return (Map.Entry)this.current;
            }
            if (this.expectedSize == 1) {
                if (CompactMap.this.val instanceof CompactMapEntry) {
                    return (CompactMapEntry)CompactMap.this.val;
                }
                return new CompactMapEntry(CompactMap.this.getLogicalSingleKey(), CompactMap.this.getLogicalSingleValue());
            }
            Object[] objs = (Object[])CompactMap.this.val;
            return new CompactMapEntry(objs[this.index * 2], objs[this.index * 2 + 1]);
        }
    }

    final class CompactValueIterator
    extends CompactIterator
    implements Iterator<V> {
        CompactValueIterator() {
        }

        @Override
        public V next() {
            this.advance();
            if (this.mapIterator != null) {
                return ((Map.Entry)this.current).getValue();
            }
            if (this.expectedSize == 1) {
                return CompactMap.this.getLogicalSingleValue();
            }
            return ((Object[])CompactMap.this.val)[this.index * 2 + 1];
        }
    }

    final class CompactKeyIterator
    extends CompactIterator
    implements Iterator<K> {
        CompactKeyIterator() {
        }

        @Override
        public K next() {
            this.advance();
            if (this.mapIterator != null) {
                return ((Map.Entry)this.current).getKey();
            }
            return this.current;
        }
    }

    abstract class CompactIterator {
        Iterator<Map.Entry<K, V>> mapIterator;
        Object current;
        int expectedSize;
        int index;

        CompactIterator() {
            this.expectedSize = CompactMap.this.size();
            this.current = CompactMap.EMPTY_MAP;
            this.index = -1;
            if (CompactMap.this.val instanceof Object[]) {
                CompactMap.this.sortCompactArray((Object[])CompactMap.this.val);
            } else if (CompactMap.this.val instanceof Map) {
                this.mapIterator = ((Map)CompactMap.this.val).entrySet().iterator();
            } else if (CompactMap.this.val == CompactMap.EMPTY_MAP) {
                // empty if block
            }
        }

        public final boolean hasNext() {
            if (CompactMap.this.val instanceof Object[]) {
                return this.index + 1 < CompactMap.this.size();
            }
            if (CompactMap.this.val instanceof Map) {
                return this.mapIterator.hasNext();
            }
            if (CompactMap.this.val == CompactMap.EMPTY_MAP) {
                return false;
            }
            return this.index < 0;
        }

        final void advance() {
            if (this.expectedSize != CompactMap.this.size()) {
                throw new ConcurrentModificationException();
            }
            if (++this.index >= CompactMap.this.size()) {
                throw new NoSuchElementException();
            }
            if (CompactMap.this.val instanceof Object[]) {
                this.current = ((Object[])CompactMap.this.val)[this.index * 2];
            } else if (CompactMap.this.val instanceof Map) {
                this.current = this.mapIterator.next();
            } else {
                if (CompactMap.this.val == CompactMap.EMPTY_MAP) {
                    throw new NoSuchElementException();
                }
                this.current = CompactMap.this.getLogicalSingleKey();
            }
        }

        public final void remove() {
            if (this.current == CompactMap.EMPTY_MAP) {
                throw new IllegalStateException();
            }
            if (CompactMap.this.size() != this.expectedSize) {
                throw new ConcurrentModificationException();
            }
            int newSize = this.expectedSize - 1;
            if (this.mapIterator != null && newSize == CompactMap.this.compactSize()) {
                this.current = ((Map.Entry)this.current).getKey();
                this.mapIterator = null;
            }
            if (this.mapIterator == null) {
                CompactMap.this.remove(this.current);
            } else {
                this.mapIterator.remove();
            }
            --this.index;
            this.current = CompactMap.EMPTY_MAP;
            --this.expectedSize;
        }
    }
}

