/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.cache.LockingLRUCacheStrategy;
import com.cedarsoftware.util.cache.ThreadedLRUCacheStrategy;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class LRUCache<K, V>
implements Map<K, V> {
    private final Map<K, V> strategy;

    public LRUCache(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity must be at least 1.");
        }
        this.strategy = new LockingLRUCacheStrategy(capacity);
    }

    public LRUCache(int capacity, StrategyType strategyType) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity must be at least 1.");
        }
        if (strategyType == StrategyType.THREADED) {
            this.strategy = new ThreadedLRUCacheStrategy(capacity);
        } else if (strategyType == StrategyType.LOCKING) {
            this.strategy = new LockingLRUCacheStrategy(capacity);
        } else {
            throw new IllegalArgumentException("Unsupported strategy type: " + (Object)((Object)strategyType));
        }
    }

    @Deprecated
    public LRUCache(int capacity, int cleanupDelayMillis) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity must be at least 1.");
        }
        this.strategy = new ThreadedLRUCacheStrategy(capacity);
    }

    public int getCapacity() {
        if (this.strategy instanceof ThreadedLRUCacheStrategy) {
            return ((ThreadedLRUCacheStrategy)this.strategy).getCapacity();
        }
        return ((LockingLRUCacheStrategy)this.strategy).getCapacity();
    }

    @Override
    public V get(Object key) {
        return this.strategy.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.strategy.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.strategy.putAll(m);
    }

    @Override
    public V remove(Object key) {
        return this.strategy.remove(key);
    }

    @Override
    public void clear() {
        this.strategy.clear();
    }

    @Override
    public int size() {
        return this.strategy.size();
    }

    @Override
    public boolean isEmpty() {
        return this.strategy.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.strategy.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.strategy.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.strategy.entrySet();
    }

    @Override
    public Set<K> keySet() {
        return this.strategy.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.strategy.values();
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.strategy.computeIfAbsent((K)key, mappingFunction);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.strategy.putIfAbsent(key, value);
    }

    public String toString() {
        return this.strategy.toString();
    }

    @Override
    public int hashCode() {
        return this.strategy.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        return this.strategy.equals(other);
    }

    public void shutdown() {
        if (this.strategy instanceof ThreadedLRUCacheStrategy) {
            ((ThreadedLRUCacheStrategy)this.strategy).shutdown();
        }
    }

    public static enum StrategyType {
        THREADED,
        LOCKING;

    }
}

