/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ByteUtilities;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.Converter;
import com.cedarsoftware.util.MathUtilities;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;

public final class StringUtilities {
    public static final String FOLDER_SEPARATOR = File.separator;
    public static final String EMPTY = "";

    private static boolean isSecurityEnabled() {
        return Boolean.parseBoolean(System.getProperty("stringutilities.security.enabled", "false"));
    }

    private static int getMaxHexDecodeSize() {
        try {
            return Converter.convert(System.getProperty("stringutilities.max.hex.decode.size", "0"), Integer.TYPE);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static int getMaxWildcardLength() {
        try {
            return Converter.convert(System.getProperty("stringutilities.max.wildcard.length", "0"), Integer.TYPE);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static int getMaxWildcardCount() {
        try {
            return Converter.convert(System.getProperty("stringutilities.max.wildcard.count", "0"), Integer.TYPE);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static int getMaxLevenshteinStringLength() {
        try {
            return Converter.convert(System.getProperty("stringutilities.max.levenshtein.string.length", "0"), Integer.TYPE);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static int getMaxDamerauLevenshteinStringLength() {
        try {
            return Converter.convert(System.getProperty("stringutilities.max.damerau.levenshtein.string.length", "0"), Integer.TYPE);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static int getMaxRepeatCount() {
        try {
            return Converter.convert(System.getProperty("stringutilities.max.repeat.count", "0"), Integer.TYPE);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static int getMaxRepeatTotalSize() {
        try {
            return Converter.convert(System.getProperty("stringutilities.max.repeat.total.size", "0"), Integer.TYPE);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private StringUtilities() {
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1.length() != cs2.length()) {
            return false;
        }
        if (cs1 instanceof String) {
            return ((String)cs1).contentEquals(cs2);
        }
        if (cs2 instanceof String) {
            return ((String)cs2).contentEquals(cs1);
        }
        int length = cs1.length();
        for (int i = 0; i < length; ++i) {
            if (cs1.charAt(i) == cs2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(String s1, String s2) {
        return StringUtilities.equals((CharSequence)s1, (CharSequence)s2);
    }

    public static boolean equalsIgnoreCase(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        int n = cs1.length();
        if (n != cs2.length()) {
            return false;
        }
        if (cs1 instanceof String && cs2 instanceof String) {
            return ((String)cs1).equalsIgnoreCase((String)cs2);
        }
        return StringUtilities.regionEqualsIgnoreCase(cs1, 0, cs2, 0, n);
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        return StringUtilities.equalsIgnoreCase((CharSequence)s1, (CharSequence)s2);
    }

    public static boolean containsIgnoreCase(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        if (s2.isEmpty()) {
            return true;
        }
        if (s1.length() < s2.length()) {
            return false;
        }
        int searchLen = s2.length();
        int maxIndex = s1.length() - searchLen;
        for (int i = 0; i <= maxIndex; ++i) {
            if (!s1.regionMatches(true, i, s2, 0, searchLen)) continue;
            return true;
        }
        return false;
    }

    static boolean regionMatches(CharSequence cs, boolean ignoreCase, int thisStart, CharSequence substring, int start, int length) {
        Convention.throwIfNull(cs, "cs to be processed cannot be null");
        Convention.throwIfNull(substring, "substring cannot be null");
        if (cs instanceof String && substring instanceof String) {
            return ((String)cs).regionMatches(ignoreCase, thisStart, (String)substring, start, length);
        }
        if (thisStart < 0 || start < 0 || length < 0) {
            return false;
        }
        if (cs.length() - thisStart < length || substring.length() - start < length) {
            return false;
        }
        if (length == 0) {
            return true;
        }
        if (!ignoreCase) {
            for (int i = 0; i < length; ++i) {
                if (cs.charAt(thisStart + i) == substring.charAt(start + i)) continue;
                return false;
            }
            return true;
        }
        return StringUtilities.regionEqualsIgnoreCase(cs, thisStart, substring, start, length);
    }

    private static boolean regionEqualsIgnoreCase(CharSequence a, int aOff, CharSequence b, int bOff, int len) {
        int i = 0;
        while (i < len) {
            char c2;
            char c1 = a.charAt(aOff + i);
            if (c1 == (c2 = b.charAt(bOff + i))) {
                ++i;
                continue;
            }
            if ((c1 | c2) >= 128) {
                return StringUtilities.regionEqualsIgnoreCaseSlow(a, aOff + i, b, bOff + i, len - i);
            }
            if (c1 - 65 <= 25) {
                c1 = (char)(c1 + 32);
            }
            if (c2 - 65 <= 25) {
                c2 = (char)(c2 + 32);
            }
            if (c1 != c2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean regionEqualsIgnoreCaseSlow(CharSequence a, int aOff, CharSequence b, int bOff, int len) {
        for (int i = 0; i < len; ++i) {
            char u2;
            char u1;
            char c2;
            char c1 = a.charAt(aOff + i);
            if (c1 == (c2 = b.charAt(bOff + i)) || (u1 = Character.toUpperCase(c1)) == (u2 = Character.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsWithTrim(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.trim().equals(s2.trim());
    }

    public static boolean equalsIgnoreCaseWithTrim(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.trim().equalsIgnoreCase(s2.trim());
    }

    public static boolean isEmpty(CharSequence cs) {
        return StringUtilities.isWhitespace(cs);
    }

    public static boolean isEmpty(String s) {
        return StringUtilities.isWhitespace(s);
    }

    public static boolean isWhitespace(CharSequence cs) {
        int strLen = StringUtilities.length(cs);
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasContent(String s) {
        return !StringUtilities.isWhitespace(s);
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static int length(String s) {
        return s == null ? 0 : s.length();
    }

    public static int trimLength(String s) {
        return StringUtilities.trimToEmpty(s).length();
    }

    public static int lastIndexOf(String path, char ch) {
        if (path == null) {
            return -1;
        }
        return path.lastIndexOf(ch);
    }

    public static byte[] decode(String s) {
        int maxSize;
        if (s == null) {
            return null;
        }
        if (StringUtilities.isSecurityEnabled() && (maxSize = StringUtilities.getMaxHexDecodeSize()) > 0 && s.length() > maxSize) {
            throw new IllegalArgumentException("Input string too long for hex decoding (max " + maxSize + "): " + s.length());
        }
        int len = s.length();
        if (len % 2 != 0) {
            return null;
        }
        byte[] bytes = new byte[len / 2];
        int pos = 0;
        for (int i = 0; i < len; i += 2) {
            int hi = Character.digit(s.charAt(i), 16);
            int lo = Character.digit(s.charAt(i + 1), 16);
            if (hi == -1 || lo == -1) {
                return null;
            }
            bytes[pos++] = (byte)((hi << 4) + lo);
        }
        return bytes;
    }

    public static String encode(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length << 1);
        for (byte aByte : bytes) {
            sb.append(StringUtilities.convertDigit(aByte >> 4));
            sb.append(StringUtilities.convertDigit(aByte & 0xF));
        }
        return sb.toString();
    }

    private static char convertDigit(int value) {
        return ByteUtilities.HEX_ARRAY[value & 0xF];
    }

    public static int count(String s, char c) {
        if (s == null) {
            return 0;
        }
        int answer = 0;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (s.charAt(i) != c) continue;
            ++answer;
        }
        return answer;
    }

    public static int count(CharSequence content, CharSequence token) {
        if (content == null || token == null) {
            return 0;
        }
        int contentLen = content.length();
        int tokenLen = token.length();
        if (contentLen == 0 || tokenLen == 0) {
            return 0;
        }
        int answer = 0;
        int idx = 0;
        while (idx <= contentLen - tokenLen) {
            boolean match = true;
            for (int i = 0; i < tokenLen; ++i) {
                if (content.charAt(idx + i) == token.charAt(i)) continue;
                match = false;
                break;
            }
            if (match) {
                ++answer;
                idx += tokenLen;
                continue;
            }
            ++idx;
        }
        return answer;
    }

    public static String wildcardToRegexString(String wildcard) {
        if (wildcard == null) {
            throw new IllegalArgumentException("Wildcard pattern cannot be null");
        }
        if (StringUtilities.isSecurityEnabled()) {
            int maxLength = StringUtilities.getMaxWildcardLength();
            if (maxLength > 0 && wildcard.length() > maxLength) {
                throw new IllegalArgumentException("Wildcard pattern too long (max " + maxLength + " characters): " + wildcard.length());
            }
            int maxCount = StringUtilities.getMaxWildcardCount();
            if (maxCount > 0) {
                int wildcardCount = 0;
                for (int i = 0; i < wildcard.length(); ++i) {
                    if (wildcard.charAt(i) != '*' && wildcard.charAt(i) != '?' || ++wildcardCount <= maxCount) continue;
                    throw new IllegalArgumentException("Too many wildcards in pattern (max " + maxCount + "): " + wildcardCount);
                }
            }
        }
        int len = wildcard.length();
        StringBuilder s = new StringBuilder(len);
        s.append('^');
        block6: for (int i = 0; i < len; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    continue block6;
                }
                case '?': {
                    s.append('.');
                    continue block6;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append('\\');
                    s.append(c);
                    continue block6;
                }
                default: {
                    s.append(c);
                }
            }
        }
        s.append('$');
        return s.toString();
    }

    public static int levenshteinDistance(CharSequence s, CharSequence t) {
        int maxLength;
        if (StringUtilities.isSecurityEnabled() && (maxLength = StringUtilities.getMaxLevenshteinStringLength()) > 0) {
            if (s != null && s.length() > maxLength) {
                throw new IllegalArgumentException("First string too long for distance calculation (max " + maxLength + "): " + s.length());
            }
            if (t != null && t.length() > maxLength) {
                throw new IllegalArgumentException("Second string too long for distance calculation (max " + maxLength + "): " + t.length());
            }
        }
        if (s == null || EMPTY.contentEquals(s)) {
            return t == null || EMPTY.contentEquals(t) ? 0 : t.length();
        }
        if (t == null || EMPTY.contentEquals(t)) {
            return s.length();
        }
        int[] v0 = new int[t.length() + 1];
        int[] v1 = new int[t.length() + 1];
        for (int i = 0; i < v0.length; ++i) {
            v0[i] = i;
        }
        int sLen = s.length();
        int tLen = t.length();
        for (int i = 0; i < sLen; ++i) {
            v1[0] = i + 1;
            for (int j = 0; j < tLen; ++j) {
                int cost = s.charAt(i) == t.charAt(j) ? 0 : 1;
                v1[j + 1] = (int)MathUtilities.minimum(new long[]{v1[j] + 1, v0[j + 1] + 1, v0[j] + cost});
            }
            System.arraycopy(v1, 0, v0, 0, v0.length);
        }
        return v1[t.length()];
    }

    public static int damerauLevenshteinDistance(CharSequence source, CharSequence target) {
        int srcIndex;
        int maxLength;
        if (StringUtilities.isSecurityEnabled() && (maxLength = StringUtilities.getMaxDamerauLevenshteinStringLength()) > 0) {
            if (source != null && source.length() > maxLength) {
                throw new IllegalArgumentException("Source string too long for Damerau-Levenshtein calculation (max " + maxLength + "): " + source.length());
            }
            if (target != null && target.length() > maxLength) {
                throw new IllegalArgumentException("Target string too long for Damerau-Levenshtein calculation (max " + maxLength + "): " + target.length());
            }
        }
        if (source == null || EMPTY.contentEquals(source)) {
            return target == null || EMPTY.contentEquals(target) ? 0 : target.length();
        }
        if (target == null || EMPTY.contentEquals(target)) {
            return source.length();
        }
        int srcLen = source.length();
        int targetLen = target.length();
        int[][] distanceMatrix = new int[srcLen + 1][targetLen + 1];
        for (srcIndex = 0; srcIndex <= srcLen; ++srcIndex) {
            distanceMatrix[srcIndex][0] = srcIndex;
        }
        for (int targetIndex = 0; targetIndex <= targetLen; ++targetIndex) {
            distanceMatrix[0][targetIndex] = targetIndex;
        }
        for (srcIndex = 1; srcIndex <= srcLen; ++srcIndex) {
            for (int targetIndex = 1; targetIndex <= targetLen; ++targetIndex) {
                int cost = source.charAt(srcIndex - 1) == target.charAt(targetIndex - 1) ? 0 : 1;
                distanceMatrix[srcIndex][targetIndex] = (int)MathUtilities.minimum(new long[]{distanceMatrix[srcIndex - 1][targetIndex] + 1, distanceMatrix[srcIndex][targetIndex - 1] + 1, distanceMatrix[srcIndex - 1][targetIndex - 1] + cost});
                if (srcIndex == 1 || targetIndex == 1 || source.charAt(srcIndex - 1) != target.charAt(targetIndex - 2) || source.charAt(srcIndex - 2) != target.charAt(targetIndex - 1)) continue;
                distanceMatrix[srcIndex][targetIndex] = (int)MathUtilities.minimum(new long[]{distanceMatrix[srcIndex][targetIndex], distanceMatrix[srcIndex - 2][targetIndex - 2] + cost});
            }
        }
        return distanceMatrix[srcLen][targetLen];
    }

    public static String getRandomString(Random random, int minLen, int maxLen) {
        if (random == null) {
            throw new NullPointerException("random cannot be null");
        }
        if (minLen < 0 || maxLen < minLen) {
            throw new IllegalArgumentException("minLen must be >= 0 and <= maxLen");
        }
        StringBuilder s = new StringBuilder();
        int len = minLen + random.nextInt(maxLen - minLen + 1);
        for (int i = 0; i < len; ++i) {
            s.append(StringUtilities.getRandomChar(random, i == 0));
        }
        return s.toString();
    }

    public static char getRandomChar(Random random, boolean upper) {
        int r = random.nextInt(26);
        return upper ? (char)(65 + r) : (char)(97 + r);
    }

    public static byte[] getBytes(String s, String encoding) {
        try {
            return s == null ? null : s.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(String.format("Encoding (%s) is not supported by your JVM", encoding), e);
        }
    }

    public static String createUTF8String(byte[] bytes) {
        return bytes == null ? null : new String(bytes, StandardCharsets.UTF_8);
    }

    public static byte[] getUTF8Bytes(String s) {
        return s == null ? null : s.getBytes(StandardCharsets.UTF_8);
    }

    public static String createString(byte[] bytes, String encoding) {
        try {
            return bytes == null ? null : new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(String.format("Encoding (%s) is not supported by your JVM", encoding), e);
        }
    }

    public static int hashCodeIgnoreCase(CharSequence cs) {
        if (cs == null) {
            return 0;
        }
        if (cs instanceof String) {
            return StringUtilities.hashCodeIgnoreCase((String)cs);
        }
        int n = cs.length();
        int h = 0;
        for (int i = 0; i < n; ++i) {
            char c = cs.charAt(i);
            if (c >= '\u0080') {
                return cs.toString().toLowerCase().hashCode();
            }
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            h = 31 * h + c;
        }
        return h;
    }

    public static int hashCodeIgnoreCase(String s) {
        if (s == null) {
            return 0;
        }
        int n = s.length();
        int h = 0;
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c >= '\u0080') {
                return s.toLowerCase().hashCode();
            }
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            h = 31 * h + c;
        }
        return h;
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String trimToEmpty(String value) {
        return value == null ? EMPTY : value.trim();
    }

    public static String trimToNull(String value) {
        String ts = StringUtilities.trim(value);
        return StringUtilities.isEmpty(ts) ? null : ts;
    }

    public static String trimEmptyToDefault(String value, String defaultValue) {
        return Optional.ofNullable(value).map(StringUtilities::trimToNull).orElse(defaultValue);
    }

    public static String removeLeadingAndTrailingQuotes(String input) {
        int start;
        if (input == null || input.isEmpty()) {
            return input;
        }
        int end = input.length();
        for (start = 0; start < end && input.charAt(start) == '\"'; ++start) {
        }
        while (end > start && input.charAt(end - 1) == '\"') {
            --end;
        }
        return input.substring(start, end);
    }

    public static Set<String> commaSeparatedStringToSet(String commaSeparatedString) {
        if (commaSeparatedString == null || commaSeparatedString.trim().isEmpty()) {
            return new LinkedHashSet<String>();
        }
        return Arrays.stream(commaSeparatedString.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
    }

    public static String snakeToCamel(String snake) {
        if (snake == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean upper = false;
        for (char c : snake.toCharArray()) {
            if (c == '_') {
                upper = true;
                continue;
            }
            result.append(upper ? Character.toUpperCase(c) : c);
            upper = false;
        }
        return result.toString();
    }

    public static String camelToSnake(String camel) {
        if (camel == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < camel.length(); ++i) {
            char c = camel.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                result.append('_');
            }
            result.append(Character.toLowerCase(c));
        }
        return result.toString();
    }

    public static boolean isNumeric(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String repeat(String s, int count) {
        if (s == null) {
            return null;
        }
        if (count < 0) {
            throw new IllegalArgumentException("count must be >= 0");
        }
        if (count == 0) {
            return EMPTY;
        }
        if (StringUtilities.isSecurityEnabled()) {
            int maxCount = StringUtilities.getMaxRepeatCount();
            if (maxCount > 0 && count > maxCount) {
                throw new IllegalArgumentException("count too large (max " + maxCount + "): " + count);
            }
            long totalLength = (long)s.length() * (long)count;
            if (totalLength > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Result would be too large: " + totalLength + " characters");
            }
            int maxTotalSize = StringUtilities.getMaxRepeatTotalSize();
            if (maxTotalSize > 0 && totalLength > (long)maxTotalSize) {
                throw new IllegalArgumentException("Result too large (max " + maxTotalSize + "): " + totalLength + " characters");
            }
        }
        StringBuilder result = new StringBuilder(s.length() * count);
        for (int i = 0; i < count; ++i) {
            result.append(s);
        }
        return result.toString();
    }

    public static String reverse(String s) {
        return s == null ? null : new StringBuilder(s).reverse().toString();
    }

    public static String padLeft(String s, int length) {
        if (s == null) {
            return null;
        }
        if (length <= s.length()) {
            return s;
        }
        StringBuilder result = new StringBuilder(length);
        for (int i = s.length(); i < length; ++i) {
            result.append(' ');
        }
        return result.append(s).toString();
    }

    public static String padRight(String s, int length) {
        if (s == null) {
            return null;
        }
        if (length <= s.length()) {
            return s;
        }
        StringBuilder result = new StringBuilder(length);
        result.append(s);
        for (int i = s.length(); i < length; ++i) {
            result.append(' ');
        }
        return result.toString();
    }
}

