/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ClassValueMap;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.IdentitySet;
import com.cedarsoftware.util.LRUCache;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class TypeUtilities {
    private static final int DEFAULT_TYPE_CACHE_SIZE = 2000;
    private static final Map<Map.Entry<Type, Type>, Type> TYPE_RESOLVE_CACHE = new LRUCache<Map.Entry<Type, Type>, Type>(Integer.getInteger("cedarsoftware.util.typeResolveCacheSize", 2000));
    private static final Map<Class<?>, Class<?>> ARRAY_CLASS_CACHE = new ClassValueMap();

    private TypeUtilities() {
    }

    public static Class<?> getRawClass(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type rawType = pType.getRawType();
            if (rawType instanceof Class) {
                return (Class)rawType;
            }
            throw new IllegalArgumentException("Unexpected raw type: " + rawType);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            Type componentType = arrayType.getGenericComponentType();
            Class<?> componentClass = TypeUtilities.getRawClass(componentType);
            return TypeUtilities.getArrayClass(componentClass);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] upperBounds = wildcardType.getUpperBounds();
            if (upperBounds.length > 0) {
                return TypeUtilities.getRawClass(upperBounds[0]);
            }
            return Object.class;
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVar = (TypeVariable)type;
            Type[] bounds = typeVar.getBounds();
            if (bounds.length > 0) {
                return TypeUtilities.getRawClass(bounds[0]);
            }
            return Object.class;
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    public static Type extractArrayComponentType(Type type) {
        Class cls;
        if (type == null) {
            return null;
        }
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        if (type instanceof Class && (cls = (Class)type).isArray()) {
            return cls.getComponentType();
        }
        return null;
    }

    public static boolean hasUnresolvedType(Type type) {
        if (type == null) {
            return false;
        }
        if (type instanceof TypeVariable) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            for (Type arg : ((ParameterizedType)type).getActualTypeArguments()) {
                if (!TypeUtilities.hasUnresolvedType(arg)) continue;
                return true;
            }
        }
        if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            for (Type bound : wt.getUpperBounds()) {
                if (!TypeUtilities.hasUnresolvedType(bound)) continue;
                return true;
            }
            for (Type bound : wt.getLowerBounds()) {
                if (!TypeUtilities.hasUnresolvedType(bound)) continue;
                return true;
            }
        }
        if (type instanceof GenericArrayType) {
            return TypeUtilities.hasUnresolvedType(((GenericArrayType)type).getGenericComponentType());
        }
        return false;
    }

    public static Type resolveTypeUsingInstance(Object target, Type typeToResolve) {
        Convention.throwIfNull(target, "target cannot be null");
        Type resolved = TypeUtilities.resolveType(target.getClass(), typeToResolve);
        if (resolved instanceof TypeVariable) {
            resolved = TypeUtilities.firstBound((TypeVariable)resolved);
        }
        return resolved;
    }

    public static Type resolveType(Type rootContext, Type typeToResolve) {
        AbstractMap.SimpleImmutableEntry<Type, Type> key = new AbstractMap.SimpleImmutableEntry<Type, Type>(rootContext, typeToResolve);
        return TYPE_RESOLVE_CACHE.computeIfAbsent(key, k -> TypeUtilities.resolveType(rootContext, rootContext, typeToResolve, new IdentitySet<Type>()));
    }

    private static Class<?> getArrayClass(Class<?> componentClass) {
        return ARRAY_CLASS_CACHE.computeIfAbsent(componentClass, c -> Array.newInstance(c, 0).getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Type resolveType(Type rootContext, Type currentContext, Type typeToResolve, Set<Type> visited) {
        if (typeToResolve == null) {
            return null;
        }
        if (typeToResolve instanceof TypeVariable) {
            return TypeUtilities.processTypeVariable(rootContext, currentContext, (TypeVariable)typeToResolve, visited);
        }
        if (visited.contains(typeToResolve)) {
            return typeToResolve;
        }
        visited.add(typeToResolve);
        try {
            if (typeToResolve instanceof ParameterizedType) {
                ParameterizedTypeImpl result;
                ParameterizedType pt = (ParameterizedType)typeToResolve;
                Type[] args = pt.getActualTypeArguments();
                Type[] resolvedArgs = new Type[args.length];
                for (int i = 0; i < args.length; ++i) {
                    resolvedArgs[i] = TypeUtilities.resolveType(rootContext, pt, args[i], visited);
                }
                Type ownerType = pt.getOwnerType();
                if (ownerType != null) {
                    ownerType = TypeUtilities.resolveType(rootContext, pt, ownerType, visited);
                }
                ParameterizedTypeImpl parameterizedTypeImpl = result = new ParameterizedTypeImpl((Class)pt.getRawType(), resolvedArgs, ownerType);
                return parameterizedTypeImpl;
            }
            if (typeToResolve instanceof GenericArrayType) {
                GenericArrayTypeImpl result;
                GenericArrayType gat = (GenericArrayType)typeToResolve;
                Type resolvedComp = TypeUtilities.resolveType(rootContext, currentContext, gat.getGenericComponentType(), visited);
                GenericArrayTypeImpl ownerType = result = new GenericArrayTypeImpl(resolvedComp);
                return ownerType;
            }
            if (typeToResolve instanceof WildcardType) {
                int i;
                WildcardType wt = (WildcardType)typeToResolve;
                boolean needsClone = !(wt instanceof WildcardTypeImpl);
                Type[] upperBounds = wt.getUpperBounds();
                Type[] lowerBounds = wt.getLowerBounds();
                if (needsClone) {
                    upperBounds = (Type[])upperBounds.clone();
                    lowerBounds = (Type[])lowerBounds.clone();
                }
                for (i = 0; i < upperBounds.length; ++i) {
                    upperBounds[i] = TypeUtilities.resolveType(rootContext, currentContext, upperBounds[i], visited);
                }
                for (i = 0; i < lowerBounds.length; ++i) {
                    lowerBounds[i] = TypeUtilities.resolveType(rootContext, currentContext, lowerBounds[i], visited);
                }
                WildcardTypeImpl wildcardTypeImpl = new WildcardTypeImpl(upperBounds, lowerBounds);
                return wildcardTypeImpl;
            }
            Type type = typeToResolve;
            return type;
        }
        finally {
            visited.remove(typeToResolve);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Type processTypeVariable(Type rootContext, Type currentContext, TypeVariable<?> typeVar, Set<Type> visited) {
        if (visited.contains(typeVar)) {
            return typeVar;
        }
        visited.add(typeVar);
        try {
            ParameterizedType pType;
            if (!(typeVar.getGenericDeclaration() instanceof Class)) {
                Type type = TypeUtilities.firstBound(typeVar);
                return type;
            }
            Type resolved = null;
            if (currentContext instanceof ParameterizedType && (resolved = TypeUtilities.resolveTypeVariableFromParentType(currentContext, typeVar)) == typeVar) {
                resolved = null;
            }
            Class declaringClass = (Class)typeVar.getGenericDeclaration();
            Class<?> currentRaw = TypeUtilities.getRawClass(currentContext);
            if (resolved == null && !declaringClass.equals(currentRaw) && (pType = TypeUtilities.findParameterizedType(rootContext, declaringClass)) != null) {
                TypeVariable<Class<T>>[] declaredVars = declaringClass.getTypeParameters();
                for (int i = 0; i < declaredVars.length; ++i) {
                    if (!declaredVars[i].getName().equals(typeVar.getName())) continue;
                    resolved = pType.getActualTypeArguments()[i];
                    break;
                }
            }
            if (resolved == null && currentContext instanceof Class) {
                resolved = TypeUtilities.climbGenericHierarchy(rootContext, currentContext, typeVar, visited);
            }
            if (resolved instanceof TypeVariable) {
                resolved = TypeUtilities.resolveType(rootContext, rootContext, resolved, visited);
            }
            if (resolved == null) {
                resolved = rootContext instanceof Class && rootContext == currentContext ? typeVar : TypeUtilities.firstBound(typeVar);
            }
            TypeVariable<?> typeVariable = resolved;
            return typeVariable;
        }
        finally {
            visited.remove(typeVar);
        }
    }

    private static Type climbGenericHierarchy(Type rootContext, Type currentContext, TypeVariable<?> typeVar, Set<Type> visited) {
        ParameterizedType pt;
        Type resolved;
        ParameterizedType pType;
        Class declaringClass = (Class)typeVar.getGenericDeclaration();
        Class<?> contextClass = TypeUtilities.getRawClass(currentContext);
        if (contextClass != null && declaringClass.equals(contextClass) && (pType = TypeUtilities.findParameterizedType(rootContext, declaringClass)) != null) {
            TypeVariable<Class<T>>[] declaredVars = declaringClass.getTypeParameters();
            for (int i = 0; i < declaredVars.length; ++i) {
                if (!declaredVars[i].getName().equals(typeVar.getName())) continue;
                return pType.getActualTypeArguments()[i];
            }
        }
        if (currentContext instanceof ParameterizedType && (resolved = TypeUtilities.climbGenericHierarchy(rootContext, (pt = (ParameterizedType)currentContext).getRawType(), typeVar, visited)) != null && !(resolved instanceof TypeVariable)) {
            return resolved;
        }
        if (contextClass == null) {
            return null;
        }
        Type superType = contextClass.getGenericSuperclass();
        if (superType != null && !superType.equals(Object.class)) {
            resolved = TypeUtilities.resolveType(rootContext, superType, superType, visited);
            if (resolved != null && !(resolved instanceof TypeVariable)) {
                return resolved;
            }
            resolved = TypeUtilities.climbGenericHierarchy(rootContext, superType, typeVar, visited);
            if (resolved != null && !(resolved instanceof TypeVariable)) {
                return resolved;
            }
        }
        for (Type iface : contextClass.getGenericInterfaces()) {
            Type resolved2 = TypeUtilities.resolveType(rootContext, iface, iface, visited);
            if (resolved2 != null && !(resolved2 instanceof TypeVariable)) {
                return resolved2;
            }
            resolved2 = TypeUtilities.climbGenericHierarchy(rootContext, iface, typeVar, visited);
            if (resolved2 == null || resolved2 instanceof TypeVariable) continue;
            return resolved2;
        }
        return null;
    }

    private static ParameterizedType findParameterizedType(Type context, Class<?> target) {
        ParameterizedType pt;
        if (context instanceof ParameterizedType && target.equals((pt = (ParameterizedType)context).getRawType())) {
            return pt;
        }
        Class<?> clazz = TypeUtilities.getRawClass(context);
        if (clazz != null) {
            for (Type iface : clazz.getGenericInterfaces()) {
                ParameterizedType pt2 = TypeUtilities.findParameterizedType(iface, target);
                if (pt2 == null) continue;
                return pt2;
            }
            Type superType = clazz.getGenericSuperclass();
            if (superType != null) {
                return TypeUtilities.findParameterizedType(superType, target);
            }
        }
        return null;
    }

    private static Type resolveTypeVariableFromParentType(Type parentType, TypeVariable<?> typeToResolve) {
        if (parentType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)parentType;
            TypeVariable<Class<T>>[] typeParams = ((Class)pt.getRawType()).getTypeParameters();
            Type[] actualTypes = pt.getActualTypeArguments();
            for (int i = 0; i < typeParams.length; ++i) {
                if (!typeParams[i].equals(typeToResolve)) continue;
                return actualTypes[i];
            }
        }
        return null;
    }

    private static Type firstBound(TypeVariable<?> tv) {
        Type[] bounds = tv.getBounds();
        return bounds.length > 0 ? bounds[0] : Object.class;
    }

    public static Type inferElementType(Type container, Type fieldGenericType) {
        if (container instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)container;
            Type[] typeArgs = pt.getActualTypeArguments();
            Class<?> raw = TypeUtilities.getRawClass(pt.getRawType());
            if (Map.class.isAssignableFrom(raw)) {
                if (typeArgs.length >= 2) {
                    fieldGenericType = typeArgs[1];
                }
            } else if (Collection.class.isAssignableFrom(raw)) {
                if (typeArgs.length >= 1) {
                    fieldGenericType = typeArgs[0];
                }
            } else if (raw.isArray()) {
                if (typeArgs.length >= 1) {
                    fieldGenericType = typeArgs[0];
                }
            } else {
                fieldGenericType = Object.class;
            }
        }
        return fieldGenericType;
    }

    private static class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Class<?> raw;
        private final Type[] args;
        private final Type owner;

        public ParameterizedTypeImpl(Class<?> raw, Type[] args, Type owner) {
            this.raw = raw;
            this.args = (Type[])args.clone();
            this.owner = owner;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.args.clone();
        }

        @Override
        public Type getRawType() {
            return this.raw;
        }

        @Override
        public Type getOwnerType() {
            return this.owner;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.raw.getName());
            if (this.args != null && this.args.length > 0) {
                sb.append("<");
                for (int i = 0; i < this.args.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(this.args[i].getTypeName());
                }
                sb.append(">");
            }
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType that = (ParameterizedType)o;
            return Objects.equals(this.raw, that.getRawType()) && Objects.equals(this.owner, that.getOwnerType()) && Arrays.equals(this.args, that.getActualTypeArguments());
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.args);
            result = 31 * result + Objects.hashCode(this.raw);
            result = 31 * result + Objects.hashCode(this.owner);
            return result;
        }
    }

    private static class GenericArrayTypeImpl
    implements GenericArrayType {
        private final Type componentType;

        public GenericArrayTypeImpl(Type componentType) {
            this.componentType = componentType;
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }

        public String toString() {
            return this.componentType.getTypeName() + "[]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GenericArrayType)) {
                return false;
            }
            GenericArrayType that = (GenericArrayType)o;
            return Objects.equals(this.componentType, that.getGenericComponentType());
        }

        public int hashCode() {
            return Objects.hashCode(this.componentType);
        }
    }

    private static class WildcardTypeImpl
    implements WildcardType {
        private final Type[] upperBounds;
        private final Type[] lowerBounds;

        WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
            Type[] typeArray;
            if (upperBounds != null) {
                typeArray = upperBounds;
            } else {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = Object.class;
            }
            this.upperBounds = typeArray;
            this.lowerBounds = lowerBounds != null ? lowerBounds : new Type[]{};
        }

        @Override
        public Type[] getUpperBounds() {
            return (Type[])this.upperBounds.clone();
        }

        @Override
        public Type[] getLowerBounds() {
            return (Type[])this.lowerBounds.clone();
        }

        public String toString() {
            int i;
            StringBuilder sb = new StringBuilder("?");
            if (this.upperBounds.length > 0 && (this.upperBounds.length != 1 || this.upperBounds[0] != Object.class)) {
                sb.append(" extends ");
                for (i = 0; i < this.upperBounds.length; ++i) {
                    if (i > 0) {
                        sb.append(" & ");
                    }
                    sb.append(this.upperBounds[i].getTypeName());
                }
            }
            if (this.lowerBounds.length > 0) {
                sb.append(" super ");
                for (i = 0; i < this.lowerBounds.length; ++i) {
                    if (i > 0) {
                        sb.append(" & ");
                    }
                    sb.append(this.lowerBounds[i].getTypeName());
                }
            }
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WildcardType)) {
                return false;
            }
            WildcardType that = (WildcardType)o;
            return Arrays.equals(this.upperBounds, that.getUpperBounds()) && Arrays.equals(this.lowerBounds, that.getLowerBounds());
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.upperBounds);
            result = 31 * result + Arrays.hashCode(this.lowerBounds);
            return result;
        }
    }
}

