/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.geom.Dimension;
import com.cedarsoftware.util.geom.Insets;
import com.cedarsoftware.util.geom.Point;
import com.cedarsoftware.util.geom.Rectangle;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

final class InsetsConversions {
    private InsetsConversions() {
    }

    static String toString(Object from, Converter converter) {
        Insets insets = (Insets)from;
        return "(" + insets.getTop() + "," + insets.getLeft() + "," + insets.getBottom() + "," + insets.getRight() + ")";
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        Insets insets = (Insets)from;
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        target.put("top", insets.getTop());
        target.put("left", insets.getLeft());
        target.put("bottom", insets.getBottom());
        target.put("right", insets.getRight());
        return target;
    }

    static int[] toIntArray(Object from, Converter converter) {
        Insets insets = (Insets)from;
        return new int[]{insets.getTop(), insets.getLeft(), insets.getBottom(), insets.getRight()};
    }

    static Long toLong(Object from, Converter converter) {
        Insets insets = (Insets)from;
        return (long)insets.getTop() + (long)insets.getLeft() + (long)insets.getBottom() + (long)insets.getRight();
    }

    static Integer toInteger(Object from, Converter converter) {
        Insets insets = (Insets)from;
        return insets.getTop() + insets.getLeft() + insets.getBottom() + insets.getRight();
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        Insets insets = (Insets)from;
        return BigInteger.valueOf((long)insets.getTop() + (long)insets.getLeft() + (long)insets.getBottom() + (long)insets.getRight());
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        Insets insets = (Insets)from;
        return BigDecimal.valueOf((long)insets.getTop() + (long)insets.getLeft() + (long)insets.getBottom() + (long)insets.getRight());
    }

    static Boolean toBoolean(Object from, Converter converter) {
        Insets insets = (Insets)from;
        return insets.getTop() != 0 || insets.getLeft() != 0 || insets.getBottom() != 0 || insets.getRight() != 0;
    }

    static AtomicBoolean toAtomicBoolean(Object from, Converter converter) {
        return new AtomicBoolean(InsetsConversions.toBoolean(from, converter));
    }

    static Point toPoint(Object from, Converter converter) {
        Insets insets = (Insets)from;
        return new Point(insets.getTop(), insets.getLeft());
    }

    static Dimension toDimension(Object from, Converter converter) {
        Insets insets = (Insets)from;
        return new Dimension(insets.getLeft() + insets.getRight(), insets.getTop() + insets.getBottom());
    }

    static Rectangle toRectangle(Object from, Converter converter) {
        Insets insets = (Insets)from;
        int width = Math.max(0, insets.getRight() - insets.getLeft());
        int height = Math.max(0, insets.getBottom() - insets.getTop());
        return new Rectangle(insets.getLeft(), insets.getTop(), width, height);
    }
}

