/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ExceptionUtilities;
import java.io.IOException;
import java.io.Reader;

public final class FastReader
extends Reader {
    private Reader in;
    private final char[] buf;
    private final int bufferSize;
    private final int pushbackBufferSize;
    private int position;
    private int limit;
    private final char[] pushbackBuffer;
    private int pushbackPosition;

    public FastReader(Reader in) {
        this(in, 8192, 16);
    }

    public FastReader(Reader in, int bufferSize, int pushbackBufferSize) {
        super((Object)in);
        if (bufferSize <= 0 || pushbackBufferSize < 0) {
            throw new IllegalArgumentException("bufferSize must be positive, pushbackBufferSize must be non-negative");
        }
        this.in = in;
        this.bufferSize = bufferSize;
        this.pushbackBufferSize = pushbackBufferSize;
        this.buf = new char[bufferSize];
        this.pushbackBuffer = new char[pushbackBufferSize];
        this.position = 0;
        this.limit = 0;
        this.pushbackPosition = pushbackBufferSize;
    }

    private void fill() {
        if (this.limit == -1) {
            return;
        }
        if (this.position >= this.limit) {
            try {
                this.limit = this.in.read(this.buf, 0, this.bufferSize);
            }
            catch (IOException e) {
                ExceptionUtilities.uncheckedThrow(e);
            }
            if (this.limit > 0) {
                this.position = 0;
            }
        }
    }

    public void pushback(char ch) {
        if (this.pushbackPosition == 0) {
            ExceptionUtilities.uncheckedThrow(new IOException("Pushback buffer is full"));
        }
        this.pushbackBuffer[--this.pushbackPosition] = ch;
    }

    @Override
    public int read() {
        if (this.in == null) {
            ExceptionUtilities.uncheckedThrow(new IOException("in is null"));
        }
        if (this.pushbackPosition < this.pushbackBufferSize) {
            return this.pushbackBuffer[this.pushbackPosition++];
        }
        this.fill();
        if (this.limit == -1) {
            return -1;
        }
        return this.buf[this.position++];
    }

    @Override
    public int read(char[] cbuf, int off, int len) {
        if (this.in == null) {
            ExceptionUtilities.uncheckedThrow(new IOException("inputReader is null"));
        }
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int charsRead = 0;
        while (len > 0) {
            int availableFromPushback = this.pushbackBufferSize - this.pushbackPosition;
            if (availableFromPushback > 0) {
                int toRead = Math.min(availableFromPushback, len);
                System.arraycopy(this.pushbackBuffer, this.pushbackPosition, cbuf, off, toRead);
                this.pushbackPosition += toRead;
                off += toRead;
                len -= toRead;
                charsRead += toRead;
                continue;
            }
            this.fill();
            if (this.limit == -1) {
                return charsRead > 0 ? charsRead : -1;
            }
            int availableFromMain = this.limit - this.position;
            if (availableFromMain <= 0) {
                return charsRead > 0 ? charsRead : -1;
            }
            int toRead = Math.min(availableFromMain, len);
            System.arraycopy(this.buf, this.position, cbuf, off, toRead);
            this.position += toRead;
            off += toRead;
            len -= toRead;
            charsRead += toRead;
        }
        return charsRead;
    }

    @Override
    public void close() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException e) {
                ExceptionUtilities.uncheckedThrow(e);
            }
            this.in = null;
        }
    }

    @Deprecated
    public int getLine() {
        return 0;
    }

    @Deprecated
    public int getCol() {
        return 0;
    }

    public String getLastSnippet() {
        int snippetLength = Math.min(this.position, 200);
        int start = this.position - snippetLength;
        return new String(this.buf, start, snippetLength);
    }
}

