/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class StreamGobbler
implements Runnable {
    private final InputStream _inputStream;
    private final Charset _charset;
    private String _result;

    StreamGobbler(InputStream is) {
        this(is, StandardCharsets.UTF_8);
    }

    StreamGobbler(InputStream is, Charset charset) {
        this._inputStream = is;
        this._charset = charset;
    }

    public String getResult() {
        return this._result;
    }

    @Override
    public void run() {
        String lineSeparator = System.lineSeparator();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this._inputStream, this._charset));){
            String line;
            StringBuilder output = new StringBuilder();
            while ((line = br.readLine()) != null) {
                output.append(line);
                output.append(lineSeparator);
            }
            this._result = output.toString();
        }
        catch (IOException e) {
            this._result = e.getMessage();
        }
    }
}

