/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class FastByteArrayInputStream
extends InputStream {
    private final byte[] buffer;
    private int pos;
    private int mark = 0;
    private final int count;

    public FastByteArrayInputStream(byte[] buf) {
        if (buf == null) {
            throw new NullPointerException("Input byte array cannot be null");
        }
        this.buffer = buf;
        this.pos = 0;
        this.count = buf.length;
    }

    @Override
    public int read() {
        return this.pos < this.count ? this.buffer[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        int avail = this.count - this.pos;
        if (len > avail) {
            len = avail;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buffer, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public long skip(long n) {
        long k = this.count - this.pos;
        if (n < k) {
            k = n < 0L ? 0L : n;
        }
        this.pos += (int)k;
        return k;
    }

    @Override
    public int available() {
        return this.count - this.pos;
    }

    @Override
    public void mark(int readLimit) {
        this.mark = this.pos;
    }

    @Override
    public void reset() {
        this.pos = this.mark;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public byte[] readAllBytes() {
        byte[] result = Arrays.copyOfRange(this.buffer, this.pos, this.count);
        this.pos = this.count;
        return result;
    }

    @Override
    public byte[] readNBytes(int len) {
        if (len < 0) {
            throw new IllegalArgumentException("len < 0");
        }
        int remaining = this.count - this.pos;
        int bytesToRead = Math.min(len, remaining);
        byte[] result = Arrays.copyOfRange(this.buffer, this.pos, this.pos + bytesToRead);
        this.pos += bytesToRead;
        return result;
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        if (out == null) {
            throw new NullPointerException("Output stream cannot be null");
        }
        int remaining = this.count - this.pos;
        if (remaining > 0) {
            out.write(this.buffer, this.pos, remaining);
            this.pos = this.count;
        }
        return remaining;
    }

    @Override
    public void close() {
    }
}

