/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.util.Arrays;

public final class ByteUtilities {
    private static final int DEFAULT_MAX_HEX_STRING_LENGTH = 1000000;
    private static final int DEFAULT_MAX_ARRAY_SIZE = 10000000;
    private static final String PROP_SECURITY_ENABLED = "byteutilities.security.enabled";
    private static final String PROP_MAX_HEX_LENGTH = "byteutilities.max.hex.string.length";
    private static final String PROP_MAX_ARRAY_SIZE = "byteutilities.max.array.size";
    private static volatile String cachedSecurityEnabledProp;
    private static volatile boolean cachedSecurityEnabled;
    private static volatile String cachedMaxHexLengthProp;
    private static volatile int cachedMaxHexLength;
    private static volatile String cachedMaxArraySizeProp;
    private static volatile int cachedMaxArraySize;
    private static final int MAX_SAFE_ARRAY_SIZE = 0x3FFFFFFF;
    private static final char[] HEX_ARRAY;
    private static final int[] HEX_LOOKUP;
    private static final byte[] GZIP_MAGIC;

    private static boolean isSecurityEnabled() {
        String currentProp = System.getProperty(PROP_SECURITY_ENABLED, "false");
        if (!currentProp.equals(cachedSecurityEnabledProp)) {
            cachedSecurityEnabledProp = currentProp;
            cachedSecurityEnabled = Boolean.parseBoolean(currentProp);
        }
        return cachedSecurityEnabled;
    }

    private static int getMaxHexStringLength() {
        if (!ByteUtilities.isSecurityEnabled()) {
            return 0;
        }
        String currentProp = System.getProperty(PROP_MAX_HEX_LENGTH);
        if (currentProp == null) {
            cachedMaxHexLengthProp = null;
            cachedMaxHexLength = 1000000;
            return cachedMaxHexLength;
        }
        if (!currentProp.equals(cachedMaxHexLengthProp)) {
            cachedMaxHexLengthProp = currentProp;
            try {
                int limit = Integer.parseInt(currentProp);
                cachedMaxHexLength = limit <= 0 ? 0 : limit;
            }
            catch (NumberFormatException e) {
                cachedMaxHexLength = 1000000;
            }
        }
        return cachedMaxHexLength;
    }

    private static int getMaxArraySize() {
        if (!ByteUtilities.isSecurityEnabled()) {
            return 0;
        }
        String currentProp = System.getProperty(PROP_MAX_ARRAY_SIZE);
        if (currentProp == null) {
            cachedMaxArraySizeProp = null;
            cachedMaxArraySize = 10000000;
            return cachedMaxArraySize;
        }
        if (!currentProp.equals(cachedMaxArraySizeProp)) {
            cachedMaxArraySizeProp = currentProp;
            try {
                int limit = Integer.parseInt(currentProp);
                cachedMaxArraySize = limit <= 0 ? 0 : limit;
            }
            catch (NumberFormatException e) {
                cachedMaxArraySize = 10000000;
            }
        }
        return cachedMaxArraySize;
    }

    private ByteUtilities() {
    }

    public static char toHexChar(int value) {
        return HEX_ARRAY[value & 0xF];
    }

    public static byte[] decode(String s) {
        return ByteUtilities.decode((CharSequence)s);
    }

    public static byte[] decode(CharSequence s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        int maxHexLength = ByteUtilities.getMaxHexStringLength();
        if (maxHexLength > 0 && len > maxHexLength) {
            throw new SecurityException("Hex string length exceeds maximum allowed: " + maxHexLength);
        }
        if ((len & 1) != 0) {
            return null;
        }
        byte[] bytes = new byte[len >> 1];
        int j = 0;
        for (int i = 0; i < len; i += 2) {
            char c1 = s.charAt(i);
            char c2 = s.charAt(i + 1);
            if (c1 >= HEX_LOOKUP.length || c2 >= HEX_LOOKUP.length) {
                return null;
            }
            int hi = HEX_LOOKUP[c1];
            int lo = HEX_LOOKUP[c2];
            if (hi == -1 || lo == -1) {
                return null;
            }
            bytes[j++] = (byte)(hi << 4 | lo);
        }
        return bytes;
    }

    public static String encode(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        int maxArraySize = ByteUtilities.getMaxArraySize();
        if (maxArraySize > 0 && bytes.length > maxArraySize) {
            throw new SecurityException("Byte array size exceeds maximum allowed: " + maxArraySize);
        }
        if (bytes.length > 0x3FFFFFFF) {
            throw new IllegalArgumentException("Byte array too large to encode: length " + bytes.length + " exceeds maximum safe size " + 0x3FFFFFFF);
        }
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            hexChars[j++] = HEX_ARRAY[v >>> 4];
            hexChars[j++] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static boolean isGzipped(byte[] bytes) {
        return ByteUtilities.isGzipped(bytes, 0);
    }

    public static boolean isGzipped(byte[] bytes, int offset) {
        if (bytes == null || offset < 0 || offset >= bytes.length) {
            return false;
        }
        return bytes.length - offset >= 2 && bytes[offset] == GZIP_MAGIC[0] && bytes[offset + 1] == GZIP_MAGIC[1];
    }

    public static int indexOf(byte[] data, byte[] pattern, int start) {
        if (data == null || pattern == null || start < 0 || pattern.length == 0) {
            return -1;
        }
        int patternLen = pattern.length;
        int dataLen = data.length;
        if (patternLen > dataLen || start > dataLen - patternLen) {
            return -1;
        }
        if (patternLen == 1) {
            byte target = pattern[0];
            for (int i = start; i < dataLen; ++i) {
                if (data[i] != target) continue;
                return i;
            }
            return -1;
        }
        int limit = dataLen - patternLen;
        block1: for (int i = start; i <= limit; ++i) {
            for (int j = 0; j < patternLen; ++j) {
                if (data[i + j] != pattern[j]) continue block1;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] data, byte[] pattern, int start) {
        if (data == null || pattern == null || start < 0 || pattern.length == 0) {
            return -1;
        }
        int patternLen = pattern.length;
        int dataLen = data.length;
        if (patternLen > dataLen) {
            return -1;
        }
        int effectiveStart = Math.min(start, dataLen - patternLen);
        if (effectiveStart < 0) {
            return -1;
        }
        if (patternLen == 1) {
            byte target = pattern[0];
            for (int i = effectiveStart; i >= 0; --i) {
                if (data[i] != target) continue;
                return i;
            }
            return -1;
        }
        block1: for (int i = effectiveStart; i >= 0; --i) {
            for (int j = 0; j < patternLen; ++j) {
                if (data[i + j] != pattern[j]) continue block1;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] data, byte[] pattern) {
        if (data == null) {
            return -1;
        }
        return ByteUtilities.lastIndexOf(data, pattern, data.length - 1);
    }

    public static boolean contains(byte[] data, byte[] pattern) {
        return ByteUtilities.indexOf(data, pattern, 0) >= 0;
    }

    static {
        int c;
        HEX_ARRAY = "0123456789ABCDEF".toCharArray();
        HEX_LOOKUP = new int[128];
        Arrays.fill(HEX_LOOKUP, -1);
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            ByteUtilities.HEX_LOOKUP[c] = c - 48;
        }
        for (c = 65; c <= 70; c = (int)((char)(c + 1))) {
            ByteUtilities.HEX_LOOKUP[c] = 10 + (c - 65);
        }
        for (c = 97; c <= 102; c = (int)((char)(c + 1))) {
            ByteUtilities.HEX_LOOKUP[c] = 10 + (c - 97);
        }
        GZIP_MAGIC = new byte[]{31, -117};
    }
}

