/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public class ClassValueMap<V>
extends AbstractMap<Class<?>, V>
implements ConcurrentMap<Class<?>, V> {
    private static final Object NO_VALUE = new Object();
    private static final Object NULL_VALUE = new Object();
    private final ConcurrentHashMap<Class<?>, Object> backingMap = new ConcurrentHashMap();
    private static final Object NO_NULL_KEY_MAPPING = new Object();
    private static final Object NULL_FOR_NULL_KEY = new Object();
    private final AtomicReference<Object> nullKeyStore = new AtomicReference<Object>(NO_NULL_KEY_MAPPING);
    private transient Set<Map.Entry<Class<?>, V>> cachedEntrySet;
    private transient Collection<V> cachedValues;
    private final ClassValue<Object> cache = new ClassValue<Object>(){

        @Override
        protected Object computeValue(Class<?> key) {
            Object result = ClassValueMap.this.backingMap.get(key);
            if (result == null) {
                return NO_VALUE;
            }
            return result == NULL_VALUE ? null : result;
        }
    };

    private Object maskNull(V value) {
        return value == null ? NULL_VALUE : value;
    }

    private V unmaskNull(Object value) {
        return (V)(value == NULL_VALUE ? null : value);
    }

    private boolean hasNullKeyMapping() {
        return this.nullKeyStore.get() != NO_NULL_KEY_MAPPING;
    }

    private V getNullKeyValue() {
        Object stored = this.nullKeyStore.get();
        if (stored == NO_NULL_KEY_MAPPING) {
            return null;
        }
        return (V)(stored == NULL_FOR_NULL_KEY ? null : stored);
    }

    private Object maskNullKeyValue(V value) {
        return value == null ? NULL_FOR_NULL_KEY : value;
    }

    private V unmaskNullKeyValue(Object stored) {
        if (stored == NO_NULL_KEY_MAPPING) {
            return null;
        }
        return (V)(stored == NULL_FOR_NULL_KEY ? null : stored);
    }

    public ClassValueMap() {
    }

    public ClassValueMap(Map<? extends Class<?>, ? extends V> map) {
        if (map == null) {
            throw new NullPointerException("Map cannot be null");
        }
        for (Map.Entry<Class<?>, V> entry : map.entrySet()) {
            Class<?> key = entry.getKey();
            if (key == null) {
                this.nullKeyStore.set(this.maskNullKeyValue(entry.getValue()));
                continue;
            }
            this.backingMap.put(key, this.maskNull(entry.getValue()));
        }
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return this.getNullKeyValue();
        }
        if (key.getClass() == Class.class) {
            Object value = this.cache.get((Class)key);
            if (value == NO_VALUE) {
                return null;
            }
            return (V)value;
        }
        return null;
    }

    @Override
    public V put(Class<?> key, V value) {
        if (key == null) {
            Object old = this.nullKeyStore.getAndSet(this.maskNullKeyValue(value));
            return this.unmaskNullKeyValue(old);
        }
        Object old = this.backingMap.put(key, this.maskNull(value));
        this.cache.remove(key);
        return this.unmaskNull(old);
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            Object old = this.nullKeyStore.getAndSet(NO_NULL_KEY_MAPPING);
            return this.unmaskNullKeyValue(old);
        }
        if (key.getClass() != Class.class) {
            return null;
        }
        Class clazz = (Class)key;
        Object old = this.backingMap.remove(clazz);
        if (old != null) {
            this.cache.remove(clazz);
        }
        return this.unmaskNull(old);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return this.hasNullKeyMapping();
        }
        if (key.getClass() != Class.class) {
            return false;
        }
        return this.cache.get((Class)key) != NO_VALUE;
    }

    @Override
    public void clear() {
        HashSet keys = new HashSet(this.backingMap.keySet());
        this.backingMap.clear();
        this.nullKeyStore.set(NO_NULL_KEY_MAPPING);
        for (Class key : keys) {
            this.cache.remove(key);
        }
    }

    @Override
    public int size() {
        return this.backingMap.size() + (this.hasNullKeyMapping() ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return !this.hasNullKeyMapping() && this.backingMap.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        Object nullKeyStored = this.nullKeyStore.get();
        if (nullKeyStored != NO_NULL_KEY_MAPPING && Objects.equals(this.unmaskNullKeyValue(nullKeyStored), value)) {
            return true;
        }
        return this.backingMap.containsValue(value == null ? NULL_VALUE : value);
    }

    @Override
    public Set<Map.Entry<Class<?>, V>> entrySet() {
        AbstractSet es = this.cachedEntrySet;
        if (es != null) {
            return es;
        }
        this.cachedEntrySet = es = new AbstractSet<Map.Entry<Class<?>, V>>(){

            @Override
            public Iterator<Map.Entry<Class<?>, V>> iterator() {
                final Iterator backingIterator = ClassValueMap.this.backingMap.entrySet().iterator();
                Object nullKeyStored = ClassValueMap.this.nullKeyStore.get();
                final boolean hasNullEntry = nullKeyStored != NO_NULL_KEY_MAPPING;
                final Object nullValue = hasNullEntry ? ClassValueMap.this.unmaskNullKeyValue(nullKeyStored) : null;
                return new Iterator<Map.Entry<Class<?>, V>>(){
                    private boolean nullEntryReturned;
                    {
                        this.nullEntryReturned = !hasNullEntry;
                    }

                    @Override
                    public boolean hasNext() {
                        return !this.nullEntryReturned || backingIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<Class<?>, V> next() {
                        if (!this.nullEntryReturned) {
                            this.nullEntryReturned = true;
                            return new AbstractMap.SimpleImmutableEntry<Object, Object>(null, nullValue);
                        }
                        Map.Entry entry = (Map.Entry)backingIterator.next();
                        return new AbstractMap.SimpleImmutableEntry<Class, Object>((Class)entry.getKey(), ClassValueMap.this.unmaskNull(entry.getValue()));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Removal not supported via iterator.");
                    }
                };
            }

            @Override
            public int size() {
                return ClassValueMap.this.size();
            }
        };
        return es;
    }

    @Override
    public V putIfAbsent(Class<?> key, V value) {
        if (key == null) {
            Object masked = this.maskNullKeyValue(value);
            do {
                Object current;
                if ((current = this.nullKeyStore.get()) == NO_NULL_KEY_MAPPING) continue;
                return this.unmaskNullKeyValue(current);
            } while (!this.nullKeyStore.compareAndSet(NO_NULL_KEY_MAPPING, masked));
            return null;
        }
        Object prev = this.backingMap.putIfAbsent(key, this.maskNull(value));
        if (prev == null) {
            this.cache.remove(key);
        }
        return this.unmaskNull(prev);
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (key == null) {
            Object current;
            do {
                if ((current = this.nullKeyStore.get()) == NO_NULL_KEY_MAPPING) {
                    return false;
                }
                if (Objects.equals(this.unmaskNullKeyValue(current), value)) continue;
                return false;
            } while (!this.nullKeyStore.compareAndSet(current, NO_NULL_KEY_MAPPING));
            return true;
        }
        if (key.getClass() != Class.class) {
            return false;
        }
        boolean removed = this.backingMap.remove(key, this.maskNull(value));
        if (removed) {
            this.cache.remove((Class)key);
        }
        return removed;
    }

    @Override
    public boolean replace(Class<?> key, V oldValue, V newValue) {
        if (key == null) {
            Object current;
            Object replacement = this.maskNullKeyValue(newValue);
            do {
                if ((current = this.nullKeyStore.get()) == NO_NULL_KEY_MAPPING) {
                    return false;
                }
                if (Objects.equals(this.unmaskNullKeyValue(current), oldValue)) continue;
                return false;
            } while (!this.nullKeyStore.compareAndSet(current, replacement));
            return true;
        }
        boolean replaced = this.backingMap.replace(key, this.maskNull(oldValue), this.maskNull(newValue));
        if (replaced) {
            this.cache.remove(key);
        }
        return replaced;
    }

    @Override
    public V replace(Class<?> key, V value) {
        if (key == null) {
            Object current;
            Object masked = this.maskNullKeyValue(value);
            do {
                if ((current = this.nullKeyStore.get()) != NO_NULL_KEY_MAPPING) continue;
                return null;
            } while (!this.nullKeyStore.compareAndSet(current, masked));
            return this.unmaskNullKeyValue(current);
        }
        Object replaced = this.backingMap.replace(key, this.maskNull(value));
        if (replaced != null) {
            this.cache.remove(key);
        }
        return this.unmaskNull(replaced);
    }

    @Override
    public Collection<V> values() {
        AbstractCollection vs = this.cachedValues;
        if (vs != null) {
            return vs;
        }
        this.cachedValues = vs = new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                final Iterator backingIterator = ClassValueMap.this.backingMap.values().iterator();
                Object nullKeyStored = ClassValueMap.this.nullKeyStore.get();
                final boolean hasNullEntry = nullKeyStored != NO_NULL_KEY_MAPPING;
                final Object nullValue = hasNullEntry ? ClassValueMap.this.unmaskNullKeyValue(nullKeyStored) : null;
                return new Iterator<V>(){
                    private boolean nullReturned;
                    {
                        this.nullReturned = !hasNullEntry;
                    }

                    @Override
                    public boolean hasNext() {
                        return !this.nullReturned || backingIterator.hasNext();
                    }

                    @Override
                    public V next() {
                        if (!this.nullReturned) {
                            this.nullReturned = true;
                            return nullValue;
                        }
                        return ClassValueMap.this.unmaskNull(backingIterator.next());
                    }
                };
            }

            @Override
            public int size() {
                return ClassValueMap.this.size();
            }

            @Override
            public boolean contains(Object o) {
                return ClassValueMap.this.containsValue(o);
            }
        };
        return vs;
    }

    public Map<Class<?>, V> unmodifiableView() {
        final ClassValueMap thisMap = this;
        return new AbstractMap<Class<?>, V>(){

            @Override
            public Set<Map.Entry<Class<?>, V>> entrySet() {
                return Collections.unmodifiableSet(thisMap.entrySet());
            }

            @Override
            public V get(Object key) {
                return thisMap.get(key);
            }

            @Override
            public boolean containsKey(Object key) {
                return thisMap.containsKey(key);
            }

            @Override
            public Set<Class<?>> keySet() {
                return Collections.unmodifiableSet(thisMap.keySet());
            }

            @Override
            public Collection<V> values() {
                return Collections.unmodifiableCollection(thisMap.values());
            }

            @Override
            public int size() {
                return thisMap.size();
            }

            @Override
            public V put(Class<?> key, V value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public V remove(Object key) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void putAll(Map<? extends Class<?>, ? extends V> m) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

