/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.IdentitySet;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class ClassValueSet
extends AbstractSet<Class<?>> {
    private final Set<Class<?>> backingSet = ConcurrentHashMap.newKeySet();
    private final AtomicBoolean containsNull = new AtomicBoolean(false);
    private final ClassValue<Boolean> membershipCache = new ClassValue<Boolean>(){

        @Override
        protected Boolean computeValue(Class<?> type) {
            return ClassValueSet.this.backingSet.contains(type);
        }
    };

    public ClassValueSet() {
    }

    public ClassValueSet(Collection<? extends Class<?>> c) {
        this.addAll(c);
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return this.containsNull.get();
        }
        if (o.getClass() != Class.class) {
            return false;
        }
        return this.membershipCache.get((Class)o);
    }

    @Override
    public boolean add(Class<?> cls) {
        if (cls == null) {
            return !this.containsNull.getAndSet(true);
        }
        boolean added = this.backingSet.add(cls);
        if (added) {
            this.membershipCache.remove(cls);
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return this.containsNull.getAndSet(false);
        }
        if (o.getClass() != Class.class) {
            return false;
        }
        Class clazz = (Class)o;
        boolean changed = this.backingSet.remove(clazz);
        if (changed) {
            this.membershipCache.remove(clazz);
        }
        return changed;
    }

    @Override
    public void clear() {
        HashSet keys = new HashSet(this.backingSet);
        this.backingSet.clear();
        this.containsNull.set(false);
        for (Class clazz : keys) {
            this.membershipCache.remove(clazz);
        }
    }

    @Override
    public int size() {
        return this.backingSet.size() + (this.containsNull.get() ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.backingSet.isEmpty() && !this.containsNull.get();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Set other = (Set)o;
        if (other.size() != this.size()) {
            return false;
        }
        try {
            if (this.containsNull.get() && !other.contains(null)) {
                return false;
            }
            for (Class<?> cls : this.backingSet) {
                if (other.contains(cls)) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException | NullPointerException e) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (Class<?> cls : this.backingSet) {
            h += cls.hashCode();
        }
        return h;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c, "Collection cannot be null");
        boolean modified = false;
        if (this.containsNull.get() && !c.contains(null)) {
            this.containsNull.set(false);
            modified = true;
        }
        IdentitySet toRemove = new IdentitySet();
        for (Class<Object> cls : this.backingSet) {
            if (c.contains(cls)) continue;
            toRemove.add(cls);
        }
        for (Class<Object> cls : toRemove) {
            this.backingSet.remove(cls);
            this.membershipCache.remove(cls);
            modified = true;
        }
        return modified;
    }

    @Override
    public Iterator<Class<?>> iterator() {
        final boolean hasNull = this.containsNull.get();
        final Iterator<Class<?>> backingIterator = this.backingSet.iterator();
        return new Iterator<Class<?>>(){
            private boolean nullReturned;
            private Class<?> lastReturned;
            private boolean canRemove;
            {
                this.nullReturned = !hasNull;
                this.lastReturned = null;
                this.canRemove = false;
            }

            @Override
            public boolean hasNext() {
                return !this.nullReturned || backingIterator.hasNext();
            }

            @Override
            public Class<?> next() {
                if (!this.nullReturned) {
                    this.nullReturned = true;
                    this.lastReturned = null;
                    this.canRemove = true;
                    return null;
                }
                this.lastReturned = (Class)backingIterator.next();
                this.canRemove = true;
                return this.lastReturned;
            }

            @Override
            public void remove() {
                if (!this.canRemove) {
                    throw new IllegalStateException("next() has not been called, or remove() has already been called after the last call to next()");
                }
                this.canRemove = false;
                if (this.lastReturned == null) {
                    ClassValueSet.this.containsNull.set(false);
                } else {
                    ClassValueSet.this.remove(this.lastReturned);
                }
            }
        };
    }

    public Set<Class<?>> toSet() {
        HashSet result = new HashSet(this.backingSet);
        if (this.containsNull.get()) {
            result.add(null);
        }
        return result;
    }

    public static ClassValueSet from(Collection<? extends Class<?>> collection) {
        return new ClassValueSet(collection);
    }

    public static ClassValueSet of(Class<?> ... classes) {
        ClassValueSet set = new ClassValueSet();
        if (classes != null) {
            Collections.addAll(set, classes);
        }
        return set;
    }

    public Set<Class<?>> unmodifiableView() {
        final ClassValueSet thisSet = this;
        return new AbstractSet<Class<?>>(){

            @Override
            public Iterator<Class<?>> iterator() {
                final Iterator<Class<?>> originalIterator = thisSet.iterator();
                return new Iterator<Class<?>>(){

                    @Override
                    public boolean hasNext() {
                        return originalIterator.hasNext();
                    }

                    @Override
                    public Class<?> next() {
                        return (Class)originalIterator.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Cannot modify an unmodifiable set");
                    }
                };
            }

            @Override
            public int size() {
                return thisSet.size();
            }

            @Override
            public boolean contains(Object o) {
                return thisSet.contains(o);
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return thisSet.containsAll(c);
            }

            @Override
            public boolean isEmpty() {
                return thisSet.isEmpty();
            }

            @Override
            public Object[] toArray() {
                return thisSet.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return thisSet.toArray(a);
            }

            @Override
            public boolean add(Class<?> e) {
                throw new UnsupportedOperationException("Cannot modify an unmodifiable set");
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException("Cannot modify an unmodifiable set");
            }

            @Override
            public boolean addAll(Collection<? extends Class<?>> c) {
                throw new UnsupportedOperationException("Cannot modify an unmodifiable set");
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException("Cannot modify an unmodifiable set");
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException("Cannot modify an unmodifiable set");
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException("Cannot modify an unmodifiable set");
            }

            @Override
            public String toString() {
                return thisSet.toString();
            }

            @Override
            public int hashCode() {
                return thisSet.hashCode();
            }

            @Override
            public boolean equals(Object obj) {
                return this == obj || thisSet.equals(obj);
            }
        };
    }
}

