/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.IdentitySet;
import java.util.concurrent.Callable;

public final class ExceptionUtilities {
    private ExceptionUtilities() {
    }

    public static Throwable getDeepestException(Throwable e) {
        IdentitySet<Throwable> seen = new IdentitySet<Throwable>();
        while (e.getCause() != null && seen.add(e)) {
            e = e.getCause();
        }
        return e;
    }

    public static <T> T safelyIgnoreException(Callable<T> callable, T defaultValue) {
        try {
            return callable.call();
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public static void safelyIgnoreException(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void safelyIgnoreException(Throwable t) {
        if (t instanceof OutOfMemoryError) {
            throw (OutOfMemoryError)t;
        }
    }

    public static <T extends Throwable> void uncheckedThrow(Throwable t) throws T {
        throw t;
    }
}

