/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ExceptionUtilities;
import com.cedarsoftware.util.ExecutionResult;
import com.cedarsoftware.util.LoggingConfig;
import com.cedarsoftware.util.StreamGobbler;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Executor {
    private String _error;
    private String _out;
    private static final long DEFAULT_TIMEOUT_SECONDS = 60L;
    private static final Logger LOG = Logger.getLogger(Executor.class.getName());

    private static boolean isExecutionEnabled() {
        return Boolean.parseBoolean(System.getProperty("executor.enabled", "false"));
    }

    private static void validateExecutionEnabled() {
        if (!Executor.isExecutionEnabled()) {
            throw new SecurityException("Command execution is disabled by default for security. To enable command execution, set system property: executor.enabled=true");
        }
    }

    public ExecutionResult execute(String command) {
        return this.execute(command, null, null);
    }

    public ExecutionResult execute(String[] cmdarray) {
        return this.execute(cmdarray, null, null);
    }

    public ExecutionResult execute(String command, String[] envp) {
        return this.execute(command, envp, null);
    }

    public ExecutionResult execute(String[] cmdarray, String[] envp) {
        return this.execute(cmdarray, envp, null);
    }

    public ExecutionResult execute(String command, String[] envp, File dir) {
        Executor.validateExecutionEnabled();
        try {
            Process proc = this.startProcess(command, envp, dir);
            return this.runIt(proc);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.log(Level.SEVERE, "Error occurred executing command: " + command, e);
            return new ExecutionResult(-1, "", e.getMessage());
        }
    }

    public ExecutionResult execute(String[] cmdarray, String[] envp, File dir) {
        Executor.validateExecutionEnabled();
        try {
            Process proc = this.startProcess(cmdarray, envp, dir);
            return this.runIt(proc);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.log(Level.SEVERE, "Error occurred executing command: " + this.cmdArrayToString(cmdarray), e);
            return new ExecutionResult(-1, "", e.getMessage());
        }
    }

    private Process startProcess(String command, String[] envp, File dir) {
        String[] stringArray;
        boolean windows = System.getProperty("os.name").toLowerCase().contains("windows");
        if (windows) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "cmd.exe";
            stringArray2[1] = "/c";
            stringArray = stringArray2;
            stringArray2[2] = command;
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "sh";
            stringArray3[1] = "-c";
            stringArray = stringArray3;
            stringArray3[2] = command;
        }
        String[] shellCmd = stringArray;
        return this.startProcess(shellCmd, envp, dir);
    }

    private Process startProcess(String[] cmdarray, String[] envp, File dir) {
        ProcessBuilder pb = new ProcessBuilder(cmdarray);
        if (envp != null) {
            for (String env : envp) {
                int idx = env.indexOf(61);
                if (idx <= 0) continue;
                pb.environment().put(env.substring(0, idx), env.substring(idx + 1));
            }
        }
        if (dir != null) {
            pb.directory(dir);
        }
        try {
            return pb.start();
        }
        catch (IOException e) {
            ExceptionUtilities.uncheckedThrow(e);
            return null;
        }
    }

    public int exec(String command) {
        ExecutionResult result = this.execute(command);
        return result.getExitCode();
    }

    public int exec(String[] cmdarray) {
        ExecutionResult result = this.execute(cmdarray);
        return result.getExitCode();
    }

    public int exec(String command, String[] envp) {
        ExecutionResult result = this.execute(command, envp);
        return result.getExitCode();
    }

    public int exec(String[] cmdarray, String[] envp) {
        ExecutionResult result = this.execute(cmdarray, envp);
        return result.getExitCode();
    }

    public int exec(String command, String[] envp, File dir) {
        ExecutionResult result = this.execute(command, envp, dir);
        return result.getExitCode();
    }

    public int exec(String[] cmdarray, String[] envp, File dir) {
        ExecutionResult result = this.execute(cmdarray, envp, dir);
        return result.getExitCode();
    }

    private ExecutionResult runIt(Process proc) throws InterruptedException {
        StreamGobbler errors = new StreamGobbler(proc.getErrorStream());
        Thread errorGobbler = new Thread(errors);
        StreamGobbler out = new StreamGobbler(proc.getInputStream());
        Thread outputGobbler = new Thread(out);
        errorGobbler.start();
        outputGobbler.start();
        boolean finished = proc.waitFor(60L, TimeUnit.SECONDS);
        if (!finished) {
            proc.destroyForcibly();
        }
        errorGobbler.join(60000L);
        outputGobbler.join(60000L);
        String err = errors.getResult();
        String outStr = out.getResult();
        int exitVal = finished ? proc.exitValue() : -1;
        this._error = err;
        this._out = outStr;
        return new ExecutionResult(exitVal, outStr, err);
    }

    public String getError() {
        return this._error;
    }

    public String getOut() {
        return this._out;
    }

    private String cmdArrayToString(String[] cmdArray) {
        return String.join((CharSequence)" ", cmdArray);
    }

    static {
        LoggingConfig.init();
    }
}

