/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IdentitySet<T>
extends AbstractSet<T> {
    private static final int DEFAULT_CAPACITY = 16;
    private static final int MAX_CAPACITY = 0x40000000;
    private static final float LOAD_FACTOR = 0.5f;
    private static final Object DELETED = new Object();
    private Object[] elements;
    private int size;
    private int threshold;
    private int mask;

    public IdentitySet() {
        this(16);
    }

    public IdentitySet(int initialCapacity) {
        int capacity;
        int target = Math.min(Math.max(initialCapacity, 1), 0x40000000);
        for (capacity = 1; capacity < target; capacity <<= 1) {
        }
        this.elements = new Object[capacity];
        this.mask = capacity - 1;
        this.threshold = (int)((float)capacity * 0.5f);
    }

    public IdentitySet(Collection<? extends T> c) {
        this(Math.max((int)((float)c.size() / 0.5f) + 1, 16));
        this.addAll(c);
    }

    @Override
    public boolean add(T element) {
        if (element == null) {
            throw new NullPointerException("IdentitySet does not support null elements");
        }
        if (this.size >= this.threshold) {
            this.resize();
        }
        return this.addInternal(element);
    }

    private boolean addInternal(Object element) {
        int hash = System.identityHashCode(element);
        int index = hash & this.mask;
        Object[] e = this.elements;
        int firstDeleted = -1;
        while (true) {
            Object existing;
            if ((existing = e[index]) == null) {
                int insertIndex = firstDeleted >= 0 ? firstDeleted : index;
                e[insertIndex] = element;
                ++this.size;
                return true;
            }
            if (existing == DELETED) {
                if (firstDeleted < 0) {
                    firstDeleted = index;
                }
            } else if (existing == element) {
                return false;
            }
            index = index + 1 & this.mask;
        }
    }

    @Override
    public boolean contains(Object element) {
        if (element == null) {
            return false;
        }
        int hash = System.identityHashCode(element);
        int index = hash & this.mask;
        Object[] e = this.elements;
        Object existing;
        while ((existing = e[index]) != null) {
            if (existing == element) {
                return true;
            }
            index = index + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean remove(Object element) {
        if (element == null) {
            return false;
        }
        int hash = System.identityHashCode(element);
        int index = hash & this.mask;
        Object[] e = this.elements;
        Object existing;
        while ((existing = e[index]) != null) {
            if (existing == element) {
                e[index] = DELETED;
                --this.size;
                return true;
            }
            index = index + 1 & this.mask;
        }
        return false;
    }

    private void resize() {
        Object[] oldElements = this.elements;
        int oldCapacity = oldElements.length;
        int newCapacity = oldCapacity << 1;
        this.elements = new Object[newCapacity];
        this.mask = newCapacity - 1;
        this.threshold = (int)((float)newCapacity * 0.5f);
        this.size = 0;
        for (int i = 0; i < oldCapacity; ++i) {
            Object element = oldElements[i];
            if (element == null || element == DELETED) continue;
            this.addInternal(element);
        }
    }

    @Override
    public void clear() {
        Object[] e = this.elements;
        for (int i = 0; i < e.length; ++i) {
            e[i] = null;
        }
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new IdentitySetIterator();
    }

    static /* synthetic */ int access$100(IdentitySet x0) {
        return x0.size;
    }

    private class IdentitySetIterator
    implements Iterator<T> {
        private int index = 0;
        private int remaining = IdentitySet.access$100(IdentitySet.this);
        private int lastReturnedIndex = -1;

        private IdentitySetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        @Override
        public T next() {
            if (this.remaining <= 0) {
                throw new NoSuchElementException();
            }
            Object[] e = IdentitySet.this.elements;
            while (this.index < e.length) {
                Object element = e[this.index];
                if (element != null && element != DELETED) {
                    this.lastReturnedIndex = this.index++;
                    --this.remaining;
                    return element;
                }
                ++this.index;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException();
            }
            ((IdentitySet)IdentitySet.this).elements[this.lastReturnedIndex] = DELETED;
            IdentitySet.this.size--;
            this.lastReturnedIndex = -1;
        }
    }
}

