/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class MathUtilities {
    public static final BigInteger BIG_INT_LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    public static final BigInteger BIG_INT_LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigDecimal BIG_DEC_DOUBLE_MIN = BigDecimal.valueOf(-1.7976931348623157E308);
    public static final BigDecimal BIG_DEC_DOUBLE_MAX = BigDecimal.valueOf(Double.MAX_VALUE);
    private static final int DEFAULT_MAX_ARRAY_SIZE = 100000;
    private static final int DEFAULT_MAX_STRING_LENGTH = 100000;
    private static final int DEFAULT_MAX_PERMUTATION_SIZE = 10;

    private static boolean isSecurityEnabled() {
        return Boolean.parseBoolean(System.getProperty("mathutilities.security.enabled", "false"));
    }

    private static int getMaxArraySize() {
        if (!MathUtilities.isSecurityEnabled()) {
            return 0;
        }
        String value = System.getProperty("mathutilities.max.array.size");
        if (value == null) {
            return 100000;
        }
        try {
            int limit = Integer.parseInt(value);
            return limit <= 0 ? 0 : limit;
        }
        catch (NumberFormatException e) {
            return 100000;
        }
    }

    private static int getMaxStringLength() {
        if (!MathUtilities.isSecurityEnabled()) {
            return 0;
        }
        String value = System.getProperty("mathutilities.max.string.length");
        if (value == null) {
            return 100000;
        }
        try {
            int limit = Integer.parseInt(value);
            return limit <= 0 ? 0 : limit;
        }
        catch (NumberFormatException e) {
            return 100000;
        }
    }

    private static int getMaxPermutationSize() {
        if (!MathUtilities.isSecurityEnabled()) {
            return 0;
        }
        String value = System.getProperty("mathutilities.max.permutation.size");
        if (value == null) {
            return 10;
        }
        try {
            int limit = Integer.parseInt(value);
            return limit <= 0 ? 0 : limit;
        }
        catch (NumberFormatException e) {
            return 10;
        }
    }

    private MathUtilities() {
    }

    public static long minimum(long ... values) {
        int len = values.length;
        if (len == 0) {
            throw new IllegalArgumentException("values cannot be empty");
        }
        int maxArraySize = MathUtilities.getMaxArraySize();
        if (maxArraySize > 0 && len > maxArraySize) {
            throw new SecurityException("Array size exceeds maximum allowed: " + maxArraySize);
        }
        long current = values[0];
        for (int i = 1; i < len; ++i) {
            current = Math.min(values[i], current);
        }
        return current;
    }

    public static long maximum(long ... values) {
        int len = values.length;
        if (len == 0) {
            throw new IllegalArgumentException("values cannot be empty");
        }
        int maxArraySize = MathUtilities.getMaxArraySize();
        if (maxArraySize > 0 && len > maxArraySize) {
            throw new SecurityException("Array size exceeds maximum allowed: " + maxArraySize);
        }
        long current = values[0];
        for (int i = 1; i < len; ++i) {
            current = Math.max(values[i], current);
        }
        return current;
    }

    public static double minimum(double ... values) {
        int len = values.length;
        if (len == 0) {
            throw new IllegalArgumentException("values cannot be empty");
        }
        int maxArraySize = MathUtilities.getMaxArraySize();
        if (maxArraySize > 0 && len > maxArraySize) {
            throw new SecurityException("Array size exceeds maximum allowed: " + maxArraySize);
        }
        double current = values[0];
        for (int i = 1; i < len; ++i) {
            current = Math.min(values[i], current);
        }
        return current;
    }

    public static double maximum(double ... values) {
        int len = values.length;
        if (len == 0) {
            throw new IllegalArgumentException("values cannot be empty");
        }
        int maxArraySize = MathUtilities.getMaxArraySize();
        if (maxArraySize > 0 && len > maxArraySize) {
            throw new SecurityException("Array size exceeds maximum allowed: " + maxArraySize);
        }
        double current = values[0];
        for (int i = 1; i < len; ++i) {
            current = Math.max(values[i], current);
        }
        return current;
    }

    public static BigInteger minimum(BigInteger ... values) {
        int len = values.length;
        if (len == 0) {
            throw new IllegalArgumentException("values cannot be empty");
        }
        int maxArraySize = MathUtilities.getMaxArraySize();
        if (maxArraySize > 0 && len > maxArraySize) {
            throw new SecurityException("Array size exceeds maximum allowed: " + maxArraySize);
        }
        BigInteger current = values[0];
        if (current == null) {
            throw new IllegalArgumentException("Cannot pass null BigInteger entry to minimum()");
        }
        for (int i = 1; i < len; ++i) {
            if (values[i] == null) {
                throw new IllegalArgumentException("Cannot pass null BigInteger entry to minimum()");
            }
            current = values[i].min(current);
        }
        return current;
    }

    public static BigInteger maximum(BigInteger ... values) {
        int len = values.length;
        if (len == 0) {
            throw new IllegalArgumentException("values cannot be empty");
        }
        int maxArraySize = MathUtilities.getMaxArraySize();
        if (maxArraySize > 0 && len > maxArraySize) {
            throw new SecurityException("Array size exceeds maximum allowed: " + maxArraySize);
        }
        BigInteger current = values[0];
        if (current == null) {
            throw new IllegalArgumentException("Cannot pass null BigInteger entry to maximum()");
        }
        for (int i = 1; i < len; ++i) {
            if (values[i] == null) {
                throw new IllegalArgumentException("Cannot pass null BigInteger entry to maximum()");
            }
            current = values[i].max(current);
        }
        return current;
    }

    public static BigDecimal minimum(BigDecimal ... values) {
        int len = values.length;
        if (len == 0) {
            throw new IllegalArgumentException("values cannot be empty");
        }
        int maxArraySize = MathUtilities.getMaxArraySize();
        if (maxArraySize > 0 && len > maxArraySize) {
            throw new SecurityException("Array size exceeds maximum allowed: " + maxArraySize);
        }
        BigDecimal current = values[0];
        if (current == null) {
            throw new IllegalArgumentException("Cannot pass null BigDecimal entry to minimum()");
        }
        for (int i = 1; i < len; ++i) {
            if (values[i] == null) {
                throw new IllegalArgumentException("Cannot pass null BigDecimal entry to minimum()");
            }
            current = values[i].min(current);
        }
        return current;
    }

    public static BigDecimal maximum(BigDecimal ... values) {
        int len = values.length;
        if (len == 0) {
            throw new IllegalArgumentException("values cannot be empty");
        }
        int maxArraySize = MathUtilities.getMaxArraySize();
        if (maxArraySize > 0 && len > maxArraySize) {
            throw new SecurityException("Array size exceeds maximum allowed: " + maxArraySize);
        }
        BigDecimal current = values[0];
        if (current == null) {
            throw new IllegalArgumentException("Cannot pass null BigDecimal entry to maximum()");
        }
        for (int i = 1; i < len; ++i) {
            if (values[i] == null) {
                throw new IllegalArgumentException("Cannot pass null BigDecimal entry to maximum()");
            }
            current = values[i].max(current);
        }
        return current;
    }

    public static Number parseToMinimalNumericType(String numStr) {
        Objects.requireNonNull(numStr, "numStr");
        int maxStringLength = MathUtilities.getMaxStringLength();
        if (maxStringLength > 0 && numStr.length() > maxStringLength) {
            throw new SecurityException("String length exceeds maximum allowed: " + maxStringLength);
        }
        boolean negative = false;
        boolean positive = false;
        int index = 0;
        if (numStr.startsWith("-")) {
            negative = true;
            index = 1;
        } else if (numStr.startsWith("+")) {
            positive = true;
            index = 1;
        }
        StringBuilder digits = new StringBuilder(numStr.length() - index);
        int len = numStr.length();
        while (index < len && numStr.charAt(index) == '0' && index + 1 < len && Character.isDigit(numStr.charAt(index + 1))) {
            ++index;
        }
        digits.append(numStr.substring(index));
        if (digits.length() == 0) {
            digits.append('0');
        }
        numStr = (negative ? "-" : (positive ? "+" : "")) + digits.toString();
        boolean hasDecimalPoint = false;
        boolean hasExponent = false;
        int mantissaSize = 0;
        StringBuilder exponentValue = new StringBuilder();
        len = numStr.length();
        for (int i = 0; i < len; ++i) {
            char c = numStr.charAt(i);
            if (c == '.') {
                hasDecimalPoint = true;
                continue;
            }
            if (c == 'e' || c == 'E') {
                hasExponent = true;
                continue;
            }
            if (c < '0' || c > '9') continue;
            if (!hasExponent) {
                ++mantissaSize;
                continue;
            }
            exponentValue.append(c);
        }
        if (hasDecimalPoint || hasExponent) {
            if (mantissaSize < 17) {
                try {
                    if (exponentValue.length() == 0 || Math.abs(Integer.parseInt(exponentValue.toString())) < 308) {
                        return Double.parseDouble(numStr);
                    }
                }
                catch (NumberFormatException i) {
                    // empty catch block
                }
            }
            return new BigDecimal(numStr);
        }
        if (numStr.length() < 19) {
            return Long.parseLong(numStr);
        }
        BigInteger bigInt = new BigInteger(numStr);
        if (bigInt.compareTo(BIG_INT_LONG_MIN) >= 0 && bigInt.compareTo(BIG_INT_LONG_MAX) <= 0) {
            return bigInt.longValue();
        }
        return bigInt;
    }

    public static <T extends Comparable<? super T>> boolean nextPermutation(List<T> list) {
        int k;
        if (list == null) {
            throw new IllegalArgumentException("list cannot be null");
        }
        int maxPermutationSize = MathUtilities.getMaxPermutationSize();
        if (maxPermutationSize > 0 && list.size() > maxPermutationSize) {
            throw new SecurityException("List size exceeds maximum allowed for permutation: " + maxPermutationSize);
        }
        for (k = list.size() - 2; k >= 0 && ((Comparable)list.get(k)).compareTo(list.get(k + 1)) >= 0; --k) {
        }
        if (k < 0) {
            return false;
        }
        int l = list.size() - 1;
        while (((Comparable)list.get(k)).compareTo(list.get(l)) >= 0) {
            --l;
        }
        Collections.swap(list, k, l);
        int i = k + 1;
        for (int j = list.size() - 1; i < j; ++i, --j) {
            Collections.swap(list, i, j);
        }
        return true;
    }
}

