/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.ClassValueSet;
import com.cedarsoftware.util.IdentitySet;
import com.cedarsoftware.util.LoggingConfig;
import com.cedarsoftware.util.StringUtilities;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public final class MultiKeyMap<V>
implements ConcurrentMap<Object, V> {
    private static final Logger LOG = Logger.getLogger(MultiKeyMap.class.getName());
    private static final Object OPEN;
    private static final Object CLOSE;
    private static final Object SET_OPEN;
    private static final Object SET_CLOSE;
    private static final Object NULL_SENTINEL;
    private static final MultiKey NULL_NORMALIZED_KEY;
    private static final ThreadLocal<Object[]> LOOKUP_KEY_2;
    private static final ThreadLocal<Object[]> LOOKUP_KEY_3;
    private static final ThreadLocal<Object[]> LOOKUP_KEY_4;
    private static final ThreadLocal<Object[]> LOOKUP_KEY_5;
    private static final String THIS_MAP = "(this Map \u267b\ufe0f)";
    private static final String EMOJI_OPEN = "[";
    private static final String EMOJI_CLOSE = "]";
    private static final String EMOJI_SET_OPEN = "{";
    private static final String EMOJI_SET_CLOSE = "}";
    private static final String EMOJI_CYCLE = "\u267b\ufe0f";
    private static final String EMOJI_EMPTY = "\u2205";
    private static final String EMOJI_KEY = "\ud83c\udd94 ";
    private static final String EMOJI_VALUE = "\ud83d\udfe3 ";
    private static final Set<Class<?>> SIMPLE_ARRAY_TYPES;
    private static final AtomicBoolean STRIPE_CONFIG_LOGGED;
    private final AtomicInteger totalLockAcquisitions = new AtomicInteger(0);
    private final AtomicInteger contentionCount = new AtomicInteger(0);
    private final AtomicInteger[] stripeLockContention = new AtomicInteger[STRIPE_COUNT];
    private final AtomicInteger[] stripeLockAcquisitions = new AtomicInteger[STRIPE_COUNT];
    private final AtomicInteger globalLockAcquisitions = new AtomicInteger(0);
    private final AtomicInteger globalLockContentions = new AtomicInteger(0);
    private final AtomicBoolean resizeInProgress = new AtomicBoolean(false);
    private volatile AtomicReferenceArray<MultiKey<V>[]> buckets;
    private final AtomicLong atomicSize = new AtomicLong(0L);
    private final AtomicInteger maxChainLength = new AtomicInteger(0);
    private final int capacity;
    private final float loadFactor;
    private final CollectionKeyMode collectionKeyMode;
    private final boolean flattenDimensions;
    private final boolean simpleKeysMode;
    private final boolean valueBasedEquality;
    private final boolean caseSensitive;
    private final boolean trackContentionMetrics;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private volatile transient Integer cachedHashCode;
    private static final int STRIPE_COUNT;
    private static final int STRIPE_MASK;
    private final ReentrantLock[] stripeLocks = new ReentrantLock[STRIPE_COUNT];

    private static int tableSizeFor(int cap) {
        int n = cap - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    private MultiKeyMap(Builder<V> builder) {
        if (((Builder)builder).loadFactor <= 0.0f || Float.isNaN(((Builder)builder).loadFactor)) {
            throw new IllegalArgumentException("Load factor must be positive: " + ((Builder)builder).loadFactor);
        }
        if (((Builder)builder).capacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + ((Builder)builder).capacity);
        }
        int actualCapacity = Math.max(MultiKeyMap.tableSizeFor(((Builder)builder).capacity), STRIPE_COUNT);
        this.buckets = new AtomicReferenceArray(actualCapacity);
        this.capacity = actualCapacity;
        this.loadFactor = ((Builder)builder).loadFactor;
        this.collectionKeyMode = ((Builder)builder).collectionKeyMode;
        this.flattenDimensions = ((Builder)builder).flattenDimensions;
        this.simpleKeysMode = ((Builder)builder).simpleKeysMode;
        this.valueBasedEquality = ((Builder)builder).valueBasedEquality;
        this.caseSensitive = ((Builder)builder).caseSensitive;
        this.trackContentionMetrics = ((Builder)builder).trackContentionMetrics;
        for (int i = 0; i < STRIPE_COUNT; ++i) {
            this.stripeLocks[i] = new ReentrantLock();
            this.stripeLockContention[i] = new AtomicInteger(0);
            this.stripeLockAcquisitions[i] = new AtomicInteger(0);
        }
        if (STRIPE_CONFIG_LOGGED.compareAndSet(false, true) && LOG.isLoggable(Level.INFO)) {
            LOG.info(String.format("MultiKeyMap stripe configuration: %d locks for %d cores", STRIPE_COUNT, Runtime.getRuntime().availableProcessors()));
        }
    }

    public MultiKeyMap(MultiKeyMap<? extends V> source) {
        this(MultiKeyMap.builder().from(source));
        super.withAllStripeLocks(() -> {
            AtomicReferenceArray<MultiKey<V>[]> sourceTable = source.buckets;
            int len = sourceTable.length();
            for (int i = 0; i < len; ++i) {
                MultiKey<V>[] chain = sourceTable.get(i);
                if (chain == null) continue;
                for (MultiKey<V> entry : chain) {
                    if (entry == null) continue;
                    Object value = entry.value;
                    MultiKey newKey = new MultiKey(entry.keys, entry.hash, value);
                    this.putInternal(newKey);
                }
            }
        });
    }

    public MultiKeyMap() {
        this(MultiKeyMap.builder());
    }

    public MultiKeyMap(int capacity) {
        this(MultiKeyMap.builder().capacity(capacity));
    }

    public MultiKeyMap(int capacity, float loadFactor) {
        this(MultiKeyMap.builder().capacity(capacity).loadFactor(loadFactor));
    }

    public static <V> Builder<V> builder() {
        return new Builder();
    }

    public CollectionKeyMode getCollectionKeyMode() {
        return this.collectionKeyMode;
    }

    public boolean getFlattenDimensions() {
        return this.flattenDimensions;
    }

    public boolean getSimpleKeysMode() {
        return this.simpleKeysMode;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public float getLoadFactor() {
        return this.loadFactor;
    }

    public boolean getValueBasedEquality() {
        return this.valueBasedEquality;
    }

    private static int computeElementHash(Object key, boolean caseSensitive) {
        if (key == null) {
            return 0;
        }
        Class<?> keyClass = key.getClass();
        if (keyClass == String.class) {
            return caseSensitive ? key.hashCode() : StringUtilities.hashCodeIgnoreCase((String)key);
        }
        if (keyClass == Integer.class) {
            return MultiKeyMap.hashLong(((Integer)key).longValue());
        }
        if (keyClass == Long.class) {
            return MultiKeyMap.hashLong((Long)key);
        }
        if (keyClass == Double.class) {
            double d = (Double)key;
            if (d == 0.0) {
                d = 0.0;
            }
            if (Double.isFinite(d) && d == Math.rint(d) && d >= -9.223372036854776E18 && d <= 9.223372036854776E18) {
                return MultiKeyMap.hashLong((long)d);
            }
            return MultiKeyMap.hashDouble(d);
        }
        if (key instanceof Number || key instanceof Boolean || key instanceof AtomicBoolean) {
            return MultiKeyMap.valueHashCode(key);
        }
        if (!caseSensitive && key instanceof CharSequence) {
            return StringUtilities.hashCodeIgnoreCase((CharSequence)key);
        }
        return key.hashCode();
    }

    private static int valueHashCode(Object o) {
        if (o == null) {
            return 0;
        }
        Class<?> clazz = o.getClass();
        if (clazz == Integer.class) {
            return MultiKeyMap.hashLong(((Integer)o).longValue());
        }
        if (clazz == Long.class) {
            return MultiKeyMap.hashLong((Long)o);
        }
        if (clazz == Double.class) {
            double d = (Double)o;
            if (d == 0.0) {
                d = 0.0;
            }
            if (Double.isFinite(d) && d == Math.rint(d) && d >= -9.223372036854776E18 && d <= 9.223372036854776E18) {
                return MultiKeyMap.hashLong((long)d);
            }
            return MultiKeyMap.hashDouble(d);
        }
        if (clazz == Float.class) {
            double d = ((Float)o).doubleValue();
            if (d == 0.0) {
                d = 0.0;
            }
            if (Double.isFinite(d) && d == Math.rint(d) && d >= -9.223372036854776E18 && d <= 9.223372036854776E18) {
                return MultiKeyMap.hashLong((long)d);
            }
            return MultiKeyMap.hashDouble(d);
        }
        if (clazz == Short.class) {
            return MultiKeyMap.hashLong(((Short)o).longValue());
        }
        if (clazz == Byte.class) {
            return MultiKeyMap.hashLong(((Byte)o).longValue());
        }
        if (clazz == Boolean.class) {
            return Boolean.hashCode((Boolean)o);
        }
        if (clazz == AtomicBoolean.class) {
            return Boolean.hashCode(((AtomicBoolean)o).get());
        }
        if (clazz == AtomicInteger.class) {
            return MultiKeyMap.hashLong(((AtomicInteger)o).get());
        }
        if (clazz == AtomicLong.class) {
            return MultiKeyMap.hashLong(((AtomicLong)o).get());
        }
        if (o instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)o;
            try {
                if ((bd.scale() <= 0 || bd.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) == 0) && bd.compareTo(new BigDecimal(Long.MAX_VALUE)) <= 0 && bd.compareTo(new BigDecimal(Long.MIN_VALUE)) >= 0) {
                    return MultiKeyMap.hashLong(bd.longValue());
                }
                double d = bd.doubleValue();
                if (d == 0.0) {
                    d = 0.0;
                }
                if (Double.isFinite(d) && d == Math.rint(d) && d >= -9.223372036854776E18 && d <= 9.223372036854776E18) {
                    return MultiKeyMap.hashLong((long)d);
                }
                return MultiKeyMap.hashDouble(d);
            }
            catch (Exception e) {
                return bd.hashCode();
            }
        }
        if (o instanceof BigInteger) {
            BigInteger bi = (BigInteger)o;
            try {
                if (bi.bitLength() < 64) {
                    return MultiKeyMap.hashLong(bi.longValue());
                }
                double d = bi.doubleValue();
                if (Double.isFinite(d) && d == Math.rint(d) && d >= -9.223372036854776E18 && d <= 9.223372036854776E18) {
                    return MultiKeyMap.hashLong((long)d);
                }
                return MultiKeyMap.hashDouble(d);
            }
            catch (Exception e) {
                return bi.hashCode();
            }
        }
        return o.hashCode();
    }

    private static int hashLong(long v) {
        return (int)(v ^ v >>> 32);
    }

    private static int hashDouble(double d) {
        long bits = Double.doubleToLongBits(d);
        return (int)(bits ^ bits >>> 32);
    }

    private static int spread(int h) {
        return h ^ h >>> 16;
    }

    private int getStripeIndex(int hash) {
        return MultiKeyMap.spread(hash) & STRIPE_MASK;
    }

    private ReentrantLock getStripeLock(int hash) {
        return this.stripeLocks[this.getStripeIndex(hash)];
    }

    private void lockAllStripes() {
        if (this.trackContentionMetrics) {
            int contended = 0;
            for (ReentrantLock lock : this.stripeLocks) {
                if (lock.tryLock()) continue;
                ++contended;
                lock.lock();
            }
            this.globalLockAcquisitions.incrementAndGet();
            if (contended > 0) {
                this.globalLockContentions.incrementAndGet();
            }
        } else {
            for (ReentrantLock lock : this.stripeLocks) {
                lock.lock();
            }
        }
    }

    private void unlockAllStripes() {
        for (int i = this.stripeLocks.length - 1; i >= 0; --i) {
            this.stripeLocks[i].unlock();
        }
    }

    public V getMultiKey(Object ... keys) {
        if (keys == null || keys.length == 0) {
            return this.get(null);
        }
        if (keys.length == 1) {
            return this.get(keys[0]);
        }
        return this.get(keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getMultiKey(Object k1, Object k2) {
        Object[] key = LOOKUP_KEY_2.get();
        key[0] = k1;
        key[1] = k2;
        try {
            V v = this.get(key);
            return v;
        }
        finally {
            key[0] = null;
            key[1] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getMultiKey(Object k1, Object k2, Object k3) {
        Object[] key = LOOKUP_KEY_3.get();
        key[0] = k1;
        key[1] = k2;
        key[2] = k3;
        try {
            V v = this.get(key);
            return v;
        }
        finally {
            key[0] = null;
            key[1] = null;
            key[2] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getMultiKey(Object k1, Object k2, Object k3, Object k4) {
        Object[] key = LOOKUP_KEY_4.get();
        key[0] = k1;
        key[1] = k2;
        key[2] = k3;
        key[3] = k4;
        try {
            V v = this.get(key);
            return v;
        }
        finally {
            key[0] = null;
            key[1] = null;
            key[2] = null;
            key[3] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getMultiKey(Object k1, Object k2, Object k3, Object k4, Object k5) {
        Object[] key = LOOKUP_KEY_5.get();
        key[0] = k1;
        key[1] = k2;
        key[2] = k3;
        key[3] = k4;
        key[4] = k5;
        try {
            V v = this.get(key);
            return v;
        }
        finally {
            key[0] = null;
            key[1] = null;
            key[2] = null;
            key[3] = null;
            key[4] = null;
        }
    }

    private Norm normalizeForLookup(Object key) {
        Class<?> keyClass;
        Norm n = new Norm();
        if (key == null) {
            n.key = NULL_SENTINEL;
            n.hash = 0;
            return n;
        }
        if (!(key instanceof Collection) && !(keyClass = key.getClass()).isArray()) {
            n.key = key;
            n.hash = MultiKeyMap.computeElementHash(key, this.caseSensitive);
            return n;
        }
        MultiKey mk = this.flattenKey(key);
        n.key = mk.keys;
        n.hash = mk.hash;
        return n;
    }

    private MultiKey<V> findSimpleOrComplexKey(Object key) {
        Class<?> keyClass;
        if (key != null && !(key instanceof Collection) && !(keyClass = key.getClass()).isArray()) {
            int hash = MultiKeyMap.computeElementHash(key, this.caseSensitive);
            AtomicReferenceArray<MultiKey<V>[]> table = this.buckets;
            int mask = table.length() - 1;
            int index = MultiKeyMap.spread(hash) & mask;
            MultiKey<V>[] chain = table.get(index);
            if (chain != null) {
                for (MultiKey<V> entry : chain) {
                    if (entry.hash != hash || entry.kind != 0 || !MultiKeyMap.elementEquals(entry.keys, key, this.valueBasedEquality, this.caseSensitive)) continue;
                    return entry;
                }
            }
            return null;
        }
        Norm n = this.normalizeForLookup(key);
        return this.findEntryWithPrecomputedHash(n.key, n.hash);
    }

    @Override
    public V get(Object key) {
        MultiKey<V> entry = this.findSimpleOrComplexKey(key);
        return entry != null ? (V)entry.value : null;
    }

    public V putMultiKey(V value, Object ... keys) {
        if (keys == null || keys.length == 0) {
            return this.put((Object)null, value);
        }
        if (keys.length == 1) {
            return this.put(keys[0], value);
        }
        return this.put(keys, value);
    }

    @Override
    public V put(Object key, V value) {
        MultiKey<V> newKey = this.createMultiKey(key, value);
        return this.putInternal(newKey);
    }

    private MultiKey<V> createMultiKey(Object key, V value) {
        Class<?> keyClass;
        boolean isKeyArray;
        if (key == null) {
            return new MultiKey<V>(MultiKeyMap.NULL_NORMALIZED_KEY.keys, MultiKeyMap.NULL_NORMALIZED_KEY.hash, value);
        }
        if (key instanceof Collection ? this.collectionKeyMode == CollectionKeyMode.COLLECTIONS_NOT_EXPANDED : !(isKeyArray = (keyClass = key.getClass()).isArray())) {
            return new MultiKey<V>(key, MultiKeyMap.computeElementHash(key, this.caseSensitive), value);
        }
        MultiKey normalizedKey = this.flattenKey(key);
        return new MultiKey<V>(normalizedKey.keys, normalizedKey.hash, value);
    }

    private void updateMaxChainLength(int newValue) {
        int current;
        while ((current = this.maxChainLength.get()) < newValue && !this.maxChainLength.compareAndSet(current, newValue)) {
        }
    }

    private boolean isArrayOrCollection(Object o) {
        if (this.simpleKeysMode) {
            return false;
        }
        if (o == null) {
            return false;
        }
        Class<?> c = o.getClass();
        if (c == String.class || c == Integer.class || c == Long.class || c == Double.class) {
            return false;
        }
        return o instanceof Collection || c.isArray();
    }

    private <T> MultiKey<T> flattenKey(Object key) {
        boolean isKeyArray;
        if (key == null) {
            return NULL_NORMALIZED_KEY;
        }
        Class<?> keyClass = key.getClass();
        if (keyClass == String.class || keyClass == Integer.class || keyClass == Long.class || keyClass == Double.class) {
            return new MultiKey<Object>(key, MultiKeyMap.computeElementHash(key, this.caseSensitive), null);
        }
        if (key instanceof AtomicIntegerArray) {
            AtomicIntegerArray atomicArr = (AtomicIntegerArray)key;
            int len = atomicArr.length();
            int[] regularArr = new int[len];
            for (int i = 0; i < len; ++i) {
                regularArr[i] = atomicArr.get(i);
            }
            return this.flattenKey(regularArr);
        }
        if (key instanceof AtomicLongArray) {
            AtomicLongArray atomicArr = (AtomicLongArray)key;
            int len = atomicArr.length();
            long[] regularArr = new long[len];
            for (int i = 0; i < len; ++i) {
                regularArr[i] = atomicArr.get(i);
            }
            return this.flattenKey(regularArr);
        }
        if (key instanceof AtomicReferenceArray) {
            AtomicReferenceArray atomicArr = (AtomicReferenceArray)key;
            int len = atomicArr.length();
            Object[] regularArr = new Object[len];
            for (int i = 0; i < len; ++i) {
                regularArr[i] = atomicArr.get(i);
            }
            return this.flattenKey(regularArr);
        }
        if (key instanceof Collection) {
            if (this.collectionKeyMode == CollectionKeyMode.COLLECTIONS_NOT_EXPANDED) {
                return new MultiKey<Object>(key, MultiKeyMap.computeElementHash(key, this.caseSensitive), null);
            }
            isKeyArray = false;
        } else {
            isKeyArray = keyClass.isArray();
            if (!isKeyArray) {
                return new MultiKey<Object>(key, MultiKeyMap.computeElementHash(key, this.caseSensitive), null);
            }
        }
        if (keyClass == Object[].class) {
            Object[] array = (Object[])key;
            if (this.simpleKeysMode) {
                switch (array.length) {
                    case 0: {
                        return new MultiKey<Object>(array, 0, null);
                    }
                    case 1: {
                        return this.flattenObjectArray1(array);
                    }
                    case 2: {
                        return this.flattenObjectArray2(array);
                    }
                    case 3: {
                        return this.flattenObjectArray3(array);
                    }
                }
                return this.flattenObjectArrayN(array, array.length);
            }
            switch (array.length) {
                case 0: {
                    return new MultiKey<Object>(array, 0, null);
                }
                case 1: {
                    return this.flattenObjectArray1(array);
                }
                case 2: {
                    return this.flattenObjectArray2(array);
                }
                case 3: {
                    return this.flattenObjectArray3(array);
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    return this.flattenObjectArrayN(array, array.length);
                }
            }
            return this.process1DObjectArray(array);
        }
        if (isKeyArray && keyClass.getComponentType().isPrimitive()) {
            int length = ArrayUtilities.getLength(key);
            if (length == 0) {
                return new MultiKey<Object>(key, 0, null);
            }
            int h = 1;
            if (keyClass == int[].class) {
                int[] array = (int[])key;
                for (int i = 0; i < length; ++i) {
                    h = h * 31 + MultiKeyMap.hashLong(array[i]);
                }
                return new MultiKey<Object>(array, h, null);
            }
            if (keyClass == long[].class) {
                long[] array = (long[])key;
                for (int i = 0; i < length; ++i) {
                    h = h * 31 + MultiKeyMap.hashLong(array[i]);
                }
                return new MultiKey<Object>(array, h, null);
            }
            if (keyClass == double[].class) {
                double[] array = (double[])key;
                for (int i = 0; i < length; ++i) {
                    double d = array[i];
                    if (d == 0.0) {
                        d = 0.0;
                    }
                    h = Double.isFinite(d) && d == Math.rint(d) && d >= -9.223372036854776E18 && d <= 9.223372036854776E18 ? h * 31 + MultiKeyMap.hashLong((long)d) : h * 31 + MultiKeyMap.hashDouble(d);
                }
                return new MultiKey<Object>(array, h, null);
            }
            if (keyClass == float[].class) {
                float[] array = (float[])key;
                for (int i = 0; i < length; ++i) {
                    double d = array[i];
                    if (d == 0.0) {
                        d = 0.0;
                    }
                    h = Double.isFinite(d) && d == Math.rint(d) && d >= -9.223372036854776E18 && d <= 9.223372036854776E18 ? h * 31 + MultiKeyMap.hashLong((long)d) : h * 31 + MultiKeyMap.hashDouble(d);
                }
                return new MultiKey<Object>(array, h, null);
            }
            if (keyClass == boolean[].class) {
                boolean[] array = (boolean[])key;
                for (int i = 0; i < length; ++i) {
                    h = h * 31 + Boolean.hashCode(array[i]);
                }
                return new MultiKey<Object>(array, h, null);
            }
            if (keyClass == byte[].class) {
                byte[] array = (byte[])key;
                for (int i = 0; i < length; ++i) {
                    h = h * 31 + MultiKeyMap.hashLong(array[i]);
                }
                return new MultiKey<Object>(array, h, null);
            }
            if (keyClass == short[].class) {
                short[] array = (short[])key;
                for (int i = 0; i < length; ++i) {
                    h = h * 31 + MultiKeyMap.hashLong(array[i]);
                }
                return new MultiKey<Object>(array, h, null);
            }
            if (keyClass == char[].class) {
                char[] array = (char[])key;
                for (int i = 0; i < length; ++i) {
                    h = h * 31 + Character.hashCode(array[i]);
                }
                return new MultiKey<Object>(array, h, null);
            }
            throw new IllegalStateException("Unknown primitive key type: " + keyClass.getName());
        }
        if (isKeyArray) {
            return this.process1DTypedArray(key);
        }
        Collection coll = (Collection)key;
        if (coll instanceof Set) {
            return this.expandWithHash(coll);
        }
        if (this.flattenDimensions) {
            return this.expandWithHash(coll);
        }
        int size = coll.size();
        if (this.simpleKeysMode) {
            switch (size) {
                case 0: {
                    return new MultiKey<Object>(ArrayUtilities.EMPTY_OBJECT_ARRAY, 0, null);
                }
                case 1: {
                    return this.flattenCollection1(coll);
                }
                case 2: {
                    return this.flattenCollection2(coll);
                }
                case 3: {
                    return this.flattenCollection3(coll);
                }
            }
            return this.flattenCollectionN(coll, size);
        }
        switch (size) {
            case 0: {
                return new MultiKey<Object>(ArrayUtilities.EMPTY_OBJECT_ARRAY, 0, null);
            }
            case 1: {
                return this.flattenCollection1(coll);
            }
            case 2: {
                return this.flattenCollection2(coll);
            }
            case 3: {
                return this.flattenCollection3(coll);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return this.flattenCollectionN(coll, size);
            }
        }
        return this.process1DCollection(coll);
    }

    private <T> MultiKey<T> flattenObjectArray1(Object[] array) {
        Object elem = array[0];
        if (!this.isArrayOrCollection(elem)) {
            int hash = 31 + MultiKeyMap.computeElementHash(elem, this.caseSensitive);
            return new MultiKey<Object>(array, hash, null);
        }
        if (this.flattenDimensions) {
            return this.expandWithHash(array);
        }
        return this.process1DObjectArray(array);
    }

    private <T> MultiKey<T> flattenObjectArray2(Object[] array) {
        Object elem0 = array[0];
        Object elem1 = array[1];
        if (this.isArrayOrCollection(elem0) || this.isArrayOrCollection(elem1)) {
            if (this.flattenDimensions) {
                return this.expandWithHash(array);
            }
            return this.process1DObjectArray(array);
        }
        int h = 31 + MultiKeyMap.computeElementHash(elem0, this.caseSensitive);
        h = h * 31 + MultiKeyMap.computeElementHash(elem1, this.caseSensitive);
        return new MultiKey<Object>(array, h, null);
    }

    private <T> MultiKey<T> flattenObjectArray3(Object[] array) {
        Object elem0 = array[0];
        Object elem1 = array[1];
        Object elem2 = array[2];
        if (this.isArrayOrCollection(elem0) || this.isArrayOrCollection(elem1) || this.isArrayOrCollection(elem2)) {
            if (this.flattenDimensions) {
                return this.expandWithHash(array);
            }
            return this.process1DObjectArray(array);
        }
        int h = 31 + MultiKeyMap.computeElementHash(elem0, this.caseSensitive);
        h = h * 31 + MultiKeyMap.computeElementHash(elem1, this.caseSensitive);
        h = h * 31 + MultiKeyMap.computeElementHash(elem2, this.caseSensitive);
        return new MultiKey<Object>(array, h, null);
    }

    private <T> MultiKey<T> flattenObjectArrayN(Object[] array, int size) {
        int h = 1;
        if (this.simpleKeysMode) {
            for (int i = 0; i < size; ++i) {
                h = h * 31 + MultiKeyMap.computeElementHash(array[i], this.caseSensitive);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                Class<?> ec;
                Object elem = array[i];
                if (elem != null && (ec = elem.getClass()) != String.class && ec != Integer.class && ec != Long.class && ec != Double.class && (elem instanceof Collection || ec.isArray())) {
                    if (this.flattenDimensions) {
                        return this.expandWithHash(array);
                    }
                    return this.process1DObjectArray(array);
                }
                h = h * 31 + MultiKeyMap.computeElementHash(elem, this.caseSensitive);
            }
        }
        return new MultiKey<Object>(array, h, null);
    }

    private <T> MultiKey<T> flattenCollection1(Collection<?> coll) {
        if (coll instanceof Set) {
            return this.expandWithHash(coll);
        }
        Iterator<?> iter = coll.iterator();
        Object elem = iter.next();
        if (!this.isArrayOrCollection(elem)) {
            int hash = 31 + MultiKeyMap.computeElementHash(elem, this.caseSensitive);
            return new MultiKey<Object>(coll, hash, null);
        }
        if (this.flattenDimensions) {
            return this.expandWithHash(coll);
        }
        return this.process1DCollection(coll);
    }

    private <T> MultiKey<T> flattenCollection2(Collection<?> coll) {
        if (coll instanceof Set) {
            return this.expandWithHash(coll);
        }
        Iterator<?> iter = coll.iterator();
        Object elem0 = iter.next();
        Object elem1 = iter.next();
        if (this.isArrayOrCollection(elem0) || this.isArrayOrCollection(elem1)) {
            if (this.flattenDimensions) {
                return this.expandWithHash(coll);
            }
            return this.process1DCollection(coll);
        }
        int h = 31 + MultiKeyMap.computeElementHash(elem0, this.caseSensitive);
        h = h * 31 + MultiKeyMap.computeElementHash(elem1, this.caseSensitive);
        return new MultiKey<Object>(coll, h, null);
    }

    private <T> MultiKey<T> flattenCollection3(Collection<?> coll) {
        if (coll instanceof Set) {
            return this.expandWithHash(coll);
        }
        Iterator<?> iter = coll.iterator();
        Object elem0 = iter.next();
        Object elem1 = iter.next();
        Object elem2 = iter.next();
        if (this.isArrayOrCollection(elem0) || this.isArrayOrCollection(elem1) || this.isArrayOrCollection(elem2)) {
            if (this.flattenDimensions) {
                return this.expandWithHash(coll);
            }
            return this.process1DCollection(coll);
        }
        int h = 31 + MultiKeyMap.computeElementHash(elem0, this.caseSensitive);
        h = h * 31 + MultiKeyMap.computeElementHash(elem1, this.caseSensitive);
        h = h * 31 + MultiKeyMap.computeElementHash(elem2, this.caseSensitive);
        return new MultiKey<Object>(coll, h, null);
    }

    private <T> MultiKey<T> flattenCollectionN(Collection<?> coll, int size) {
        if (coll instanceof Set) {
            return this.expandWithHash(coll);
        }
        Iterator<?> iter = coll.iterator();
        int h = 1;
        if (this.simpleKeysMode) {
            for (int i = 0; i < size; ++i) {
                h = h * 31 + MultiKeyMap.computeElementHash(iter.next(), this.caseSensitive);
            }
        } else {
            boolean flattenDimLocal = this.flattenDimensions;
            for (int i = 0; i < size; ++i) {
                boolean isArrayOrCollection;
                Object elem = iter.next();
                boolean bl = isArrayOrCollection = elem instanceof Collection || elem != null && elem.getClass().isArray();
                if (isArrayOrCollection) {
                    if (flattenDimLocal) {
                        return this.expandWithHash(coll);
                    }
                    return this.process1DCollection(coll);
                }
                h = h * 31 + MultiKeyMap.computeElementHash(elem, this.caseSensitive);
            }
        }
        return new MultiKey<Object>(coll, h, null);
    }

    private <T> MultiKey<T> process1DObjectArray(Object[] array) {
        int len = array.length;
        if (len == 0) {
            return new MultiKey<Object>(array, 0, null);
        }
        int h = 1;
        boolean is1D = true;
        for (int i = 0; i < len; ++i) {
            Object e = array[i];
            if (e == null) {
                h *= 31;
                continue;
            }
            Class<?> eClass = e.getClass();
            if (eClass.isArray() || e instanceof Collection) {
                is1D = false;
                break;
            }
            h = h * 31 + MultiKeyMap.computeElementHash(e, this.caseSensitive);
        }
        if (is1D) {
            return new MultiKey<Object>(array, h, null);
        }
        return this.expandWithHash(array);
    }

    private <T> MultiKey<T> process1DCollection(Collection<?> coll) {
        if (coll instanceof Set) {
            return this.expandWithHash(coll);
        }
        if (coll.isEmpty()) {
            return new MultiKey<Object>(ArrayUtilities.EMPTY_OBJECT_ARRAY, 0, null);
        }
        int h = 1;
        boolean is1D = true;
        for (Object e : coll) {
            h = h * 31 + MultiKeyMap.computeElementHash(e, this.caseSensitive);
            if (!(e instanceof Collection) && (e == null || !e.getClass().isArray())) continue;
            is1D = false;
            break;
        }
        if (is1D) {
            return new MultiKey<Object>(coll, h, null);
        }
        return this.expandWithHash(coll);
    }

    private <T> MultiKey<T> process1DTypedArray(Object arr) {
        Class<?> clazz = arr.getClass();
        if (SIMPLE_ARRAY_TYPES.contains(clazz)) {
            Object[] objArray = (Object[])arr;
            int len = objArray.length;
            if (len == 0) {
                return new MultiKey<Object>(objArray, 0, null);
            }
            int h = 1;
            for (int i = 0; i < len; ++i) {
                Object o = objArray[i];
                h = h * 31 + MultiKeyMap.computeElementHash(o, this.caseSensitive);
            }
            return new MultiKey<Object>(objArray, h, null);
        }
        return this.process1DGenericArray(arr);
    }

    private <T> MultiKey<T> process1DGenericArray(Object arr) {
        int len = ArrayUtilities.getLength(arr);
        if (len == 0) {
            return new MultiKey<Object>(arr, 0, null);
        }
        int h = 1;
        boolean is1D = true;
        for (int i = 0; i < len; ++i) {
            Object e = ArrayUtilities.getElement(arr, i);
            h = h * 31 + MultiKeyMap.computeElementHash(e, this.caseSensitive);
            if (!(e instanceof Collection) && (e == null || !e.getClass().isArray())) continue;
            is1D = false;
            break;
        }
        if (is1D) {
            return new MultiKey<Object>(arr, h, null);
        }
        return this.expandWithHash(arr);
    }

    private <T> MultiKey<T> expandWithHash(Object key) {
        int estimatedSize = 8;
        if (key != null) {
            if (key.getClass().isArray()) {
                int len = ArrayUtilities.getLength(key);
                estimatedSize = this.flattenDimensions ? len : len + 2;
                estimatedSize = Math.min(estimatedSize + estimatedSize / 2, 64);
            } else if (key instanceof Collection) {
                int size = ((Collection)key).size();
                estimatedSize = this.flattenDimensions ? size : size + 2;
                estimatedSize = Math.min(estimatedSize + estimatedSize / 2, 64);
            }
        }
        ArrayList<Object> expanded = new ArrayList<Object>(estimatedSize);
        IdentitySet<Object> visited = new IdentitySet<Object>();
        int hash = MultiKeyMap.expandAndHash(key, expanded, visited, 1, this.flattenDimensions, this.caseSensitive);
        return new MultiKey<Object>(expanded, hash, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int expandAndHash(Object current, List<Object> result, IdentitySet<Object> visited, int runningHash, boolean useFlatten, boolean caseSensitive) {
        if (current == null) {
            result.add(NULL_SENTINEL);
            return runningHash * 31 + NULL_SENTINEL.hashCode();
        }
        Class<?> clazz = current.getClass();
        if (clazz == String.class || clazz == Integer.class || clazz == Long.class || clazz == Double.class || clazz == Boolean.class || clazz == Short.class || clazz == Byte.class || clazz == Character.class || clazz == Float.class) {
            result.add(current);
            return runningHash * 31 + MultiKeyMap.computeElementHash(current, caseSensitive);
        }
        if (visited.contains(current)) {
            String cycle = EMOJI_CYCLE + System.identityHashCode(current);
            result.add(cycle);
            return runningHash * 31 + cycle.hashCode();
        }
        if (clazz.getComponentType() != null) {
            visited.add(current);
            try {
                if (!useFlatten) {
                    result.add(OPEN);
                    runningHash = runningHash * 31 + OPEN.hashCode();
                }
                int len = ArrayUtilities.getLength(current);
                for (int i = 0; i < len; ++i) {
                    runningHash = MultiKeyMap.expandAndHash(ArrayUtilities.getElement(current, i), result, visited, runningHash, useFlatten, caseSensitive);
                }
                if (useFlatten) return runningHash;
                result.add(CLOSE);
                runningHash = runningHash * 31 + CLOSE.hashCode();
                return runningHash;
            }
            finally {
                visited.remove(current);
            }
        } else if (current instanceof Collection) {
            Collection coll = (Collection)current;
            boolean isSet = current instanceof Set;
            visited.add(current);
            try {
                if (isSet) {
                    result.add(SET_OPEN);
                    runningHash = runningHash * 31 + SET_OPEN.hashCode();
                    int setHash = 0;
                    for (Object e : coll) {
                        int elemHash = MultiKeyMap.expandAndHash(e, result, visited, 1, useFlatten, caseSensitive);
                        setHash ^= Integer.rotateLeft(elemHash, 1);
                    }
                    runningHash = runningHash * 31 + setHash;
                    result.add(SET_CLOSE);
                    runningHash = runningHash * 31 + SET_CLOSE.hashCode();
                    return runningHash;
                }
                if (!useFlatten) {
                    result.add(OPEN);
                    runningHash = runningHash * 31 + OPEN.hashCode();
                }
                for (Object e : coll) {
                    runningHash = MultiKeyMap.expandAndHash(e, result, visited, runningHash, useFlatten, caseSensitive);
                }
                if (useFlatten) return runningHash;
                result.add(CLOSE);
                runningHash = runningHash * 31 + CLOSE.hashCode();
                return runningHash;
            }
            finally {
                visited.remove(current);
            }
        } else {
            result.add(current);
            return runningHash * 31 + MultiKeyMap.computeElementHash(current, caseSensitive);
        }
    }

    private MultiKey<V> findEntryWithPrecomputedHash(Object normalizedKey, int hash) {
        AtomicReferenceArray<MultiKey<V>[]> table = this.buckets;
        int mask = table.length() - 1;
        int index = MultiKeyMap.spread(hash) & mask;
        MultiKey<V>[] chain = table.get(index);
        if (chain == null) {
            return null;
        }
        for (MultiKey<V> entry : chain) {
            if (entry.hash != hash || !this.keysMatch(entry, normalizedKey)) continue;
            return entry;
        }
        return null;
    }

    private boolean keysMatch(MultiKey<V> stored, Object lookup) {
        boolean skipSizeCheck;
        byte lookupKind;
        int lookupSize;
        if (stored.keys == lookup) {
            return true;
        }
        if (stored.keys == null || lookup == null) {
            return false;
        }
        Class<?> lookupClass = lookup.getClass();
        if (stored.kind == 0) {
            if (lookupClass.isArray() || lookup instanceof Collection) {
                if (stored.keys instanceof Collection || stored.keys.getClass().isArray()) {
                    return MultiKeyMap.elementEquals(stored.keys, lookup, this.valueBasedEquality, this.caseSensitive);
                }
                return false;
            }
            return MultiKeyMap.elementEquals(stored.keys, lookup, this.valueBasedEquality, this.caseSensitive);
        }
        if (lookupClass.isArray()) {
            lookupSize = ArrayUtilities.getLength(lookup);
            Class<?> componentType = lookupClass.getComponentType();
            lookupKind = componentType != null && componentType.isPrimitive() ? (byte)3 : 1;
        } else if (lookup instanceof Collection) {
            lookupSize = ((Collection)lookup).size();
            lookupKind = 2;
        } else {
            return false;
        }
        boolean bl = skipSizeCheck = this.collectionKeyMode == CollectionKeyMode.COLLECTIONS_EXPANDED && stored.kind == 2 && lookupKind == 2;
        if (!skipSizeCheck && stored.size != lookupSize) {
            return false;
        }
        if (this.collectionKeyMode == CollectionKeyMode.COLLECTIONS_NOT_EXPANDED && stored.kind == 2) {
            if (!(lookup instanceof Collection)) {
                return false;
            }
            return stored.keys.equals(lookup);
        }
        Class<?> storeKeysClass = stored.keys.getClass();
        return this.compareContainers(stored.keys, lookup, stored.size, stored.kind, lookupKind, storeKeysClass, lookupClass, this.valueBasedEquality, this.caseSensitive);
    }

    private boolean compareContainers(Object stored, Object lookup, int size, byte storedKind, byte lookupKind, Class<?> storedClass, Class<?> lookupClass, boolean valueBasedEquality, boolean caseSensitive) {
        if (storedKind == lookupKind) {
            switch (storedKind) {
                case 1: {
                    return this.compareObjectArrays((Object[])stored, (Object[])lookup, size);
                }
                case 2: {
                    return MultiKeyMap.compareCollections((Collection)stored, (Collection)lookup, size, valueBasedEquality, caseSensitive);
                }
                case 3: {
                    if (storedClass != lookupClass) break;
                    return this.compareSamePrimitiveArrays(stored, lookup, storedClass, valueBasedEquality);
                }
            }
        }
        if (storedKind == 1 && lookupKind == 2) {
            return MultiKeyMap.compareObjectArrayToCollection((Object[])stored, (Collection)lookup, size, valueBasedEquality, caseSensitive);
        }
        if (storedKind == 2 && lookupKind == 1) {
            return MultiKeyMap.compareObjectArrayToCollection((Object[])lookup, (Collection)stored, size, valueBasedEquality, caseSensitive);
        }
        if (storedKind == 3 && lookupKind == 2) {
            return MultiKeyMap.comparePrimitiveArrayToCollection(stored, (Collection)lookup, size, valueBasedEquality, caseSensitive);
        }
        if (storedKind == 2 && lookupKind == 3) {
            return MultiKeyMap.comparePrimitiveArrayToCollection(lookup, (Collection)stored, size, valueBasedEquality, caseSensitive);
        }
        if (storedKind == 3 && lookupKind == 1) {
            return MultiKeyMap.comparePrimitiveArrayToObjectArray(stored, (Object[])lookup, size, valueBasedEquality, caseSensitive);
        }
        if (storedKind == 1 && lookupKind == 3) {
            return MultiKeyMap.comparePrimitiveArrayToObjectArray(lookup, (Object[])stored, size, valueBasedEquality, caseSensitive);
        }
        Iterator<Object> storedIter = storedKind == 2 ? ((Collection)stored).iterator() : new ArrayIterator(stored);
        Iterator<Object> lookupIter = lookupKind == 2 ? ((Collection)lookup).iterator() : new ArrayIterator(lookup);
        for (int i = 0; i < size; ++i) {
            if (MultiKeyMap.elementEquals(storedIter.next(), lookupIter.next(), valueBasedEquality, caseSensitive)) continue;
            return false;
        }
        return true;
    }

    private boolean compareSamePrimitiveArrays(Object array1, Object array2, Class<?> arrayClass, boolean valueBasedEquality) {
        if (arrayClass == double[].class) {
            double[] a = (double[])array1;
            double[] b = (double[])array2;
            if (valueBasedEquality) {
                for (int i = 0; i < a.length; ++i) {
                    double x = a[i];
                    double y = b[i];
                    if (x == y || Double.isNaN(x) && Double.isNaN(y)) continue;
                    return false;
                }
                return true;
            }
            return Arrays.equals(a, b);
        }
        if (arrayClass == float[].class) {
            float[] a = (float[])array1;
            float[] b = (float[])array2;
            if (valueBasedEquality) {
                for (int i = 0; i < a.length; ++i) {
                    float x = a[i];
                    float y = b[i];
                    if (x == y || Float.isNaN(x) && Float.isNaN(y)) continue;
                    return false;
                }
                return true;
            }
            return Arrays.equals(a, b);
        }
        if (arrayClass == int[].class) {
            return Arrays.equals((int[])array1, (int[])array2);
        }
        if (arrayClass == long[].class) {
            return Arrays.equals((long[])array1, (long[])array2);
        }
        if (arrayClass == boolean[].class) {
            return Arrays.equals((boolean[])array1, (boolean[])array2);
        }
        if (arrayClass == byte[].class) {
            return Arrays.equals((byte[])array1, (byte[])array2);
        }
        if (arrayClass == char[].class) {
            return Arrays.equals((char[])array1, (char[])array2);
        }
        if (arrayClass == short[].class) {
            return Arrays.equals((short[])array1, (short[])array2);
        }
        return false;
    }

    private boolean compareObjectArrays(Object[] array1, Object[] array2, int size) {
        int i = 0;
        while (i < size) {
            Object elem1 = array1[i];
            Object elem2 = array2[i];
            if (elem1 == SET_OPEN && elem2 == SET_OPEN) {
                int startIdx = ++i;
                int setSize = 0;
                while (i < size) {
                    Object next1 = array1[i];
                    Object next2 = array2[i];
                    if (next1 == SET_CLOSE && next2 == SET_CLOSE) break;
                    if (next1 == SET_CLOSE || next2 == SET_CLOSE) {
                        return false;
                    }
                    ++setSize;
                    ++i;
                }
                if (setSize != 0) {
                    if (setSize <= 6) {
                        boolean[] consumed = new boolean[setSize];
                        for (int s1 = startIdx; s1 < startIdx + setSize; ++s1) {
                            boolean found = false;
                            for (int s2 = startIdx; s2 < startIdx + setSize; ++s2) {
                                if (consumed[s2 - startIdx] || !MultiKeyMap.elementEquals(array1[s1], array2[s2], this.valueBasedEquality, this.caseSensitive)) continue;
                                consumed[s2 - startIdx] = true;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            return false;
                        }
                    } else {
                        int idx;
                        HashMap<Integer, List> hashBuckets = new HashMap<Integer, List>(Math.max(16, setSize * 4 / 3));
                        for (idx = startIdx; idx < startIdx + setSize; ++idx) {
                            Object elem = array2[idx];
                            int hash = MultiKeyMap.computeElementHash(elem, this.caseSensitive);
                            List bucket = hashBuckets.computeIfAbsent(hash, (? super K k) -> new ArrayList(2));
                            bucket.add(elem);
                        }
                        for (idx = startIdx; idx < startIdx + setSize; ++idx) {
                            Object setElem1 = array1[idx];
                            int hash1 = MultiKeyMap.computeElementHash(setElem1, this.caseSensitive);
                            List candidates = (List)hashBuckets.get(hash1);
                            boolean matched = false;
                            if (candidates != null && !candidates.isEmpty()) {
                                Iterator it = candidates.iterator();
                                while (it.hasNext()) {
                                    Object candidate = it.next();
                                    if (!MultiKeyMap.elementEquals(setElem1, candidate, this.valueBasedEquality, this.caseSensitive)) continue;
                                    it.remove();
                                    if (candidates.isEmpty()) {
                                        hashBuckets.remove(hash1);
                                    }
                                    matched = true;
                                    break;
                                }
                            }
                            if (!matched) {
                                Iterator bucketIter = hashBuckets.entrySet().iterator();
                                while (bucketIter.hasNext()) {
                                    Map.Entry bucket = bucketIter.next();
                                    if ((Integer)bucket.getKey() == hash1) continue;
                                    List otherCandidates = (List)bucket.getValue();
                                    Iterator it = otherCandidates.iterator();
                                    while (it.hasNext()) {
                                        Object candidate = it.next();
                                        if (!MultiKeyMap.elementEquals(elem1, candidate, this.valueBasedEquality, this.caseSensitive)) continue;
                                        it.remove();
                                        if (otherCandidates.isEmpty()) {
                                            bucketIter.remove();
                                        }
                                        matched = true;
                                        break;
                                    }
                                    if (!matched) continue;
                                    break;
                                }
                            }
                            if (matched) continue;
                            return false;
                        }
                    }
                }
                ++i;
                continue;
            }
            if (elem1 == SET_OPEN || elem2 == SET_OPEN) {
                return false;
            }
            if (!MultiKeyMap.elementEquals(elem1, elem2, this.valueBasedEquality, this.caseSensitive)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean compareObjectArrayToCollection(Object[] array, Collection<?> coll, int size, boolean valueBasedEquality, boolean caseSensitive) {
        Iterator<?> iter = coll.iterator();
        int i = 0;
        while (i < size) {
            Object elem1 = array[i];
            Object elem2 = iter.next();
            if (elem1 == SET_OPEN && elem2 == SET_OPEN) {
                Object next;
                int arrayStartIdx = ++i;
                int arraySetSize = 0;
                while (i < size && array[i] != SET_CLOSE) {
                    ++arraySetSize;
                    ++i;
                }
                ArrayList iterElements = new ArrayList();
                while (iter.hasNext() && (next = iter.next()) != SET_CLOSE) {
                    iterElements.add(next);
                }
                int setSize = arraySetSize;
                if (iterElements.size() != setSize) {
                    return false;
                }
                if (setSize != 0) {
                    if (setSize <= 6) {
                        boolean[] consumed = new boolean[setSize];
                        for (int s1 = arrayStartIdx; s1 < arrayStartIdx + arraySetSize; ++s1) {
                            boolean found = false;
                            for (int s2 = 0; s2 < iterElements.size(); ++s2) {
                                if (consumed[s2] || !MultiKeyMap.elementEquals(array[s1], iterElements.get(s2), valueBasedEquality, caseSensitive)) continue;
                                consumed[s2] = true;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            return false;
                        }
                    } else {
                        HashMap<Integer, List> hashBuckets = new HashMap<Integer, List>(Math.max(16, setSize * 4 / 3));
                        for (Object elem : iterElements) {
                            int hash = MultiKeyMap.computeElementHash(elem, caseSensitive);
                            List bucket = hashBuckets.computeIfAbsent(hash, (? super K k) -> new ArrayList(2));
                            bucket.add(elem);
                        }
                        for (int idx = arrayStartIdx; idx < arrayStartIdx + arraySetSize; ++idx) {
                            Object arrayElem = array[idx];
                            int hash1 = MultiKeyMap.computeElementHash(arrayElem, caseSensitive);
                            List candidates = (List)hashBuckets.get(hash1);
                            boolean matched = false;
                            if (candidates != null && !candidates.isEmpty()) {
                                Iterator it = candidates.iterator();
                                while (it.hasNext()) {
                                    Object candidate = it.next();
                                    if (!MultiKeyMap.elementEquals(arrayElem, candidate, valueBasedEquality, caseSensitive)) continue;
                                    it.remove();
                                    if (candidates.isEmpty()) {
                                        hashBuckets.remove(hash1);
                                    }
                                    matched = true;
                                    break;
                                }
                            }
                            if (!matched) {
                                Iterator bucketIter = hashBuckets.entrySet().iterator();
                                while (bucketIter.hasNext()) {
                                    Map.Entry bucket = bucketIter.next();
                                    if ((Integer)bucket.getKey() == hash1) continue;
                                    List otherCandidates = (List)bucket.getValue();
                                    Iterator it = otherCandidates.iterator();
                                    while (it.hasNext()) {
                                        Object candidate = it.next();
                                        if (!MultiKeyMap.elementEquals(arrayElem, candidate, valueBasedEquality, caseSensitive)) continue;
                                        it.remove();
                                        if (otherCandidates.isEmpty()) {
                                            bucketIter.remove();
                                        }
                                        matched = true;
                                        break;
                                    }
                                    if (!matched) continue;
                                    break;
                                }
                            }
                            if (matched) continue;
                            return false;
                        }
                    }
                }
                ++i;
                continue;
            }
            if (elem1 == SET_OPEN || elem2 == SET_OPEN) {
                return false;
            }
            if (!MultiKeyMap.elementEquals(elem1, elem2, valueBasedEquality, caseSensitive)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean compareCollections(Collection<?> coll1, Collection<?> coll2, int size, boolean valueBasedEquality, boolean caseSensitive) {
        Iterator<?> iter1 = coll1.iterator();
        Iterator<?> iter2 = coll2.iterator();
        int i = 0;
        while (i < size) {
            Object elem1 = iter1.next();
            Object elem2 = iter2.next();
            if (elem1 == SET_OPEN && elem2 == SET_OPEN) {
                ++i;
                ArrayList set1Elements = new ArrayList();
                ArrayList set2Elements = new ArrayList();
                int depth1 = 1;
                while (iter1.hasNext() && depth1 > 0) {
                    Object next1 = iter1.next();
                    ++i;
                    if (next1 == SET_OPEN) {
                        ++depth1;
                        set1Elements.add(next1);
                        continue;
                    }
                    if (next1 == SET_CLOSE) {
                        if (--depth1 <= 0) continue;
                        set1Elements.add(next1);
                        continue;
                    }
                    set1Elements.add(next1);
                }
                int depth2 = 1;
                while (iter2.hasNext() && depth2 > 0) {
                    Object next2 = iter2.next();
                    if (next2 == SET_OPEN) {
                        ++depth2;
                        set2Elements.add(next2);
                        continue;
                    }
                    if (next2 == SET_CLOSE) {
                        if (--depth2 <= 0) continue;
                        set2Elements.add(next2);
                        continue;
                    }
                    set2Elements.add(next2);
                }
                int setSize = set1Elements.size();
                if (set2Elements.size() != setSize) {
                    return false;
                }
                if (setSize == 0) continue;
                if (setSize <= 6) {
                    boolean[] consumed = new boolean[setSize];
                    for (int s1 = 0; s1 < set1Elements.size(); ++s1) {
                        boolean found = false;
                        for (int s2 = 0; s2 < set2Elements.size(); ++s2) {
                            if (consumed[s2] || !MultiKeyMap.elementEquals(set1Elements.get(s1), set2Elements.get(s2), valueBasedEquality, caseSensitive)) continue;
                            consumed[s2] = true;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        return false;
                    }
                    continue;
                }
                HashMap<Integer, List> hashBuckets = new HashMap<Integer, List>(Math.max(16, setSize * 4 / 3));
                for (Object elem : set2Elements) {
                    int hash = MultiKeyMap.computeElementHash(elem, caseSensitive);
                    List bucket = hashBuckets.computeIfAbsent(hash, (? super K k) -> new ArrayList(2));
                    bucket.add(elem);
                }
                for (Object setElem1 : set1Elements) {
                    int hash1 = MultiKeyMap.computeElementHash(setElem1, caseSensitive);
                    List candidates = (List)hashBuckets.get(hash1);
                    boolean matched = false;
                    if (candidates != null && !candidates.isEmpty()) {
                        Iterator it = candidates.iterator();
                        while (it.hasNext()) {
                            Object candidate = it.next();
                            if (!MultiKeyMap.elementEquals(setElem1, candidate, valueBasedEquality, caseSensitive)) continue;
                            it.remove();
                            if (candidates.isEmpty()) {
                                hashBuckets.remove(hash1);
                            }
                            matched = true;
                            break;
                        }
                    }
                    if (!matched) {
                        Iterator bucketIter = hashBuckets.entrySet().iterator();
                        while (bucketIter.hasNext()) {
                            Map.Entry bucket = bucketIter.next();
                            if ((Integer)bucket.getKey() == hash1) continue;
                            List otherCandidates = (List)bucket.getValue();
                            Iterator it = otherCandidates.iterator();
                            while (it.hasNext()) {
                                Object candidate = it.next();
                                if (!MultiKeyMap.elementEquals(setElem1, candidate, valueBasedEquality, caseSensitive)) continue;
                                it.remove();
                                if (otherCandidates.isEmpty()) {
                                    bucketIter.remove();
                                }
                                matched = true;
                                break;
                            }
                            if (!matched) continue;
                            break;
                        }
                    }
                    if (matched) continue;
                    return false;
                }
                continue;
            }
            if (elem1 == SET_OPEN || elem2 == SET_OPEN) {
                return false;
            }
            if (!MultiKeyMap.elementEquals(elem1, elem2, valueBasedEquality, caseSensitive)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean comparePrimitiveArrayToElements(Object primArray, ElementAccessor accessor, int size, boolean valueBasedEquality, boolean caseSensitive) {
        Class<?> arrayClass = primArray.getClass();
        if (arrayClass == int[].class) {
            int[] array = (int[])primArray;
            for (int i = 0; i < size; ++i) {
                if (MultiKeyMap.elementEquals(array[i], accessor.get(i), valueBasedEquality, caseSensitive)) continue;
                return false;
            }
            return true;
        }
        if (arrayClass == long[].class) {
            long[] array = (long[])primArray;
            for (int i = 0; i < size; ++i) {
                if (MultiKeyMap.elementEquals(array[i], accessor.get(i), valueBasedEquality, caseSensitive)) continue;
                return false;
            }
            return true;
        }
        if (arrayClass == double[].class) {
            double[] array = (double[])primArray;
            for (int i = 0; i < size; ++i) {
                if (MultiKeyMap.elementEquals(array[i], accessor.get(i), valueBasedEquality, caseSensitive)) continue;
                return false;
            }
            return true;
        }
        if (arrayClass == float[].class) {
            float[] array = (float[])primArray;
            for (int i = 0; i < size; ++i) {
                if (MultiKeyMap.elementEquals(Float.valueOf(array[i]), accessor.get(i), valueBasedEquality, caseSensitive)) continue;
                return false;
            }
            return true;
        }
        if (arrayClass == boolean[].class) {
            boolean[] array = (boolean[])primArray;
            for (int i = 0; i < size; ++i) {
                if (MultiKeyMap.elementEquals(array[i], accessor.get(i), valueBasedEquality, caseSensitive)) continue;
                return false;
            }
            return true;
        }
        if (arrayClass == byte[].class) {
            byte[] array = (byte[])primArray;
            for (int i = 0; i < size; ++i) {
                if (MultiKeyMap.elementEquals(array[i], accessor.get(i), valueBasedEquality, caseSensitive)) continue;
                return false;
            }
            return true;
        }
        if (arrayClass == char[].class) {
            char[] array = (char[])primArray;
            for (int i = 0; i < size; ++i) {
                if (MultiKeyMap.elementEquals(Character.valueOf(array[i]), accessor.get(i), valueBasedEquality, caseSensitive)) continue;
                return false;
            }
            return true;
        }
        if (arrayClass == short[].class) {
            short[] array = (short[])primArray;
            for (int i = 0; i < size; ++i) {
                if (MultiKeyMap.elementEquals(array[i], accessor.get(i), valueBasedEquality, caseSensitive)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean comparePrimitiveArrayToObjectArray(Object primArray, Object[] objArray, int size, boolean valueBasedEquality, boolean caseSensitive) {
        return MultiKeyMap.comparePrimitiveArrayToElements(primArray, i -> objArray[i], size, valueBasedEquality, caseSensitive);
    }

    private static boolean comparePrimitiveArrayToCollection(Object array, Collection<?> coll, int size, boolean valueBasedEquality, boolean caseSensitive) {
        Iterator<?> iter = coll.iterator();
        Class<?> arrayClass = array.getClass();
        if (arrayClass == int[].class) {
            int[] intArray = (int[])array;
            for (int i = 0; i < size; ++i) {
                if (MultiKeyMap.elementEquals(intArray[i], iter.next(), valueBasedEquality, caseSensitive)) continue;
                return false;
            }
            return true;
        }
        if (arrayClass == long[].class) {
            long[] longArray = (long[])array;
            for (int i = 0; i < size; ++i) {
                if (MultiKeyMap.elementEquals(longArray[i], iter.next(), valueBasedEquality, caseSensitive)) continue;
                return false;
            }
            return true;
        }
        if (arrayClass == double[].class) {
            double[] doubleArray = (double[])array;
            for (int i = 0; i < size; ++i) {
                if (MultiKeyMap.elementEquals(doubleArray[i], iter.next(), valueBasedEquality, caseSensitive)) continue;
                return false;
            }
            return true;
        }
        if (arrayClass == float[].class) {
            float[] floatArray = (float[])array;
            for (int i = 0; i < size; ++i) {
                if (MultiKeyMap.elementEquals(Float.valueOf(floatArray[i]), iter.next(), valueBasedEquality, caseSensitive)) continue;
                return false;
            }
            return true;
        }
        if (arrayClass == boolean[].class) {
            boolean[] boolArray = (boolean[])array;
            for (int i = 0; i < size; ++i) {
                if (MultiKeyMap.elementEquals(boolArray[i], iter.next(), valueBasedEquality, caseSensitive)) continue;
                return false;
            }
            return true;
        }
        if (arrayClass == byte[].class) {
            byte[] byteArray = (byte[])array;
            for (int i = 0; i < size; ++i) {
                if (MultiKeyMap.elementEquals(byteArray[i], iter.next(), valueBasedEquality, caseSensitive)) continue;
                return false;
            }
            return true;
        }
        if (arrayClass == char[].class) {
            char[] charArray = (char[])array;
            for (int i = 0; i < size; ++i) {
                if (MultiKeyMap.elementEquals(Character.valueOf(charArray[i]), iter.next(), valueBasedEquality, caseSensitive)) continue;
                return false;
            }
            return true;
        }
        if (arrayClass == short[].class) {
            short[] shortArray = (short[])array;
            for (int i = 0; i < size; ++i) {
                if (MultiKeyMap.elementEquals(shortArray[i], iter.next(), valueBasedEquality, caseSensitive)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean elementEquals(Object a, Object b, boolean valueBasedEquality, boolean caseSensitive) {
        if (a == b) {
            return true;
        }
        if (a == NULL_SENTINEL) {
            a = null;
        }
        if (b == NULL_SENTINEL) {
            b = null;
        }
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (!caseSensitive && a instanceof CharSequence && b instanceof CharSequence) {
            return StringUtilities.equalsIgnoreCase((CharSequence)a, (CharSequence)b);
        }
        if (valueBasedEquality) {
            return MultiKeyMap.valueEquals(a, b);
        }
        if (MultiKeyMap.isAtomicType(a) && MultiKeyMap.isAtomicType(b)) {
            return MultiKeyMap.atomicValueEquals(a, b);
        }
        return Objects.equals(a, b);
    }

    private static boolean isAtomicType(Object o) {
        return o instanceof AtomicBoolean || o instanceof AtomicInteger || o instanceof AtomicLong;
    }

    private static boolean atomicValueEquals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a instanceof AtomicBoolean && b instanceof AtomicBoolean) {
            return ((AtomicBoolean)a).get() == ((AtomicBoolean)b).get();
        }
        if (a instanceof AtomicInteger && b instanceof AtomicInteger) {
            return ((AtomicInteger)a).get() == ((AtomicInteger)b).get();
        }
        if (a instanceof AtomicLong && b instanceof AtomicLong) {
            return ((AtomicLong)a).get() == ((AtomicLong)b).get();
        }
        return false;
    }

    private static boolean valueEquals(Object a, Object b) {
        if (a == null || b == null) {
            return false;
        }
        if ((a instanceof Boolean || a instanceof AtomicBoolean) && (b instanceof Boolean || b instanceof AtomicBoolean)) {
            boolean valA = a instanceof Boolean ? ((Boolean)a).booleanValue() : ((AtomicBoolean)a).get();
            boolean valB = b instanceof Boolean ? ((Boolean)b).booleanValue() : ((AtomicBoolean)b).get();
            return valA == valB;
        }
        if (a instanceof Number && b instanceof Number) {
            return MultiKeyMap.compareNumericValues(a, b);
        }
        return a.equals(b);
    }

    private static boolean compareNumericValues(Object a, Object b) {
        boolean bFp;
        Class<?> cb;
        Class<?> ca = a.getClass();
        if (ca == (cb = b.getClass())) {
            if (ca == Integer.class) {
                return ((Integer)a).intValue() == ((Integer)b).intValue();
            }
            if (ca == Long.class) {
                return ((Long)a).longValue() == ((Long)b).longValue();
            }
            if (ca == Short.class) {
                return ((Short)a).shortValue() == ((Short)b).shortValue();
            }
            if (ca == Byte.class) {
                return ((Byte)a).byteValue() == ((Byte)b).byteValue();
            }
            if (ca == Double.class) {
                double y;
                double x = (Double)a;
                return x == (y = ((Double)b).doubleValue()) || Double.isNaN(x) && Double.isNaN(y);
            }
            if (ca == Float.class) {
                float y;
                float x = ((Float)a).floatValue();
                return x == (y = ((Float)b).floatValue()) || Float.isNaN(x) && Float.isNaN(y);
            }
            if (ca == BigInteger.class) {
                return ((BigInteger)a).compareTo((BigInteger)b) == 0;
            }
            if (ca == BigDecimal.class) {
                return ((BigDecimal)a).compareTo((BigDecimal)b) == 0;
            }
            if (ca == AtomicInteger.class) {
                return ((AtomicInteger)a).get() == ((AtomicInteger)b).get();
            }
            if (ca == AtomicLong.class) {
                return ((AtomicLong)a).get() == ((AtomicLong)b).get();
            }
        }
        boolean aInt = MultiKeyMap.isIntegralLike(ca);
        boolean bInt = MultiKeyMap.isIntegralLike(cb);
        if (aInt && bInt) {
            return MultiKeyMap.extractLongFast(a) == MultiKeyMap.extractLongFast(b);
        }
        boolean aFp = ca == Double.class || ca == Float.class;
        boolean bl = bFp = cb == Double.class || cb == Float.class;
        if (aFp && bFp) {
            double y;
            double x = ((Number)a).doubleValue();
            return x == (y = ((Number)b).doubleValue()) || Double.isNaN(x) && Double.isNaN(y);
        }
        if (aInt && bFp || aFp && bInt) {
            long li;
            double d;
            double d2 = d = aFp ? ((Number)a).doubleValue() : ((Number)b).doubleValue();
            if (!Double.isFinite(d)) {
                return false;
            }
            long l = li = aInt ? MultiKeyMap.extractLongFast(a) : MultiKeyMap.extractLongFast(b);
            if ((long)d != li) {
                return false;
            }
            return d == (double)li;
        }
        if (MultiKeyMap.isBig(ca) || MultiKeyMap.isBig(cb)) {
            return MultiKeyMap.toBigDecimal((Number)a).compareTo(MultiKeyMap.toBigDecimal((Number)b)) == 0;
        }
        return Objects.equals(a, b);
    }

    private static boolean isIntegralLike(Class<?> c) {
        return c == Integer.class || c == Long.class || c == Short.class || c == Byte.class || c == AtomicInteger.class || c == AtomicLong.class;
    }

    private static boolean isBig(Class<?> c) {
        return c == BigInteger.class || c == BigDecimal.class;
    }

    private static long extractLongFast(Object o) {
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Short) {
            return ((Short)o).shortValue();
        }
        if (o instanceof Byte) {
            return ((Byte)o).byteValue();
        }
        if (o instanceof AtomicInteger) {
            return ((AtomicInteger)o).get();
        }
        if (o instanceof AtomicLong) {
            return ((AtomicLong)o).get();
        }
        return ((Number)o).longValue();
    }

    private static BigDecimal toBigDecimal(Number n) {
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        if (n instanceof BigInteger) {
            return new BigDecimal((BigInteger)n);
        }
        if (n instanceof Double || n instanceof Float) {
            return new BigDecimal(n.toString());
        }
        return BigDecimal.valueOf(n.longValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V putInternal(MultiKey<V> newKey) {
        boolean resize;
        V old;
        this.cachedHashCode = null;
        int hash = newKey.hash;
        int stripe = this.getStripeIndex(hash);
        ReentrantLock lock = this.stripeLocks[stripe];
        if (this.trackContentionMetrics) {
            boolean contended;
            boolean bl = contended = !lock.tryLock();
            if (contended) {
                lock.lock();
                this.contentionCount.incrementAndGet();
                this.stripeLockContention[stripe].incrementAndGet();
            }
            try {
                this.totalLockAcquisitions.incrementAndGet();
                this.stripeLockAcquisitions[stripe].incrementAndGet();
                old = this.putNoLock(newKey);
                resize = (float)this.atomicSize.get() > (float)this.buckets.length() * this.loadFactor;
            }
            finally {
                lock.unlock();
            }
        }
        lock.lock();
        try {
            old = this.putNoLock(newKey);
            resize = (float)this.atomicSize.get() > (float)this.buckets.length() * this.loadFactor;
        }
        finally {
            lock.unlock();
        }
        this.resizeRequest(resize);
        return old;
    }

    private V getNoLock(MultiKey<V> lookupKey) {
        int hash = lookupKey.hash;
        AtomicReferenceArray<MultiKey<V>[]> table = this.buckets;
        int mask = table.length() - 1;
        int index = MultiKeyMap.spread(hash) & mask;
        MultiKey<V>[] chain = table.get(index);
        if (chain == null) {
            return null;
        }
        for (MultiKey<V> e : chain) {
            if (e.hash != hash || !this.keysMatch(e, lookupKey.keys)) continue;
            return e.value;
        }
        return null;
    }

    private V putNoLock(MultiKey<V> newKey) {
        int hash = newKey.hash;
        AtomicReferenceArray<MultiKey<V>[]> table = this.buckets;
        int mask = table.length() - 1;
        int index = MultiKeyMap.spread(hash) & mask;
        MultiKey<V>[] chain = table.get(index);
        if (chain == null) {
            table.set(index, new MultiKey[]{newKey});
            this.atomicSize.incrementAndGet();
            this.updateMaxChainLength(1);
            return null;
        }
        for (int i = 0; i < chain.length; ++i) {
            MultiKey<V> e = chain[i];
            if (e.hash != hash || !this.keysMatch(e, newKey.keys)) continue;
            Object old = e.value;
            MultiKey[] newChain = (MultiKey[])chain.clone();
            newChain[i] = newKey;
            table.set(index, newChain);
            return old;
        }
        MultiKey<V>[] newChain = Arrays.copyOf(chain, chain.length + 1);
        newChain[chain.length] = newKey;
        table.set(index, newChain);
        this.atomicSize.incrementAndGet();
        this.updateMaxChainLength(newChain.length);
        return null;
    }

    public boolean containsMultiKey(Object ... keys) {
        if (keys == null || keys.length == 0) {
            return this.containsKey(null);
        }
        if (keys.length == 1) {
            return this.containsKey(keys[0]);
        }
        return this.containsKey(keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsMultiKey(Object k1, Object k2) {
        Object[] key = LOOKUP_KEY_2.get();
        key[0] = k1;
        key[1] = k2;
        try {
            boolean bl = this.containsKey(key);
            return bl;
        }
        finally {
            key[0] = null;
            key[1] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsMultiKey(Object k1, Object k2, Object k3) {
        Object[] key = LOOKUP_KEY_3.get();
        key[0] = k1;
        key[1] = k2;
        key[2] = k3;
        try {
            boolean bl = this.containsKey(key);
            return bl;
        }
        finally {
            key[0] = null;
            key[1] = null;
            key[2] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsMultiKey(Object k1, Object k2, Object k3, Object k4) {
        Object[] key = LOOKUP_KEY_4.get();
        key[0] = k1;
        key[1] = k2;
        key[2] = k3;
        key[3] = k4;
        try {
            boolean bl = this.containsKey(key);
            return bl;
        }
        finally {
            key[0] = null;
            key[1] = null;
            key[2] = null;
            key[3] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsMultiKey(Object k1, Object k2, Object k3, Object k4, Object k5) {
        Object[] key = LOOKUP_KEY_5.get();
        key[0] = k1;
        key[1] = k2;
        key[2] = k3;
        key[3] = k4;
        key[4] = k5;
        try {
            boolean bl = this.containsKey(key);
            return bl;
        }
        finally {
            key[0] = null;
            key[1] = null;
            key[2] = null;
            key[3] = null;
            key[4] = null;
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.findSimpleOrComplexKey(key) != null;
    }

    public V removeMultiKey(Object ... keys) {
        if (keys == null || keys.length == 0) {
            return this.remove(null);
        }
        if (keys.length == 1) {
            return this.remove(keys[0]);
        }
        return this.remove(keys);
    }

    @Override
    public V remove(Object key) {
        MultiKey<Object> removeKey = this.createMultiKey(key, null);
        return this.removeInternal(removeKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V removeInternal(MultiKey<V> removeKey) {
        V old;
        this.cachedHashCode = null;
        int hash = removeKey.hash;
        int stripe = this.getStripeIndex(hash);
        ReentrantLock lock = this.stripeLocks[stripe];
        if (this.trackContentionMetrics) {
            boolean contended;
            boolean bl = contended = !lock.tryLock();
            if (contended) {
                lock.lock();
                this.contentionCount.incrementAndGet();
                this.stripeLockContention[stripe].incrementAndGet();
            }
            try {
                this.totalLockAcquisitions.incrementAndGet();
                this.stripeLockAcquisitions[stripe].incrementAndGet();
                old = this.removeNoLock(removeKey);
            }
            finally {
                lock.unlock();
            }
        }
        lock.lock();
        try {
            old = this.removeNoLock(removeKey);
        }
        finally {
            lock.unlock();
        }
        return old;
    }

    private V removeNoLock(MultiKey<V> removeKey) {
        int hash = removeKey.hash;
        AtomicReferenceArray<MultiKey<V>[]> table = this.buckets;
        int mask = table.length() - 1;
        int index = MultiKeyMap.spread(hash) & mask;
        MultiKey<V>[] chain = table.get(index);
        if (chain == null) {
            return null;
        }
        for (int i = 0; i < chain.length; ++i) {
            MultiKey<V> e = chain[i];
            if (e.hash != hash || !this.keysMatch(e, removeKey.keys)) continue;
            Object old = e.value;
            if (chain.length == 1) {
                table.set(index, null);
            } else {
                MultiKey[] newChain = new MultiKey[chain.length - 1];
                System.arraycopy(chain, 0, newChain, 0, i);
                System.arraycopy(chain, i + 1, newChain, i, chain.length - i - 1);
                table.set(index, newChain);
            }
            this.atomicSize.decrementAndGet();
            return old;
        }
        return null;
    }

    private void resizeInternal() {
        this.withAllStripeLocks(() -> {
            double lf = (double)this.atomicSize.get() / (double)this.buckets.length();
            if (lf <= (double)this.loadFactor) {
                return;
            }
            AtomicReferenceArray<MultiKey<V>[]> oldBuckets = this.buckets;
            AtomicReferenceArray<MultiKey<V>[]> newBuckets = new AtomicReferenceArray<MultiKey<V>[]>(oldBuckets.length() * 2);
            int newMax = 0;
            this.atomicSize.set(0L);
            for (int i = 0; i < oldBuckets.length(); ++i) {
                MultiKey<V>[] chain = oldBuckets.get(i);
                if (chain == null) continue;
                for (MultiKey<V> e : chain) {
                    int len = this.rehashEntry(e, newBuckets);
                    this.atomicSize.incrementAndGet();
                    newMax = Math.max(newMax, len);
                }
            }
            this.maxChainLength.set(newMax);
            this.buckets = newBuckets;
        });
    }

    private int rehashEntry(MultiKey<V> entry, AtomicReferenceArray<MultiKey<V>[]> target) {
        int index = MultiKeyMap.spread(entry.hash) & target.length() - 1;
        MultiKey<V>[] chain = target.get(index);
        if (chain == null) {
            target.set(index, new MultiKey[]{entry});
            return 1;
        }
        MultiKey<V>[] newChain = Arrays.copyOf(chain, chain.length + 1);
        newChain[chain.length] = entry;
        target.set(index, newChain);
        return newChain.length;
    }

    private void resizeRequest(boolean resize) {
        if (!resize || this.resizeInProgress.get()) {
            return;
        }
        if ((float)this.atomicSize.get() <= (float)this.buckets.length() * this.loadFactor) {
            return;
        }
        if (this.resizeInProgress.compareAndSet(false, true)) {
            try {
                this.resizeInternal();
            }
            finally {
                this.resizeInProgress.set(false);
            }
        }
    }

    @Override
    public int size() {
        long sz = this.atomicSize.get();
        return sz > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)sz;
    }

    public long longSize() {
        return this.atomicSize.get();
    }

    @Override
    public boolean isEmpty() {
        return this.atomicSize.get() == 0L;
    }

    @Override
    public void clear() {
        this.cachedHashCode = null;
        this.withAllStripeLocks(() -> {
            AtomicReferenceArray<MultiKey<V>[]> table = this.buckets;
            for (int i = 0; i < table.length(); ++i) {
                table.set(i, null);
            }
            this.atomicSize.set(0L);
            this.maxChainLength.set(0);
        });
    }

    @Override
    public boolean containsValue(Object value) {
        AtomicReferenceArray<MultiKey<V>[]> table = this.buckets;
        for (int i = 0; i < table.length(); ++i) {
            MultiKey<V>[] chain = table.get(i);
            if (chain == null) continue;
            for (MultiKey<V> e : chain) {
                if (!Objects.equals(e.value, value)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Object> keySet() {
        HashSet<Object> set = new HashSet<Object>();
        AtomicReferenceArray<MultiKey<V>[]> snapshot = this.buckets;
        int len = snapshot.length();
        for (int bucketIdx = 0; bucketIdx < len; ++bucketIdx) {
            MultiKey<V>[] chain = snapshot.get(bucketIdx);
            if (chain == null) continue;
            for (MultiKey<V> e : chain) {
                Object[] keysArray;
                Object k;
                Object keys = e.keys;
                if (keys == null || keys == NULL_SENTINEL) {
                    k = null;
                } else if (keys instanceof Object[]) {
                    keysArray = (Object[])keys;
                    k = keysArray.length == 1 ? (keysArray[0] == NULL_SENTINEL ? null : keysArray[0]) : MultiKeyMap.reconstructKey(keysArray);
                } else if (keys instanceof Collection) {
                    if (this.collectionKeyMode == CollectionKeyMode.COLLECTIONS_NOT_EXPANDED) {
                        k = keys;
                    } else {
                        keysArray = ((Collection)keys).toArray();
                        k = MultiKeyMap.reconstructKey(keysArray);
                    }
                } else {
                    k = keys;
                }
                set.add(k);
            }
        }
        return set;
    }

    @Override
    public Collection<V> values() {
        ArrayList vals = new ArrayList();
        AtomicReferenceArray<MultiKey<V>[]> snapshot = this.buckets;
        int len = snapshot.length();
        for (int bucketIdx = 0; bucketIdx < len; ++bucketIdx) {
            MultiKey<V>[] chain = snapshot.get(bucketIdx);
            if (chain == null) continue;
            for (MultiKey<V> e : chain) {
                vals.add(e.value);
            }
        }
        return vals;
    }

    @Override
    public Set<Map.Entry<Object, V>> entrySet() {
        HashSet<Map.Entry<Object, V>> set = new HashSet<Map.Entry<Object, V>>();
        AtomicReferenceArray<MultiKey<V>[]> snapshot = this.buckets;
        int len = snapshot.length();
        for (int bucketIdx = 0; bucketIdx < len; ++bucketIdx) {
            MultiKey<V>[] chain = snapshot.get(bucketIdx);
            if (chain == null) continue;
            for (MultiKey<V> e : chain) {
                Object[] keysArray;
                Object k;
                Object keys = e.keys;
                if (keys == null || keys == NULL_SENTINEL) {
                    k = null;
                } else if (keys instanceof Object[]) {
                    keysArray = (Object[])keys;
                    k = keysArray.length == 1 ? (keysArray[0] == NULL_SENTINEL ? null : keysArray[0]) : MultiKeyMap.reconstructKey(keysArray);
                } else if (keys instanceof Collection) {
                    if (this.collectionKeyMode == CollectionKeyMode.COLLECTIONS_NOT_EXPANDED) {
                        k = keys;
                    } else {
                        keysArray = ((Collection)keys).toArray();
                        k = MultiKeyMap.reconstructKey(keysArray);
                    }
                } else {
                    k = keys;
                }
                set.add(new AbstractMap.SimpleEntry(k, e.value));
            }
        }
        return set;
    }

    @Override
    public void putAll(Map<?, ? extends V> m) {
        for (Map.Entry<?, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(Object key, V value) {
        this.cachedHashCode = null;
        V existing = this.get(key);
        if (existing != null) {
            return existing;
        }
        MultiKey norm = this.flattenKey(key);
        Object normalizedKey = norm.keys;
        int hash = norm.hash;
        ReentrantLock lock = this.getStripeLock(hash);
        boolean resize = false;
        lock.lock();
        try {
            MultiKey<Object> lookupKey = new MultiKey<Object>(normalizedKey, hash, null);
            existing = this.getNoLock(lookupKey);
            if (existing == null) {
                MultiKey<V> newKey = new MultiKey<V>(normalizedKey, hash, value);
                this.putNoLock(newKey);
                resize = (float)this.atomicSize.get() > (float)this.buckets.length() * this.loadFactor;
            }
        }
        finally {
            lock.unlock();
        }
        this.resizeRequest(resize);
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfAbsent(Object key, Function<? super Object, ? extends V> mappingFunction) {
        Object v;
        Objects.requireNonNull(mappingFunction);
        this.cachedHashCode = null;
        MultiKey norm = this.flattenKey(key);
        Object normalizedKey = norm.keys;
        int hash = norm.hash;
        MultiKey<V> existing = this.findEntryWithPrecomputedHash(normalizedKey, hash);
        if (existing != null && existing.value != null) {
            return existing.value;
        }
        ReentrantLock lock = this.getStripeLock(hash);
        boolean resize = false;
        lock.lock();
        try {
            MultiKey<Object> lookupKey = new MultiKey<Object>(normalizedKey, hash, null);
            v = this.getNoLock(lookupKey);
            if (v == null && (v = (Object)mappingFunction.apply(key)) != null) {
                MultiKey<Object> newKey = new MultiKey<Object>(normalizedKey, hash, v);
                this.putNoLock(newKey);
                resize = (float)this.atomicSize.get() > (float)this.buckets.length() * this.loadFactor;
            }
        }
        finally {
            lock.unlock();
        }
        this.resizeRequest(resize);
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfPresent(Object key, BiFunction<? super Object, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        this.cachedHashCode = null;
        MultiKey norm = this.flattenKey(key);
        Object normalizedKey = norm.keys;
        int hash = norm.hash;
        MultiKey<V> existing = this.findEntryWithPrecomputedHash(normalizedKey, hash);
        if (existing == null) {
            return null;
        }
        ReentrantLock lock = this.getStripeLock(hash);
        boolean resize = false;
        V result = null;
        lock.lock();
        try {
            MultiKey<Object> lookupKey = new MultiKey<Object>(normalizedKey, hash, null);
            Object old = this.getNoLock(lookupKey);
            if (old != null) {
                V newV = remappingFunction.apply(key, old);
                if (newV != null) {
                    MultiKey<V> newKey = new MultiKey<V>(normalizedKey, hash, newV);
                    this.putNoLock(newKey);
                    resize = (float)this.atomicSize.get() > (float)this.buckets.length() * this.loadFactor;
                    result = newV;
                } else {
                    MultiKey<Object> removeKey = new MultiKey<Object>(normalizedKey, hash, old);
                    this.removeNoLock(removeKey);
                }
            }
        }
        finally {
            lock.unlock();
        }
        this.resizeRequest(resize);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V compute(Object key, BiFunction<? super Object, ? super V, ? extends V> remappingFunction) {
        V result;
        Objects.requireNonNull(remappingFunction);
        this.cachedHashCode = null;
        MultiKey norm = this.flattenKey(key);
        Object normalizedKey = norm.keys;
        int hash = norm.hash;
        ReentrantLock lock = this.getStripeLock(hash);
        boolean resize = false;
        lock.lock();
        try {
            MultiKey<Object> lookupKey = new MultiKey<Object>(normalizedKey, hash, null);
            Object old = this.getNoLock(lookupKey);
            V newV = remappingFunction.apply(key, old);
            if (newV == null) {
                if (old != null || this.findEntryWithPrecomputedHash(normalizedKey, hash) != null) {
                    MultiKey<Object> removeKey = new MultiKey<Object>(normalizedKey, hash, old);
                    this.removeNoLock(removeKey);
                }
                result = null;
            } else {
                MultiKey<V> newKey = new MultiKey<V>(normalizedKey, hash, newV);
                this.putNoLock(newKey);
                resize = (float)this.atomicSize.get() > (float)this.buckets.length() * this.loadFactor;
                result = newV;
            }
        }
        finally {
            lock.unlock();
        }
        this.resizeRequest(resize);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V merge(Object key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        V result;
        Objects.requireNonNull(value);
        Objects.requireNonNull(remappingFunction);
        this.cachedHashCode = null;
        MultiKey norm = this.flattenKey(key);
        Object normalizedKey = norm.keys;
        int hash = norm.hash;
        ReentrantLock lock = this.getStripeLock(hash);
        boolean resize = false;
        lock.lock();
        try {
            V newV;
            MultiKey<Object> lookupKey = new MultiKey<Object>(normalizedKey, hash, null);
            Object old = this.getNoLock(lookupKey);
            V v = newV = old == null ? value : remappingFunction.apply(old, value);
            if (newV == null) {
                MultiKey<Object> removeKey = new MultiKey<Object>(normalizedKey, hash, old);
                this.removeNoLock(removeKey);
            } else {
                MultiKey<V> newKey = new MultiKey<V>(normalizedKey, hash, newV);
                this.putNoLock(newKey);
                resize = (float)this.atomicSize.get() > (float)this.buckets.length() * this.loadFactor;
            }
            result = newV;
        }
        finally {
            lock.unlock();
        }
        this.resizeRequest(resize);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        this.cachedHashCode = null;
        MultiKey norm = this.flattenKey(key);
        Object normalizedKey = norm.keys;
        int hash = norm.hash;
        ReentrantLock lock = this.getStripeLock(hash);
        lock.lock();
        try {
            MultiKey<Object> lookupKey = new MultiKey<Object>(normalizedKey, hash, null);
            Object current = this.getNoLock(lookupKey);
            if (!Objects.equals(current, value)) {
                boolean bl = false;
                return bl;
            }
            MultiKey<Object> removeKey = new MultiKey<Object>(normalizedKey, hash, current);
            this.removeNoLock(removeKey);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(Object key, V value) {
        V result;
        this.cachedHashCode = null;
        MultiKey norm = this.flattenKey(key);
        Object normalizedKey = norm.keys;
        int hash = norm.hash;
        ReentrantLock lock = this.getStripeLock(hash);
        boolean resize = false;
        lock.lock();
        try {
            MultiKey<Object> lookupKey = new MultiKey<Object>(normalizedKey, hash, null);
            Object old = this.getNoLock(lookupKey);
            if (old == null && this.findEntryWithPrecomputedHash(normalizedKey, hash) == null) {
                result = null;
            } else {
                MultiKey<V> newKey = new MultiKey<V>(normalizedKey, hash, value);
                result = this.putNoLock(newKey);
                resize = (float)this.atomicSize.get() > (float)this.buckets.length() * this.loadFactor;
            }
        }
        finally {
            lock.unlock();
        }
        this.resizeRequest(resize);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(Object key, V oldValue, V newValue) {
        this.cachedHashCode = null;
        MultiKey norm = this.flattenKey(key);
        Object normalizedKey = norm.keys;
        int hash = norm.hash;
        ReentrantLock lock = this.getStripeLock(hash);
        boolean resize = false;
        boolean result = false;
        lock.lock();
        try {
            MultiKey<Object> lookupKey = new MultiKey<Object>(normalizedKey, hash, null);
            Object current = this.getNoLock(lookupKey);
            if (Objects.equals(current, oldValue)) {
                MultiKey<V> newKey = new MultiKey<V>(normalizedKey, hash, newValue);
                this.putNoLock(newKey);
                resize = (float)this.atomicSize.get() > (float)this.buckets.length() * this.loadFactor;
                result = true;
            }
        }
        finally {
            lock.unlock();
        }
        this.resizeRequest(resize);
        return result;
    }

    @Override
    public int hashCode() {
        Integer cached = this.cachedHashCode;
        if (cached != null) {
            return cached;
        }
        int h = 0;
        if (this.caseSensitive) {
            for (Map.Entry<Object, V> e : this.entrySet()) {
                h += Objects.hashCode(e.getKey()) ^ Objects.hashCode(e.getValue());
            }
        } else {
            AtomicReferenceArray<MultiKey<V>[]> snapshot = this.buckets;
            int len = snapshot.length();
            for (int bucketIdx = 0; bucketIdx < len; ++bucketIdx) {
                MultiKey<V>[] chain = snapshot.get(bucketIdx);
                if (chain == null) continue;
                for (MultiKey<V> mk : chain) {
                    h += mk.hash ^ Objects.hashCode(mk.value);
                }
            }
        }
        this.cachedHashCode = h;
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        for (Map.Entry entry : m.entrySet()) {
            V myValue;
            Object key = entry.getKey();
            Object theirValue = entry.getValue();
            if (Objects.equals(theirValue, myValue = this.get(key)) && (theirValue != null || this.containsKey(key))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder("{\n");
        boolean first = true;
        AtomicReferenceArray<MultiKey<V>[]> snapshot = this.buckets;
        int len = snapshot.length();
        for (int bucketIdx = 0; bucketIdx < len; ++bucketIdx) {
            MultiKey<V>[] chain = snapshot.get(bucketIdx);
            if (chain == null) continue;
            for (MultiKey<V> e : chain) {
                if (!first) {
                    sb.append(",\n");
                }
                first = false;
                sb.append("  ");
                Object keys = e.keys;
                Object[] keysArray = keys instanceof Object[] ? (Object[])keys : (keys instanceof Collection ? ((Collection)keys).toArray() : new Object[]{keys});
                String keyStr = MultiKeyMap.dumpExpandedKeyStatic(keysArray, true, this);
                if (keyStr.endsWith(", ")) {
                    keyStr = keyStr.substring(0, keyStr.length() - 2);
                }
                sb.append(keyStr).append(" \u2192 ");
                sb.append(EMOJI_VALUE);
                sb.append(MultiKeyMap.formatValueForToString(e.value, this));
            }
        }
        return sb.append("\n}").toString();
    }

    public static Object reconstructKey(Object[] in) {
        ArrayList<Object> elements;
        boolean hasMarkers = false;
        boolean hasSetMarker = false;
        for (Object elem : in) {
            if (elem == OPEN || elem == CLOSE) {
                hasMarkers = true;
                continue;
            }
            if (elem != SET_OPEN && elem != SET_CLOSE) continue;
            hasMarkers = true;
            hasSetMarker = true;
        }
        if (!hasMarkers) {
            if (in.length == 1) {
                return in[0] == NULL_SENTINEL ? null : in[0];
            }
            elements = new ArrayList(in.length);
            for (int i = 0; i < in.length; ++i) {
                elements.add(in[i] == NULL_SENTINEL ? null : in[i]);
            }
            return Collections.unmodifiableList(elements);
        }
        if (hasSetMarker && !MultiKeyMap.hasNonSetMarkers(in)) {
            elements = new ArrayList<Object>();
            for (Object elem : in) {
                if (elem == SET_OPEN || elem == SET_CLOSE) continue;
                elements.add(elem == NULL_SENTINEL ? null : elem);
            }
            return Collections.unmodifiableSet(new LinkedHashSet(elements));
        }
        ArrayList<Object> components = new ArrayList<Object>();
        int[] index = new int[]{0};
        while (index[0] < in.length) {
            List<Object> elements2;
            Object elem = in[index[0]];
            if (elem == OPEN) {
                index[0] = index[0] + 1;
                elements2 = MultiKeyMap.collectElementsToNative(in, index, CLOSE);
                components.add(Collections.unmodifiableList(elements2));
                index[0] = index[0] + 1;
                continue;
            }
            if (elem == SET_OPEN) {
                index[0] = index[0] + 1;
                elements2 = MultiKeyMap.collectElementsToNative(in, index, SET_CLOSE);
                components.add(Collections.unmodifiableSet(new LinkedHashSet<Object>(elements2)));
                index[0] = index[0] + 1;
                continue;
            }
            components.add(elem == NULL_SENTINEL ? null : elem);
            index[0] = index[0] + 1;
        }
        if (components.size() == 1) {
            return components.get(0);
        }
        return Collections.unmodifiableList(components);
    }

    private static List<Object> collectElementsToNative(Object[] in, int[] index, Object closeMarker) {
        ArrayList<Object> elements = new ArrayList<Object>();
        while (index[0] < in.length && in[index[0]] != closeMarker) {
            Object current = in[index[0]];
            if (current == SET_OPEN || current == OPEN) {
                Object matchingClose = current == SET_OPEN ? SET_CLOSE : CLOSE;
                int closeIdx = MultiKeyMap.findMatchingClose(in, index[0], current, matchingClose);
                Object[] nested = Arrays.copyOfRange(in, index[0], closeIdx + 1);
                elements.add(MultiKeyMap.reconstructKey(nested));
                index[0] = closeIdx + 1;
                continue;
            }
            elements.add(current == NULL_SENTINEL ? null : current);
            index[0] = index[0] + 1;
        }
        return elements;
    }

    private static boolean hasNonSetMarkers(Object[] arr) {
        for (Object elem : arr) {
            if (elem != OPEN && elem != CLOSE) continue;
            return true;
        }
        return false;
    }

    private static int findMatchingClose(Object[] arr, int openIdx, Object openMarker, Object closeMarker) {
        int depth = 1;
        for (int i = openIdx + 1; i < arr.length; ++i) {
            if (arr[i] == openMarker) {
                ++depth;
                continue;
            }
            if (arr[i] != closeMarker || --depth != 0) continue;
            return i;
        }
        throw new IllegalStateException("No matching close marker found");
    }

    private static int calculateOptimalStripeCount() {
        int cores = Runtime.getRuntime().availableProcessors();
        int stripes = Math.max(8, cores * 2);
        stripes = Math.min(128, stripes);
        return Integer.highestOneBit(stripes - 1) << 1;
    }

    public void printContentionStatistics() {
        int totalAcquisitions = this.totalLockAcquisitions.get();
        int totalContentions = this.contentionCount.get();
        int globalAcquisitions = this.globalLockAcquisitions.get();
        int globalContentions = this.globalLockContentions.get();
        LOG.info("=== MultiKeyMap Contention Statistics ===");
        LOG.info("Total lock acquisitions: " + totalAcquisitions);
        LOG.info("Total contentions: " + totalContentions);
        if (totalAcquisitions > 0) {
            double contentionRate = (double)totalContentions / (double)totalAcquisitions * 100.0;
            LOG.info(String.format("Overall contention rate: %.2f%%", contentionRate));
        }
        LOG.info("Global lock acquisitions: " + globalAcquisitions);
        LOG.info("Global lock contentions: " + globalContentions);
        LOG.info("Stripe-level statistics:");
        LOG.info("Stripe | Acquisitions | Contentions | Rate");
        LOG.info("-------|-------------|-------------|------");
        for (int i = 0; i < STRIPE_COUNT; ++i) {
            int acquisitions = this.stripeLockAcquisitions[i].get();
            int contentions = this.stripeLockContention[i].get();
            double rate = acquisitions > 0 ? (double)contentions / (double)acquisitions * 100.0 : 0.0;
            LOG.info(String.format("%6d | %11d | %11d | %5.2f%%", i, acquisitions, contentions, rate));
        }
        int maxContentionStripe = 0;
        int minContentionStripe = 0;
        int maxContentions = this.stripeLockContention[0].get();
        int minContentions = this.stripeLockContention[0].get();
        for (int i = 1; i < STRIPE_COUNT; ++i) {
            int contentions = this.stripeLockContention[i].get();
            if (contentions > maxContentions) {
                maxContentions = contentions;
                maxContentionStripe = i;
            }
            if (contentions >= minContentions) continue;
            minContentions = contentions;
            minContentionStripe = i;
        }
        LOG.info("Stripe distribution analysis:");
        LOG.info(String.format("Most contended stripe: %d (%d contentions)", maxContentionStripe, maxContentions));
        LOG.info(String.format("Least contended stripe: %d (%d contentions)", minContentionStripe, minContentions));
        int unusedStripes = 0;
        for (int i = 0; i < STRIPE_COUNT; ++i) {
            if (this.stripeLockAcquisitions[i].get() != 0) continue;
            ++unusedStripes;
        }
        LOG.info(String.format("Unused stripes: %d out of %d", unusedStripes, STRIPE_COUNT));
        LOG.info("================================================");
    }

    private void withAllStripeLocks(Runnable action) {
        this.lockAllStripes();
        try {
            action.run();
        }
        finally {
            this.unlockAllStripes();
        }
    }

    private static void processNestedStructure(StringBuilder sb, List<Object> list, int[] index, MultiKeyMap<?> selfMap) {
        if (index[0] >= list.size()) {
            return;
        }
        Object element = list.get(index[0]);
        index[0] = index[0] + 1;
        if (element == OPEN) {
            sb.append(EMOJI_OPEN);
            boolean first = true;
            while (index[0] < list.size()) {
                Object next = list.get(index[0]);
                if (next == CLOSE) {
                    index[0] = index[0] + 1;
                    sb.append(EMOJI_CLOSE);
                    break;
                }
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                MultiKeyMap.processNestedStructure(sb, list, index, selfMap);
            }
        } else if (element == SET_OPEN) {
            sb.append(EMOJI_SET_OPEN);
            boolean first = true;
            while (index[0] < list.size()) {
                Object next = list.get(index[0]);
                if (next == SET_CLOSE) {
                    index[0] = index[0] + 1;
                    sb.append(EMOJI_SET_CLOSE);
                    break;
                }
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                MultiKeyMap.processNestedStructure(sb, list, index, selfMap);
            }
        } else if (element == NULL_SENTINEL) {
            sb.append(EMOJI_EMPTY);
        } else if (selfMap != null && element == selfMap) {
            sb.append(THIS_MAP);
        } else if (element instanceof String && ((String)element).startsWith(EMOJI_CYCLE)) {
            sb.append(element);
        } else {
            sb.append(element);
        }
    }

    private static String dumpExpandedKeyStatic(Object key, boolean forToString, MultiKeyMap<?> selfMap) {
        Object element;
        if (key == null) {
            return forToString ? "\ud83c\udd94 \u2205" : EMOJI_EMPTY;
        }
        if (key == NULL_SENTINEL) {
            return forToString ? "\ud83c\udd94 \u2205" : EMOJI_EMPTY;
        }
        if (key.getClass().isArray() && ArrayUtilities.getLength(key) == 1 && (element = ArrayUtilities.getElement(key, 0)) instanceof Collection) {
            return MultiKeyMap.dumpExpandedKeyStatic(element, forToString, selfMap);
        }
        if (!key.getClass().isArray() && !(key instanceof Collection)) {
            if (selfMap != null && key == selfMap) {
                return "\ud83c\udd94 (this Map \u267b\ufe0f)";
            }
            return EMOJI_KEY + key;
        }
        if (forToString) {
            StringBuilder sb;
            Object first;
            Collection coll;
            if (key instanceof Collection) {
                coll = (Collection)key;
                boolean isAlreadyFlattened = false;
                if (!coll.isEmpty() && (first = coll.iterator().next()) == OPEN) {
                    isAlreadyFlattened = true;
                }
                if (isAlreadyFlattened) {
                    sb = new StringBuilder();
                    sb.append(EMOJI_KEY);
                    ArrayList<Object> collList = new ArrayList<Object>(coll);
                    int[] index = new int[]{0};
                    MultiKeyMap.processNestedStructure(sb, collList, index, selfMap);
                    return sb.toString();
                }
            }
            if (key.getClass().isArray()) {
                int len = ArrayUtilities.getLength(key);
                boolean isAlreadyFlattenedArray = false;
                if (len > 0 && (first = ArrayUtilities.getElement(key, 0)) == OPEN) {
                    isAlreadyFlattenedArray = true;
                }
                if (isAlreadyFlattenedArray) {
                    sb = new StringBuilder();
                    sb.append(EMOJI_KEY);
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    for (int i = 0; i < len; ++i) {
                        arrayList.add(ArrayUtilities.getElement(key, i));
                    }
                    int[] index = new int[]{0};
                    MultiKeyMap.processNestedStructure(sb, arrayList, index, selfMap);
                    return sb.toString();
                }
                if (len == 1) {
                    Object element2 = ArrayUtilities.getElement(key, 0);
                    if (element2 == NULL_SENTINEL) {
                        return "\ud83c\udd94 \u2205";
                    }
                    if (selfMap != null && element2 == selfMap) {
                        return "\ud83c\udd94 (this Map \u267b\ufe0f)";
                    }
                    if (element2 == OPEN) {
                        return "\ud83c\udd94 [";
                    }
                    if (element2 == CLOSE) {
                        return "\ud83c\udd94 ]";
                    }
                    if (element2 == SET_OPEN) {
                        return "\ud83c\udd94 {";
                    }
                    if (element2 == SET_CLOSE) {
                        return "\ud83c\udd94 }";
                    }
                    return EMOJI_KEY + (element2 != null ? element2.toString() : EMOJI_EMPTY);
                }
                sb = new StringBuilder();
                sb.append(EMOJI_KEY).append(EMOJI_OPEN);
                boolean needsComma = false;
                for (int i = 0; i < len; ++i) {
                    Object element3 = ArrayUtilities.getElement(key, i);
                    if (element3 == NULL_SENTINEL) {
                        if (needsComma) {
                            sb.append(", ");
                        }
                        sb.append(EMOJI_EMPTY);
                        needsComma = true;
                        continue;
                    }
                    if (element3 == OPEN) {
                        sb.append(EMOJI_OPEN);
                        needsComma = false;
                        continue;
                    }
                    if (element3 == CLOSE) {
                        sb.append(EMOJI_CLOSE);
                        needsComma = true;
                        continue;
                    }
                    if (element3 == SET_OPEN) {
                        sb.append(EMOJI_SET_OPEN);
                        needsComma = false;
                        continue;
                    }
                    if (element3 == SET_CLOSE) {
                        sb.append(EMOJI_SET_CLOSE);
                        needsComma = true;
                        continue;
                    }
                    if (selfMap != null && element3 == selfMap) {
                        if (needsComma) {
                            sb.append(", ");
                        }
                        sb.append(THIS_MAP);
                        needsComma = true;
                        continue;
                    }
                    if (element3 instanceof String && ((String)element3).startsWith(EMOJI_CYCLE)) {
                        if (needsComma) {
                            sb.append(", ");
                        }
                        sb.append(element3);
                        needsComma = true;
                        continue;
                    }
                    if (needsComma) {
                        sb.append(", ");
                    }
                    if (element3 == NULL_SENTINEL) {
                        sb.append(EMOJI_EMPTY);
                    } else if (element3 == OPEN) {
                        sb.append(EMOJI_OPEN);
                    } else if (element3 == CLOSE) {
                        sb.append(EMOJI_CLOSE);
                    } else if (element3 == SET_OPEN) {
                        sb.append(EMOJI_SET_OPEN);
                    } else if (element3 == SET_CLOSE) {
                        sb.append(EMOJI_SET_CLOSE);
                    } else {
                        sb.append(element3 != null ? element3.toString() : EMOJI_EMPTY);
                    }
                    needsComma = true;
                }
                sb.append(EMOJI_CLOSE);
                return sb.toString();
            }
            coll = (Collection)key;
            if (coll.size() == 1) {
                Object element4 = coll.iterator().next();
                if (element4 == NULL_SENTINEL) {
                    return "\ud83c\udd94 [\u2205]";
                }
                if (selfMap != null && element4 == selfMap) {
                    return "\ud83c\udd94 (this Map \u267b\ufe0f)";
                }
                if (element4 == OPEN) {
                    return "\ud83c\udd94 [";
                }
                if (element4 == CLOSE) {
                    return "\ud83c\udd94 ]";
                }
                if (element4 == SET_OPEN) {
                    return "\ud83c\udd94 {";
                }
                if (element4 == SET_CLOSE) {
                    return "\ud83c\udd94 }";
                }
                return EMOJI_KEY + (element4 != null ? element4.toString() : EMOJI_EMPTY);
            }
            StringBuilder sb2 = new StringBuilder();
            sb2.append(EMOJI_KEY).append(EMOJI_OPEN);
            boolean needsComma = false;
            for (Object element5 : coll) {
                if (element5 == NULL_SENTINEL) {
                    if (needsComma) {
                        sb2.append(", ");
                    }
                    sb2.append(EMOJI_EMPTY);
                    needsComma = true;
                    continue;
                }
                if (element5 == OPEN) {
                    sb2.append(EMOJI_OPEN);
                    needsComma = false;
                    continue;
                }
                if (element5 == CLOSE) {
                    sb2.append(EMOJI_CLOSE);
                    needsComma = true;
                    continue;
                }
                if (element5 == SET_OPEN) {
                    sb2.append(EMOJI_SET_OPEN);
                    needsComma = false;
                    continue;
                }
                if (element5 == SET_CLOSE) {
                    sb2.append(EMOJI_SET_CLOSE);
                    needsComma = true;
                    continue;
                }
                if (selfMap != null && element5 == selfMap) {
                    if (needsComma) {
                        sb2.append(", ");
                    }
                    sb2.append(THIS_MAP);
                    needsComma = true;
                    continue;
                }
                if (element5 instanceof String && ((String)element5).startsWith(EMOJI_CYCLE)) {
                    if (needsComma) {
                        sb2.append(", ");
                    }
                    sb2.append(element5);
                    needsComma = true;
                    continue;
                }
                if (needsComma) {
                    sb2.append(", ");
                }
                if (element5 == NULL_SENTINEL) {
                    sb2.append(EMOJI_EMPTY);
                } else if (element5 == OPEN) {
                    sb2.append(EMOJI_OPEN);
                } else if (element5 == CLOSE) {
                    sb2.append(EMOJI_CLOSE);
                } else if (element5 == SET_OPEN) {
                    sb2.append(EMOJI_SET_OPEN);
                } else if (element5 == SET_CLOSE) {
                    sb2.append(EMOJI_SET_CLOSE);
                } else {
                    sb2.append(element5 != null ? element5.toString() : EMOJI_EMPTY);
                }
                needsComma = true;
            }
            sb2.append(EMOJI_CLOSE);
            return sb2.toString();
        }
        ArrayList<Object> expanded = new ArrayList<Object>();
        IdentitySet<Object> visited = new IdentitySet<Object>();
        MultiKeyMap.expandAndHash(key, expanded, visited, 1, false, true);
        StringBuilder sb = new StringBuilder();
        sb.append(EMOJI_KEY);
        int[] index = new int[]{0};
        MultiKeyMap.processNestedStructure(sb, expanded, index, selfMap);
        return sb.toString();
    }

    private static String formatValueForToString(Object value, MultiKeyMap<?> selfMap) {
        if (value == null) {
            return EMOJI_EMPTY;
        }
        if (selfMap != null && value == selfMap) {
            return THIS_MAP;
        }
        if (value instanceof Collection || value.getClass().isArray()) {
            return MultiKeyMap.formatComplexValueForToString(value, selfMap);
        }
        return value.toString();
    }

    private static String formatComplexValueForToString(Object value, MultiKeyMap<?> selfMap) {
        if (value == null) {
            return EMOJI_EMPTY;
        }
        if (selfMap != null && value == selfMap) {
            return THIS_MAP;
        }
        if (value.getClass().isArray()) {
            return MultiKeyMap.formatArrayValueForToString(value, selfMap);
        }
        if (value instanceof Collection) {
            return MultiKeyMap.formatCollectionValueForToString((Collection)value, selfMap);
        }
        return value.toString();
    }

    private static String formatArrayValueForToString(Object array, MultiKeyMap<?> selfMap) {
        int len = ArrayUtilities.getLength(array);
        if (len == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(EMOJI_OPEN);
        if (array instanceof Object[]) {
            Object[] oa = (Object[])array;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(MultiKeyMap.formatValueForToString(oa[i], selfMap));
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                Object element = ArrayUtilities.getElement(array, i);
                sb.append(MultiKeyMap.formatValueForToString(element, selfMap));
            }
        }
        sb.append(EMOJI_CLOSE);
        return sb.toString();
    }

    private static String formatCollectionValueForToString(Collection<?> collection, MultiKeyMap<?> selfMap) {
        if (collection.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(EMOJI_OPEN);
        boolean first = true;
        for (Object element : collection) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(MultiKeyMap.formatValueForToString(element, selfMap));
        }
        sb.append(EMOJI_CLOSE);
        return sb.toString();
    }

    static {
        LoggingConfig.init();
        OPEN = new Object(){

            public String toString() {
                return MultiKeyMap.EMOJI_OPEN;
            }

            public int hashCode() {
                return MultiKeyMap.EMOJI_OPEN.hashCode();
            }
        };
        CLOSE = new Object(){

            public String toString() {
                return MultiKeyMap.EMOJI_CLOSE;
            }

            public int hashCode() {
                return MultiKeyMap.EMOJI_CLOSE.hashCode();
            }
        };
        SET_OPEN = new Object(){

            public String toString() {
                return MultiKeyMap.EMOJI_SET_OPEN;
            }

            public int hashCode() {
                return MultiKeyMap.EMOJI_SET_OPEN.hashCode();
            }
        };
        SET_CLOSE = new Object(){

            public String toString() {
                return MultiKeyMap.EMOJI_SET_CLOSE;
            }

            public int hashCode() {
                return MultiKeyMap.EMOJI_SET_CLOSE.hashCode();
            }
        };
        NULL_SENTINEL = new Object(){

            public String toString() {
                return MultiKeyMap.EMOJI_EMPTY;
            }

            public int hashCode() {
                return MultiKeyMap.EMOJI_EMPTY.hashCode();
            }
        };
        NULL_NORMALIZED_KEY = new MultiKey<Object>(NULL_SENTINEL, 0, null);
        LOOKUP_KEY_2 = ThreadLocal.withInitial(() -> new Object[2]);
        LOOKUP_KEY_3 = ThreadLocal.withInitial(() -> new Object[3]);
        LOOKUP_KEY_4 = ThreadLocal.withInitial(() -> new Object[4]);
        LOOKUP_KEY_5 = ThreadLocal.withInitial(() -> new Object[5]);
        SIMPLE_ARRAY_TYPES = new ClassValueSet();
        SIMPLE_ARRAY_TYPES.add(String[].class);
        SIMPLE_ARRAY_TYPES.add(Integer[].class);
        SIMPLE_ARRAY_TYPES.add(Long[].class);
        SIMPLE_ARRAY_TYPES.add(Double[].class);
        SIMPLE_ARRAY_TYPES.add(Float[].class);
        SIMPLE_ARRAY_TYPES.add(Boolean[].class);
        SIMPLE_ARRAY_TYPES.add(Character[].class);
        SIMPLE_ARRAY_TYPES.add(Byte[].class);
        SIMPLE_ARRAY_TYPES.add(Short[].class);
        SIMPLE_ARRAY_TYPES.add(Date[].class);
        SIMPLE_ARRAY_TYPES.add(java.sql.Date[].class);
        SIMPLE_ARRAY_TYPES.add(Time[].class);
        SIMPLE_ARRAY_TYPES.add(Timestamp[].class);
        SIMPLE_ARRAY_TYPES.add(LocalDate[].class);
        SIMPLE_ARRAY_TYPES.add(LocalTime[].class);
        SIMPLE_ARRAY_TYPES.add(LocalDateTime[].class);
        SIMPLE_ARRAY_TYPES.add(ZonedDateTime[].class);
        SIMPLE_ARRAY_TYPES.add(OffsetDateTime[].class);
        SIMPLE_ARRAY_TYPES.add(OffsetTime[].class);
        SIMPLE_ARRAY_TYPES.add(Instant[].class);
        SIMPLE_ARRAY_TYPES.add(Duration[].class);
        SIMPLE_ARRAY_TYPES.add(Period[].class);
        SIMPLE_ARRAY_TYPES.add(Year[].class);
        SIMPLE_ARRAY_TYPES.add(YearMonth[].class);
        SIMPLE_ARRAY_TYPES.add(MonthDay[].class);
        SIMPLE_ARRAY_TYPES.add(ZoneId[].class);
        SIMPLE_ARRAY_TYPES.add(ZoneOffset[].class);
        SIMPLE_ARRAY_TYPES.add(BigInteger[].class);
        SIMPLE_ARRAY_TYPES.add(BigDecimal[].class);
        SIMPLE_ARRAY_TYPES.add(URL[].class);
        SIMPLE_ARRAY_TYPES.add(URI[].class);
        SIMPLE_ARRAY_TYPES.add(InetAddress[].class);
        SIMPLE_ARRAY_TYPES.add(Inet4Address[].class);
        SIMPLE_ARRAY_TYPES.add(Inet6Address[].class);
        SIMPLE_ARRAY_TYPES.add(File[].class);
        SIMPLE_ARRAY_TYPES.add(Path[].class);
        SIMPLE_ARRAY_TYPES.add(UUID[].class);
        SIMPLE_ARRAY_TYPES.add(Locale[].class);
        SIMPLE_ARRAY_TYPES.add(Currency[].class);
        SIMPLE_ARRAY_TYPES.add(TimeZone[].class);
        SIMPLE_ARRAY_TYPES.add(Pattern[].class);
        SIMPLE_ARRAY_TYPES.add(DayOfWeek[].class);
        SIMPLE_ARRAY_TYPES.add(Month[].class);
        SIMPLE_ARRAY_TYPES.add(StandardOpenOption[].class);
        SIMPLE_ARRAY_TYPES.add(LinkOption[].class);
        STRIPE_CONFIG_LOGGED = new AtomicBoolean(false);
        STRIPE_COUNT = MultiKeyMap.calculateOptimalStripeCount();
        STRIPE_MASK = STRIPE_COUNT - 1;
    }

    public static class Builder<V> {
        private int capacity = 16;
        private float loadFactor = 0.75f;
        private CollectionKeyMode collectionKeyMode = CollectionKeyMode.COLLECTIONS_EXPANDED;
        private boolean flattenDimensions = false;
        private boolean simpleKeysMode = false;
        private boolean valueBasedEquality = true;
        private boolean caseSensitive = true;
        private boolean trackContentionMetrics = false;

        private Builder() {
        }

        public Builder<V> capacity(int capacity) {
            if (capacity < 0) {
                throw new IllegalArgumentException("Capacity must be non-negative");
            }
            this.capacity = capacity;
            return this;
        }

        public Builder<V> loadFactor(float loadFactor) {
            if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
                throw new IllegalArgumentException("Load factor must be positive");
            }
            this.loadFactor = loadFactor;
            return this;
        }

        public Builder<V> collectionKeyMode(CollectionKeyMode mode) {
            this.collectionKeyMode = Objects.requireNonNull(mode);
            return this;
        }

        public Builder<V> flattenDimensions(boolean flatten) {
            this.flattenDimensions = flatten;
            return this;
        }

        public Builder<V> simpleKeysMode(boolean simple) {
            this.simpleKeysMode = simple;
            return this;
        }

        public Builder<V> valueBasedEquality(boolean valueBasedEquality) {
            this.valueBasedEquality = valueBasedEquality;
            return this;
        }

        public Builder<V> caseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        public Builder<V> trackContentionMetrics(boolean track) {
            this.trackContentionMetrics = track;
            return this;
        }

        public Builder<V> from(MultiKeyMap<?> source) {
            this.capacity = ((MultiKeyMap)source).capacity;
            this.loadFactor = ((MultiKeyMap)source).loadFactor;
            this.collectionKeyMode = ((MultiKeyMap)source).collectionKeyMode;
            this.flattenDimensions = ((MultiKeyMap)source).flattenDimensions;
            this.simpleKeysMode = ((MultiKeyMap)source).simpleKeysMode;
            this.valueBasedEquality = ((MultiKeyMap)source).valueBasedEquality;
            this.caseSensitive = ((MultiKeyMap)source).caseSensitive;
            this.trackContentionMetrics = ((MultiKeyMap)source).trackContentionMetrics;
            return this;
        }

        public MultiKeyMap<V> build() {
            return new MultiKeyMap(this);
        }
    }

    public static enum CollectionKeyMode {
        COLLECTIONS_EXPANDED,
        COLLECTIONS_NOT_EXPANDED;

    }

    private static final class Norm {
        Object key;
        int hash;

        private Norm() {
        }
    }

    private static final class MultiKey<V> {
        static final byte KIND_SINGLE = 0;
        static final byte KIND_OBJECT_ARRAY = 1;
        static final byte KIND_COLLECTION = 2;
        static final byte KIND_PRIMITIVE_ARRAY = 3;
        final Object keys;
        final int hash;
        final V value;
        final int size;
        final byte kind;

        MultiKey(Object normalizedKeys, int hash, V value) {
            this.keys = normalizedKeys;
            this.hash = hash;
            this.value = value;
            if (normalizedKeys == null) {
                this.size = 1;
                this.kind = 0;
            } else {
                Class<?> keyClass = normalizedKeys.getClass();
                if (keyClass.isArray()) {
                    this.size = ArrayUtilities.getLength(normalizedKeys);
                    Class<?> componentType = keyClass.getComponentType();
                    this.kind = componentType != null && componentType.isPrimitive() ? 3 : 1;
                } else if (normalizedKeys instanceof Collection) {
                    this.size = ((Collection)normalizedKeys).size();
                    this.kind = (byte)2;
                } else {
                    this.size = 1;
                    this.kind = 0;
                }
            }
        }

        public String toString() {
            return MultiKeyMap.dumpExpandedKeyStatic(this.keys, true, null);
        }
    }

    private static class ArrayIterator
    implements Iterator<Object> {
        private final Object array;
        private final int len;
        private int index = 0;

        ArrayIterator(Object array) {
            this.array = array;
            this.len = ArrayUtilities.getLength(array);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.len;
        }

        @Override
        public Object next() {
            return ArrayUtilities.getElement(this.array, this.index++);
        }
    }

    @FunctionalInterface
    private static interface ElementAccessor {
        public Object get(int var1);
    }
}

